/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ParallelActivity;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.Splash;
import java.awt.SplashScreen;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplashManager {
    public static final String NO_SPLASH = "nosplash";
    private static Splash SPLASH_WINDOW;

    public static void show(@NotNull String[] args) {
        if (args == null) {
            SplashManager.$$$reportNull$$$0(0);
        }
        if (Boolean.getBoolean(NO_SPLASH)) {
            return;
        }
        for (String arg : args) {
            if (!NO_SPLASH.equals(arg)) continue;
            System.setProperty(NO_SPLASH, "true");
            return;
        }
        assert (SPLASH_WINDOW == null);
        Activity activity = ParallelActivity.PREPARE_APP_INIT.start("splash initialization");
        SPLASH_WINDOW = new Splash(ApplicationInfoImpl.getShadowInstance());
        activity.end();
    }

    public static void executeWithHiddenSplash(@NotNull Window window, @NotNull Runnable runnable2) {
        if (window == null) {
            SplashManager.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            SplashManager.$$$reportNull$$$0(2);
        }
        WindowAdapter listener2 = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SplashManager.setVisible(false);
            }
        };
        window.addWindowListener(listener2);
        runnable2.run();
        SplashManager.setVisible(true);
        window.removeWindowListener(listener2);
    }

    private static void setVisible(boolean value) {
        Splash splash = SPLASH_WINDOW;
        if (splash != null) {
            splash.setVisible(value);
            if (value) {
                splash.paint(splash.getGraphics());
            }
        }
    }

    public static void showLicenseeInfoOnSplash(@NotNull Logger log2) {
        SplashScreen javaSplash;
        Splash splash;
        if (log2 == null) {
            SplashManager.$$$reportNull$$$0(3);
        }
        if ((splash = SPLASH_WINDOW) != null) {
            splash.paintLicenseeInfo();
            return;
        }
        try {
            javaSplash = SplashScreen.getSplashScreen();
        }
        catch (Throwable t) {
            log2.warn(t);
            return;
        }
        if (javaSplash == null) {
            return;
        }
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        if (Splash.showLicenseeInfo(javaSplash.createGraphics(), 0, 0, javaSplash.getSize().height, appInfo, Splash.createFont())) {
            javaSplash.update();
        }
    }

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        if (SPLASH_WINDOW == null) {
            return null;
        }
        return new EmptyProgressIndicator(){

            public void setFraction(double fraction) {
                SPLASH_WINDOW.showProgress(fraction);
            }
        };
    }

    @Nullable
    public static Runnable getHideTask() {
        if (SPLASH_WINDOW == null) {
            return null;
        }
        Ref splash = new Ref((Object)SPLASH_WINDOW);
        SPLASH_WINDOW = null;
        return () -> {
            ((Splash)splash.get()).setVisible(false);
            ((Splash)splash.get()).dispose();
            splash.set(null);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        objectArray2[1] = "com/intellij/idea/SplashManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeWithHiddenSplash";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showLicenseeInfoOnSplash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

