/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompoundIconProvider
extends IconProvider {
    private static final IconProvider INSTANCE = new CompoundIconProvider();
    private static final Logger LOG = Logger.getInstance(CompoundIconProvider.class);

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            CompoundIconProvider.$$$reportNull$$$0(0);
        }
        if (element.isValid()) {
            for (IconProvider provider : (IconProvider[])EXTENSION_POINT_NAME.getExtensions()) {
                try {
                    Icon icon = provider.getIcon(element, flags);
                    if (icon == null) continue;
                    LOG.debug("icon found in ", new Object[]{provider});
                    if (icon instanceof RowIcon) {
                        RowIcon rowIcon = (RowIcon)icon;
                        if (AllIcons.Nodes.Package.equals(rowIcon.getIcon(0)) && !CompoundIconProvider.isValidPackage(element)) {
                            LOG.debug("fix row icon for invalid package: ", new Object[]{element});
                            rowIcon.setIcon(AllIcons.Nodes.Folder, 0);
                        }
                    } else if (AllIcons.Nodes.Package.equals(icon) && !CompoundIconProvider.isValidPackage(element)) {
                        LOG.debug("fix icon for invalid package: ", new Object[]{element});
                        return AllIcons.Nodes.Folder;
                    }
                    return icon;
                }
                catch (IndexNotReadyException exception) {
                    throw new ProcessCanceledException((Throwable)exception);
                }
                catch (ProcessCanceledException exception) {
                    throw exception;
                }
                catch (Exception exception) {
                    LOG.warn("unexpected error in " + provider, (Throwable)exception);
                }
            }
            if (element instanceof PsiDirectory) {
                LOG.debug("add default folder icon: ", new Object[]{element});
                return IconManager.getInstance().createLayeredIcon((Iconable)element, AllIcons.Nodes.Folder, flags);
            }
        }
        return null;
    }

    @Nullable
    public static Icon findIcon(@Nullable PsiElement element, int flags) {
        return element == null ? null : INSTANCE.getIcon(element, flags);
    }

    private static boolean isValidPackage(@Nullable PsiElement element) {
        PsiDirectoryFactory factory;
        if (element instanceof PsiDirectory && element.isValid() && (factory = PsiDirectoryFactory.getInstance(element.getProject())) != null && factory.isPackage((PsiDirectory)element)) {
            return factory.isValidPackageName(factory.getQualifiedName((PsiDirectory)element, false));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/projectView/impl/CompoundIconProvider", "getIcon"));
    }
}

