/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunTab
implements DataProvider,
Disposable {
    @NotNull
    protected final RunnerLayoutUi myUi;
    private LogFilesManager myManager;
    protected RunContentDescriptor myRunContentDescriptor;
    protected ExecutionEnvironment myEnvironment;
    protected final Project myProject;
    protected final GlobalSearchScope mySearchScope;
    private LogConsoleManagerBase logConsoleManager;

    protected RunTab(@NotNull ExecutionEnvironment environment, @NotNull String runnerType) {
        if (environment == null) {
            RunTab.$$$reportNull$$$0(0);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(1);
        }
        this(environment.getProject(), GlobalSearchScopes.executionScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile()), runnerType, environment.getExecutor().getId(), environment.getRunProfile().getName());
        this.myEnvironment = environment;
    }

    public void dispose() {
        this.myRunContentDescriptor = null;
        this.myEnvironment = null;
        this.logConsoleManager = null;
    }

    protected RunTab(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull String runnerType, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (project == null) {
            RunTab.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            RunTab.$$$reportNull$$$0(3);
        }
        if (runnerType == null) {
            RunTab.$$$reportNull$$$0(4);
        }
        if (runnerTitle == null) {
            RunTab.$$$reportNull$$$0(5);
        }
        if (sessionName == null) {
            RunTab.$$$reportNull$$$0(6);
        }
        this.myProject = project;
        this.mySearchScope = searchScope;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project).create(runnerType, runnerTitle, sessionName, (Disposable)this);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            RunTab.$$$reportNull$$$0(7);
        }
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            return this.myEnvironment == null ? null : this.myEnvironment.getRunProfile();
        }
        if (LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myEnvironment;
        }
        if (LangDataKeys.RUN_CONTENT_DESCRIPTOR.is(dataId)) {
            return this.myRunContentDescriptor;
        }
        return null;
    }

    @NotNull
    public LogConsoleManagerBase getLogConsoleManager() {
        if (this.logConsoleManager == null) {
            this.logConsoleManager = new LogConsoleManagerBase(this.myProject, this.mySearchScope){

                @Override
                protected Icon getDefaultIcon() {
                    return AllIcons.Debugger.Console;
                }

                @Override
                protected RunnerLayoutUi getUi() {
                    return RunTab.this.myUi;
                }

                @Override
                public ProcessHandler getProcessHandler() {
                    return RunTab.this.myRunContentDescriptor == null ? null : RunTab.this.myRunContentDescriptor.getProcessHandler();
                }
            };
        }
        LogConsoleManagerBase logConsoleManagerBase = this.logConsoleManager;
        if (logConsoleManagerBase == null) {
            RunTab.$$$reportNull$$$0(8);
        }
        return logConsoleManagerBase;
    }

    protected final void initLogConsoles(@NotNull RunProfile runConfiguration, @NotNull RunContentDescriptor contentDescriptor, @Nullable ExecutionConsole console) {
        if (runConfiguration == null) {
            RunTab.$$$reportNull$$$0(9);
        }
        if (contentDescriptor == null) {
            RunTab.$$$reportNull$$$0(10);
        }
        ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configuration = (RunConfigurationBase)runConfiguration;
            if (this.myManager == null) {
                this.myManager = new LogFilesManager(this.myProject, this.getLogConsoleManager(), (Disposable)contentDescriptor);
            }
            this.myManager.addLogConsoles(configuration, processHandler2);
            if (processHandler2 != null) {
                OutputFileUtil.attachDumpListener(configuration, processHandler2, console);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerTitle";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/runners/RunTab";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogConsoleManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initLogConsoles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

