/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageErrorFilter
extends HighlightErrorFilter {
    @NotNull
    private final TokenSet myTemplateExpressionEdgeTokens;
    @NotNull
    private final Class myTemplateFileViewProviderClass;
    private final Set<Language> knownLanguageSet;
    private static final Key<FileViewProvider> TOP_LEVEL_VIEW_PROVIDER = Key.create((String)"TOP_LEVEL_VIEW_PROVIDER");

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass) {
        if (templateExpressionEdgeTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(0);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(1);
        }
        this(templateExpressionEdgeTokens, templateFileViewProviderClass, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass, String ... knownSubLanguageNames) {
        if (templateExpressionEdgeTokens == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(2);
        }
        if (templateFileViewProviderClass == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(3);
        }
        if (knownSubLanguageNames == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(4);
        }
        this.myTemplateExpressionEdgeTokens = TokenSet.create((IElementType[])templateExpressionEdgeTokens.getTypes());
        this.myTemplateFileViewProviderClass = templateFileViewProviderClass;
        ArrayList<String> knownSubLanguageList = new ArrayList<String>(Arrays.asList(knownSubLanguageNames));
        knownSubLanguageList.add("JavaScript");
        knownSubLanguageList.add("CSS");
        this.knownLanguageSet = new HashSet<Language>();
        for (String name : knownSubLanguageList) {
            Language language = Language.findLanguageByID((String)name);
            if (language == null) continue;
            this.knownLanguageSet.add(language);
        }
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        if (element == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(5);
        }
        if (this.isKnownSubLanguage(element.getParent().getLanguage())) {
            PsiLanguageInjectionHost host;
            FileViewProvider viewProvider = (FileViewProvider)element.getUserData(TOP_LEVEL_VIEW_PROVIDER);
            if (viewProvider == null) {
                viewProvider = InjectedLanguageManager.getInstance((Project)element.getProject()).getTopLevelFile((PsiElement)element).getViewProvider();
                element.putUserData(TOP_LEVEL_VIEW_PROVIDER, (Object)viewProvider);
            }
            if (!this.isTemplateViewProvider(viewProvider)) {
                return true;
            }
            PsiFile psiFile = element.getContainingFile();
            TextRange range2 = element.getTextRange();
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)psiFile.getProject());
            if (injectedLanguageManager.isInjectedFragment(psiFile) && (host = injectedLanguageManager.getInjectionHost((PsiElement)psiFile)) != null) {
                psiFile = host.getContainingFile();
                range2 = injectedLanguageManager.injectedToHost((PsiElement)psiFile, range2);
            }
            if (this.isNearTemplateExpressions(psiFile, range2.getStartOffset(), range2.getEndOffset()) || TemplateLanguageErrorFilter.hasErrorElementsBeforeAndUp((PsiElement)element) || PsiTreeUtil.findChildOfType((PsiElement)element, OuterLanguageElement.class) != null) {
                return false;
            }
        }
        return true;
    }

    protected boolean isTemplateViewProvider(FileViewProvider viewProvider) {
        return viewProvider.getClass() == this.myTemplateFileViewProviderClass;
    }

    private static boolean hasErrorElementsBeforeAndUp(@NotNull PsiElement element) {
        if (element == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(6);
        }
        JBIterable previousErrors = JBIterable.generate((Object)element, e -> (PsiElement)ObjectUtils.coalesce((Object)e.getPrevSibling(), (Object)e.getParent())).skip(1).filter(PsiErrorElement.class);
        return previousErrors.isNotEmpty();
    }

    protected final boolean isNearTemplateExpressions(@NotNull PsiFile file2, int start2, int end) {
        FileViewProvider viewProvider;
        if (file2 == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(7);
        }
        if (!this.isTemplateViewProvider(viewProvider = file2.getViewProvider()) || file2.getLanguage() == viewProvider.getBaseLanguage()) {
            return false;
        }
        CharSequence fileText = viewProvider.getContents();
        PsiElement beforeWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftBackward((CharSequence)fileText, (int)(start2 - 1), (String)" \t\n"));
        PsiElement afterWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftForward((CharSequence)fileText, (int)end, (String)" \t\n"));
        if (this.isTemplateEdge(afterWs) || this.isTemplateEdge(beforeWs)) {
            return true;
        }
        return this.hasTemplateInside(start2, end, viewProvider);
    }

    private boolean hasTemplateInside(int start2, int end, FileViewProvider viewProvider) {
        int dataEnd;
        PsiElement data = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, start2);
        return data != null && (dataEnd = data.getTextRange().getEndOffset()) < end && this.isTemplateEdge(TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, dataEnd));
    }

    @Nullable
    private static PsiElement findBaseLanguageElement(FileViewProvider viewProvider, int offset) {
        return viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
    }

    private boolean isTemplateEdge(PsiElement e) {
        return this.myTemplateExpressionEdgeTokens.contains(PsiUtilCore.getElementType((PsiElement)e));
    }

    protected boolean isKnownSubLanguage(@NotNull Language language) {
        if (language == null) {
            TemplateLanguageErrorFilter.$$$reportNull$$$0(8);
        }
        for (Language knownLanguage : this.knownLanguageSet) {
            if (!language.is(knownLanguage) && !knownLanguage.getDialects().contains(language)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateExpressionEdgeTokens";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFileViewProviderClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "knownSubLanguageNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/highlighting/TemplateLanguageErrorFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldHighlightErrorElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorElementsBeforeAndUp";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isNearTemplateExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isKnownSubLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

