/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<GitFileRevision> {
    private static final Logger LOG = Logger.getInstance(GitDiffFromHistoryHandler.class);
    @NotNull
    private final Git myGit;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;

    public GitDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(0);
        }
        super(project);
        this.myGit = (Git)ServiceManager.getService((Project)project, Git.class);
        this.myRepositoryManager = GitUtil.getRepositoryManager(project);
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        GitFileRevision rev;
        Collection<String> parents;
        if (e == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(3);
        }
        if (previousRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(4);
        }
        if (revision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(5);
        }
        if ((parents = (rev = (GitFileRevision)revision).getParents()).size() < 2) {
            super.showDiffForOne(e, project, filePath, previousRevision, revision);
        } else {
            this.showDiffForMergeCommit(e, filePath, rev, parents);
        }
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull GitFileRevision rev1, @Nullable GitFileRevision rev2) throws VcsException {
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(6);
        }
        if (rev1 == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(7);
        }
        GitRepository repository = this.getRepository(path);
        String hash1 = rev1.getHash();
        if (rev2 == null) {
            ArrayList<Change> arrayList = new ArrayList<Change>(GitChangeUtils.getDiffWithWorkingDir(this.myProject, repository.getRoot(), hash1, Collections.singleton(path), false));
            if (arrayList == null) {
                GitDiffFromHistoryHandler.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        String hash2 = rev2.getHash();
        ArrayList<Change> arrayList = new ArrayList<Change>(GitChangeUtils.getDiff(this.myProject, repository.getRoot(), hash1, hash2, Collections.singletonList(path)));
        if (arrayList == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull GitFileRevision rev) throws VcsException {
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(10);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(11);
        }
        GitRepository repository = this.getRepository(path);
        ArrayList<Change> arrayList = new ArrayList<Change>(GitChangeUtils.getRevisionChanges(repository.getProject(), repository.getRoot(), rev.getHash(), false, true, true).getChanges());
        if (arrayList == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    protected String getPresentableName(@NotNull GitFileRevision revision) {
        if (revision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(13);
        }
        String string = DvcsUtil.getShortHash((String)revision.getHash());
        if (string == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private GitRepository getRepository(@NotNull FilePath path) {
        GitRepository repository;
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(15);
        }
        LOG.assertTrue((repository = (GitRepository)this.myRepositoryManager.getRepositoryForFile(path)) != null, (Object)("Repository is null for " + path));
        GitRepository gitRepository = repository;
        if (gitRepository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(16);
        }
        return gitRepository;
    }

    private void showDiffForMergeCommit(@NotNull AnActionEvent event, @NotNull FilePath filePath, @NotNull GitFileRevision rev, @NotNull Collection<String> parents) {
        VcsHistorySession session;
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(17);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(18);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(19);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(20);
        }
        List revisions = (session = (VcsHistorySession)event.getData(VcsDataKeys.HISTORY_SESSION)) != null ? session.getRevisionList() : null;
        this.checkIfFileWasTouchedAndFindParentsInBackground(filePath, rev, parents, revisions, (Consumer<? super MergeCommitPreCheckInfo>)((Consumer)info -> {
            if (!info.wasFileTouched()) {
                String message = String.format("There were no changes in %s in this merge commit, besides those which were made in both branches", filePath.getName());
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)message, (MessageType)MessageType.INFO);
            }
            this.showPopup(event, rev, filePath, info.getParents());
        }));
    }

    private void checkIfFileWasTouchedAndFindParentsInBackground(final @NotNull FilePath filePath, final @NotNull GitFileRevision rev, final @NotNull Collection<String> parentHashes, final @Nullable List<? extends VcsFileRevision> revisions, final @NotNull Consumer<? super MergeCommitPreCheckInfo> resultHandler) {
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(21);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(22);
        }
        if (parentHashes == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(23);
        }
        if (resultHandler == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(24);
        }
        new Task.Backgroundable(this.myProject, "Loading changes...", true){
            private MergeCommitPreCheckInfo myInfo;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    GitRepository repository = GitDiffFromHistoryHandler.this.getRepository(filePath);
                    boolean fileTouched = GitDiffFromHistoryHandler.this.wasFileTouched(repository, rev);
                    Collection parents = GitDiffFromHistoryHandler.this.findParentRevisions(repository, rev, parentHashes, revisions);
                    this.myInfo = new MergeCommitPreCheckInfo(fileTouched, parents);
                }
                catch (VcsException e) {
                    String logMessage = "Error happened while executing git show " + rev + ":" + filePath;
                    GitDiffFromHistoryHandler.this.showError(e, logMessage);
                }
            }

            public void onSuccess() {
                if (this.myInfo != null) {
                    resultHandler.consume((Object)this.myInfo);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/history/GitDiffFromHistoryHandler$1", "run"));
            }
        }.queue();
    }

    @NotNull
    private Collection<GitFileRevision> findParentRevisions(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull Collection<String> parentHashes, @Nullable List<? extends VcsFileRevision> revisions) throws VcsException {
        if (repository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(25);
        }
        if (currentRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(26);
        }
        if (parentHashes == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(27);
        }
        ArrayList<GitFileRevision> parents = new ArrayList<GitFileRevision>(parentHashes.size());
        for (String parentHash : parentHashes) {
            parents.add(this.createParentRevision(repository, currentRevision, parentHash, revisions));
        }
        ArrayList<GitFileRevision> arrayList = parents;
        if (arrayList == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private GitFileRevision createParentRevision(@NotNull GitRepository repository, @NotNull GitFileRevision currentRevision, @NotNull String parentHash, @Nullable List<? extends VcsFileRevision> revisions) throws VcsException {
        FilePath currentRevisionPath;
        if (repository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(29);
        }
        if (currentRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(30);
        }
        if (parentHash == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(31);
        }
        if (revisions != null) {
            for (VcsFileRevision vcsFileRevision : revisions) {
                if (!((GitFileRevision)vcsFileRevision).getHash().equals(parentHash)) continue;
                GitFileRevision gitFileRevision = (GitFileRevision)vcsFileRevision;
                if (gitFileRevision == null) {
                    GitDiffFromHistoryHandler.$$$reportNull$$$0(32);
                }
                return gitFileRevision;
            }
        }
        if ((currentRevisionPath = currentRevision.getPath()).isDirectory()) {
            GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
            if (gitFileRevision == null) {
                GitDiffFromHistoryHandler.$$$reportNull$$$0(33);
            }
            return gitFileRevision;
        }
        Collection<Change> collection = GitChangeUtils.getDiff(this.myProject, repository.getRoot(), parentHash, currentRevision.getHash(), null);
        for (Change change : collection) {
            ContentRevision afterRevision = change.getAfterRevision();
            ContentRevision beforeRevision = change.getBeforeRevision();
            if (afterRevision == null || !afterRevision.getFile().equals(currentRevisionPath)) continue;
            FilePath path = beforeRevision != null ? beforeRevision.getFile() : afterRevision.getFile();
            GitFileRevision gitFileRevision = this.makeRevisionFromHash(path, parentHash);
            if (gitFileRevision == null) {
                GitDiffFromHistoryHandler.$$$reportNull$$$0(34);
            }
            return gitFileRevision;
        }
        LOG.error(String.format("Could not find parent revision. Will use the path from parent revision. Current revision: %s, parent hash: %s", currentRevision, parentHash));
        GitFileRevision gitFileRevision = this.makeRevisionFromHash(currentRevisionPath, parentHash);
        if (gitFileRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(35);
        }
        return gitFileRevision;
    }

    private void showPopup(@NotNull AnActionEvent event, @NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<? extends GitFileRevision> parents) {
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(36);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(37);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(38);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(39);
        }
        ActionGroup parentActions = this.createActionGroup(rev, filePath, parents);
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)this.myProject);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Choose parent to compare", parentActions, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true);
        GitDiffFromHistoryHandler.showPopupInBestPosition(popup, event, dataContext);
    }

    private static void showPopupInBestPosition(@NotNull ListPopup popup, @NotNull AnActionEvent event, @NotNull DataContext dataContext) {
        if (popup == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(40);
        }
        if (event == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(41);
        }
        if (dataContext == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(42);
        }
        if (event.getInputEvent() instanceof MouseEvent) {
            if (!event.getPlace().equals("UpdatePopup")) {
                popup.show(new RelativePoint((MouseEvent)event.getInputEvent()));
            } else {
                popup.showInBestPositionFor(dataContext);
            }
        } else {
            popup.showInBestPositionFor(dataContext);
        }
    }

    @NotNull
    private ActionGroup createActionGroup(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull Collection<? extends GitFileRevision> parents) {
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(43);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(44);
        }
        if (parents == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(45);
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        for (GitFileRevision gitFileRevision : parents) {
            actions.add(this.createParentAction(rev, filePath, gitFileRevision));
        }
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(actions.toArray(AnAction.EMPTY_ARRAY));
        if (defaultActionGroup == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(46);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction createParentAction(@NotNull GitFileRevision rev, @NotNull FilePath filePath, @NotNull GitFileRevision parent) {
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(47);
        }
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(48);
        }
        if (parent == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(49);
        }
        ShowDiffWithParentAction showDiffWithParentAction = new ShowDiffWithParentAction(filePath, rev, parent);
        if (showDiffWithParentAction == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(50);
        }
        return showDiffWithParentAction;
    }

    @NotNull
    private GitFileRevision makeRevisionFromHash(@NotNull FilePath filePath, @NotNull String hash) {
        if (filePath == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(51);
        }
        if (hash == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(52);
        }
        GitFileRevision gitFileRevision = new GitFileRevision(this.myProject, filePath, new GitRevisionNumber(hash));
        if (gitFileRevision == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(53);
        }
        return gitFileRevision;
    }

    private boolean wasFileTouched(@NotNull GitRepository repository, @NotNull GitFileRevision rev) throws VcsException {
        GitCommandResult result2;
        if (repository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(54);
        }
        if (rev == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(55);
        }
        if ((result2 = this.myGit.show(repository, rev.getHash())).success()) {
            return GitDiffFromHistoryHandler.isFilePresentInOutput(repository, rev.getPath(), result2.getOutput());
        }
        throw new VcsException(result2.getErrorOutputAsJoinedString());
    }

    private static boolean isFilePresentInOutput(@NotNull GitRepository repository, @NotNull FilePath path, @NotNull List<String> output) {
        if (repository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(56);
        }
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(57);
        }
        if (output == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(58);
        }
        String relativePath = GitDiffFromHistoryHandler.getRelativePath(repository, path);
        for (String line : output) {
            if (!line.startsWith("---") && !line.startsWith("+++") || !line.contains(relativePath)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull GitRepository repository, @NotNull FilePath path) {
        if (repository == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(59);
        }
        if (path == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(60);
        }
        return FileUtil.getRelativePath((String)repository.getRoot().getPath(), (String)path.getPath(), (char)'/');
    }

    @NotNull
    private static String getRevisionDescription(@NotNull GitFileRevision parent) {
        if (parent == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(61);
        }
        String hash = DvcsUtil.getShortHash((String)parent.getHash());
        String message = parent.getCommitMessage();
        if (message != null) {
            int index = StringUtil.indexOfAny((String)message, (String)"\n\r");
            if (index != -1) {
                message = message.substring(0, index) + "...";
            }
            if (message.length() > 40) {
                message = message.substring(0, 35) + "...";
            }
            String string = hash + " - " + message;
            if (string == null) {
                GitDiffFromHistoryHandler.$$$reportNull$$$0(62);
            }
            return string;
        }
        String string = hash;
        if (string == null) {
            GitDiffFromHistoryHandler.$$$reportNull$$$0(63);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 46: 
            case 50: 
            case 53: 
            case 62: 
            case 63: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 46: 
            case 50: 
            case 53: 
            case 62: 
            case 63: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 18: 
            case 21: 
            case 38: 
            case 44: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRevision";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev1";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 46: 
            case 50: 
            case 53: 
            case 62: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitDiffFromHistoryHandler";
                break;
            }
            case 11: 
            case 19: 
            case 22: 
            case 37: 
            case 43: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 17: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 20: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHashes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultHandler";
                break;
            }
            case 25: 
            case 29: 
            case 54: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRevision";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentHash";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 49: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitDiffFromHistoryHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBetweenRevisions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChanges";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findParentRevisions";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentRevision";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionGroup";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createParentAction";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "makeRevisionFromHash";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getRevisionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForOne";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChangesBetweenRevisions";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 46: 
            case 50: 
            case 53: 
            case 62: 
            case 63: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChanges";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForMergeCommit";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkIfFileWasTouchedAndFindParentsInBackground";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findParentRevisions";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createParentRevision";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showPopupInBestPosition";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createActionGroup";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createParentAction";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "makeRevisionFromHash";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "wasFileTouched";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isFilePresentInOutput";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 28: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 46: 
            case 50: 
            case 53: 
            case 62: 
            case 63: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ShowDiffWithParentAction
    extends DumbAwareAction {
        @NotNull
        private final FilePath myFilePath;
        @NotNull
        private final GitFileRevision myRevision;
        @NotNull
        private final GitFileRevision myParentRevision;

        ShowDiffWithParentAction(@NotNull FilePath filePath, @NotNull GitFileRevision rev, GitFileRevision parent) {
            if (filePath == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(0);
            }
            if (rev == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(2);
            }
            super(GitDiffFromHistoryHandler.getRevisionDescription(parent), parent.getCommitMessage(), null);
            this.myFilePath = filePath;
            this.myRevision = rev;
            this.myParentRevision = parent;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowDiffWithParentAction.$$$reportNull$$$0(3);
            }
            GitDiffFromHistoryHandler.this.doShowDiff(this.myFilePath, (VcsFileRevision)this.myParentRevision, (VcsFileRevision)this.myRevision);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rev";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "git4idea/history/GitDiffFromHistoryHandler$ShowDiffWithParentAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MergeCommitPreCheckInfo {
        private final boolean myWasFileTouched;
        private final Collection<GitFileRevision> myParents;

        private MergeCommitPreCheckInfo(boolean touched, Collection<GitFileRevision> parents) {
            this.myWasFileTouched = touched;
            this.myParents = parents;
        }

        public boolean wasFileTouched() {
            return this.myWasFileTouched;
        }

        public Collection<GitFileRevision> getParents() {
            return this.myParents;
        }
    }
}

