/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.util.PathUtilRt;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StorageId;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0002J\u0012\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0002J\u0012\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0002J\u0012\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u0012\u001a\u00020\u0003H\u0007J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u000fJ\u001c\u0010\u0019\u001a\u00020\u00112\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00110\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/util/StorageId;", "", "subdirName", "", "logId", "version", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "features", "", "(Ljava/lang/String;Ljava/lang/String;I[Z)V", "safeLogId", "getVersion", "()I", "cleanupAllStorageFiles", "", "cleanupStorageFiles", "", "kind", "forMapIndexStorage", "featuresSuffix", "getFile", "Ljava/io/File;", "getFileForMapIndexStorage", "getStorageFile", "iterateOverOtherFeatures", "function", "Lkotlin/Function1;", "subdir", "intellij.platform.vcs.log.impl"})
public final class StorageId {
    private final String safeLogId;
    private final String subdirName;
    private final String logId;
    private final int version;
    private final boolean[] features;

    @NotNull
    public final File subdir() {
        return new File(PersistentUtil.LOG_CACHE, this.subdirName);
    }

    /*
     * WARNING - void declaration
     */
    private final String featuresSuffix() {
        Collection<Integer> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        boolean[] blArray = this.features;
        boolean bl = false;
        if (blArray.length == 0) {
            return "";
        }
        blArray = this.features;
        StringBuilder stringBuilder = new StringBuilder().append(".");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var6_7 = $this$mapTo$iv$iv;
        int n = ((void)var6_7).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = var6_7[i];
            collection = destination$iv$iv;
            boolean bl2 = false;
            Integer n2 = it != false ? 1 : 0;
            collection.add(n2);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, (Function1)featuresSuffix.2.INSTANCE, (int)31, null)).toString();
    }

    private final File getFile(String kind) {
        CharSequence charSequence = kind;
        boolean bl = false;
        String name = charSequence.length() == 0 ? this.safeLogId + '.' + this.version : this.safeLogId + '.' + kind + '.' + this.version;
        return new File(this.subdir(), name + this.featuresSuffix());
    }

    static /* synthetic */ File getFile$default(StorageId storageId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return storageId.getFile(string);
    }

    private final File getFileForMapIndexStorage(String kind) {
        File file = MapIndexStorage.getIndexStorageFile((File)this.getFile(kind));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"MapIndexStorage.getIndexStorageFile(getFile(kind))");
        return file;
    }

    static /* synthetic */ File getFileForMapIndexStorage$default(StorageId storageId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return storageId.getFileForMapIndexStorage(string);
    }

    /*
     * WARNING - void declaration
     */
    private final void iterateOverOtherFeatures(Function1<? super boolean[], Unit> function) {
        boolean[] blArray = this.features;
        int n = 0;
        if (blArray.length == 0) {
            return;
        }
        n = this.features.length;
        boolean[] blArray2 = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            boolean bl;
            int n3 = n2;
            int n4 = n2++;
            boolean[] blArray3 = blArray2;
            boolean bl2 = false;
            blArray3[n4] = bl = false;
        }
        boolean[] f = blArray2;
        block1: while (true) {
            boolean[] blArray4 = this.features;
            int n5 = 0;
            if (!Arrays.equals(blArray4, f)) {
                function.invoke((Object)f);
            }
            n = 0;
            n5 = this.features.length;
            while (n < n5) {
                void i;
                if (!f[i]) {
                    f[i] = true;
                    continue block1;
                }
                f[i] = false;
                ++i;
            }
            break;
        }
    }

    @JvmOverloads
    @NotNull
    public final File getStorageFile(@NotNull String kind) {
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        File storageFile = this.getFile(kind);
        if (!storageFile.exists()) {
            IOUtil.deleteAllFilesStartingWith((File)new File(this.subdir(), this.safeLogId));
        }
        return storageFile;
    }

    public static /* synthetic */ File getStorageFile$default(StorageId storageId, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return storageId.getStorageFile(string);
    }

    @JvmOverloads
    @NotNull
    public final File getStorageFile() {
        return StorageId.getStorageFile$default(this, null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final File getStorageFile(@NotNull String kind, boolean forMapIndexStorage) {
        File storageFile;
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        File file = storageFile = forMapIndexStorage ? this.getFileForMapIndexStorage(kind) : this.getFile(kind);
        if (!storageFile.exists()) {
            int n = 0;
            int n2 = this.version;
            while (n < n2) {
                void oldVersion;
                new StorageId(this.subdirName, this.logId, (int)oldVersion).cleanupStorageFiles(kind, forMapIndexStorage);
                ++oldVersion;
            }
            this.iterateOverOtherFeatures((Function1<? super boolean[], Unit>)((Function1)new Function1<boolean[], Unit>(this, kind, forMapIndexStorage){
                final /* synthetic */ StorageId this$0;
                final /* synthetic */ String $kind;
                final /* synthetic */ boolean $forMapIndexStorage;

                public final void invoke(@NotNull boolean[] it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    StorageId.access$cleanupStorageFiles(new StorageId(StorageId.access$getSubdirName$p(this.this$0), StorageId.access$getLogId$p(this.this$0), this.this$0.getVersion(), it), this.$kind, this.$forMapIndexStorage);
                }
                {
                    this.this$0 = storageId;
                    this.$kind = string;
                    this.$forMapIndexStorage = bl;
                    super(1);
                }
            }));
        }
        return this.getFile(kind);
    }

    public static /* synthetic */ File getStorageFile$default(StorageId storageId, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return storageId.getStorageFile(string, bl);
    }

    private final void cleanupStorageFiles(String kind, boolean forMapIndexStorage) {
        File oldStorageFile = forMapIndexStorage ? this.getFileForMapIndexStorage(kind) : this.getFile(kind);
        IOUtil.deleteAllFilesStartingWith((File)oldStorageFile);
    }

    public final boolean cleanupAllStorageFiles() {
        return PersistentUtil.INSTANCE.deleteWithRenamingAllFilesStartingWith$intellij_platform_vcs_log_impl(new File(this.subdir(), this.safeLogId + '.'));
    }

    public final int getVersion() {
        return this.version;
    }

    public StorageId(@NotNull String subdirName, @NotNull String logId, int version, @NotNull boolean[] features) {
        Intrinsics.checkParameterIsNotNull((Object)subdirName, (String)"subdirName");
        Intrinsics.checkParameterIsNotNull((Object)logId, (String)"logId");
        Intrinsics.checkParameterIsNotNull((Object)features, (String)"features");
        this.subdirName = subdirName;
        this.logId = logId;
        this.version = version;
        this.features = features;
        String string = PathUtilRt.suggestFileName((String)this.logId, (boolean)true, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PathUtilRt.suggestFileName(logId, true, true)");
        this.safeLogId = string;
    }

    public StorageId(@NotNull String subdirName, @NotNull String logId, int version) {
        Intrinsics.checkParameterIsNotNull((Object)subdirName, (String)"subdirName");
        Intrinsics.checkParameterIsNotNull((Object)logId, (String)"logId");
        this(subdirName, logId, version, new boolean[0]);
    }

    public static final /* synthetic */ void access$cleanupStorageFiles(StorageId $this, String kind, boolean forMapIndexStorage) {
        $this.cleanupStorageFiles(kind, forMapIndexStorage);
    }

    public static final /* synthetic */ String access$getSubdirName$p(StorageId $this) {
        return $this.subdirName;
    }

    public static final /* synthetic */ String access$getLogId$p(StorageId $this) {
        return $this.logId;
    }
}

