/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabbedShowHistoryAction
extends AbstractVcsAction
implements UpdateInBackground {
    @Override
    protected void update(@NotNull VcsContext context, @NotNull Presentation presentation) {
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        presentation.setEnabled(this.isEnabled(context));
        presentation.setVisible(project != null && ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss());
    }

    protected boolean isEnabled(@NotNull VcsContext context) {
        Project project;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(2);
        }
        if ((project = context.getProject()) == null) {
            return false;
        }
        List<FilePath> selectedFiles = context.getSelectedFilePathsStream().collect(Collectors.toList());
        if (selectedFiles.isEmpty()) {
            return false;
        }
        if (!ContainerUtil.all(selectedFiles, path -> AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)path))) {
            return false;
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project, selectedFiles)) {
            return true;
        }
        if (selectedFiles.size() > 1) {
            return false;
        }
        FilePath selectedPath = (FilePath)ContainerUtil.getFirstItem(selectedFiles);
        if (selectedPath == null) {
            return false;
        }
        VirtualFile fileOrParent = TabbedShowHistoryAction.getExistingFileOrParent(selectedPath);
        if (fileOrParent == null) {
            return false;
        }
        return TabbedShowHistoryAction.canShowOldFileHistory(project, selectedPath, fileOrParent);
    }

    private static boolean canShowOldFileHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile fileOrParent) {
        AbstractVcs vcs;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(3);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(4);
        }
        if (fileOrParent == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(5);
        }
        if ((vcs = ChangesUtil.getVcsForFile((VirtualFile)fileOrParent, (Project)project)) == null) {
            return false;
        }
        VcsHistoryProvider provider = vcs.getVcsHistoryProvider();
        return provider != null && (provider.supportsHistoryForDirectories() || !path.isDirectory()) && provider.canShowHistoryFor(fileOrParent);
    }

    private static boolean canShowNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        VcsLogFileHistoryProvider historyProvider;
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(6);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(7);
        }
        return (historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class)) != null && historyProvider.canShowFileHistory(project, paths, null);
    }

    @Nullable
    private static VirtualFile getExistingFileOrParent(@NotNull FilePath selectedPath) {
        if (selectedPath == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(8);
        }
        return (VirtualFile)ObjectUtils.chooseNotNull((Object)selectedPath.getVirtualFile(), (Object)selectedPath.getVirtualFileParent());
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context) {
        List<FilePath> selectedFiles;
        Project project;
        if (context == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(9);
        }
        if (TabbedShowHistoryAction.canShowNewFileHistory(project = (Project)ObjectUtils.assertNotNull((Object)context.getProject()), selectedFiles = context.getSelectedFilePathsStream().collect(Collectors.toList()))) {
            TabbedShowHistoryAction.showNewFileHistory(project, selectedFiles);
        } else if (selectedFiles.size() == 1) {
            FilePath path = (FilePath)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(selectedFiles));
            AbstractVcs vcs = (AbstractVcs)ObjectUtils.assertNotNull((Object)ChangesUtil.getVcsForFile((VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)TabbedShowHistoryAction.getExistingFileOrParent(path))), (Project)project));
            TabbedShowHistoryAction.showOldFileHistory(project, vcs, path);
        }
    }

    private static void showNewFileHistory(@NotNull Project project, @NotNull Collection<FilePath> paths) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(10);
        }
        if (paths == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(11);
        }
        VcsLogFileHistoryProvider historyProvider = (VcsLogFileHistoryProvider)ServiceManager.getService(VcsLogFileHistoryProvider.class);
        historyProvider.showFileHistory(project, paths, null);
    }

    private static void showOldFileHistory(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull FilePath path) {
        if (project == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(12);
        }
        if (vcs == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(13);
        }
        if (path == null) {
            TabbedShowHistoryAction.$$$reportNull$$$0(14);
        }
        VcsHistoryProvider provider = (VcsHistoryProvider)ObjectUtils.assertNotNull((Object)vcs.getVcsHistoryProvider());
        AbstractVcsHelper.getInstance((Project)project).showFileHistory(provider, vcs.getAnnotationProvider(), path, vcs);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrParent";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/TabbedShowHistoryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowOldFileHistory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "canShowNewFileHistory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getExistingFileOrParent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "showNewFileHistory";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "showOldFileHistory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

