/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.StringFactory;
import com.intellij.util.xml.NanoXmlBuilder;
import com.intellij.util.xml.XmlFileHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLEntityResolver;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.IXMLValidator;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NanoXmlUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.NanoXmlUtil");

    private NanoXmlUtil() {
    }

    private static MyXMLReader createReader(PsiFile psiFile) {
        return new MyXMLReader((Reader)new CharSequenceReader(psiFile.getViewProvider().getContents()));
    }

    public static void parseFile(PsiFile psiFile, IXMLBuilder builder) {
        MyXMLReader reader = NanoXmlUtil.createReader(psiFile);
        NanoXmlUtil.parse((IXMLReader)reader, builder);
    }

    public static void parse(InputStream is, IXMLBuilder builder) {
        try {
            NanoXmlUtil.parse((IXMLReader)new MyXMLReader(is), builder);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void parse(Reader reader, IXMLBuilder builder) {
        NanoXmlUtil.parse(reader, builder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(@NotNull Reader reader, @NotNull IXMLBuilder builder, @Nullable IXMLValidator validator) {
        if (reader == null) {
            NanoXmlUtil.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            NanoXmlUtil.$$$reportNull$$$0(1);
        }
        try {
            NanoXmlUtil.parse((IXMLReader)new MyXMLReader(reader), builder, validator);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void parse(IXMLReader r, IXMLBuilder builder) {
        NanoXmlUtil.parse(r, builder, null);
    }

    public static void parse(IXMLReader r, IXMLBuilder builder, @Nullable IXMLValidator validator) {
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader(r);
            parser.setBuilder(builder);
            parser.setValidator((IXMLValidator)(validator == null ? new EmptyValidator() : validator));
            parser.setResolver((IXMLEntityResolver)new EmptyEntityResolver());
            try {
                parser.parse();
            }
            catch (ParserStoppedXmlException parserStoppedXmlException) {
            }
            catch (XMLException e) {
                LOG.debug((Throwable)e);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    public static XmlFileHeader parseHeader(VirtualFile file) {
        XmlFileHeader xmlFileHeader;
        try {
            xmlFileHeader = NanoXmlUtil.parseHeaderWithException(file);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            if (null == null) {
                NanoXmlUtil.$$$reportNull$$$0(3);
            }
            return null;
        }
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(2);
        }
        return xmlFileHeader;
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(Reader reader) {
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader(new MyXMLReader(reader));
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(4);
        }
        return xmlFileHeader;
    }

    @NotNull
    public static XmlFileHeader parseHeaderWithException(VirtualFile file) throws IOException {
        XmlFileHeader xmlFileHeader;
        try (InputStream stream = file.getInputStream();){
            XmlFileHeader xmlFileHeader2 = NanoXmlUtil.parseHeader(new MyXMLReader(stream));
            xmlFileHeader = xmlFileHeader2;
        }
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(5);
        }
        return xmlFileHeader;
    }

    @NotNull
    public static XmlFileHeader parseHeader(Reader reader) {
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader(new MyXMLReader(reader));
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(6);
        }
        return xmlFileHeader;
    }

    @NotNull
    public static XmlFileHeader parseHeader(PsiFile file) {
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader(NanoXmlUtil.createReader(file));
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(7);
        }
        return xmlFileHeader;
    }

    @NotNull
    private static XmlFileHeader parseHeader(MyXMLReader r) {
        RootTagInfoBuilder builder = new RootTagInfoBuilder();
        NanoXmlUtil.parse((IXMLReader)r, (IXMLBuilder)builder);
        XmlFileHeader xmlFileHeader = new XmlFileHeader(builder.getRootTagName(), builder.getNamespace(), r.publicId, r.systemId);
        if (xmlFileHeader == null) {
            NanoXmlUtil.$$$reportNull$$$0(8);
        }
        return xmlFileHeader;
    }

    public static String createLocation(String ... tagNames) {
        StringBuilder result = new StringBuilder();
        for (String tagName : tagNames) {
            result.append(".");
            result.append(tagName);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/NanoXmlUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHeaderWithException";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RootTagInfoBuilder
    implements IXMLBuilder {
        private String myRootTagName;
        private String myNamespace;

        private RootTagInfoBuilder() {
        }

        public void startBuilding(String systemID, int lineNr) {
        }

        public void newProcessingInstruction(String target, Reader reader) {
        }

        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myRootTagName = name;
            this.myNamespace = nsURI;
            throw ParserStoppedXmlException.INSTANCE;
        }

        public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) {
        }

        public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) {
        }

        public void endElement(String name, String nsPrefix, String nsURI) {
        }

        public void addPCData(Reader reader, String systemID, int lineNr) {
        }

        public String getNamespace() {
            return this.myNamespace;
        }

        public String getRootTagName() {
            return this.myRootTagName;
        }

        public String getResult() {
            return this.myRootTagName;
        }
    }

    public static class ParserStoppedXmlException
    extends XMLException {
        public static final ParserStoppedXmlException INSTANCE = new ParserStoppedXmlException();

        private ParserStoppedXmlException() {
            super("Parsing stopped");
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private static class MyXMLReader
    extends StdXMLReader {
        private String publicId;
        private String systemId;

        MyXMLReader(@NotNull Reader documentReader) {
            if (documentReader == null) {
                MyXMLReader.$$$reportNull$$$0(0);
            }
            super(documentReader);
        }

        MyXMLReader(InputStream stream) throws IOException {
            super(stream);
        }

        public Reader openStream(String publicId, String systemId) {
            this.publicId = StringUtil.isEmpty((String)publicId) ? null : publicId;
            this.systemId = StringUtil.isEmpty((String)systemId) ? null : systemId;
            return new StringReader(" ");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentReader", "com/intellij/util/xml/NanoXmlUtil$MyXMLReader", "<init>"));
        }
    }

    private static class EmptyEntityResolver
    implements IXMLEntityResolver {
        private EmptyEntityResolver() {
        }

        public void addInternalEntity(String name, String value) {
        }

        public void addExternalEntity(String name, String publicID, String systemID) {
        }

        public Reader getEntity(IXMLReader xmlReader, String name) {
            return new StringReader("");
        }

        public boolean isExternalEntity(String name) {
            return false;
        }
    }

    public static class EmptyValidator
    extends NonValidator {
        private IXMLEntityResolver myParameterEntityResolver;

        public void setParameterEntityResolver(IXMLEntityResolver resolver) {
            this.myParameterEntityResolver = resolver;
        }

        public IXMLEntityResolver getParameterEntityResolver() {
            return this.myParameterEntityResolver;
        }

        public void parseDTD(String publicID, IXMLReader reader, IXMLEntityResolver entityResolver, boolean external) throws Exception {
            if (!external) {
                int cnt = 1;
                char ch = reader.read();
                while (ch != ']' || --cnt != 0) {
                    if (ch == '[') {
                        ++cnt;
                    }
                    ch = reader.read();
                }
            } else {
                char ch;
                int origLevel = reader.getStreamLevel();
                do {
                    ch = reader.read();
                } while (reader.getStreamLevel() >= origLevel);
                reader.unread(ch);
                return;
            }
        }

        public void elementStarted(String name, String systemId, int lineNr) {
        }

        public void elementEnded(String name, String systemId, int lineNr) {
        }

        public void attributeAdded(String key, String value, String systemId, int lineNr) {
        }

        public void elementAttributesProcessed(String name, Properties extraAttributes, String systemId, int lineNr) {
        }

        public void PCDataAdded(String systemId, int lineNr) {
        }
    }

    public static class BaseXmlBuilder
    implements NanoXmlBuilder {
        private final Stack<String> myLocation = new Stack();

        @Override
        public void startBuilding(String systemID, int lineNr) {
            this.myLocation.push((Object)"");
        }

        @Override
        public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
            this.myLocation.push((Object)((String)this.myLocation.peek() + "." + name));
        }

        @Override
        public void endElement(String name, String nsPrefix, String nsURI) throws Exception {
            this.myLocation.pop();
        }

        protected static String readText(Reader reader) throws IOException {
            return StringFactory.createShared((char[])StreamUtil.readTextAndConvertSeparators((Reader)reader));
        }

        protected String getLocation() {
            return (String)this.myLocation.peek();
        }
    }

    @Deprecated
    public static abstract class IXMLBuilderAdapter
    implements NanoXmlBuilder {
        @Deprecated
        protected static void stop() throws ParserStoppedXmlException {
            throw ParserStoppedXmlException.INSTANCE;
        }
    }
}

