/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.openapi.MnemonicWrapper;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ComponentTreeWatcher;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntPredicate;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MnemonicHelper
extends ComponentTreeWatcher {
    private static final Logger LOG = Logger.getInstance(MnemonicHelper.class);
    public static final Key<IntPredicate> MNEMONIC_CHECKER = Key.create((String)"MNEMONIC_CHECKER");
    private static final String TEXT_CHANGED_PROPERTY = "text";
    private static final PropertyChangeListener ourTextPropertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            Object source = event.getSource();
            if (source instanceof AbstractButton) {
                SwingUtilities.invokeLater(() -> DialogUtil.registerMnemonic((AbstractButton)source));
            } else if (source instanceof JLabel) {
                SwingUtilities.invokeLater(() -> DialogUtil.registerMnemonic((JLabel)source, null));
            }
        }
    };
    private Map<Integer, String> myMnemonics;
    private static final MnemonicFixer ourMnemonicFixer = new MnemonicFixer();

    @Deprecated
    public MnemonicHelper() {
        super(ArrayUtil.EMPTY_CLASS_ARRAY);
    }

    @Override
    protected void processComponent(Component component) {
        if (component instanceof AbstractButton) {
            component.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, ourTextPropertyListener);
            DialogUtil.registerMnemonic((AbstractButton)component);
            this.checkForDuplicateMnemonics((AbstractButton)component);
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component, null);
        } else if (component instanceof JLabel) {
            component.addPropertyChangeListener(TEXT_CHANGED_PROPERTY, ourTextPropertyListener);
            DialogUtil.registerMnemonic((JLabel)component, null);
            this.checkForDuplicateMnemonics((JLabel)component);
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component, "release");
        } else if (component instanceof ActionButtonComponent) {
            MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)component, null);
        }
    }

    private static void fixMacMnemonicKeyStroke(JComponent component, String type) {
        KeyStroke[] strokes;
        InputMap inputMap;
        if (SystemInfo.isMac && Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") && (inputMap = component.getInputMap(2)) != null && (strokes = inputMap.allKeys()) != null) {
            int mask = 10;
            for (KeyStroke stroke : strokes) {
                if (mask != (mask & stroke.getModifiers())) continue;
                inputMap.put(MnemonicHelper.getKeyStrokeWithoutCtrlModifier(stroke), type != null ? type : inputMap.get(stroke));
            }
        }
    }

    private static KeyStroke getKeyStrokeWithoutCtrlModifier(KeyStroke stroke) {
        try {
            Method method = AWTKeyStroke.class.getDeclaredMethod("getCachedStroke", Character.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            method.setAccessible(true);
            int modifiers = stroke.getModifiers() & 0xFFFFFFFD & 0xFFFFFF7F;
            return (KeyStroke)method.invoke(null, Character.valueOf(stroke.getKeyChar()), stroke.getKeyCode(), modifiers, stroke.isOnKeyRelease());
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    @Override
    protected void unprocessComponent(Component component) {
    }

    public void checkForDuplicateMnemonics(JLabel label) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(label.getDisplayedMnemonic(), label.getText());
    }

    public void checkForDuplicateMnemonics(AbstractButton button) {
        if (!Registry.is((String)"ide.checkDuplicateMnemonics")) {
            return;
        }
        this.checkForDuplicateMnemonics(button.getMnemonic(), button.getText());
    }

    public void checkForDuplicateMnemonics(int mnemonic, String text) {
        String other;
        if (mnemonic == 0) {
            return;
        }
        if (this.myMnemonics == null) {
            this.myMnemonics = new HashMap<Integer, String>();
        }
        if ((other = this.myMnemonics.get(mnemonic)) != null && !other.equals(text)) {
            LOG.error("conflict: multiple components with mnemonic '" + (char)mnemonic + "' seen on '" + text + "' and '" + other + "'");
        }
        this.myMnemonics.put(mnemonic, text);
    }

    public static CustomShortcutSet createShortcut(char ch) {
        Character mnemonic = Character.valueOf(ch);
        return CustomShortcutSet.fromString("alt " + (SystemInfo.isMac ? "released" : "pressed") + " " + mnemonic);
    }

    public static void init(Component component) {
        if (Registry.is((String)"ide.mnemonic.helper.old") || Registry.is((String)"ide.checkDuplicateMnemonics")) {
            new MnemonicHelper().register(component);
        } else {
            ourMnemonicFixer.addTo(component);
        }
    }

    public static boolean hasMnemonic(@Nullable Component component, int keyCode) {
        if (component instanceof AbstractButton) {
            AbstractButton button = (AbstractButton)component;
            if (button instanceof JBOptionButton) {
                return ((JBOptionButton)button).isOkToProcessDefaultMnemonics() || button.getMnemonic() == keyCode;
            }
            return button.getMnemonic() == keyCode;
        }
        if (component instanceof JLabel) {
            return ((JLabel)component).getDisplayedMnemonic() == keyCode;
        }
        IntPredicate checker = (IntPredicate)UIUtil.getClientProperty((Object)component, MNEMONIC_CHECKER);
        return checker != null && checker.test(keyCode);
    }

    public static int getFocusAcceleratorKeyMask() {
        return SystemInfo.isMac ? 10 : 8;
    }

    public static void registerMnemonicAction(@NotNull JComponent component, int mnemonic) {
        if (component == null) {
            MnemonicHelper.$$$reportNull$$$0(0);
        }
        InputMap map = component.getInputMap(2);
        int mask = MnemonicHelper.getFocusAcceleratorKeyMask();
        if (component instanceof AbstractButton) {
            map.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "pressed");
            map.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
            map.put(KeyStroke.getKeyStroke(mnemonic, 0, true), "released");
        } else if (component instanceof JLabel) {
            map.put(KeyStroke.getKeyStroke(mnemonic, mask, true), "released");
        } else if (component instanceof ActionButtonComponent) {
            map.put(KeyStroke.getKeyStroke(mnemonic, mask, false), "doClick");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/MnemonicHelper", "registerMnemonicAction"));
    }

    private static class MnemonicFixer
    implements ContainerListener {
        private MnemonicFixer() {
        }

        void addTo(Component component) {
            for (Component c : UIUtil.uiTraverser((Component)component)) {
                if (c instanceof Container) {
                    ((Container)c).addContainerListener(this);
                }
                if (c instanceof ActionButtonComponent) {
                    MnemonicHelper.fixMacMnemonicKeyStroke((JComponent)c, null);
                }
                MnemonicWrapper.getWrapper(c);
            }
        }

        void removeFrom(Component component) {
            for (Container c : UIUtil.uiTraverser((Component)component).filter(Container.class)) {
                c.removeContainerListener(this);
            }
        }

        @Override
        public void componentAdded(ContainerEvent event) {
            this.addTo(event.getChild());
        }

        @Override
        public void componentRemoved(ContainerEvent event) {
            this.removeFrom(event.getChild());
        }
    }
}

