/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubErrorMessage;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsListLoader;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchPanel;
import org.jetbrains.plugins.github.pullrequest.search.GithubPullRequestSearchQueryHolder;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsList;
import org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListSelectionHolder;
import org.jetbrains.plugins.github.pullrequest.ui.HtmlInfoPanel;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0000\u0018\u0000 22\u00020\u00012\u00020\u0002:\u00012B[\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0002J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020'H\u0002J\b\u0010-\u001a\u00020'H\u0002J\b\u0010.\u001a\u00020'H\u0002J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0002J\b\u00101\u001a\u00020'H\u0002R\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListWithSearchPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "copyPasteManager", "Lcom/intellij/openapi/ide/CopyPasteManager;", "actionManager", "Lcom/intellij/openapi/actionSystem/ActionManager;", "autoPopupController", "Lcom/intellij/codeInsight/AutoPopupController;", "avatarIconsProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "loader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsListLoader;", "dataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;", "listModel", "Ljavax/swing/ListModel;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "searchQueryHolder", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQueryHolder;", "listSelectionHolder", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListSelectionHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/ide/CopyPasteManager;Lcom/intellij/openapi/actionSystem/ActionManager;Lcom/intellij/codeInsight/AutoPopupController;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;Ljavax/swing/ListModel;Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchQueryHolder;Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListSelectionHolder;)V", "autoSelectionNumber", "", "Ljava/lang/Long;", "infoPanel", "Lorg/jetbrains/plugins/github/pullrequest/ui/HtmlInfoPanel;", "list", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsList;", "progressStripe", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "scrollPane", "Ljavax/swing/JScrollPane;", "search", "Lorg/jetbrains/plugins/github/pullrequest/search/GithubPullRequestSearchPanel;", "dispose", "", "getErrorPrefix", "", "isScrollAtThreshold", "", "potentiallyLoadMore", "reset", "resetSearch", "updateEmptyText", "updateInfoPanel", "updateProgress", "Companion", "intellij.vcs.github"})
public final class GithubPullRequestsListWithSearchPanel
extends BorderLayoutPanel
implements Disposable {
    private final GithubPullRequestsList list;
    private final JScrollPane scrollPane;
    private final HtmlInfoPanel infoPanel;
    private final ProgressStripe progressStripe;
    private final GithubPullRequestSearchPanel search;
    private Long autoSelectionNumber;
    private final GithubPullRequestsListLoader loader;
    private final GithubPullRequestsDataLoader dataLoader;
    private final ListModel<GithubSearchedIssue> listModel;
    private final GithubPullRequestSearchQueryHolder searchQueryHolder;
    private final GithubPullRequestsListSelectionHolder listSelectionHolder;
    public static final Companion Companion = new Companion(null);

    private final void updateProgress() {
        if (this.loader.getLoading()) {
            this.progressStripe.startLoading();
        } else {
            this.progressStripe.stopLoading();
            this.scrollPane.getViewport().validate();
            if (this.loader.getError() == null) {
                this.potentiallyLoadMore();
            }
        }
    }

    private final void updateEmptyText() {
        this.list.getEmptyText().clear();
        if (this.loader.getLoading()) {
            StatusText statusText = this.list.getEmptyText();
            Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
            statusText.setText("Loading pull requests...");
        } else {
            Throwable error = this.loader.getError();
            if (error != null) {
                this.list.getEmptyText().appendText(this.getErrorPrefix(), SimpleTextAttributes.ERROR_ATTRIBUTES).appendSecondaryText(org.jetbrains.plugins.github.pullrequest.ui.GithubPullRequestsListWithSearchPanel$Companion.getLoadingErrorText$default(Companion, error, null, 2, null), SimpleTextAttributes.ERROR_ATTRIBUTES, null).appendSecondaryText("  ", SimpleTextAttributes.ERROR_ATTRIBUTES, null).appendSecondaryText("Retry", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                    final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;

                    public final void actionPerformed(ActionEvent it) {
                        GithubPullRequestsListWithSearchPanel.access$getLoader$p(this.this$0).reset();
                    }
                    {
                        this.this$0 = githubPullRequestsListWithSearchPanel;
                    }
                });
            } else if (this.searchQueryHolder.getSearchQuery().isEmpty()) {
                StatusText statusText = this.list.getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
                statusText.setText("No pull requests loaded. ");
                this.list.getEmptyText().appendSecondaryText("Refresh", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                    final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;

                    public final void actionPerformed(ActionEvent it) {
                        GithubPullRequestsListWithSearchPanel.access$getLoader$p(this.this$0).reset();
                    }
                    {
                        this.this$0 = githubPullRequestsListWithSearchPanel;
                    }
                });
            } else {
                StatusText statusText = this.list.getEmptyText();
                Intrinsics.checkExpressionValueIsNotNull((Object)statusText, (String)"list.emptyText");
                statusText.setText("No pull requests matching filters. ");
                this.list.getEmptyText().appendSecondaryText("Reset Filters", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                    final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;

                    public final void actionPerformed(ActionEvent it) {
                        GithubPullRequestsListWithSearchPanel.access$resetSearch(this.this$0);
                    }
                    {
                        this.this$0 = githubPullRequestsListWithSearchPanel;
                    }
                });
            }
        }
    }

    private final void updateInfoPanel() {
        Throwable error = this.loader.getError();
        if (error != null && this.listModel.getSize() != 0) {
            this.infoPanel.setInfo("<html><body>" + this.getErrorPrefix() + "<br/>" + GithubPullRequestsListWithSearchPanel.Companion.getLoadingErrorText(error, "<br/>") + "<a href=''>Retry</a></body></html>", HtmlInfoPanel.Severity.ERROR, (Function1<? super HyperlinkEvent, Unit>)((Function1)new Function1<HyperlinkEvent, Unit>(this){
                final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;

                public final void invoke(@NotNull HyperlinkEvent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    GithubPullRequestsListWithSearchPanel.access$getLoader$p(this.this$0).reset();
                }
                {
                    this.this$0 = githubPullRequestsListWithSearchPanel;
                    super(1);
                }
            }));
        } else if (this.loader.getOutdated()) {
            this.infoPanel.setInfo("<html><body>The list is outdated. <a href=''>Refresh</a></body></html>", HtmlInfoPanel.Severity.INFO, (Function1<? super HyperlinkEvent, Unit>)((Function1)new Function1<HyperlinkEvent, Unit>(this){
                final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;

                public final void invoke(@NotNull HyperlinkEvent it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    GithubPullRequestsListWithSearchPanel.access$reset(this.this$0);
                }
                {
                    this.this$0 = githubPullRequestsListWithSearchPanel;
                    super(1);
                }
            }));
        } else {
            HtmlInfoPanel.setInfo$default(this.infoPanel, null, null, null, 6, null);
        }
    }

    private final void reset() {
        this.loader.reset();
        this.dataLoader.invalidateAllData();
    }

    private final String getErrorPrefix() {
        return this.listModel.getSize() == 0 ? "Can't load pull requests." : "Can't load full pull requests list.";
    }

    private final void potentiallyLoadMore() {
        if (this.loader.canLoadMore() && this.isScrollAtThreshold()) {
            this.loader.loadMore();
        }
    }

    private final boolean isScrollAtThreshold() {
        JScrollBar verticalScrollBar;
        JScrollBar jScrollBar = verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        int visibleAmount = jScrollBar.getVisibleAmount();
        int value = verticalScrollBar.getValue();
        int maximum = verticalScrollBar.getMaximum();
        if (maximum == 0) {
            return false;
        }
        float scrollFraction = (float)(visibleAmount + value) / (float)maximum;
        return !((double)scrollFraction < 0.5);
    }

    private final void resetSearch() {
        this.search.setSearchText("state:open");
    }

    public void dispose() {
    }

    public GithubPullRequestsListWithSearchPanel(@NotNull Project project, @NotNull CopyPasteManager copyPasteManager, @NotNull ActionManager actionManager, @NotNull AutoPopupController autoPopupController, @NotNull CachingGithubAvatarIconsProvider.Factory avatarIconsProviderFactory, @NotNull GithubPullRequestsListLoader loader, @NotNull GithubPullRequestsDataLoader dataLoader, @NotNull ListModel<GithubSearchedIssue> listModel, @NotNull GithubPullRequestSearchQueryHolder searchQueryHolder, @NotNull GithubPullRequestsListSelectionHolder listSelectionHolder) {
        JScrollPane jScrollPane;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)copyPasteManager, (String)"copyPasteManager");
        Intrinsics.checkParameterIsNotNull((Object)actionManager, (String)"actionManager");
        Intrinsics.checkParameterIsNotNull((Object)autoPopupController, (String)"autoPopupController");
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProviderFactory, (String)"avatarIconsProviderFactory");
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkParameterIsNotNull(listModel, (String)"listModel");
        Intrinsics.checkParameterIsNotNull((Object)searchQueryHolder, (String)"searchQueryHolder");
        Intrinsics.checkParameterIsNotNull((Object)listSelectionHolder, (String)"listSelectionHolder");
        this.loader = loader;
        this.dataLoader = dataLoader;
        this.listModel = listModel;
        this.searchQueryHolder = searchQueryHolder;
        this.listSelectionHolder = listSelectionHolder;
        this.list = new GithubPullRequestsList(copyPasteManager, avatarIconsProviderFactory, this.listModel);
        Object object = ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.list)), (int)20, (int)31);
        GithubPullRequestsListWithSearchPanel githubPullRequestsListWithSearchPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        JScrollPane $this$apply = object;
        boolean bl3 = false;
        $this$apply.setBorder((Border)JBUI.Borders.empty());
        JScrollBar jScrollBar = $this$apply.getVerticalScrollBar();
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollBar, (String)"verticalScrollBar");
        jScrollBar.getModel().addChangeListener(new ChangeListener(this){
            final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;
            {
                this.this$0 = githubPullRequestsListWithSearchPanel;
            }

            public final void stateChanged(ChangeEvent it) {
                GithubPullRequestsListWithSearchPanel.access$potentiallyLoadMore(this.this$0);
            }
        });
        JScrollPane jScrollPane2 = jScrollPane = object;
        Intrinsics.checkExpressionValueIsNotNull((Object)jScrollPane2, (String)"ScrollPaneFactory.create\u2026tentiallyLoadMore() }\n  }");
        githubPullRequestsListWithSearchPanel.scrollPane = jScrollPane2;
        this.infoPanel = new HtmlInfoPanel();
        this.progressStripe = new ProgressStripe((JComponent)JBUI.Panels.simplePanel((Component)this.scrollPane).addToTop((Component)((Object)this.infoPanel)), (Disposable)this, 300);
        object = new GithubPullRequestSearchPanel(project, autoPopupController, this.searchQueryHolder);
        githubPullRequestsListWithSearchPanel = this;
        bl = false;
        bl2 = false;
        $this$apply = object;
        boolean bl4 = false;
        $this$apply.setBorder(IdeBorderFactory.createBorder((int)8));
        jScrollPane = object;
        githubPullRequestsListWithSearchPanel.search = jScrollPane;
        this.loader.addLoadingStateChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateProgress();
                this.updateEmptyText();
            }
        }));
        this.loader.addErrorChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateInfoPanel();
                this.updateEmptyText();
            }
        }));
        this.loader.addOutdatedStateChangeListener(this, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.updateInfoPanel();
            }
        }));
        this.listModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(@NotNull ListDataEvent e) {
                block3: {
                    Object v2;
                    boolean bl;
                    Object object;
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                        if (e.getType() != 1) break block3;
                        int n = e.getIndex0();
                        object = (Iterable)new IntRange(n, e.getIndex1());
                        bl = false;
                        Iterable iterable = object;
                        boolean bl2 = false;
                        for (Object t : iterable) {
                            int it = ((Number)t).intValue();
                            boolean bl3 = false;
                            Object e2 = listModel.getElementAt(it);
                            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"listModel.getElementAt(it)");
                            Long l = autoSelectionNumber;
                            if (!(l != null && ((GithubSearchedIssue)e2).getNumber() == l.longValue())) continue;
                            v2 = t;
                            break block2;
                        }
                        v2 = null;
                    }
                    Integer n = v2;
                    if (n != null) {
                        object = n;
                        bl = false;
                        boolean bl4 = false;
                        int $this$run = ((Number)object).intValue();
                        boolean bl5 = false;
                        ApplicationManager.getApplication().invokeLater(new Runnable($this$run, this){
                            final /* synthetic */ int $this_run;
                            final /* synthetic */ 4 this$0;
                            {
                                this.$this_run = n;
                                this.this$0 = var2_2;
                            }

                            public final void run() {
                                ScrollingUtil.selectItem((JList)((JList)((Object)GithubPullRequestsListWithSearchPanel.access$getList$p(this.this$0.this))), (int)this.$this_run);
                            }
                        });
                    }
                }
            }

            @Override
            public void contentsChanged(@NotNull ListDataEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }

            @Override
            public void intervalRemoved(@NotNull ListDataEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e.getType() == 2) {
                    autoSelectionNumber = listSelectionHolder.getSelectionNumber();
                }
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public final void valueChanged(@NotNull ListSelectionEvent e) {
                int selectedIndex;
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (!e.getValueIsAdjusting() && (selectedIndex = list.getSelectedIndex()) >= 0 && selectedIndex < listModel.getSize()) {
                    GithubPullRequestsListSelectionHolder githubPullRequestsListSelectionHolder = listSelectionHolder;
                    Object e2 = listModel.getElementAt(selectedIndex);
                    Intrinsics.checkExpressionValueIsNotNull(e2, (String)"listModel.getElementAt(selectedIndex)");
                    githubPullRequestsListSelectionHolder.setSelectionNumber(((GithubSearchedIssue)e2).getNumber());
                    autoSelectionNumber = null;
                }
            }
        });
        PopupHandler popupHandler2 = new PopupHandler(this, actionManager){
            final /* synthetic */ GithubPullRequestsListWithSearchPanel this$0;
            final /* synthetic */ ActionManager $actionManager;

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                if (ListUtil.isPointOnSelection((JList)((JList)((Object)GithubPullRequestsListWithSearchPanel.access$getList$p(this.this$0))), (int)x, (int)y)) {
                    AnAction anAction = this.$actionManager.getAction("Github.PullRequest.ToolWindow.List.Popup");
                    if (anAction == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                    }
                    ActionPopupMenu actionPopupMenu = this.$actionManager.createActionPopupMenu("GithubPullRequestListPopup", (ActionGroup)anAction);
                    Intrinsics.checkExpressionValueIsNotNull((Object)actionPopupMenu, (String)"actionManager\n          \u2026t.Popup\") as ActionGroup)");
                    ActionPopupMenu popupMenu = actionPopupMenu;
                    popupMenu.setTargetComponent((JComponent)((Object)GithubPullRequestsListWithSearchPanel.access$getList$p(this.this$0)));
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
            {
                this.this$0 = $outer;
                this.$actionManager = $captured_local_variable$1;
            }
        };
        this.list.addMouseListener((MouseListener)popupHandler2);
        this.addToTop((Component)((Object)this.search));
        this.addToCenter((Component)this.progressStripe);
        this.resetSearch();
        this.updateProgress();
        this.updateInfoPanel();
        this.updateEmptyText();
        Disposer.register((Disposable)this, (Disposable)this.list);
    }

    public static final /* synthetic */ GithubPullRequestsListLoader access$getLoader$p(GithubPullRequestsListWithSearchPanel $this) {
        return $this.loader;
    }

    public static final /* synthetic */ void access$resetSearch(GithubPullRequestsListWithSearchPanel $this) {
        $this.resetSearch();
    }

    public static final /* synthetic */ void access$reset(GithubPullRequestsListWithSearchPanel $this) {
        $this.reset();
    }

    public static final /* synthetic */ void access$potentiallyLoadMore(GithubPullRequestsListWithSearchPanel $this) {
        $this.potentiallyLoadMore();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u001a\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestsListWithSearchPanel$Companion;", "", "()V", "addDotIfNeeded", "", "line", "getLoadingErrorText", "error", "", "newLineSeparator", "intellij.vcs.github"})
    public static final class Companion {
        private final String getLoadingErrorText(Throwable error, String newLineSeparator) {
            String string;
            block9: {
                block8: {
                    if (error instanceof GithubStatusCodeException && ((GithubStatusCodeException)error).getError() != null) {
                        GithubErrorMessage githubErrorMessage = ((GithubStatusCodeException)error).getError();
                        if (githubErrorMessage == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)githubErrorMessage, (String)"error.error!!");
                        GithubErrorMessage githubError = githubErrorMessage;
                        StringBuilder builder = new StringBuilder(githubError.getMessage());
                        List<GithubErrorMessage.Error> list = githubError.getErrors();
                        Intrinsics.checkExpressionValueIsNotNull(list, (String)"githubError.errors");
                        Collection collection = list;
                        boolean bl = false;
                        if (!collection.isEmpty()) {
                            builder.append(": ").append(newLineSeparator);
                            Iterator<GithubErrorMessage.Error> iterator = githubError.getErrors().iterator();
                            while (iterator.hasNext()) {
                                GithubErrorMessage.Error e;
                                GithubErrorMessage.Error error2 = e = iterator.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)error2, (String)"e");
                                String string2 = error2.getMessage();
                                if (string2 == null) {
                                    string2 = e.getCode() + " error in " + e.getResource() + " field " + e.getField();
                                }
                                builder.append(string2).append(newLineSeparator);
                            }
                        }
                        String string3 = builder.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"builder.toString()");
                        return string3;
                    }
                    string = error.getMessage();
                    if (string == null) break block8;
                    String string4 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string4;
                    boolean bl3 = false;
                    string = Companion.addDotIfNeeded(it);
                    if (string != null) break block9;
                }
                string = "Unknown loading error.";
            }
            return string;
        }

        static /* synthetic */ String getLoadingErrorText$default(Companion companion, Throwable throwable, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "\n";
            }
            return companion.getLoadingErrorText(throwable, string);
        }

        private final String addDotIfNeeded(String line) {
            return StringsKt.endsWith$default((CharSequence)line, (char)'.', (boolean)false, (int)2, null) ? line : line + '.';
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

