/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.util.BitUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileAttributes {
    public static final byte SYM_LINK = 1;
    public static final byte HIDDEN = 2;
    public static final byte READ_ONLY = 4;
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(null, 1, 0L, 0L);
    @Nullable
    public final Type type;
    @Flags
    public final byte flags;
    public final long length;
    public final long lastModified;

    public FileAttributes(boolean directory, boolean special, boolean symlink, boolean hidden, long length, long lastModified, boolean writable) {
        this(FileAttributes.type(directory, special), FileAttributes.flags(symlink, hidden, !writable), length, lastModified);
    }

    private FileAttributes(@Nullable Type type, @Flags byte flags, long length, long lastModified) {
        this.type = type;
        this.flags = flags;
        this.length = length;
        this.lastModified = lastModified;
    }

    @NotNull
    private static Type type(boolean isDirectory, boolean isSpecial) {
        Type type = isDirectory ? Type.DIRECTORY : (isSpecial ? Type.SPECIAL : Type.FILE);
        if (type == null) {
            FileAttributes.$$$reportNull$$$0(0);
        }
        return type;
    }

    @Flags
    private static byte flags(boolean isSymlink, boolean isHidden, boolean isReadOnly) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (isReadOnly) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isFile() {
        return this.type == Type.FILE;
    }

    public boolean isDirectory() {
        return this.type == Type.DIRECTORY;
    }

    public boolean isSpecial() {
        return this.type == Type.SPECIAL;
    }

    public boolean isSymLink() {
        return BitUtil.isSet(this.flags, (byte)1);
    }

    public boolean isHidden() {
        return BitUtil.isSet(this.flags, (byte)2);
    }

    public boolean isWritable() {
        return !BitUtil.isSet(this.flags, (byte)4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAttributes that = (FileAttributes)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        if (this.length != that.length) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.flags;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type:");
        if (this.type == Type.FILE) {
            sb.append('f');
        } else if (this.type == Type.DIRECTORY) {
            sb.append('d');
        } else if (this.type == Type.SPECIAL) {
            sb.append('!');
        } else {
            sb.append('-');
        }
        if (BitUtil.isSet(this.flags, (byte)1)) {
            sb.append('l');
        }
        if (BitUtil.isSet(this.flags, (byte)2)) {
            sb.append('.');
        }
        if (BitUtil.isSet(this.flags, (byte)4)) {
            sb.append(" ro");
        }
        sb.append(" length:").append(this.length);
        sb.append(" modified:").append(this.lastModified);
        sb.append(']');
        return sb.toString();
    }

    @NotNull
    public static FileAttributes createFrom(byte fileAttributesType, byte flags, long length, long lastModified) {
        Type type = fileAttributesType == -1 ? null : Type.values()[fileAttributesType];
        FileAttributes fileAttributes = new FileAttributes(type, flags, length, lastModified);
        if (fileAttributes == null) {
            FileAttributes.$$$reportNull$$$0(1);
        }
        return fileAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/util/io/FileAttributes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "type";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrom";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static @interface Flags {
    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }
}

