/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.ReallyAbstractPlayer;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingNote;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.timingdiagram.TitleStrategy;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public abstract class AbstractPlayer
extends ReallyAbstractPlayer
implements Player {
    private String initialState;
    private final Set<ChangeState> changes = new TreeSet<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    protected final List<TimingNote> notes = new ArrayList<TimingNote>();
    protected final Map<String, String> statesLabel = new LinkedHashMap<String, String>();
    private TimeDrawing cached;
    private Colors initialColors;

    public AbstractPlayer(TitleStrategy titleStrategy, String full, ISkinParam skinParam, TimingRuler ruler) {
        super(titleStrategy, full, skinParam, ruler);
    }

    protected abstract TimeDrawing buildDrawing();

    @Override
    public void drawFrameTitle(UGraphic ug) {
        if (this.titleStrategy == TitleStrategy.IN_FRAME) {
            TextBlock title = this.getTitle();
            title.drawU(ug);
            Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
            this.drawLine(ug.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UStroke(1.0)), -5.0, dimTitle.getHeight() + 1.0, dimTitle.getWidth() + 1.0, dimTitle.getHeight() + 1.0, dimTitle.getWidth() + 1.0 + 10.0, 0.0);
        }
    }

    @Override
    public void drawContent(UGraphic ug) {
        ug = ug.apply(this.getTranslateForTimeDrawing(ug.getStringBounder()));
        this.getTimeDrawing().drawU(ug);
    }

    @Override
    public void drawLeftHeader(UGraphic ug) {
        if (this.titleStrategy == TitleStrategy.IN_LEFT_HEADER) {
            StringBounder stringBounder = ug.getStringBounder();
            TextBlock title = this.getTitle();
            Dimension2D dim = title.calculateDimension(stringBounder);
            double y = (this.getHeight(stringBounder) - dim.getHeight()) / 2.0;
            title.drawU(ug.apply(new UTranslate(0.0, y)));
            ug = ug.apply(new UTranslate(dim.getWidth() + 5.0, 0.0));
        }
        ug = ug.apply(this.getTranslateForTimeDrawing(ug.getStringBounder()));
        this.getTimeDrawing().getWidthHeader(ug.getStringBounder()).drawU(ug);
    }

    @Override
    public double getWidthHeader(StringBounder stringBounder) {
        Dimension2D dimHeader1 = this.getTimeDrawing().getWidthHeader(stringBounder).calculateDimension(stringBounder);
        if (this.titleStrategy == TitleStrategy.IN_LEFT_HEADER) {
            Dimension2D dimTitle = this.getTitle().calculateDimension(stringBounder);
            return dimTitle.getWidth() + 5.0 + dimHeader1.getWidth();
        }
        return dimHeader1.getWidth();
    }

    private void drawLine(UGraphic ug, double ... coord) {
        for (int i = 0; i < coord.length - 2; i += 2) {
            double x1 = coord[i];
            double y1 = coord[i + 1];
            double x2 = coord[i + 2];
            double y2 = coord[i + 3];
            ug.apply(new UTranslate(x1, y1)).draw(new ULine(x2 - x1, y2 - y1));
        }
    }

    private UTranslate getTranslateForTimeDrawing(StringBounder stringBounder) {
        if (this.titleStrategy == TitleStrategy.IN_FRAME) {
            TextBlock title = this.getTitle();
            return new UTranslate(0.0, title.calculateDimension(stringBounder).getHeight() * 2.0);
        }
        return new UTranslate(0.0, 12.0);
    }

    private TimeDrawing getTimeDrawing() {
        if (this.cached == null) {
            this.cached = this.computeTimeDrawing();
        }
        return this.cached;
    }

    private TimeDrawing computeTimeDrawing() {
        TimeDrawing result = this.buildDrawing();
        result.setInitialState(this.initialState, this.initialColors);
        for (ChangeState change : this.changes) {
            result.addChange(change);
        }
        for (TimeConstraint constraint : this.constraints) {
            result.addConstraint(constraint);
        }
        return result;
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        double zoneHeight = this.getZoneHeight(stringBounder);
        if (this.titleStrategy == TitleStrategy.IN_LEFT_HEADER) {
            return zoneHeight;
        }
        TextBlock title = this.getTitle();
        return title.calculateDimension(stringBounder).getHeight() * 2.0 + zoneHeight;
    }

    private double getZoneHeight(StringBounder stringBounder) {
        return this.getTimeDrawing().getHeight(stringBounder);
    }

    @Override
    public void setState(TimeTick now, String comment, Colors color, String ... states) {
        for (int i = 0; i < states.length; ++i) {
            states[i] = this.decodeState(states[i]);
        }
        if (now == null) {
            this.initialState = states[0];
            this.initialColors = color;
        } else {
            this.changes.add(new ChangeState(now, comment, color, states));
        }
    }

    private String decodeState(String code) {
        String label = this.statesLabel.get(code);
        if (label == null) {
            return code;
        }
        return label;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        IntricatedPoint point = this.getTimeDrawing().getTimeProjection(stringBounder, tick);
        if (point == null) {
            return null;
        }
        UTranslate translation = this.getTranslateForTimeDrawing(stringBounder);
        return point.translated(translation);
    }

    @Override
    public void createConstraint(TimeTick tick1, TimeTick tick2, String message) {
        this.constraints.add(new TimeConstraint(tick1, tick2, message));
    }

    @Override
    public void addNote(TimeTick now, Display note, Position position) {
        this.notes.add(new TimingNote(now, this, note, position, this.skinParam));
    }

    @Override
    public void defineState(String stateCode, String label) {
        this.statesLabel.put(stateCode, label);
    }
}

