/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import net.sourceforge.plantuml.project3.DayAsDate;
import net.sourceforge.plantuml.project3.GCalendar;
import net.sourceforge.plantuml.project3.InstantDay;

public class GCalendarSimple
implements GCalendar {
    private final DayAsDate start;

    public GCalendarSimple(DayAsDate start) {
        this.start = start;
    }

    @Override
    public DayAsDate toDayAsDate(InstantDay day) {
        DayAsDate result = this.start;
        int target = day.getNumDay();
        for (int work = 0; work < target; ++work) {
            result = result.next();
        }
        return result;
    }

    @Override
    public InstantDay fromDayAsDate(DayAsDate day) {
        if (day.compareTo(this.start) < 0) {
            throw new IllegalArgumentException();
        }
        InstantDay result = new InstantDay(0);
        while (!this.toDayAsDate(result).equals(day)) {
            result = result.increment();
        }
        return result;
    }

    @Override
    public DayAsDate getStartingDate() {
        return this.start;
    }
}

