/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileDiamond
extends AbstractFtile {
    private final HtmlColor backColor;
    private final HtmlColor borderColor;
    private final Swimlane swimlane;
    private final TextBlock north;
    private final TextBlock south;
    private final TextBlock west1;
    private final TextBlock east1;
    private final double shadowing;

    public FtileDiamond(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane) {
        this(skinParam, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public StyleSignature getDefaultStyleDefinitionDiamond() {
        return StyleSignature.of(SName.root, SName.element, SName.activityDiagram, SName.diamond);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.emptyList();
    }

    public FtileDiamond withNorth(TextBlock north) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, north, this.south, this.east1, this.west1);
    }

    public FtileDiamond withWest(TextBlock west1) {
        if (west1 == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, this.east1, west1);
    }

    public FtileDiamond withEast(TextBlock east1) {
        if (east1 == null) {
            return this;
        }
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.south, east1, this.west1);
    }

    public FtileDiamond withSouth(TextBlock south) {
        return new FtileDiamond(this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, south, this.east1, this.west1);
    }

    private FtileDiamond(ISkinParam skinParam, HtmlColor backColor, HtmlColor borderColor, Swimlane swimlane, TextBlock north, TextBlock south, TextBlock east1, TextBlock west1) {
        super(skinParam);
        if (SkinParam.USE_STYLES()) {
            Style style = this.getDefaultStyleDefinitionDiamond().getMergedStyle(skinParam.getCurrentStyleBuilder());
            this.shadowing = style.value(PName.Shadowing).asDouble();
        } else {
            this.shadowing = this.skinParam().shadowing(null) ? 3.0 : 0.0;
        }
        this.backColor = backColor;
        this.swimlane = swimlane;
        this.borderColor = borderColor;
        this.north = north;
        this.west1 = west1;
        this.east1 = east1;
        this.south = south;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    @Override
    public void drawU(UGraphic ug) {
        double suppY1 = this.north.calculateDimension(ug.getStringBounder()).getHeight();
        ug = ug.apply(new UTranslate(0.0, suppY1));
        ug.apply(new UChangeColor(this.borderColor)).apply(this.getThickness()).apply(new UChangeBackColor(this.backColor)).draw(Diamond.asPolygon(this.shadowing));
        this.north.drawU(ug.apply(new UTranslate(18.0, -suppY1)));
        this.south.drawU(ug.apply(new UTranslate(18.0, 24.0)));
        Dimension2D dimWeat1 = this.west1.calculateDimension(ug.getStringBounder());
        this.west1.drawU(ug.apply(new UTranslate(-dimWeat1.getWidth(), -dimWeat1.getHeight() + 12.0)));
        Dimension2D dimEast1 = this.east1.calculateDimension(ug.getStringBounder());
        this.east1.drawU(ug.apply(new UTranslate(24.0, -dimEast1.getHeight() + 12.0)));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        double suppY1 = this.north.calculateDimension(stringBounder).getHeight();
        Dimension2DDouble dim = new Dimension2DDouble(24.0, 24.0 + suppY1);
        return new FtileGeometry(dim, ((Dimension2D)dim).getWidth() / 2.0, suppY1, ((Dimension2D)dim).getHeight());
    }

    public Ftile withWestAndEast(TextBlock tb1, TextBlock tb2) {
        return this.withWest(tb1).withEast(tb2);
    }

    public double getEastLabelWidth(StringBounder stringBounder) {
        Dimension2D dimEast = this.east1.calculateDimension(stringBounder);
        return dimEast.getWidth();
    }

    public double getSouthLabelHeight(StringBounder stringBounder) {
        Dimension2D dimSouth = this.south.calculateDimension(stringBounder);
        return dimSouth.getHeight();
    }
}

