/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClassKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.FirProvider;
import org.jetbrains.kotlin.fir.resolve.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformerWithSuperTypes;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypeResolverTransformerKt;
import org.jetbrains.kotlin.fir.scopes.FirPosition;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ScopesKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirErrorTypeRefImpl;
import org.jetbrains.kotlin.fir.visitors.CompositeTransformResult;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004J\u0014\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012\"\u000e\b\u0000\u0010\u001c*\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010 \u001a\u00020!2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010#\u001a\u00020$2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010%\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010&\u001a\u00020'2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J \u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010)\u001a\u00020*2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "()V", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "setSession", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "initFromFile", "", "resolveSupertypesOrExpansions", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "transformAnonymousInitializer", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "anonymousInitializer", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "data", "", "transformConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "transformFile", "transformFunction", "F", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "function", "transformNamedFunction", "namedFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirNamedFunction;", "transformProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "transformRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "ResolveSuperTypesTask", "resolve"})
public final class FirSupertypeResolverTransformer
extends FirAbstractTreeTransformer {
    @NotNull
    public FirSession session;
    private FirFile file;

    @Override
    @NotNull
    public FirSession getSession() {
        FirSession firSession = this.session;
        if (firSession == null) {
            Intrinsics.throwUninitializedPropertyAccessException("session");
        }
        return firSession;
    }

    public void setSession(@NotNull FirSession firSession) {
        Intrinsics.checkParameterIsNotNull(firSession, "<set-?>");
        this.session = firSession;
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirFile> transformFile(@NotNull FirFile file2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.initFromFile(file2);
        return this.transformElement((FirElement)file2, data);
    }

    public final void initFromFile(@NotNull FirFile file2) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        this.setSession(file2.getFileSession());
        this.file = file2;
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
        FirRegularClass firRegularClass;
        Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
        FirDeclaration firDeclaration = this.resolveSupertypesOrExpansions(regularClass);
        if (!(firDeclaration instanceof FirRegularClass)) {
            firDeclaration = null;
        }
        if ((firRegularClass = (FirRegularClass)firDeclaration) == null) {
            firRegularClass = regularClass;
        }
        FirRegularClass transformedClass = firRegularClass;
        return this.transformElement((FirElement)transformedClass, data);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
        FirDeclaration result2 = this.resolveSupertypesOrExpansions(typeAlias);
        FirElement $this$compose$iv = result2;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformAnonymousInitializer(@NotNull FirAnonymousInitializer anonymousInitializer, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(anonymousInitializer, "anonymousInitializer");
        FirElement $this$compose$iv = anonymousInitializer;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformConstructor(@NotNull FirConstructor constructor, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(constructor, "constructor");
        FirElement $this$compose$iv = constructor;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformNamedFunction(@NotNull FirNamedFunction namedFunction, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(namedFunction, "namedFunction");
        FirElement $this$compose$iv = namedFunction;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public CompositeTransformResult<FirDeclaration> transformProperty(@NotNull FirProperty property, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(property, "property");
        FirElement $this$compose$iv = property;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    @Override
    @NotNull
    public <F extends FirFunction<F>> CompositeTransformResult<FirDeclaration> transformFunction(@NotNull FirFunction<F> function2, @Nullable Void data) {
        Intrinsics.checkParameterIsNotNull(function2, "function");
        FirElement $this$compose$iv = function2;
        boolean $i$f$compose = false;
        return CompositeTransformResult.Companion.single($this$compose$iv);
    }

    private final FirDeclaration resolveSupertypesOrExpansions(FirClassLikeDeclaration<?> classLikeDeclaration) {
        if (FirSupertypeResolverTransformerKt.access$areSupertypesComputed(classLikeDeclaration) || FirSupertypeResolverTransformerKt.access$areSupertypesComputing(classLikeDeclaration)) {
            return classLikeDeclaration;
        }
        ClassId classId = classLikeDeclaration.getSymbol().getClassId();
        FirSession firSession = this.getSession();
        FirFile firFile = this.file;
        if (firFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
        }
        ResolveSuperTypesTask visitor2 = new ResolveSuperTypesTask(firSession, classId, firFile, classLikeDeclaration);
        FirFile firFile2 = this.file;
        if (firFile2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("file");
        }
        ((CompositeTransformResult)firFile2.accept(visitor2, null)).getSingle();
        return visitor2.getResultingClass();
    }

    public FirSupertypeResolverTransformer() {
        super(FirResolvePhase.SUPER_TYPES);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J \u0010 \u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\u0006\u0010!\u001a\u00020\"2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\f\u0010#\u001a\u00020$*\u00020\u0005H\u0002J\u0010\u0010%\u001a\u00020$*\u0006\u0012\u0002\b\u00030\tH\u0002R\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverTransformer$ResolveSuperTypesTask;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformerWithSuperTypes;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "requestedClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "knownFirClassLikeDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)V", "resultingClass", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getResultingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "setResultingClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "resolveLoops", "", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "firClassLikeDeclaration", "classId", "resolvedTypesRefs", "resolveNestedClassesSupertypes", "Lorg/jetbrains/kotlin/fir/visitors/CompositeTransformResult;", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "data", "", "transformRegularClass", "transformTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "areSupertypesComputing", "", "matchesRequestedDeclaration", "resolve"})
    private static final class ResolveSuperTypesTask
    extends FirAbstractTreeTransformerWithSuperTypes {
        @NotNull
        public FirDeclaration resultingClass;
        @NotNull
        private final FirSession session;
        private final ClassId requestedClassId;
        private final FirClassLikeDeclaration<?> knownFirClassLikeDeclaration;

        @NotNull
        public final FirDeclaration getResultingClass() {
            FirDeclaration firDeclaration = this.resultingClass;
            if (firDeclaration == null) {
                Intrinsics.throwUninitializedPropertyAccessException("resultingClass");
            }
            return firDeclaration;
        }

        public final void setResultingClass(@NotNull FirDeclaration firDeclaration) {
            Intrinsics.checkParameterIsNotNull(firDeclaration, "<set-?>");
            this.resultingClass = firDeclaration;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public CompositeTransformResult<FirDeclaration> transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data) {
            FirRegularClass firRegularClass;
            Intrinsics.checkParameterIsNotNull(regularClass, "regularClass");
            ClassId classId = FirRegularClassKt.getClassId(regularClass);
            if (!FirSupertypeResolverTransformerKt.access$isOuterClass(classId, this.requestedClassId)) {
                FirElement $this$compose$iv = regularClass;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            if (FirSupertypeResolverTransformerKt.access$areSupertypesComputed(regularClass) || FirSupertypeResolverTransformerKt.access$areSupertypesComputing(regularClass)) {
                firRegularClass = regularClass;
            } else {
                void $this$mapTo$iv$iv;
                this.addTypeParametersScope(regularClass);
                FirSpecificTypeResolverTransformer transformer = new FirSpecificTypeResolverTransformer(this.getTowerScope(), FirPosition.SUPER_TYPE_OR_EXPANSION, this.getSession());
                Iterable $this$map$iv = regularClass.getSuperTypeRefs();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    FirTypeRef firTypeRef2 = transformer.transformTypeRef((FirTypeRef)it, data).getSingle();
                    collection.add(firTypeRef2);
                }
                List resolvedTypesRefs = (List)destination$iv$iv;
                List resultingTypeRefs = this.resolveLoops(regularClass, classId, resolvedTypesRefs);
                firRegularClass = regularClass.replaceSupertypes(resultingTypeRefs);
            }
            FirRegularClass result$iv = firRegularClass;
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl3 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            n = size$iv - sizeBefore$iv;
            bl3 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl5 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl6 = false;
                boolean bl7 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl8 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            FirRegularClass transformedClass = result$iv;
            if (this.matchesRequestedDeclaration(regularClass)) {
                this.resultingClass = transformedClass;
                FirElement $this$compose$iv = transformedClass;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            return this.resolveNestedClassesSupertypes(transformedClass, data);
        }

        private final boolean matchesRequestedDeclaration(@NotNull FirClassLikeDeclaration<?> $this$matchesRequestedDeclaration) {
            if (this.knownFirClassLikeDeclaration != null) {
                return Intrinsics.areEqual(this.knownFirClassLikeDeclaration, $this$matchesRequestedDeclaration);
            }
            return Intrinsics.areEqual($this$matchesRequestedDeclaration.getSymbol().getClassId(), this.requestedClassId);
        }

        @Override
        @NotNull
        public CompositeTransformResult<FirDeclaration> transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data) {
            Intrinsics.checkParameterIsNotNull(typeAlias, "typeAlias");
            ClassId classId = typeAlias.getSymbol().getClassId();
            if (FirSupertypeResolverTransformerKt.access$areSupertypesComputed(typeAlias) || !this.matchesRequestedDeclaration(typeAlias)) {
                FirElement $this$compose$iv = typeAlias;
                boolean $i$f$compose = false;
                return CompositeTransformResult.Companion.single($this$compose$iv);
            }
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            this.addTypeParametersScope(typeAlias);
            FirSpecificTypeResolverTransformer transformer = new FirSpecificTypeResolverTransformer(this.getTowerScope(), FirPosition.SUPER_TYPE_OR_EXPANSION, this.getSession());
            FirTypeRef resolvedTypesRef = transformer.transformTypeRef(typeAlias.getExpandedTypeRef(), data).getSingle();
            FirTypeRef resultingTypeRef = (FirTypeRef)CollectionsKt.firstOrNull(this.resolveLoops(typeAlias, classId, CollectionsKt.listOf(resolvedTypesRef)));
            FirTypeRef firTypeRef = resultingTypeRef;
            if (firTypeRef == null) {
                firTypeRef = resolvedTypesRef;
            }
            FirTypeAlias firTypeAlias = typeAlias.replaceExpandTypeRef(firTypeRef);
            boolean bl2 = false;
            boolean bl3 = false;
            FirTypeAlias it = firTypeAlias;
            boolean bl4 = false;
            this.setResultingClass(it);
            FirTypeAlias result$iv = firTypeAlias;
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl5 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl6 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            n = size$iv - sizeBefore$iv;
            bl5 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl7 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl8 = false;
                boolean bl9 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl10 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            FirElement $this$compose$iv = result$iv;
            boolean $i$f$compose = false;
            return CompositeTransformResult.Companion.single($this$compose$iv);
        }

        private final List<FirTypeRef> resolveLoops(FirClassLikeDeclaration<?> firClassLikeDeclaration, ClassId classId, List<? extends FirTypeRef> resolvedTypesRefs) {
            firClassLikeDeclaration.setSupertypesComputationStatus(FirClassLikeDeclaration.SupertypesComputationStatus.COMPUTING);
            boolean bl = false;
            List resultingTypeRefs = new ArrayList();
            Iterator<? extends FirTypeRef> iterator2 = resolvedTypesRefs.iterator();
            while (iterator2.hasNext()) {
                FirTypeRef superTypeRef;
                block17: {
                    FirSession sessionForSupertype;
                    ClassId superTypeClassId;
                    block16: {
                        boolean bl2;
                        block15: {
                            FirClassLikeDeclaration firClassForSupertype;
                            boolean bl3;
                            block14: {
                                ConeClassLikeType resolvedType;
                                FirTypeRef $this$coneTypeSafe$iv = superTypeRef = iterator2.next();
                                boolean $i$f$coneTypeSafe = false;
                                FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
                                if (!(firTypeRef instanceof FirResolvedTypeRef)) {
                                    firTypeRef = null;
                                }
                                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
                                ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                                    coneKotlinType = null;
                                }
                                if ((ConeClassLikeType)coneKotlinType == null) {
                                    continue;
                                }
                                superTypeClassId = resolvedType.getLookupTag().getClassId();
                                Sequence $this$any$iv = FirSupertypeResolverTransformerKt.access$outerClasses(superTypeClassId);
                                boolean $i$f$any = false;
                                Iterator iterator3 = $this$any$iv.iterator();
                                while (iterator3.hasNext()) {
                                    Object element$iv = iterator3.next();
                                    ClassId it = (ClassId)element$iv;
                                    boolean bl4 = false;
                                    if (!this.areSupertypesComputing(it)) continue;
                                    bl3 = true;
                                    break block14;
                                }
                                bl3 = false;
                            }
                            if (bl3) {
                                resultingTypeRefs.add(new FirErrorTypeRefImpl(superTypeRef.getPsi(), "Recursion detected: " + FirRendererKt.render(superTypeRef)));
                                continue;
                            }
                            if (((FirSymbolProvider)this.getSession().getService(Reflection.getOrCreateKotlinClass(FirSymbolProvider.class))).getSessionForClass(superTypeClassId) == null) {
                                continue;
                            }
                            FirClassLikeSymbol<?> firClassLikeSymbol = ((FirSymbolProvider)sessionForSupertype.getService(Reflection.getOrCreateKotlinClass(FirSymbolProvider.class))).getClassLikeSymbolByFqName(superTypeClassId);
                            FirClassLikeDeclaration firClassLikeDeclaration2 = firClassForSupertype = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
                            if (firClassForSupertype == null) break block16;
                            if (!(firClassForSupertype instanceof FirClass)) break block17;
                            Iterable $this$any$iv = ((FirClass)((Object)firClassForSupertype)).getSuperTypeRefs();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    FirTypeRef it = (FirTypeRef)element$iv;
                                    boolean bl5 = false;
                                    if (!(!(it instanceof FirResolvedTypeRef))) continue;
                                    bl2 = true;
                                    break block15;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) break block17;
                    }
                    FirProvider provider = (FirProvider)sessionForSupertype.getService(Reflection.getOrCreateKotlinClass(FirProvider.class));
                    FirFile firForSuperClassFile = provider.getFirClassifierContainerFile(superTypeClassId);
                    new ResolveSuperTypesTask(sessionForSupertype, superTypeClassId, firForSuperClassFile, null, 8, null).transformFile(firForSuperClassFile, null);
                }
                resultingTypeRefs.add(superTypeRef);
            }
            firClassLikeDeclaration.setSupertypesComputationStatus(FirClassLikeDeclaration.SupertypesComputationStatus.COMPUTED);
            return resultingTypeRefs;
        }

        private final boolean areSupertypesComputing(@NotNull ClassId $this$areSupertypesComputing) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.getFirSymbolProvider(this.getSession()).getClassLikeSymbolByFqName($this$areSupertypesComputing);
            if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) {
                return false;
            }
            FirClassLikeSymbol<?> fir = firClassLikeSymbol;
            return FirSupertypeResolverTransformerKt.access$areSupertypesComputing((FirClassLikeDeclaration)((Object)fir));
        }

        /*
         * WARNING - void declaration
         */
        private final CompositeTransformResult<FirDeclaration> resolveNestedClassesSupertypes(FirRegularClass regularClass, Void data) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            void $this$mapTo$iv;
            ResolveSuperTypesTask this_$iv = this;
            boolean $i$f$withScopeCleanup = false;
            int sizeBefore$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            boolean bl = false;
            FirProvider firProvider = FirProvider.Companion.getInstance(this.getSession());
            ClassId classId = regularClass.getSymbol().getClassId();
            Iterable iterable = CollectionsKt.asReversed(SupertypeUtilsKt.lookupSuperTypes(regularClass, false, true, this.getSession()));
            Collection destination$iv = this.getTowerScope().getScopes();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                ConeClassLikeType coneClassLikeType = (ConeClassLikeType)item$iv;
                Collection collection = destination$iv;
                boolean bl2 = false;
                FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(it.getLookupTag().getClassId(), FirSymbolProvider.Companion.getInstance(this.getSession()));
                collection.add(firNestedClassifierScope);
            }
            Iterable $this$filterIsInstance$iv = regularClass.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Object object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirRegularClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirRegularClass it = (FirRegularClass)element$iv$iv;
                boolean bl3 = false;
                if (!it.isCompanion()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List companionObjects = (List)destination$iv$iv;
            for (FirRegularClass companionObject : companionObjects) {
                object = this.getTowerScope().getScopes();
                FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(companionObject.getSymbol().getClassId(), firProvider);
                boolean bl4 = false;
                object.add(firNestedClassifierScope);
            }
            Collection collection = this.getTowerScope().getScopes();
            FirNestedClassifierScope firNestedClassifierScope = new FirNestedClassifierScope(classId, firProvider);
            boolean bl5 = false;
            collection.add(firNestedClassifierScope);
            this.addTypeParametersScope(regularClass);
            CompositeTransformResult<FirElement> result$iv = this.transformElement((FirElement)regularClass, data);
            int size$iv = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes().size();
            int n = size$iv >= sizeBefore$iv ? 1 : 0;
            boolean bl6 = false;
            int n2 = 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl7 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            n = size$iv - sizeBefore$iv;
            bl6 = false;
            n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it$iv = n2++;
                boolean bl8 = false;
                List<FirScope> list2 = FirAbstractTreeTransformerWithSuperTypes.access$getTowerScope$p(this_$iv).getScopes();
                boolean bl9 = false;
                boolean bl10 = false;
                List<FirScope> it$iv2 = list2;
                boolean bl11 = false;
                it$iv2.remove(it$iv2.size() - 1);
            }
            return result$iv;
        }

        @Override
        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        public ResolveSuperTypesTask(@NotNull FirSession session, @NotNull ClassId requestedClassId, @NotNull FirFile file2, @Nullable FirClassLikeDeclaration<?> knownFirClassLikeDeclaration) {
            Intrinsics.checkParameterIsNotNull(session, "session");
            Intrinsics.checkParameterIsNotNull(requestedClassId, "requestedClassId");
            Intrinsics.checkParameterIsNotNull(file2, "file");
            super(FirResolvePhase.SUPER_TYPES, true);
            this.session = session;
            this.requestedClassId = requestedClassId;
            this.knownFirClassLikeDeclaration = knownFirClassLikeDeclaration;
            ScopeSession scopeSession = new ScopeSession();
            ScopesKt.addImportingScopes(this.getTowerScope(), file2, this.getSession(), scopeSession);
        }

        public /* synthetic */ ResolveSuperTypesTask(FirSession firSession, ClassId classId, FirFile firFile, FirClassLikeDeclaration firClassLikeDeclaration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                firClassLikeDeclaration = null;
            }
            this(firSession, classId, firFile, firClassLikeDeclaration);
        }
    }
}

