/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirLabel;
import org.jetbrains.kotlin.fir.FirLoopTarget;
import org.jetbrains.kotlin.fir.FirReference;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.builder.Context;
import org.jetbrains.kotlin.fir.builder.ConversionUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirNamedFunction;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirErrorFunction;
import org.jetbrains.kotlin.fir.declarations.impl.FirErrorLoop;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirTypeParameterImplKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirReturnExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractLoop;
import org.jetbrains.kotlin.fir.expressions.impl.FirArraySetCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallWithArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImplKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirLoopJump;
import org.jetbrains.kotlin.fir.expressions.impl.FirModifiableQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.impl.FirReturnExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirStringConcatenationCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirThrowExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnknownTypeExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirVariableAssignmentImpl;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirExplicitThisReference;
import org.jetbrains.kotlin.fir.references.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.ConeClassTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.constants.evaluate.ParseUtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f2\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 w*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001wB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010#\u001a\u00020$J\u0018\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)J\u0013\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010-JH\u0010.\u001a\u00020+2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020)2\u0017\u00104\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020+05\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010;\u001a\u00020\u000bJ*\u0010<\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0006\u0010&\u001a\u00020'2\f\u0010=\u001a\b\u0012\u0004\u0012\u0002H\u00010>H\u0086\b\u00a2\u0006\u0002\u0010?J<\u0010@\u001a\u00020A*\u0004\u0018\u00018\u00002\b\u0010B\u001a\u0004\u0018\u0001002\u001f\u00104\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020+0C\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u0010DJ\u0017\u0010E\u001a\u00020F*\u00020F2\u0006\u0010,\u001a\u00028\u0000\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u00020I*\u00020I2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020K0>JD\u0010L\u001a\u00020M*\u0004\u0018\u00018\u00002\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010P\u001a\u00020+2\u0006\u0010Q\u001a\u00020R2\u0017\u00104\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020+05\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u0010SJ\u001b\u0010T\u001a\u0004\u0018\u00018\u0000*\u00028\u00002\u0006\u0010U\u001a\u00020\u001bH&\u00a2\u0006\u0002\u0010VJ\u0013\u0010W\u001a\u0004\u0018\u00018\u0000*\u00028\u0000H&\u00a2\u0006\u0002\u0010 J\u0013\u0010X\u001a\u0004\u0018\u00010\u0017*\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0019J\u0019\u0010Y\u001a\u0004\u0018\u00010O\"\u0004\b\u0001\u0010\u0001*\u0002H\u0001H\u0002\u00a2\u0006\u0002\u0010ZJ\u0011\u0010[\u001a\u00020'*\u00028\u0000H&\u00a2\u0006\u0002\u0010\\J:\u0010]\u001a\u00020^*\u0006\u0012\u0002\b\u00030_2\b\u0010`\u001a\u0004\u0018\u00018\u00002\u0019\u0010a\u001a\u0015\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00010b05\u00a2\u0006\u0002\b6H\u0002\u00a2\u0006\u0002\u0010cJ\u001d\u0010d\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010e\u00a2\u0006\u0002\u0010fJ\u0016\u0010g\u001a\u00020h\"\u0004\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010eJ\u0014\u0010i\u001a\u00020\u000b*\u0004\u0018\u00010j2\u0006\u0010k\u001a\u00020lJD\u0010m\u001a\u00020+*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00018\u00000n2\b\u0010o\u001a\u0004\u0018\u00010p2\u001f\u0010q\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020+0C\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u0010rJ\"\u0010s\u001a\u00020t*\u00020+2\n\b\u0002\u0010u\u001a\u0004\u0018\u00010O2\n\b\u0002\u0010v\u001a\u0004\u0018\u00010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\u00020\u0017*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\u001b*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u0004\u0018\u00018\u0000*\u0004\u0018\u00018\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u0017*\u00028\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019\u00a8\u0006x"}, d2={"Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder;", "T", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "context", "Lorg/jetbrains/kotlin/fir/builder/Context;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/builder/Context;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/builder/Context;", "implicitAnnotationType", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "getImplicitAnnotationType", "()Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "implicitAnyType", "getImplicitAnyType", "implicitEnumType", "getImplicitEnumType", "implicitUnitType", "getImplicitUnitType", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "asText", "", "getAsText", "(Ljava/lang/Object;)Ljava/lang/String;", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "(Ljava/lang/Object;)Lcom/intellij/psi/tree/IElementType;", "selectorExpression", "getSelectorExpression", "(Ljava/lang/Object;)Ljava/lang/Object;", "unescapedValue", "getUnescapedValue", "callableIdForClassConstructor", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "callableIdForName", "name", "Lorg/jetbrains/kotlin/name/Name;", "local", "", "generateConstantExpressionByLiteral", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "expression", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "generateIncrementOrDecrementBlock", "baseExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "argument", "callName", "prefix", "convert", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Ljava/lang/Object;Lorg/jetbrains/kotlin/name/Name;ZLkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "typeParametersFromSelfType", "", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "delegatedSelfTypeRef", "withChildClassName", "l", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "bangBangToWhen", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "parent", "Lkotlin/Function2;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "bindLabel", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirLoopJump;", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirLoopJump;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/impl/FirLoopJump;", "configure", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractLoop;", "generateBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "generateAssignment", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "psi", "Lcom/intellij/psi/PsiElement;", "value", "operation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "(Ljava/lang/Object;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/expressions/FirOperation;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getChildNodeByType", "type", "(Ljava/lang/Object;Lcom/intellij/psi/tree/IElementType;)Ljava/lang/Object;", "getExpressionInParentheses", "getLabelName", "getPsiOrNull", "(Ljava/lang/Object;)Lcom/intellij/psi/PsiElement;", "getReferencedNameAsName", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/name/Name;", "initializeLValue", "Lorg/jetbrains/kotlin/fir/FirReference;", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirModifiableQualifiedAccess;", "left", "convertQualified", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "(Lorg/jetbrains/kotlin/fir/expressions/impl/FirModifiableQualifiedAccess;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/FirReference;", "pop", "", "(Ljava/util/List;)Ljava/lang/Object;", "removeLast", "", "toDelegatedSelfType", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "toInterpolatingCall", "", "base", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "convertTemplateEntry", "([Ljava/lang/Object;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toReturn", "Lorg/jetbrains/kotlin/fir/expressions/FirReturnExpression;", "basePsi", "labelName", "Companion", "psi2fir"})
public abstract class BaseFirBuilder<T> {
    @NotNull
    private final FirTypeRef implicitUnitType;
    @NotNull
    private final FirTypeRef implicitAnyType;
    @NotNull
    private final FirTypeRef implicitEnumType;
    @NotNull
    private final FirTypeRef implicitAnnotationType;
    @NotNull
    private final FirSession session;
    @NotNull
    private final Context context;
    @NotNull
    private static final Name KNPE;
    public static final Companion Companion;

    @NotNull
    protected final FirTypeRef getImplicitUnitType() {
        return this.implicitUnitType;
    }

    @NotNull
    protected final FirTypeRef getImplicitAnyType() {
        return this.implicitAnyType;
    }

    @NotNull
    protected final FirTypeRef getImplicitEnumType() {
        return this.implicitEnumType;
    }

    @NotNull
    protected final FirTypeRef getImplicitAnnotationType() {
        return this.implicitAnnotationType;
    }

    @NotNull
    public abstract IElementType getElementType(T var1);

    @NotNull
    public abstract String getAsText(T var1);

    @NotNull
    public abstract String getUnescapedValue(T var1);

    @NotNull
    public abstract Name getReferencedNameAsName(T var1);

    @Nullable
    public abstract String getLabelName(T var1);

    @Nullable
    public abstract T getExpressionInParentheses(T var1);

    @Nullable
    public abstract T getChildNodeByType(T var1, @NotNull IElementType var2);

    @Nullable
    public abstract T getSelectorExpression(@Nullable T var1);

    public final <T> T withChildClassName(@NotNull Name name, @NotNull Function0<? extends T> l) {
        int $i$f$withChildClassName = 0;
        Intrinsics.checkParameterIsNotNull(name, "name");
        Intrinsics.checkParameterIsNotNull(l, "l");
        Context context2 = this.getContext();
        FqName fqName2 = this.getContext().getClassName().child(name);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "context.className.child(name)");
        context2.setClassName(fqName2);
        T t = l.invoke();
        Context context3 = this.getContext();
        FqName fqName3 = this.getContext().getClassName().parent();
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "context.className.parent()");
        context3.setClassName(fqName3);
        return t;
    }

    @NotNull
    public final CallableId callableIdForName(@NotNull Name name, boolean local2) {
        Intrinsics.checkParameterIsNotNull(name, "name");
        return local2 ? new CallableId(name) : (Intrinsics.areEqual(this.context.getClassName(), FqName.ROOT) ? new CallableId(this.context.getPackageFqName(), name) : new CallableId(this.context.getPackageFqName(), this.context.getClassName(), name));
    }

    public static /* synthetic */ CallableId callableIdForName$default(BaseFirBuilder baseFirBuilder, Name name, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: callableIdForName");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return baseFirBuilder.callableIdForName(name, bl);
    }

    @NotNull
    public final CallableId callableIdForClassConstructor() {
        CallableId callableId;
        if (Intrinsics.areEqual(this.context.getClassName(), FqName.ROOT)) {
            FqName fqName2 = this.context.getPackageFqName();
            Name name = Name.special("<anonymous-init>");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<anonymous-init>\")");
            callableId = new CallableId(fqName2, name);
        } else {
            FqName fqName3 = this.context.getPackageFqName();
            FqName fqName4 = this.context.getClassName();
            Name name = this.context.getClassName().shortName();
            Intrinsics.checkExpressionValueIsNotNull(name, "context.className.shortName()");
            callableId = new CallableId(fqName3, fqName4, name);
        }
        return callableId;
    }

    public final <T> void removeLast(@NotNull List<T> $this$removeLast) {
        Intrinsics.checkParameterIsNotNull($this$removeLast, "$this$removeLast");
        $this$removeLast.remove($this$removeLast.size() - 1);
    }

    @Nullable
    public final <T> T pop(@NotNull List<T> $this$pop) {
        Intrinsics.checkParameterIsNotNull($this$pop, "$this$pop");
        T result2 = CollectionsKt.lastOrNull($this$pop);
        if (result2 != null) {
            $this$pop.remove($this$pop.size() - 1);
        }
        return result2;
    }

    @NotNull
    public final FirReturnExpression toReturn(@NotNull FirExpression $this$toReturn, @Nullable PsiElement basePsi, @Nullable String labelName) {
        FirReturnExpressionImpl firReturnExpressionImpl;
        block7: {
            Intrinsics.checkParameterIsNotNull($this$toReturn, "$this$toReturn");
            firReturnExpressionImpl = new FirReturnExpressionImpl(basePsi, $this$toReturn);
            boolean bl = false;
            boolean bl2 = false;
            FirReturnExpressionImpl $this$apply = firReturnExpressionImpl;
            boolean bl3 = false;
            $this$apply.setTarget(new FirFunctionTarget(labelName));
            FirFunction<?> lastFunction = CollectionsKt.lastOrNull(this.context.getFirFunctions());
            if (labelName == null) {
                if (lastFunction != null) {
                    $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)lastFunction));
                } else {
                    $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)new FirErrorFunction(this.session, $this$apply.getPsi(), "Cannot bind unlabeled return to a function", null, 8, null)));
                }
            } else {
                for (FirFunction<?> firFunction : CollectionsKt.asReversedMutable(this.context.getFirFunctions())) {
                    FirFunction<?> firFunction2 = firFunction;
                    if (firFunction2 instanceof FirAnonymousFunction) {
                        FirLabel firLabel = ((FirAnonymousFunction)firFunction).getLabel();
                        if (!Intrinsics.areEqual(firLabel != null ? firLabel.getName() : null, labelName)) continue;
                        $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)firFunction));
                    } else {
                        if (!(firFunction2 instanceof FirNamedFunction) || !Intrinsics.areEqual(((FirNamedFunction)firFunction).getName().asString(), labelName)) continue;
                        $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)firFunction));
                    }
                    break block7;
                }
                $this$apply.getTarget().bind((FirFunction<?>)((FirTargetElement)new FirErrorFunction(this.session, $this$apply.getPsi(), "Cannot bind label " + labelName + " to a function", null, 8, null)));
            }
        }
        return firReturnExpressionImpl;
    }

    public static /* synthetic */ FirReturnExpression toReturn$default(BaseFirBuilder baseFirBuilder, FirExpression firExpression2, PsiElement psiElement, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toReturn");
        }
        if ((n & 1) != 0) {
            psiElement = firExpression2.getPsi();
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return baseFirBuilder.toReturn(firExpression2, psiElement, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FirTypeRef toDelegatedSelfType(@Nullable KtClassOrObject $this$toDelegatedSelfType, @NotNull FirRegularClass firClass) {
        void $this$toTypedArray$iv;
        Collection<ConeTypeParameterTypeImpl> collection;
        FirTypeParameterImpl it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(firClass, "firClass");
        Iterable $this$map$iv = firClass.getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            FirTypeParameterImpl firTypeParameterImpl = new FirTypeParameterImpl(this.session, it.getPsi(), new FirTypeParameterSymbol(), it.getName(), Variance.INVARIANT, false);
            boolean bl2 = false;
            boolean bl3 = false;
            FirTypeParameterImpl $this$apply = firTypeParameterImpl;
            boolean bl4 = false;
            Collection collection3 = $this$apply.getBounds();
            Iterable iterable2 = it.getBounds();
            boolean bl5 = false;
            CollectionsKt.addAll(collection3, iterable2);
            FirTypeParameterImplKt.addDefaultBoundIfNecessary($this$apply);
            FirTypeParameterImpl firTypeParameterImpl2 = firTypeParameterImpl;
            collection2.add(firTypeParameterImpl2);
        }
        List typeParameters2 = (List)destination$iv$iv;
        $this$map$iv = typeParameters2;
        ConeClassLikeLookupTag coneClassLikeLookupTag = firClass.getSymbol().toLookupTag();
        PsiElement psiElement = $this$toDelegatedSelfType;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirTypeParameterImpl)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ConeTypeParameterTypeImpl coneTypeParameterTypeImpl = new ConeTypeParameterTypeImpl(it.getSymbol().toLookupTag(), false);
            collection.add(coneTypeParameterTypeImpl);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ConeTypeParameterTypeImpl[] coneTypeParameterTypeImplArray = thisCollection$iv.toArray(new ConeTypeParameterTypeImpl[0]);
        if (coneTypeParameterTypeImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = coneTypeParameterTypeImplArray;
        boolean bl = false;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray = (ConeKotlinTypeProjection[])collection;
        ConeClassLikeLookupTag coneClassLikeLookupTag2 = coneClassLikeLookupTag;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        List list2 = null;
        ConeKotlinType coneKotlinType = new ConeClassTypeImpl(coneClassLikeLookupTag2, coneKotlinTypeProjectionArray, bl);
        PsiElement psiElement2 = psiElement;
        return new FirResolvedTypeRefImpl(psiElement2, coneKotlinType, list2, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameter> typeParametersFromSelfType(@NotNull FirTypeRef delegatedSelfTypeRef) {
        List list2;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray;
        Intrinsics.checkParameterIsNotNull(delegatedSelfTypeRef, "delegatedSelfTypeRef");
        FirTypeRef $this$coneTypeSafe$iv = delegatedSelfTypeRef;
        boolean $i$f$coneTypeSafe = false;
        FirTypeRef firTypeRef = $this$coneTypeSafe$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)firTypeRef;
        Object object = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(object instanceof ConeKotlinType)) {
            object = coneKotlinTypeProjectionArray = null;
        }
        if (object != null && (coneKotlinTypeProjectionArray = coneKotlinTypeProjectionArray.getTypeArguments()) != null) {
            void $this$mapTo$iv$iv;
            ConeKotlinTypeProjection[] $this$map$iv = coneKotlinTypeProjectionArray;
            boolean $i$f$map = false;
            ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var7_7 = $this$mapTo$iv$iv;
            int n = ((void)var7_7).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = var7_7[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v4 = it;
                if (v4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeTypeParameterType");
                }
                FirClassifierSymbol<?> firClassifierSymbol = ((ConeTypeParameterType)v4).getLookupTag().getSymbol();
                if (firClassifierSymbol == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol");
                }
                FirTypeParameter firTypeParameter = (FirTypeParameter)((FirTypeParameterSymbol)firClassifierSymbol).getFir();
                collection.add(firTypeParameter);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final FirWhenExpression bangBangToWhen(@Nullable T $this$bangBangToWhen, @Nullable KtUnaryExpression parent2, @NotNull Function2<? super T, ? super String, ? extends FirExpression> convert) {
        Intrinsics.checkParameterIsNotNull(convert, "convert");
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(this.getPsiOrNull(parent2), false, 2, null);
        PsiElement psiElement = this.getPsiOrNull(parent2);
        FirSession firSession = this.session;
        FirExpression firExpression2 = convert.invoke($this$bangBangToWhen, "No operand");
        boolean bl = false;
        boolean bl2 = false;
        FirFunctionCallImpl $this$apply = firFunctionCallImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(parent2, KNPE));
        FirFunctionCallImpl firFunctionCallImpl2 = firFunctionCallImpl;
        FirExpression firExpression3 = firFunctionCallImpl2;
        PsiElement psiElement2 = psiElement;
        return ConversionUtilsKt.generateNotNullOrOther(firExpression2, firSession, new FirThrowExpressionImpl(psiElement2, firExpression3), "bangbang", parent2);
    }

    @NotNull
    public final FirAbstractLoop configure(@NotNull FirAbstractLoop $this$configure, @NotNull Function0<? extends FirBlock> generateBlock) {
        Intrinsics.checkParameterIsNotNull($this$configure, "$this$configure");
        Intrinsics.checkParameterIsNotNull(generateBlock, "generateBlock");
        $this$configure.setLabel(this.pop(this.context.getFirLabels()));
        Collection collection = this.context.getFirLoops();
        boolean bl = false;
        collection.add($this$configure);
        $this$configure.setBlock(generateBlock.invoke());
        this.removeLast(this.context.getFirLoops());
        return $this$configure;
    }

    @NotNull
    public final FirLoopJump bindLabel(@NotNull FirLoopJump $this$bindLabel, T expression2) {
        Intrinsics.checkParameterIsNotNull($this$bindLabel, "$this$bindLabel");
        String labelName = this.getLabelName(expression2);
        $this$bindLabel.setTarget(new FirLoopTarget(labelName));
        FirLoop lastLoop = CollectionsKt.lastOrNull(this.context.getFirLoops());
        if (labelName == null) {
            if (lastLoop != null) {
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)lastLoop));
            } else {
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)new FirErrorLoop(this.getPsiOrNull(expression2), "Cannot bind unlabeled jump to a loop")));
            }
        } else {
            for (FirLoop firLoop : CollectionsKt.asReversedMutable(this.context.getFirLoops())) {
                FirLabel firLabel = firLoop.getLabel();
                if (!Intrinsics.areEqual(firLabel != null ? firLabel.getName() : null, labelName)) continue;
                $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)firLoop));
                return $this$bindLabel;
            }
            $this$bindLabel.getTarget().bind((FirLoop)((FirTargetElement)new FirErrorLoop(this.getPsiOrNull(expression2), "Cannot bind label " + labelName + " to a loop")));
        }
        return $this$bindLabel;
    }

    private final <T> PsiElement getPsiOrNull(T $this$getPsiOrNull) {
        return (PsiElement)($this$getPsiOrNull instanceof PsiElement ? $this$getPsiOrNull : null);
    }

    @NotNull
    public final FirExpression generateConstantExpressionByLiteral(T expression2) {
        FirUnknownTypeExpression firUnknownTypeExpression;
        IElementType type2 = this.getElementType(expression2);
        String text2 = this.getAsText(expression2);
        IElementType iElementType = type2;
        Serializable convertedText = Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT) ? (Serializable)ParseUtilsKt.parseNumericLiteral(text2, type2) : (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT) ? (Serializable)Boolean.valueOf(ParseUtilsKt.parseBoolean(text2)) : null);
        iElementType = type2;
        if (Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT)) {
            firUnknownTypeExpression = convertedText instanceof Long && (ParseUtilsKt.hasLongSuffix(text2) || ParseUtilsKt.hasUnsignedLongSuffix(text2) || ParseUtilsKt.hasUnsignedSuffix(text2) || ((Number)convertedText).longValue() > (long)Integer.MAX_VALUE || ((Number)convertedText).longValue() < (long)Integer.MIN_VALUE) ? FirConstExpressionImplKt.FirConstExpressionImpl(this.getPsiOrNull(expression2), IrConstKind.Long.INSTANCE, convertedText, "Incorrect long: " + text2) : (convertedText instanceof Number ? FirConstExpressionImplKt.FirConstExpressionImpl(this.getPsiOrNull(expression2), IrConstKind.Int.INSTANCE, ((Number)convertedText).intValue(), "Incorrect int: " + text2) : (FirUnknownTypeExpression)new FirErrorExpressionImpl(this.getPsiOrNull(expression2), "Incorrect constant expression: " + text2));
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT)) {
            if (convertedText instanceof Float) {
                firUnknownTypeExpression = FirConstExpressionImplKt.FirConstExpressionImpl(this.getPsiOrNull(expression2), IrConstKind.Float.INSTANCE, convertedText, "Incorrect float: " + text2);
            } else {
                Serializable serializable = convertedText;
                if (serializable == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Double");
                }
                firUnknownTypeExpression = FirConstExpressionImplKt.FirConstExpressionImpl(this.getPsiOrNull(expression2), IrConstKind.Double.INSTANCE, (Double)serializable, "Incorrect double: " + text2);
            }
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.CHARACTER_CONSTANT)) {
            firUnknownTypeExpression = FirConstExpressionImplKt.FirConstExpressionImpl(this.getPsiOrNull(expression2), IrConstKind.Char.INSTANCE, ConversionUtilsKt.parseCharacter(text2), "Incorrect character: " + text2);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.BOOLEAN_CONSTANT)) {
            Serializable serializable = convertedText;
            if (serializable == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            firUnknownTypeExpression = new FirConstExpressionImpl<Boolean>(this.getPsiOrNull(expression2), IrConstKind.Boolean.INSTANCE, (Boolean)serializable);
        } else if (Intrinsics.areEqual(iElementType, KtNodeTypes.NULL)) {
            firUnknownTypeExpression = new FirConstExpressionImpl<Object>(this.getPsiOrNull(expression2), IrConstKind.Null.INSTANCE, null);
        } else {
            throw (Throwable)((Object)new AssertionError((Object)("Unknown literal type: " + type2 + ", " + text2)));
        }
        return firUnknownTypeExpression;
    }

    @NotNull
    public final FirExpression toInterpolatingCall(@NotNull T[] $this$toInterpolatingCall, @Nullable KtStringTemplateExpression base, @NotNull Function2<? super T, ? super String, ? extends FirExpression> convertTemplateEntry) {
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull($this$toInterpolatingCall, "$this$toInterpolatingCall");
        Intrinsics.checkParameterIsNotNull(convertTemplateEntry, "convertTemplateEntry");
        StringBuilder sb = new StringBuilder();
        boolean hasExpressions = false;
        FirExpression result2 = null;
        boolean callCreated = false;
        for (T entry : $this$toInterpolatingCall) {
            Object object;
            boolean bl;
            FirExpression firExpression3;
            Collection collection;
            Object $this$apply;
            boolean bl2;
            boolean bl3;
            Object object2;
            FirExpression firExpression4;
            Object object3;
            if (entry == null || Intrinsics.areEqual(object3 = this.getElementType(entry), KtTokens.OPEN_QUOTE) || Intrinsics.areEqual(object3, KtTokens.CLOSING_QUOTE)) continue;
            if (Intrinsics.areEqual(object3, KtNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY)) {
                sb.append(this.getAsText(entry));
                firExpression4 = new FirConstExpressionImpl<String>(this.getPsiOrNull(entry), IrConstKind.String.INSTANCE, this.getAsText(entry));
            } else if (Intrinsics.areEqual(object3, KtNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY)) {
                sb.append(this.getUnescapedValue(entry));
                firExpression4 = new FirConstExpressionImpl<String>(this.getPsiOrNull(entry), IrConstKind.String.INSTANCE, this.getUnescapedValue(entry));
            } else if (Intrinsics.areEqual(object3, KtNodeTypes.SHORT_STRING_TEMPLATE_ENTRY) || Intrinsics.areEqual(object3, KtNodeTypes.LONG_STRING_TEMPLATE_ENTRY)) {
                hasExpressions = true;
                firExpression4 = convertTemplateEntry.invoke(entry, "Incorrect template argument");
            } else {
                hasExpressions = true;
                firExpression4 = new FirErrorExpressionImpl(this.getPsiOrNull(entry), "Incorrect template entry: " + this.getAsText(entry));
            }
            FirExpression nextArgument = firExpression4;
            if (result2 == null) {
                object2 = nextArgument;
            } else if (callCreated && result2 instanceof FirStringConcatenationCallImpl) {
                object3 = result2;
                bl3 = false;
                bl2 = false;
                $this$apply = (FirStringConcatenationCallImpl)object3;
                boolean bl4 = false;
                collection = ((FirCallWithArgumentList)$this$apply).getArguments();
                firExpression3 = nextArgument;
                bl = false;
                collection.add(firExpression3);
                object2 = object = object3;
            } else {
                callCreated = true;
                object3 = new FirStringConcatenationCallImpl(base);
                bl3 = false;
                bl2 = false;
                $this$apply = object3;
                boolean bl5 = false;
                collection = ((FirCallWithArgumentList)$this$apply).getArguments();
                FirExpression firExpression5 = result2;
                if (firExpression5 == null) {
                    Intrinsics.throwNpe();
                }
                firExpression3 = firExpression5;
                bl = false;
                collection.add(firExpression3);
                collection = ((FirCallWithArgumentList)$this$apply).getArguments();
                firExpression3 = nextArgument;
                bl = false;
                collection.add(firExpression3);
                object = object3;
                object2 = (FirExpression)object;
            }
            result2 = object2;
        }
        if (hasExpressions) {
            firExpression2 = result2;
            if (firExpression2 == null) {
                Intrinsics.throwNpe();
            }
        } else {
            PsiElement psiElement = base;
            IrConstKind irConstKind = IrConstKind.String.INSTANCE;
            String string2 = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull(string2, "sb.toString()");
            firExpression2 = new FirConstExpressionImpl<String>(psiElement, irConstKind, string2);
        }
        return firExpression2;
    }

    @NotNull
    public final FirExpression generateIncrementOrDecrementBlock(@Nullable KtUnaryExpression baseExpression, @Nullable T argument, @NotNull Name callName, boolean prefix, @NotNull Function1<? super T, ? extends FirExpression> convert) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(callName, "callName");
        Intrinsics.checkParameterIsNotNull(convert, "convert");
        if (argument == null) {
            return new FirErrorExpressionImpl((PsiElement)argument, "Inc/dec without operand");
        }
        FirBlockImpl firBlockImpl = new FirBlockImpl(baseExpression);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        Name name = Name.special("<unary>");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<unary>\")");
        Name tempName = name;
        FirVariable<?> temporaryVariable = ConversionUtilsKt.generateTemporaryVariable(this.session, (PsiElement)baseExpression, tempName, convert.invoke(argument));
        Collection collection2 = $this$apply.getStatements();
        boolean bl4 = false;
        collection2.add(temporaryVariable);
        Name name2 = Name.special("<unary-result>");
        Intrinsics.checkExpressionValueIsNotNull(name2, "Name.special(\"<unary-result>\")");
        Name resultName = name2;
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(baseExpression, false, 2, null);
        boolean bl5 = false;
        boolean bl6 = false;
        FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
        boolean bl7 = false;
        KtUnaryExpression ktUnaryExpression = baseExpression;
        $this$apply2.setCalleeReference(new FirSimpleNamedReference(ktUnaryExpression != null ? ktUnaryExpression.getOperationReference() : null, callName));
        $this$apply2.setExplicitReceiver(ConversionUtilsKt.generateResolvedAccessExpression(baseExpression, temporaryVariable));
        FirFunctionCallImpl resultInitializer = firFunctionCallImpl;
        FirVariable<?> resultVar = ConversionUtilsKt.generateTemporaryVariable(this.session, (PsiElement)baseExpression, resultName, (FirExpression)resultInitializer);
        FirStatement assignment = this.generateAssignment(argument, baseExpression, (FirExpression)(prefix && Intrinsics.areEqual(this.getElementType(argument), KtNodeTypes.REFERENCE_EXPRESSION) ^ true ? (FirStatement)ConversionUtilsKt.generateResolvedAccessExpression(baseExpression, resultVar) : (FirStatement)resultInitializer), FirOperation.ASSIGN, convert);
        Function0<Unit> $fun$appendAssignment$1 = new Function0<Unit>($this$apply, assignment){
            final /* synthetic */ FirBlockImpl $this_apply;
            final /* synthetic */ FirStatement $assignment;

            public final void invoke() {
                if (this.$assignment instanceof FirBlock) {
                    Collection collection = this.$this_apply.getStatements();
                    Iterable iterable = ((FirBlock)this.$assignment).getStatements();
                    boolean bl = false;
                    CollectionsKt.addAll(collection, iterable);
                } else {
                    Collection collection = this.$this_apply.getStatements();
                    FirStatement firStatement = this.$assignment;
                    boolean bl = false;
                    collection.add(firStatement);
                }
            }
            {
                this.$this_apply = firBlockImpl;
                this.$assignment = firStatement;
                super(0);
            }
        };
        if (prefix) {
            if (Intrinsics.areEqual(this.getElementType(argument), KtNodeTypes.REFERENCE_EXPRESSION) ^ true) {
                collection = $this$apply.getStatements();
                boolean bl8 = false;
                collection.add(resultVar);
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(baseExpression, resultVar);
                boolean bl9 = false;
                collection.add(firQualifiedAccessExpression);
            } else {
                $fun$appendAssignment$1.invoke();
                collection = $this$apply.getStatements();
                FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateAccessExpression(baseExpression, this.getReferencedNameAsName(argument));
                boolean bl10 = false;
                collection.add(firQualifiedAccessExpression);
            }
        } else {
            $fun$appendAssignment$1.invoke();
            collection = $this$apply.getStatements();
            FirQualifiedAccessExpression firQualifiedAccessExpression = ConversionUtilsKt.generateResolvedAccessExpression(baseExpression, temporaryVariable);
            boolean bl11 = false;
            collection.add(firQualifiedAccessExpression);
        }
        return firBlockImpl;
    }

    private final FirReference initializeLValue(@NotNull FirModifiableQualifiedAccess<?> $this$initializeLValue, T left, Function1<? super T, ? extends FirQualifiedAccess> convertQualified) {
        IElementType tokenType;
        T t = left;
        IElementType iElementType = tokenType = t != null ? this.getElementType(t) : null;
        if (left != null) {
            IElementType iElementType2 = tokenType;
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.REFERENCE_EXPRESSION)) {
                return new FirSimpleNamedReference(this.getPsiOrNull(left), this.getReferencedNameAsName(left));
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.THIS_EXPRESSION)) {
                return new FirExplicitThisReference(this.getPsiOrNull(left), this.getLabelName(left));
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.DOT_QUALIFIED_EXPRESSION) || Intrinsics.areEqual(iElementType2, KtNodeTypes.SAFE_ACCESS_EXPRESSION)) {
                FirReference firReference;
                FirQualifiedAccess firMemberAccess = convertQualified.invoke(left);
                if (firMemberAccess != null) {
                    $this$initializeLValue.setExplicitReceiver(firMemberAccess.getExplicitReceiver());
                    $this$initializeLValue.setSafe(firMemberAccess.getSafe());
                    firReference = firMemberAccess.getCalleeReference();
                } else {
                    firReference = new FirErrorNamedReference(this.getPsiOrNull(left), "Unsupported qualified LValue: " + this.getAsText(left), null, 4, null);
                }
                return firReference;
            }
            if (Intrinsics.areEqual(iElementType2, KtNodeTypes.PARENTHESIZED)) {
                return this.initializeLValue($this$initializeLValue, this.getExpressionInParentheses(left), convertQualified);
            }
        }
        return new FirErrorNamedReference(this.getPsiOrNull(left), "Unsupported LValue: " + tokenType, null, 4, null);
    }

    @NotNull
    public final FirStatement generateAssignment(@Nullable T $this$generateAssignment, @Nullable PsiElement psi, @NotNull FirExpression value2, @NotNull FirOperation operation, @NotNull Function1<? super T, ? extends FirExpression> convert) {
        block12: {
            block13: {
                IElementType tokenType;
                Intrinsics.checkParameterIsNotNull(value2, "value");
                Intrinsics.checkParameterIsNotNull((Object)operation, "operation");
                Intrinsics.checkParameterIsNotNull(convert, "convert");
                T t = $this$generateAssignment;
                IElementType iElementType = tokenType = t != null ? this.getElementType(t) : null;
                if (Intrinsics.areEqual(tokenType, KtNodeTypes.PARENTHESIZED)) {
                    T t2 = $this$generateAssignment;
                    if (t2 == null) {
                        Intrinsics.throwNpe();
                    }
                    return this.generateAssignment(this.getExpressionInParentheses(t2), psi, value2, operation, convert);
                }
                if (Intrinsics.areEqual(tokenType, KtNodeTypes.ARRAY_ACCESS_EXPRESSION)) {
                    T t3 = $this$generateAssignment;
                    if (t3 == null) {
                        Intrinsics.throwNpe();
                    }
                    FirExpression firExpression2 = convert.invoke(t3);
                    if (firExpression2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl");
                    }
                    FirFunctionCallImpl firArrayAccess = (FirFunctionCallImpl)firExpression2;
                    if (operation == FirOperation.ASSIGN) {
                        FirFunctionCallImpl firFunctionCallImpl = firArrayAccess;
                        boolean bl = false;
                        boolean bl2 = false;
                        FirFunctionCallImpl $this$apply2 = firFunctionCallImpl;
                        boolean bl3 = false;
                        $this$apply2.setCalleeReference(new FirSimpleNamedReference(psi, OperatorNameConventions.SET));
                        Collection collection = $this$apply2.getArguments();
                        FirExpression firExpression3 = value2;
                        boolean bl4 = false;
                        collection.add(firExpression3);
                        return firFunctionCallImpl;
                    }
                    FirArraySetCallImpl firArraySetCallImpl = new FirArraySetCallImpl(psi, value2, operation);
                    boolean bl = false;
                    boolean bl5 = false;
                    FirArraySetCallImpl $this$apply = firArraySetCallImpl;
                    boolean bl6 = false;
                    Collection collection = $this$apply.getIndexes();
                    Iterable iterable = firArrayAccess.getArguments();
                    boolean bl7 = false;
                    CollectionsKt.addAll(collection, iterable);
                    FirArraySetCallImpl arraySet = firArraySetCallImpl;
                    IElementType iElementType2 = KtNodeTypes.REFERENCE_EXPRESSION;
                    Intrinsics.checkExpressionValueIsNotNull(iElementType2, "REFERENCE_EXPRESSION");
                    T arrayExpression = this.getChildNodeByType($this$generateAssignment, iElementType2);
                    if (arrayExpression != null) {
                        FirArraySetCallImpl firArraySetCallImpl2 = arraySet;
                        bl5 = false;
                        boolean $this$apply2 = false;
                        FirArraySetCallImpl $this$apply3 = firArraySetCallImpl2;
                        boolean bl8 = false;
                        $this$apply3.setLValue(this.initializeLValue($this$apply3, arrayExpression, new Function1<T, FirQualifiedAccess>(this, arrayExpression, convert){
                            final /* synthetic */ BaseFirBuilder this$0;
                            final /* synthetic */ Object $arrayExpression$inlined;
                            final /* synthetic */ Function1 $convert$inlined;
                            {
                                this.this$0 = baseFirBuilder;
                                this.$arrayExpression$inlined = object;
                                this.$convert$inlined = function1;
                                super(1);
                            }

                            @Nullable
                            public final FirQualifiedAccess invoke(T $this$initializeLValue) {
                                R r = this.$convert$inlined.invoke($this$initializeLValue);
                                if (!(r instanceof FirQualifiedAccess)) {
                                    r = null;
                                }
                                return (FirQualifiedAccess)r;
                            }
                        }));
                        return firArraySetCallImpl2;
                    }
                    FirExpression firExpression4 = firArrayAccess.getExplicitReceiver();
                    PsiElement psiArrayExpression = firExpression4 != null ? firExpression4.getPsi() : null;
                    FirBlockImpl firBlockImpl = new FirBlockImpl(psiArrayExpression);
                    boolean $this$apply2 = false;
                    boolean bl9 = false;
                    FirBlockImpl $this$apply4 = firBlockImpl;
                    boolean bl10 = false;
                    Name name = Name.special("<array-set>");
                    Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<array-set>\")");
                    Name name2 = name;
                    Collection collection2 = $this$apply4.getStatements();
                    PsiElement psiElement = this.getPsiOrNull($this$generateAssignment);
                    FirExpression firExpression5 = firArrayAccess.getExplicitReceiver();
                    if (firExpression5 == null) {
                        Intrinsics.throwNpe();
                    }
                    FirStatement firStatement = ConversionUtilsKt.generateTemporaryVariable(this.session, psiElement, name2, firExpression5);
                    boolean bl11 = false;
                    collection2.add(firStatement);
                    collection2 = $this$apply4.getStatements();
                    firStatement = arraySet;
                    bl11 = false;
                    boolean bl12 = false;
                    FirStatement $this$apply5 = firStatement;
                    boolean bl13 = false;
                    ((FirArraySetCallImpl)$this$apply5).setLValue(new FirSimpleNamedReference(psiArrayExpression, name2));
                    bl11 = false;
                    collection2.add(firStatement);
                    return firBlockImpl;
                }
                if (operation == FirOperation.ASSIGN || !(Intrinsics.areEqual(tokenType, KtNodeTypes.REFERENCE_EXPRESSION) ^ true) || !(Intrinsics.areEqual(tokenType, KtNodeTypes.THIS_EXPRESSION) ^ true)) break block12;
                if (Intrinsics.areEqual(tokenType, KtNodeTypes.DOT_QUALIFIED_EXPRESSION) ^ true && Intrinsics.areEqual(tokenType, KtNodeTypes.SAFE_ACCESS_EXPRESSION) ^ true) break block13;
                T t4 = this.getSelectorExpression($this$generateAssignment);
                if (!(Intrinsics.areEqual(t4 != null ? this.getElementType(t4) : null, KtNodeTypes.REFERENCE_EXPRESSION) ^ true)) break block12;
            }
            FirBlockImpl firBlockImpl = new FirBlockImpl(this.getPsiOrNull($this$generateAssignment));
            boolean bl = false;
            boolean bl14 = false;
            FirBlockImpl $this$apply = firBlockImpl;
            boolean bl15 = false;
            Name name = Name.special("<complex-set>");
            Intrinsics.checkExpressionValueIsNotNull(name, "Name.special(\"<complex-set>\")");
            Name name3 = name;
            Collection collection = $this$apply.getStatements();
            PsiElement psiElement = this.getPsiOrNull($this$generateAssignment);
            Object object = $this$generateAssignment;
            if (object == null || (object = convert.invoke(object)) == null) {
                object = new FirErrorExpressionImpl(this.getPsiOrNull($this$apply), "No LValue in assignment");
            }
            FirStatement firStatement = ConversionUtilsKt.generateTemporaryVariable(this.session, psiElement, name3, object);
            boolean bl16 = false;
            collection.add(firStatement);
            collection = $this$apply.getStatements();
            firStatement = new FirVariableAssignmentImpl(psi, value2, operation, false, 8, null);
            bl16 = false;
            boolean bl17 = false;
            FirStatement $this$apply6 = firStatement;
            boolean bl18 = false;
            ((FirAbstractAssignment)$this$apply6).setLValue(new FirSimpleNamedReference(this.getPsiOrNull($this$apply6), name3));
            bl16 = false;
            collection.add(firStatement);
            return firBlockImpl;
        }
        FirVariableAssignmentImpl firVariableAssignmentImpl = new FirVariableAssignmentImpl(psi, value2, operation, false, 8, null);
        boolean bl = false;
        boolean bl19 = false;
        FirVariableAssignmentImpl $this$apply = firVariableAssignmentImpl;
        boolean bl20 = false;
        $this$apply.setLValue(this.initializeLValue($this$apply, $this$generateAssignment, new Function1<T, FirQualifiedAccess>(this, $this$generateAssignment, convert){
            final /* synthetic */ BaseFirBuilder this$0;
            final /* synthetic */ Object $this_generateAssignment$inlined;
            final /* synthetic */ Function1 $convert$inlined;
            {
                this.this$0 = baseFirBuilder;
                this.$this_generateAssignment$inlined = object;
                this.$convert$inlined = function1;
                super(1);
            }

            @Nullable
            public final FirQualifiedAccess invoke(T $this$initializeLValue) {
                R r = this.$convert$inlined.invoke($this$initializeLValue);
                if (!(r instanceof FirQualifiedAccess)) {
                    r = null;
                }
                return (FirQualifiedAccess)r;
            }
        }));
        return firVariableAssignmentImpl;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public BaseFirBuilder(@NotNull FirSession session, @NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull(session, "session");
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.session = session;
        this.context = context2;
        this.implicitUnitType = this.session.getBuiltinTypes().getUnitType();
        this.implicitAnyType = this.session.getBuiltinTypes().getAnyType();
        this.implicitEnumType = this.session.getBuiltinTypes().getEnumType();
        this.implicitAnnotationType = this.session.getBuiltinTypes().getAnnotationType();
    }

    public /* synthetic */ BaseFirBuilder(FirSession firSession, Context context2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            context2 = new Context();
        }
        this(firSession, context2);
    }

    static {
        Companion = new Companion(null);
        Name name = Name.identifier("KotlinNullPointerException");
        Intrinsics.checkExpressionValueIsNotNull(name, "Name.identifier(\"KotlinNullPointerException\")");
        KNPE = name;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/builder/BaseFirBuilder$Companion;", "", "()V", "KNPE", "Lorg/jetbrains/kotlin/name/Name;", "getKNPE", "()Lorg/jetbrains/kotlin/name/Name;", "psi2fir"})
    public static final class Companion {
        @NotNull
        public final Name getKNPE() {
            return KNPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

