/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.AttributeMapper;
import com.lightdev.app.shtm.CSSWriter;
import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.FontPanel;
import com.lightdev.app.shtm.MarginPanel;
import com.lightdev.app.shtm.NamedObject;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.StylePanel;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleContext;
import javax.swing.text.html.HTML;
import javax.swing.text.html.StyleSheet;

class ParaStyleDialog
extends DialogShell
implements AttributeComponent,
ActionListener,
ListSelectionListener,
ChangeListener {
    private final String standardStyleName = Util.getResourceString("standardStyleName");
    private static int MODE_NAMED_STYLES = 1;
    private static int MODE_PARAGRAPH_STYLE = 2;
    private JButton saveStyleBtn;
    private JButton saveStyleAsBtn;
    private JButton deleteStyleBtn;
    private final int mode;
    private final Vector components = new Vector();
    private final FontPanel fp;
    private JList styleList;
    private StyleSheet styles;
    private final Document doc;
    private AttributeSet mapSet;
    private final StylePanel sp;
    private final MarginPanel mp;
    private static NamedObject[] cTypes = null;
    private JComboBox cType;

    public ParaStyleDialog(Frame parent, String title) {
        this(parent, title, null, MODE_PARAGRAPH_STYLE);
    }

    public ParaStyleDialog(Frame parent, String title, Document doc) {
        this(parent, title, doc, MODE_NAMED_STYLES);
    }

    private ParaStyleDialog(Frame parent, String title, Document doc, int mode) {
        super(parent, title);
        JPanel hPanel = null;
        this.mode = mode;
        this.doc = doc;
        Container contentPane = super.getContentPane();
        JTabbedPane tp = new JTabbedPane();
        tp.setTabLayoutPolicy(1);
        this.sp = new StylePanel(1);
        this.sp.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("cellGenTabLabel")));
        this.components.add(this.sp);
        this.mp = new MarginPanel();
        this.components.add(this.mp);
        this.mp.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("cellMarginTabLabel")));
        if (mode == MODE_NAMED_STYLES) {
            this.styles = ((SHTMLDocument)doc).getStyleSheet();
            this.initContentTypes();
            this.cType = new JComboBox<NamedObject>(cTypes);
            this.cType.addActionListener(this);
            this.styleList = new JList();
            this.updateStyleList();
            this.styles.addChangeListener(this);
            this.styleList.addListSelectionListener(this);
            JPanel btnPanel = new JPanel(new GridLayout(3, 1, 5, 5));
            this.saveStyleBtn = new JButton(Util.getResourceString("saveStyleButtonLabel"));
            this.saveStyleBtn.addActionListener(this);
            this.saveStyleBtn.setEnabled(false);
            this.saveStyleAsBtn = new JButton(Util.getResourceString("saveStyleAsButtonLabel"));
            this.saveStyleAsBtn.addActionListener(this);
            this.deleteStyleBtn = new JButton(Util.getResourceString("deleteStyleButtonLabel"));
            this.deleteStyleBtn.addActionListener(this);
            this.deleteStyleBtn.setEnabled(false);
            btnPanel.add(this.saveStyleBtn);
            btnPanel.add(this.saveStyleAsBtn);
            btnPanel.add(this.deleteStyleBtn);
            hPanel = new JPanel(new BorderLayout());
            hPanel.add((Component)btnPanel, "North");
            JPanel nsPanel = new JPanel(new BorderLayout(5, 5));
            nsPanel.add((Component)this.cType, "North");
            nsPanel.add((Component)new JScrollPane(this.styleList), "Center");
            nsPanel.add((Component)hPanel, "East");
            nsPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("stylePanelLabel")));
            nsPanel.setVisible(mode == MODE_NAMED_STYLES);
            hPanel = new JPanel(new BorderLayout());
            hPanel.add((Component)this.sp, "North");
            hPanel.add((Component)nsPanel, "Center");
            this.okButton.setText(Util.getResourceString("closeLabel"));
        } else {
            hPanel = new JPanel(new BorderLayout());
            hPanel.add((Component)this.sp, "North");
        }
        JPanel paraPanel = new JPanel(new BorderLayout());
        paraPanel.add((Component)hPanel, "Center");
        paraPanel.add((Component)this.mp, "East");
        tp.add(Util.getResourceString("paraTabLabel"), paraPanel);
        this.fp = new FontPanel(true);
        contentPane.add((Component)tp, "Center");
        this.cancelButton.setVisible(mode != MODE_NAMED_STYLES);
        tp.add(Util.getResourceString("fontTabLabel"), this.fp);
        this.pack();
    }

    private void updateStyleList() {
        Vector styleNames = Util.getStyleNamesForTag(this.styles, this.getContentType());
        styleNames.insertElementAt(this.standardStyleName, 0);
        this.styleList.setModel(new DefaultComboBoxModel(styleNames));
    }

    private void initContentTypes() {
        cTypes = new NamedObject[10];
        int i = 0;
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.P.toString(), Util.getResourceString("cTagNamePara"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H1.toString(), Util.getResourceString("cTagNameHead1"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H2.toString(), Util.getResourceString("cTagNameHead2"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H3.toString(), Util.getResourceString("cTagNameHead3"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H4.toString(), Util.getResourceString("cTagNameHead4"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H5.toString(), Util.getResourceString("cTagNameHead5"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.H6.toString(), Util.getResourceString("cTagNameHead6"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.A.toString(), Util.getResourceString("cTagNameLink"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.UL.toString(), Util.getResourceString("cTagNameUL"));
        ParaStyleDialog.cTypes[i++] = new NamedObject(HTML.Tag.OL.toString(), Util.getResourceString("cTagNameOL"));
    }

    private String getContentType() {
        return ((NamedObject)this.cType.getSelectedItem()).getObject().toString();
    }

    public AttributeSet getValue() {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            attributes.addAttributes(ac.getValue());
        }
        attributes.addAttributes(this.fp.getAttributes());
        return attributes;
    }

    public AttributeSet getValue(boolean includeUnchanged) {
        if (includeUnchanged) {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            Enumeration elements = this.components.elements();
            while (elements.hasMoreElements()) {
                AttributeComponent ac = (AttributeComponent)elements.nextElement();
                attributes.addAttributes(ac.getValue(includeUnchanged));
            }
            attributes.addAttributes(this.fp.getAttributes(includeUnchanged));
            return attributes;
        }
        return this.getValue();
    }

    public boolean setValue(AttributeSet a) {
        boolean result = true;
        AttributeSet set = Util.resolveAttributes(a);
        Enumeration elements = this.components.elements();
        while (elements.hasMoreElements()) {
            AttributeComponent ac = (AttributeComponent)elements.nextElement();
            if (ac.setValue(set)) continue;
            result = false;
        }
        this.fp.setAttributes(set);
        return result;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource().equals(this.styleList)) {
            int selectedStyleNo = this.styleList.getSelectedIndex();
            boolean styleSelected = selectedStyleNo > -1;
            this.saveStyleBtn.setEnabled(styleSelected);
            this.deleteStyleBtn.setEnabled(styleSelected);
            if (styleSelected) {
                this.sp.reset();
                this.fp.reset();
                this.mp.reset();
                String className = this.styleList.getSelectedValue().toString();
                String styleName = className.equalsIgnoreCase(this.standardStyleName) ? this.getContentType() : this.getContentType() + "." + className;
                MutableAttributeSet style = this.styles.getStyle(styleName);
                if (style == null) {
                    style = new SimpleAttributeSet();
                }
                MutableAttributeSet allStyles = (MutableAttributeSet)SHTMLPanelImpl.getMaxAttributes(((SHTMLDocument)this.doc).getCharacterElement(this.doc.getEndPosition().getOffset()), ((SHTMLDocument)this.doc).getStyleSheet());
                allStyles.addAttributes(style);
                this.setValue(allStyles);
            }
        }
    }

    private String getSelectedStyleName() {
        String styleName = null;
        if (this.styleList.getSelectedIndex() > -1) {
            styleName = this.styleList.getSelectedValue().toString();
        }
        return styleName;
    }

    private void doSaveStyle() {
        String styleName = this.getSelectedStyleName();
        if (styleName != null) {
            this.saveStyleAs(styleName);
        }
    }

    private void doSaveStyleAs() {
        String newStyleName;
        String initialName = this.getSelectedStyleName();
        if (initialName == null) {
            initialName = Util.getResourceString("newStyleDefaultName");
        }
        if ((newStyleName = Util.nameInput(null, initialName, "\\w[\\w ]*", "styleNameInputTitle", "styleNameInputText").trim()) != null) {
            if (this.styleNameExists(newStyleName) || newStyleName.equalsIgnoreCase(this.standardStyleName)) {
                if (Util.msg(0, "confirmSaveAs", "fileExistsQuery", newStyleName, " ")) {
                    this.saveStyleAs(newStyleName);
                }
            } else {
                this.saveStyleAs(newStyleName);
            }
        }
    }

    private void doDeleteStyle() {
        String styleName = this.getSelectedStyleName();
        if (styleName != null && Util.msg(0, "confirmDelete", "deleteStyleQuery", styleName, "\r\n\r\n")) {
            this.styles.removeStyle(this.getContentType() + "." + styleName);
        }
    }

    private void saveStyleAs(String newStyleName) {
        try {
            SHTMLDocument sd;
            String className = this.getContentType();
            if (!newStyleName.equalsIgnoreCase(this.standardStyleName)) {
                className = className + "." + newStyleName;
            }
            StringWriter sw = new StringWriter();
            CSSWriter cw = new CSSWriter(sw, null);
            SimpleAttributeSet a = new SimpleAttributeSet();
            if (this.mapSet != null) {
                a.addAttributes(this.mapSet);
            }
            a.addAttributes(new AttributeMapper(this.getValue(true)).getMappedAttributes(0));
            cw.writeRule(className, a);
            String ruleStr = sw.getBuffer().toString();
            this.styles.removeStyle(className);
            this.styles.addRule(ruleStr);
            if (this.doc != null && !(sd = (SHTMLDocument)this.doc).hasStyleRef()) {
                sd.insertStyleRef();
            }
        }
        catch (Exception ex) {
            Util.errMsg(this, ex.getMessage(), ex);
        }
    }

    public StyleSheet getStyleSheet() {
        return this.styles;
    }

    private boolean styleNameExists(String styleName) {
        Vector styleNames = Util.getStyleNamesForTag(this.styles, this.getContentType());
        return styleNames.indexOf(styleName) > -1;
    }

    public void dispose() {
        if (this.mode == MODE_NAMED_STYLES) {
            this.styles.removeChangeListener(this);
        }
        super.dispose();
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src instanceof StyleContext.NamedStyle) {
            Vector styleNames = Util.getStyleNamesForTag((AttributeSet)src, this.getContentType());
            styleNames.insertElementAt(this.standardStyleName, 0);
            this.styleList.setModel(new DefaultComboBoxModel(styleNames));
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.saveStyleBtn)) {
            this.doSaveStyle();
        } else if (src.equals(this.saveStyleAsBtn)) {
            this.doSaveStyleAs();
        } else if (src.equals(this.deleteStyleBtn)) {
            this.doDeleteStyle();
        } else if (src.equals(this.cType)) {
            this.updateStyleList();
        } else {
            super.actionPerformed(e);
        }
    }
}

