/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.FreeMindFileDialog;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.swing.AbstractAction;

public class ImportFolderStructureAction
extends AbstractAction {
    private static Logger logger;
    private final MindMapController controller;

    public ImportFolderStructureAction(MindMapController controller) {
        super(controller.getText("import_folder_structure"));
        this.controller = controller;
        if (logger == null) {
            logger = controller.getFrame().getLogger(this.getClass().getName());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FreeMindFileDialog chooser = this.controller.getFileChooser(null);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(this.controller.getText("select_folder_for_importing"));
        FreeMindMain frame = this.getFrame();
        int returnVal = chooser.showOpenDialog(frame.getContentPane());
        if (returnVal == 0) {
            File folder = chooser.getSelectedFile();
            frame.out("Importing folder structure ...");
            try {
                frame.setWaitingCursor(true);
                this.importFolderStructure(folder, this.controller.getSelected(), true);
            }
            catch (Exception ex) {
                Resources.getInstance().logException(ex);
            }
            frame.setWaitingCursor(false);
            frame.out("Folder structure imported.");
        }
    }

    private FreeMindMain getFrame() {
        return this.controller.getFrame();
    }

    public void importFolderStructure(File folder, MindMapNode target, boolean redisplay) throws MalformedURLException {
        logger.fine("Entering folder: " + folder);
        if (folder.isDirectory()) {
            this.getFrame().out(folder.getName());
            File[] list = folder.listFiles();
            if (list != null) {
                int i;
                for (i = 0; i < list.length; ++i) {
                    if (!list[i].isDirectory()) continue;
                    MindMapNode node = this.addNode(target, list[i].getName(), Tools.fileToUrl(list[i]).toString());
                    this.importFolderStructure(list[i], node, false);
                }
                for (i = 0; i < list.length; ++i) {
                    if (list[i].isDirectory()) continue;
                    this.addNode(target, list[i].getName(), Tools.fileToUrl(list[i]).toString());
                }
            }
        }
        this.controller.setFolded(target, true);
    }

    private MindMapNode addNode(MindMapNode target, String nodeContent, String link) {
        MindMapNode node = this.controller.addNewNode(target, target.getChildCount(), target.isNewChildLeft());
        this.controller.setNodeText(node, nodeContent);
        this.controller.setLink(node, link);
        return node;
    }
}

