/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlighting;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingPresenter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingReconciler;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightings;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.IColorManagerExtension;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class SemanticHighlightingManager
implements IPropertyChangeListener {
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlightingReconciler fReconciler;
    private SemanticHighlighting[] fSemanticHighlightings;
    private Highlighting[] fHighlightings;
    private JavaEditor fEditor;
    private JavaSourceViewer fSourceViewer;
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private JavaScriptSourceViewerConfiguration fConfiguration;
    private JavaPresentationReconciler fPresentationReconciler;
    private HighlightedRange[][] fHardcodedRanges;

    public void install(JavaEditor editor, JavaSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fColorManager = colorManager;
        this.fPreferenceStore = preferenceStore;
        if (this.fEditor != null) {
            this.fConfiguration = editor.createJavaSourceViewerConfiguration();
            this.fPresentationReconciler = (JavaPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.fPreferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.isEnabled()) {
            this.enable();
        }
    }

    public void install(JavaSourceViewer sourceViewer, IColorManager colorManager, IPreferenceStore preferenceStore, HighlightedRange[][] hardcodedRanges) {
        this.fHardcodedRanges = hardcodedRanges;
        this.install(null, sourceViewer, colorManager, preferenceStore);
    }

    private void enable() {
        this.initializeHighlightings();
        this.fPresenter = new SemanticHighlightingPresenter();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = new SemanticHighlightingReconciler();
            this.fReconciler.install(this.fEditor, (ISourceViewer)this.fSourceViewer, this.fPresenter, this.fSemanticHighlightings, this.fHighlightings);
        } else {
            this.fPresenter.updatePresentation(null, this.createHardcodedPositions(), new HighlightedPosition[0]);
        }
    }

    private HighlightedPosition[] createHardcodedPositions() {
        ArrayList<HighlightedPosition> positions = new ArrayList<HighlightedPosition>();
        int i = 0;
        while (i < this.fHardcodedRanges.length) {
            HighlightedRange range = null;
            Highlighting hl = null;
            int j = 0;
            while (j < this.fHardcodedRanges[i].length) {
                hl = this.getHighlighting(this.fHardcodedRanges[i][j].getKey());
                if (hl.isEnabled()) {
                    range = this.fHardcodedRanges[i][j];
                    break;
                }
                ++j;
            }
            if (range != null) {
                positions.add(this.fPresenter.createHighlightedPosition(range.getOffset(), range.getLength(), hl));
            }
            ++i;
        }
        return positions.toArray(new HighlightedPosition[positions.size()]);
    }

    private Highlighting getHighlighting(String key) {
        int i = 0;
        while (i < this.fSemanticHighlightings.length) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            if (key.equals(semanticHighlighting.getPreferenceKey())) {
                return this.fHighlightings[i];
            }
            ++i;
        }
        return null;
    }

    public void uninstall() {
        this.disable();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferenceStore = null;
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fColorManager = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
        this.fHardcodedRanges = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
        if (this.fSemanticHighlightings != null) {
            this.disposeHighlightings();
        }
    }

    private boolean isEnabled() {
        return SemanticHighlightings.isEnabled(this.fPreferenceStore);
    }

    private void initializeHighlightings() {
        this.fSemanticHighlightings = SemanticHighlightings.getSemanticHighlightings();
        this.fHighlightings = new Highlighting[this.fSemanticHighlightings.length];
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            String underlineKey;
            String strikethroughKey;
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            this.addColor(colorKey);
            String boldKey = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
            int style = this.fPreferenceStore.getBoolean(boldKey) ? 1 : 0;
            String italicKey = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
            if (this.fPreferenceStore.getBoolean(italicKey)) {
                style |= 2;
            }
            if (this.fPreferenceStore.getBoolean(strikethroughKey = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting))) {
                style |= 0x20000000;
            }
            if (this.fPreferenceStore.getBoolean(underlineKey = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting))) {
                style |= 0x40000000;
            }
            boolean isEnabled = this.fPreferenceStore.getBoolean(SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting));
            this.fHighlightings[i] = new Highlighting(new TextAttribute(this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey)), null, style), isEnabled);
            ++i;
        }
    }

    private void disposeHighlightings() {
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            this.removeColor(SemanticHighlightings.getColorPreferenceKey(this.fSemanticHighlightings[i]));
            ++i;
        }
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.handlePropertyChangeEvent(event);
    }

    private void handlePropertyChangeEvent(PropertyChangeEvent event) {
        if (this.fPreferenceStore == null) {
            return;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration.handlePropertyChangeEvent(event);
        }
        if (SemanticHighlightings.affectsEnablement(this.fPreferenceStore, event)) {
            if (this.isEnabled()) {
                this.enable();
            } else {
                this.disable();
            }
        }
        if (!this.isEnabled()) {
            return;
        }
        boolean refreshNeeded = false;
        int i = 0;
        int n = this.fSemanticHighlightings.length;
        while (i < n) {
            SemanticHighlighting semanticHighlighting = this.fSemanticHighlightings[i];
            String colorKey = SemanticHighlightings.getColorPreferenceKey(semanticHighlighting);
            if (colorKey.equals(event.getProperty())) {
                this.adaptToTextForegroundChange(this.fHighlightings[i], event);
                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                refreshNeeded = true;
            } else {
                String boldKey = SemanticHighlightings.getBoldPreferenceKey(semanticHighlighting);
                if (boldKey.equals(event.getProperty())) {
                    this.adaptToTextStyleChange(this.fHighlightings[i], event, 1);
                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                    refreshNeeded = true;
                } else {
                    String italicKey = SemanticHighlightings.getItalicPreferenceKey(semanticHighlighting);
                    if (italicKey.equals(event.getProperty())) {
                        this.adaptToTextStyleChange(this.fHighlightings[i], event, 2);
                        this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                        refreshNeeded = true;
                    } else {
                        String strikethroughKey = SemanticHighlightings.getStrikethroughPreferenceKey(semanticHighlighting);
                        if (strikethroughKey.equals(event.getProperty())) {
                            this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x20000000);
                            this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                            refreshNeeded = true;
                        } else {
                            String underlineKey = SemanticHighlightings.getUnderlinePreferenceKey(semanticHighlighting);
                            if (underlineKey.equals(event.getProperty())) {
                                this.adaptToTextStyleChange(this.fHighlightings[i], event, 0x40000000);
                                this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                refreshNeeded = true;
                            } else {
                                String enabledKey = SemanticHighlightings.getEnabledPreferenceKey(semanticHighlighting);
                                if (enabledKey.equals(event.getProperty())) {
                                    this.adaptToEnablementChange(this.fHighlightings[i], event);
                                    this.fPresenter.highlightingStyleChanged(this.fHighlightings[i]);
                                    refreshNeeded = true;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (refreshNeeded && this.fReconciler != null) {
            this.fReconciler.refresh();
        }
    }

    private void adaptToEnablementChange(Highlighting highlighting, PropertyChangeEvent event) {
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(Highlighting highlighting, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if ((color == null || !rgb.equals((Object)color.getRGB())) && this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(property);
                ext.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = highlighting.getTextAttribute();
            highlighting.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(Highlighting highlighting, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = highlighting.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            highlighting.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)colorKey);
            if (this.fColorManager instanceof IColorManagerExtension) {
                IColorManagerExtension ext = (IColorManagerExtension)((Object)this.fColorManager);
                ext.unbindColor(colorKey);
                ext.bindColor(colorKey, rgb);
            }
        }
    }

    private void removeColor(String colorKey) {
        if (this.fColorManager instanceof IColorManagerExtension) {
            ((IColorManagerExtension)((Object)this.fColorManager)).unbindColor(colorKey);
        }
    }

    public SemanticHighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    static class HighlightedPosition
    extends Position {
        private Highlighting fStyle;
        private Object fLock;

        public HighlightedPosition(int offset, int length, Highlighting highlighting, Object lock) {
            super(offset, length);
            this.fStyle = highlighting;
            this.fLock = lock;
        }

        public StyleRange createStyleRange() {
            int len = 0;
            if (this.fStyle.isEnabled()) {
                len = this.getLength();
            }
            TextAttribute textAttribute = this.fStyle.getTextAttribute();
            int style = textAttribute.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(this.getOffset(), len, textAttribute.getForeground(), textAttribute.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            return styleRange;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEqual(int off, int len, Highlighting highlighting) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && this.getOffset() == off && this.getLength() == len && this.fStyle == highlighting;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContained(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                return !this.isDeleted() && off <= this.getOffset() && off + len >= this.getOffset() + this.getLength();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int off, int len) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(off);
                super.setLength(len);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLength(int length) {
            Object object = this.fLock;
            synchronized (object) {
                super.setLength(length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setOffset(int offset) {
            Object object = this.fLock;
            synchronized (object) {
                super.setOffset(offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            Object object = this.fLock;
            synchronized (object) {
                super.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void undelete() {
            Object object = this.fLock;
            synchronized (object) {
                super.undelete();
            }
        }

        public Highlighting getHighlighting() {
            return this.fStyle;
        }
    }

    public static class HighlightedRange
    extends Region {
        private String fKey;

        public HighlightedRange(int offset, int length, String key) {
            super(offset, length);
            this.fKey = key;
        }

        public String getKey() {
            return this.fKey;
        }

        public boolean equals(Object o) {
            return super.equals(o) && o instanceof HighlightedRange && this.fKey.equals(((HighlightedRange)((Object)o)).getKey());
        }

        public int hashCode() {
            return super.hashCode() | this.fKey.hashCode();
        }
    }

    static class Highlighting {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public Highlighting(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }
}

