/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

public class LostEventsMarkerEventSource
implements IMarkerEventSource {
    private static final @NonNull String LOST_EVENTS = (String)NonNullUtils.checkNotNull((Object)Messages.MarkerEvent_LostEvents);
    private static final RGBA COLOR = new RGBA(255, 0, 0, 50);
    private final @NonNull ITmfTrace fTrace;
    private long[] fLastRequest;
    private @NonNull List<@NonNull IMarkerEvent> fLastMarkers = Collections.emptyList();

    public LostEventsMarkerEventSource(@NonNull ITmfTrace trace) {
        this.fTrace = trace;
    }

    @Override
    public @NonNull List<@NonNull String> getMarkerCategories() {
        return Arrays.asList(LOST_EVENTS);
    }

    @Override
    public synchronized @NonNull List<@NonNull IMarkerEvent> getMarkerList(@NonNull String category, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        if (!category.equals(LOST_EVENTS)) {
            return Collections.emptyList();
        }
        ITmfStateSystem ss = this.getStateSystem();
        if (ss == null) {
            return Collections.emptyList();
        }
        int lostEventsQuark = LostEventsMarkerEventSource.getLostEventsQuark(ss);
        if (lostEventsQuark == -1) {
            return Collections.emptyList();
        }
        long[] request = new long[]{startTime, endTime, resolution, ss.getCurrentEndTime()};
        if (Arrays.equals(request, this.fLastRequest)) {
            return this.fLastMarkers;
        }
        ArrayList<@NonNull MarkerEvent> markers = new ArrayList<MarkerEvent>();
        try {
            long start = Math.max(startTime, ss.getStartTime());
            long end = Math.min(endTime, ss.getCurrentEndTime());
            if (start <= end) {
                start = Math.max(start - 1L, ss.getStartTime());
                long nextStartTime = ss.querySingleState(end, lostEventsQuark).getEndTime() + 1L;
                end = Math.min(nextStartTime, ss.getCurrentEndTime());
                List intervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ss, (int)lostEventsQuark, (long)start, (long)end, (long)resolution, (IProgressMonitor)monitor);
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                for (ITmfStateInterval interval : intervals) {
                    if (interval.getStateValue().isNull()) continue;
                    long lostEventsStartTime = interval.getStartTime();
                    long lostEventsEndTime = interval.getStateValue().unboxLong();
                    long duration = lostEventsEndTime - lostEventsStartTime;
                    MarkerEvent marker = new MarkerEvent(null, lostEventsStartTime, duration, LOST_EVENTS, COLOR, null, false);
                    markers.add(marker);
                }
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException throwable) {
            // empty catch block
        }
        this.fLastRequest = request;
        this.fLastMarkers = Collections.unmodifiableList(markers);
        return this.fLastMarkers;
    }

    private ITmfStateSystem getStateSystem() {
        TmfStatisticsModule module = (TmfStatisticsModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.fTrace, TmfStatisticsModule.class, (String)"org.eclipse.linuxtools.tmf.core.statistics.analysis");
        if (module == null) {
            return null;
        }
        return module.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
    }

    private static int getLostEventsQuark(ITmfStateSystem ss) {
        try {
            return ss.getQuarkAbsolute(new String[]{"lost_events"});
        }
        catch (AttributeNotFoundException e) {
            return -1;
        }
    }
}

