/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.ui.internal;

import java.nio.file.Paths;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.ui.internal.Activator;
import org.eclipse.cdt.cmake.ui.internal.Messages;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewCMakeToolChainFilePage
extends WizardPage {
    private Text pathText;
    private Combo tcCombo;
    private IToolChain[] toolchains;

    public NewCMakeToolChainFilePage() {
        super("NewCMakeToolChainFilePage", Messages.NewCMakeToolChainFilePage_Title, null);
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(2, false));
        Label pathLabel = new Label(comp, 0);
        pathLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathLabel.setText(Messages.NewCMakeToolChainFilePage_Path);
        Composite pathComp = new Composite(comp, 0);
        pathComp.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        pathComp.setLayout((Layout)layout);
        this.pathText = new Text(pathComp, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addModifyListener(e -> this.validate());
        Button pathButton = new Button(pathComp, 8);
        pathButton.setLayoutData((Object)new GridData(4, 4, false, false));
        pathButton.setText(Messages.NewCMakeToolChainFilePage_Browse);
        pathButton.addListener(13, e -> {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            dialog.setText(Messages.NewCMakeToolChainFilePage_Select);
            String path = dialog.open();
            if (path != null) {
                this.pathText.setText(path);
            }
        });
        Label tcLabel = new Label(comp, 0);
        tcLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        tcLabel.setText(Messages.NewCMakeToolChainFilePage_Toolchain);
        this.tcCombo = new Combo(comp, 8);
        this.tcCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            IToolChainManager tcManager = Activator.getService(IToolChainManager.class);
            IToolChain[] iToolChainArray = this.toolchains = tcManager.getAllToolChains().toArray(new IToolChain[0]);
            int n = this.toolchains.length;
            int n2 = 0;
            while (n2 < n) {
                IToolChain tc = iToolChainArray[n2];
                this.tcCombo.add(tc.getName());
                ++n2;
            }
            this.tcCombo.select(0);
        }
        catch (CoreException e2) {
            Activator.log(e2.getStatus());
        }
        this.setControl((Control)comp);
        this.validate();
    }

    private void validate() {
        this.setPageComplete(false);
        String path = this.pathText.getText();
        if (path.isEmpty()) {
            this.setErrorMessage(Messages.NewCMakeToolChainFilePage_NoPath);
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    public ICMakeToolChainFile getNewFile() {
        ICMakeToolChainManager manager = Activator.getService(ICMakeToolChainManager.class);
        ICMakeToolChainFile file = manager.newToolChainFile(Paths.get(this.pathText.getText(), new String[0]));
        IToolChain tc = this.toolchains[this.tcCombo.getSelectionIndex()];
        file.setProperty("cdt.toolChain.type", tc.getTypeId());
        file.setProperty("cdt.toolChain.id", tc.getId());
        return file;
    }
}

