/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutionTargetManager {
    public static final Topic<ExecutionTargetListener> TOPIC = Topic.create("ExecutionTarget topic", ExecutionTargetListener.class);

    @NotNull
    public static ExecutionTargetManager getInstance(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(0);
        }
        ExecutionTargetManager executionTargetManager = ServiceManager.getService(project, ExecutionTargetManager.class);
        if (executionTargetManager == null) {
            ExecutionTargetManager.$$$reportNull$$$0(1);
        }
        return executionTargetManager;
    }

    @NotNull
    public static ExecutionTarget getActiveTarget(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(2);
        }
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance(project).getActiveTarget();
        if (executionTarget == null) {
            ExecutionTargetManager.$$$reportNull$$$0(3);
        }
        return executionTarget;
    }

    public static void setActiveTarget(@NotNull Project project, @NotNull ExecutionTarget target) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(4);
        }
        if (target == null) {
            ExecutionTargetManager.$$$reportNull$$$0(5);
        }
        ExecutionTargetManager.getInstance(project).setActiveTarget(target);
    }

    @NotNull
    public static List<ExecutionTarget> getTargetsToChooseFor(@NotNull Project project, @Nullable RunConfiguration configuration) {
        List<ExecutionTarget> result;
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(6);
        }
        if ((result = ExecutionTargetManager.getInstance(project).getTargetsFor(configuration)).size() == 1 && DefaultExecutionTarget.INSTANCE.equals(result.get(0))) {
            List<ExecutionTarget> list = Collections.emptyList();
            if (list == null) {
                ExecutionTargetManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<ExecutionTarget> list = result;
        if (list == null) {
            ExecutionTargetManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Deprecated
    public static boolean canRun(@Nullable RunnerAndConfigurationSettings settings, @Nullable ExecutionTarget target) {
        return ExecutionTargetManager.canRun(settings != null ? settings.getConfiguration() : null, target);
    }

    public static boolean canRun(@Nullable RunConfiguration configuration, @Nullable ExecutionTarget target) {
        if (configuration == null || target == null) {
            return false;
        }
        return ExecutionTargetManager.getInstance(configuration.getProject()).doCanRun(configuration, target);
    }

    public static boolean canRun(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings settings;
        if (environment == null) {
            ExecutionTargetManager.$$$reportNull$$$0(9);
        }
        return (settings = environment.getRunnerAndConfigurationSettings()) != null && ExecutionTargetManager.canRun(settings.getConfiguration(), environment.getExecutionTarget());
    }

    protected abstract boolean doCanRun(@Nullable RunConfiguration var1, @NotNull ExecutionTarget var2);

    public static void update(@NotNull Project project) {
        if (project == null) {
            ExecutionTargetManager.$$$reportNull$$$0(10);
        }
        ExecutionTargetManager.getInstance(project).update();
    }

    @NotNull
    public abstract ExecutionTarget getActiveTarget();

    public abstract void setActiveTarget(@NotNull ExecutionTarget var1);

    @NotNull
    public abstract List<ExecutionTarget> getTargetsFor(@Nullable RunConfiguration var1);

    @Deprecated
    @NotNull
    public List<ExecutionTarget> getTargetsFor(@Nullable RunnerAndConfigurationSettings settings) {
        List<ExecutionTarget> list = this.getTargetsFor(settings == null ? null : settings.getConfiguration());
        if (list == null) {
            ExecutionTargetManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    public abstract void update();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionTargetManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionTargetManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTarget";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToChooseFor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActiveTarget";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setActiveTarget";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetsToChooseFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

