/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CheckUtil {
    private CheckUtil() {
    }

    public static void checkWritable(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CheckUtil.$$$reportNull$$$0(0);
        }
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                String url = ((PsiDirectory)element).getVirtualFile().getPresentableUrl();
                throw new IncorrectOperationException(PsiBundle.message((String)"cannot.modify.a.read.only.directory", (Object[])new Object[]{url}));
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{virtualFile.getPresentableUrl()}));
        }
    }

    public static void checkDelete(@NotNull VirtualFile file2) throws IncorrectOperationException {
        if (file2 == null) {
            CheckUtil.$$$reportNull$$$0(1);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS}){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (FileTypeRegistry.getInstance().isFileIgnored(file2)) {
                    return false;
                }
                if (!file2.isWritable()) {
                    throw new IncorrectOperationException(PsiBundle.message((String)"cannot.delete.a.read.only.file", (Object[])new Object[]{file2.getPresentableUrl()}));
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/CheckUtil$1", "visitFile"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/CheckUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkWritable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDelete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

