/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ClonableContentFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.ContentFolderBaseImpl;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementFactory;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.model.serialization.module.JpsModuleRootModelSerializer;

@ApiStatus.Internal
public class SourceFolderImpl
extends ContentFolderBaseImpl
implements SourceFolder,
ClonableContentFolder {
    private final JpsModuleSourceRoot myJpsElement;
    @NonNls
    public static final String ELEMENT_NAME = "sourceFolder";
    @NonNls
    public static final String TEST_SOURCE_ATTR = "isTestSource";
    static final String DEFAULT_PACKAGE_PREFIX = "";

    SourceFolderImpl(@NotNull VirtualFile file2, @NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        if (file2 == null) {
            SourceFolderImpl.$$$reportNull$$$0(0);
        }
        if (jpsElement == null) {
            SourceFolderImpl.$$$reportNull$$$0(1);
        }
        if (contentEntry == null) {
            SourceFolderImpl.$$$reportNull$$$0(2);
        }
        super(file2, contentEntry);
        this.myJpsElement = jpsElement;
    }

    public SourceFolderImpl(@NotNull JpsModuleSourceRoot jpsElement, @NotNull ContentEntryImpl contentEntry) {
        if (jpsElement == null) {
            SourceFolderImpl.$$$reportNull$$$0(3);
        }
        if (contentEntry == null) {
            SourceFolderImpl.$$$reportNull$$$0(4);
        }
        super(jpsElement.getUrl(), contentEntry);
        this.myJpsElement = jpsElement;
    }

    SourceFolderImpl(Element element, ContentEntryImpl contentEntry) throws InvalidDataException {
        super(element, contentEntry);
        this.myJpsElement = JpsModuleRootModelSerializer.loadSourceRoot((Element)element);
    }

    private SourceFolderImpl(SourceFolderImpl that, ContentEntryImpl contentEntry) {
        super(that, contentEntry);
        this.myJpsElement = SourceFolderImpl.createCopy(that, that.myJpsElement.asTyped());
    }

    private static <P extends JpsElement> JpsModuleSourceRoot createCopy(SourceFolderImpl that, JpsTypedModuleSourceRoot<P> jpsElement) {
        return JpsElementFactory.getInstance().createModuleSourceRoot(that.getUrl(), jpsElement.getRootType(), jpsElement.getProperties().getBulkModificationSupport().createCopy());
    }

    public boolean isTestSource() {
        return this.getRootType().isForTests();
    }

    @NotNull
    public String getPackagePrefix() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        if (properties != null) {
            String string = properties.getPackagePrefix();
            if (string == null) {
                SourceFolderImpl.$$$reportNull$$$0(5);
            }
            return string;
        }
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        if (resourceJavaProperties != null) {
            String string = resourceJavaProperties.getRelativeOutputPath().replace('/', '.');
            if (string == null) {
                SourceFolderImpl.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (DEFAULT_PACKAGE_PREFIX == null) {
            SourceFolderImpl.$$$reportNull$$$0(7);
        }
        return DEFAULT_PACKAGE_PREFIX;
    }

    @Nullable
    private JavaSourceRootProperties getJavaProperties() {
        return (JavaSourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
    }

    @Nullable
    private JavaResourceRootProperties getResourceJavaProperties() {
        return (JavaResourceRootProperties)this.myJpsElement.getProperties(JavaModuleSourceRootTypes.RESOURCES);
    }

    public void setPackagePrefix(@NotNull String packagePrefix) {
        JavaSourceRootProperties properties;
        if (packagePrefix == null) {
            SourceFolderImpl.$$$reportNull$$$0(8);
        }
        if ((properties = this.getJavaProperties()) != null) {
            properties.setPackagePrefix(packagePrefix);
        }
    }

    @NotNull
    public JpsModuleSourceRootType<?> getRootType() {
        JpsModuleSourceRootType jpsModuleSourceRootType = this.myJpsElement.getRootType();
        if (jpsModuleSourceRootType == null) {
            SourceFolderImpl.$$$reportNull$$$0(9);
        }
        return jpsModuleSourceRootType;
    }

    @Override
    @NotNull
    public ContentFolder cloneFolder(@NotNull ContentEntry contentEntry) {
        if (contentEntry == null) {
            SourceFolderImpl.$$$reportNull$$$0(10);
        }
        assert (!((ContentEntryImpl)contentEntry).isDisposed()) : "target entry already disposed: " + contentEntry;
        assert (!this.isDisposed()) : "Already disposed: " + this;
        SourceFolderImpl sourceFolderImpl = new SourceFolderImpl(this, (ContentEntryImpl)contentEntry);
        if (sourceFolderImpl == null) {
            SourceFolderImpl.$$$reportNull$$$0(11);
        }
        return sourceFolderImpl;
    }

    @NotNull
    public JpsModuleSourceRoot getJpsElement() {
        JpsModuleSourceRoot jpsModuleSourceRoot = this.myJpsElement;
        if (jpsModuleSourceRoot == null) {
            SourceFolderImpl.$$$reportNull$$$0(12);
        }
        return jpsModuleSourceRoot;
    }

    private boolean isForGeneratedSources() {
        JavaSourceRootProperties properties = this.getJavaProperties();
        JavaResourceRootProperties resourceJavaProperties = this.getResourceJavaProperties();
        return properties != null && properties.isForGeneratedSources() || resourceJavaProperties != null && resourceJavaProperties.isForGeneratedSources();
    }

    @Override
    public int compareTo(ContentFolderBaseImpl folder) {
        if (!(folder instanceof SourceFolderImpl)) {
            return -1;
        }
        int i = super.compareTo(folder);
        if (i != 0) {
            return i;
        }
        SourceFolderImpl sourceFolder = (SourceFolderImpl)folder;
        i = this.getPackagePrefix().compareTo(sourceFolder.getPackagePrefix());
        if (i != 0) {
            return i;
        }
        i = Boolean.compare(this.isTestSource(), sourceFolder.isTestSource());
        if (i != 0) {
            return i;
        }
        i = Boolean.compare(this.isForGeneratedSources(), sourceFolder.isForGeneratedSources());
        if (i != 0) {
            return i;
        }
        return this.myJpsElement.getRootType().getClass().getName().compareTo(sourceFolder.getRootType().getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jpsElement";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/SourceFolderImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packagePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/SourceFolderImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagePrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneFolder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJpsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPackagePrefix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneFolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

