/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebReferencesAnnotatorBase
extends ExternalAnnotator<MyInfo[], MyInfo[]> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.paths.WebReferencesAnnotatorBase");
    private final Map<String, MyFetchCacheEntry> myFetchCache = new HashMap<String, MyFetchCacheEntry>();
    private final Object myFetchCacheLock = new Object();
    private static final long FETCH_CACHE_TIMEOUT = 10000L;
    protected static final WebReference[] EMPTY_ARRAY = new WebReference[0];

    @NotNull
    protected abstract WebReference[] collectWebReferences(@NotNull PsiFile var1);

    @Nullable
    protected static WebReference lookForWebReference(@NotNull PsiElement element) {
        if (element == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(0);
        }
        return WebReferencesAnnotatorBase.lookForWebReference(Arrays.asList(element.getReferences()));
    }

    @Nullable
    private static WebReference lookForWebReference(Collection<PsiReference> references) {
        for (PsiReference reference2 : references) {
            WebReference webReference;
            if (reference2 instanceof WebReference) {
                return (WebReference)reference2;
            }
            if (!(reference2 instanceof PsiDynaReference) || (webReference = WebReferencesAnnotatorBase.lookForWebReference(((PsiDynaReference)reference2).getReferences())) == null) continue;
            return webReference;
        }
        return null;
    }

    public MyInfo[] collectInformation(@NotNull PsiFile file2) {
        if (file2 == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(1);
        }
        WebReference[] references = this.collectWebReferences(file2);
        MyInfo[] infos = new MyInfo[references.length];
        for (int i = 0; i < infos.length; ++i) {
            WebReference reference2 = references[i];
            infos[i] = new MyInfo(PsiAnchor.create(reference2.getElement()), reference2.getRangeInElement(), reference2.getValue());
        }
        return infos;
    }

    public MyInfo[] doAnnotate(MyInfo[] infos) {
        MyFetchResult[] fetchResults = new MyFetchResult[infos.length];
        for (int i = 0; i < fetchResults.length; ++i) {
            fetchResults[i] = this.checkUrl(infos[i].myUrl);
        }
        boolean containsAvailableHosts = false;
        for (MyFetchResult fetchResult : fetchResults) {
            if (fetchResult == MyFetchResult.UNKNOWN_HOST) continue;
            containsAvailableHosts = true;
            break;
        }
        for (int i = 0; i < fetchResults.length; ++i) {
            MyFetchResult result2 = fetchResults[i];
            if (result2 != MyFetchResult.OK && (containsAvailableHosts || result2 != MyFetchResult.UNKNOWN_HOST)) continue;
            infos[i].myResult = true;
        }
        return infos;
    }

    public void apply(@NotNull PsiFile file2, MyInfo[] infos, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(3);
        }
        if (infos == null || infos.length == 0) {
            return;
        }
        HighlightDisplayLevel displayLevel = this.getHighlightDisplayLevel((PsiElement)file2);
        for (MyInfo info : infos) {
            PsiElement element;
            if (info.myResult || (element = info.myAnchor.retrieve()) == null) continue;
            int start2 = element.getTextRange().getStartOffset();
            TextRange range2 = new TextRange(start2 + info.myRangeInElement.getStartOffset(), start2 + info.myRangeInElement.getEndOffset());
            String message = this.getErrorMessage(info.myUrl);
            Annotation annotation = displayLevel == HighlightDisplayLevel.ERROR ? holder.createErrorAnnotation(range2, message) : (displayLevel == HighlightDisplayLevel.WARNING ? holder.createWarningAnnotation(range2, message) : (displayLevel == HighlightDisplayLevel.WEAK_WARNING ? holder.createInfoAnnotation(range2, message) : holder.createWarningAnnotation(range2, message)));
            for (IntentionAction action2 : this.getQuickFixes()) {
                annotation.registerFix(action2);
            }
        }
    }

    @NotNull
    protected abstract String getErrorMessage(@NotNull String var1);

    @NotNull
    protected IntentionAction[] getQuickFixes() {
        if (IntentionAction.EMPTY_ARRAY == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(4);
        }
        return IntentionAction.EMPTY_ARRAY;
    }

    @NotNull
    protected abstract HighlightDisplayLevel getHighlightDisplayLevel(@NotNull PsiElement var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private MyFetchResult checkUrl(String url) {
        Object object = this.myFetchCacheLock;
        // MONITORENTER : object
        MyFetchCacheEntry entry = this.myFetchCache.get(url);
        long currentTime = System.currentTimeMillis();
        if (entry != null && currentTime - entry.getTime() < 10000L) {
            MyFetchResult myFetchResult = entry.getFetchResult();
            // MONITOREXIT : object
            if (myFetchResult != null) return myFetchResult;
            WebReferencesAnnotatorBase.$$$reportNull$$$0(5);
            return myFetchResult;
        }
        MyFetchResult fetchResult = WebReferencesAnnotatorBase.doCheckUrl(url);
        this.myFetchCache.put(url, new MyFetchCacheEntry(currentTime, fetchResult));
        MyFetchResult myFetchResult = fetchResult;
        // MONITOREXIT : object
        if (myFetchResult != null) return myFetchResult;
        WebReferencesAnnotatorBase.$$$reportNull$$$0(6);
        return myFetchResult;
    }

    private static MyFetchResult doCheckUrl(@NotNull String url) {
        if (url == null) {
            WebReferencesAnnotatorBase.$$$reportNull$$$0(7);
        }
        if (url.startsWith("mailto")) {
            return MyFetchResult.OK;
        }
        try {
            HttpRequests.request((String)url).connectTimeout(3000).readTimeout(3000).tryConnect();
        }
        catch (UnknownHostException e) {
            LOG.info((Throwable)e);
            return MyFetchResult.UNKNOWN_HOST;
        }
        catch (HttpRequests.HttpStatusException e) {
            LOG.info((Throwable)e);
            return MyFetchResult.NONEXISTENCE;
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.debug((Throwable)e);
        }
        return MyFetchResult.OK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/WebReferencesAnnotatorBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/WebReferencesAnnotatorBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "checkUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lookForWebReference";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCheckUrl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class MyInfo {
        final PsiAnchor myAnchor;
        final String myUrl;
        final TextRange myRangeInElement;
        volatile boolean myResult;

        private MyInfo(PsiAnchor anchor2, TextRange rangeInElement, String url) {
            this.myAnchor = anchor2;
            this.myRangeInElement = rangeInElement;
            this.myUrl = url;
        }
    }

    private static enum MyFetchResult {
        OK,
        UNKNOWN_HOST,
        NONEXISTENCE;

    }

    private static class MyFetchCacheEntry {
        private final long myTime;
        private final MyFetchResult myFetchResult;

        /*
         * WARNING - void declaration
         */
        private MyFetchCacheEntry(long time, @NotNull MyFetchResult myFetchResult) {
            void fetchResult;
            if (myFetchResult == null) {
                MyFetchCacheEntry.$$$reportNull$$$0(0);
            }
            this.myTime = time;
            this.myFetchResult = fetchResult;
        }

        public long getTime() {
            return this.myTime;
        }

        @NotNull
        public MyFetchResult getFetchResult() {
            MyFetchResult myFetchResult = this.myFetchResult;
            if (myFetchResult == null) {
                MyFetchCacheEntry.$$$reportNull$$$0(1);
            }
            return myFetchResult;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetchResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/paths/WebReferencesAnnotatorBase$MyFetchCacheEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/paths/WebReferencesAnnotatorBase$MyFetchCacheEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFetchResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

