/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageSchemaDescriptor;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsagesCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LazyInstance;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsageCounterCollector {
    private static final Logger LOG = Logger.getInstance((String)("#" + FileTypeUsageCounterCollector.class.getPackage().getName()));
    private static final ExtensionPointName<FileTypeUsageSchemaDescriptorEP<FileTypeUsageSchemaDescriptor>> EP = ExtensionPointName.create((String)"com.intellij.fileTypeUsageSchemaDescriptor");

    public static void triggerEdit(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(1);
        }
        FileTypeUsageCounterCollector.trigger(project, file2, "edit");
    }

    public static void triggerOpen(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(3);
        }
        FileTypeUsageCounterCollector.trigger(project, file2, "open");
    }

    private static void trigger(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String type) {
        if (project == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(5);
        }
        if (type == null) {
            FileTypeUsageCounterCollector.$$$reportNull$$$0(6);
        }
        FeatureUsageData data = new FeatureUsageData().addData("type", type);
        FileType fileType = file2.getFileType();
        for (FileTypeUsageSchemaDescriptorEP ext : EP.getExtensionList()) {
            FileTypeUsageSchemaDescriptor instance = (FileTypeUsageSchemaDescriptor)ext.getInstance();
            if (ext.schema == null) {
                LOG.warn("Extension " + ext.implementationClass + " should define a 'schema' attribute");
                continue;
            }
            if (!instance.describes(file2)) continue;
            data.addData("schema", StatisticsUtilKt.getPluginType(instance.getClass()).isSafeToReport() ? ext.schema : "third.party");
            break;
        }
        String id = FileTypeUsagesCollector.toReportedId(fileType, data);
        FUCounterUsageLogger.getInstance().logEvent(project, "file.types.usage", id, data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerEdit";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerOpen";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trigger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FileTypeUsageSchemaDescriptorEP<T>
    extends AbstractExtensionPointBean
    implements KeyedLazyInstance<T> {
        @Attribute(value="schema")
        public String schema;
        @Attribute(value="implementationClass")
        public String implementationClass;
        private final LazyInstance<T> myHandler = new LazyInstance<T>(){

            protected Class<T> getInstanceClass() throws ClassNotFoundException {
                return this.findClass(implementationClass);
            }
        };

        @NotNull
        public T getInstance() {
            Object object = this.myHandler.getValue();
            if (object == null) {
                FileTypeUsageSchemaDescriptorEP.$$$reportNull$$$0(0);
            }
            return (T)object;
        }

        public String getKey() {
            return this.schema;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsageCounterCollector$FileTypeUsageSchemaDescriptorEP", "getInstance"));
        }
    }
}

