/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.RatesPanel;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public class PluginManagerColumnInfo
extends ColumnInfo<IdeaPluginDescriptor, String> {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DOWNLOADS = 1;
    public static final int COLUMN_RATE = 2;
    public static final int COLUMN_DATE = 3;
    public static final int COLUMN_CATEGORY = 4;
    public static final String[] COLUMNS = new String[]{IdeBundle.message((String)"column.plugins.name", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.downloads", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.rate", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.date", (Object[])new Object[0]), IdeBundle.message((String)"column.plugins.category", (Object[])new Object[0])};
    private static final InstalledPluginsState ourState = InstalledPluginsState.getInstance();
    private final int columnIdx;
    private final PluginTableModel myModel;

    public PluginManagerColumnInfo(int columnIdx, PluginTableModel model2) {
        super(COLUMNS[columnIdx]);
        this.columnIdx = columnIdx;
        this.myModel = model2;
    }

    public String valueOf(IdeaPluginDescriptor base) {
        if (this.columnIdx == 0) {
            return base.getName();
        }
        if (this.columnIdx == 1) {
            return base instanceof PluginNode ? ((PluginNode)base).getDownloads() : null;
        }
        if (this.columnIdx == 3) {
            long date;
            long l = date = base instanceof PluginNode ? ((PluginNode)base).getDate() : 0L;
            if (date != 0L) {
                return DateFormatUtil.formatDate((long)date);
            }
            return IdeBundle.message((String)"plugin.info.not.available", (Object[])new Object[0]);
        }
        if (this.columnIdx == 4) {
            return base.getCategory();
        }
        if (this.columnIdx == 2) {
            return ((PluginNode)base).getRating();
        }
        return "";
    }

    protected boolean isSortByName() {
        return !this.isSortByDate() && !this.isSortByDownloads() && !this.isSortByStatus();
    }

    protected boolean isSortByDownloads() {
        return this.myModel.isSortByDownloads();
    }

    protected boolean isSortByDate() {
        return this.myModel.isSortByUpdated();
    }

    protected boolean isSortByStatus() {
        return this.myModel.isSortByStatus();
    }

    public static boolean isDownloaded(@NotNull PluginNode node) {
        if (node == null) {
            PluginManagerColumnInfo.$$$reportNull$$$0(0);
        }
        if (node.getStatus() == PluginNode.Status.DOWNLOADED) {
            return true;
        }
        PluginId pluginId = node.getPluginId();
        if (PluginManager.isPluginInstalled(pluginId)) {
            return false;
        }
        return ourState.wasInstalled(pluginId);
    }

    public Comparator<IdeaPluginDescriptor> getComparator() {
        Comparator<IdeaPluginDescriptor> comparator2 = this.getColumnComparator();
        if (this.isSortByStatus()) {
            RowSorter.SortKey defaultSortKey = this.myModel.getDefaultSortKey();
            int up = defaultSortKey != null && defaultSortKey.getSortOrder() == SortOrder.ASCENDING ? -1 : 1;
            return (o1, o2) -> {
                if (o1 instanceof PluginNode && o2 instanceof PluginNode) {
                    PluginNode.Status status1 = ((PluginNode)o1).getStatus();
                    PluginNode.Status status2 = ((PluginNode)o2).getStatus();
                    if (PluginManagerColumnInfo.isDownloaded((PluginNode)o1)) {
                        if (!PluginManagerColumnInfo.isDownloaded((PluginNode)o2)) {
                            return up;
                        }
                        return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                    }
                    if (PluginManagerColumnInfo.isDownloaded((PluginNode)o2)) {
                        return -up;
                    }
                    if (status1 == PluginNode.Status.DELETED) {
                        if (status2 != PluginNode.Status.DELETED) {
                            return up;
                        }
                        return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                    }
                    if (status2 == PluginNode.Status.DELETED) {
                        return -up;
                    }
                    if (status1 == PluginNode.Status.INSTALLED) {
                        boolean hasNewerVersion2;
                        if (status2 != PluginNode.Status.INSTALLED) {
                            return up;
                        }
                        boolean hasNewerVersion1 = ourState.hasNewerVersion(o1.getPluginId());
                        if (hasNewerVersion1 != (hasNewerVersion2 = ourState.hasNewerVersion(o2.getPluginId()))) {
                            if (hasNewerVersion1) {
                                return up;
                            }
                            return -up;
                        }
                        return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
                    }
                    if (status2 == PluginNode.Status.INSTALLED) {
                        return -up;
                    }
                }
                return comparator2.compare((IdeaPluginDescriptor)o1, (IdeaPluginDescriptor)o2);
            };
        }
        return comparator2;
    }

    protected Comparator<IdeaPluginDescriptor> getColumnComparator() {
        return (o1, o2) -> {
            if (this.myModel.isSortByRating()) {
                String rating1 = ((PluginNode)o1).getRating();
                String rating2 = ((PluginNode)o2).getRating();
                int compare = Comparing.compare((Comparable)((Object)rating2), (Comparable)((Object)rating1));
                if (compare != 0) {
                    return compare;
                }
            }
            if (this.isSortByDate()) {
                long date2;
                long date1 = o1 instanceof PluginNode ? ((PluginNode)o1).getDate() : 0L;
                long l = date2 = o2 instanceof PluginNode ? ((PluginNode)o2).getDate() : 0L;
                if ((date2 /= 60000L) != (date1 /= 60000L)) {
                    return date2 - date1 > 0L ? 1 : -1;
                }
            }
            if (this.isSortByDownloads()) {
                String d1 = o1 instanceof PluginNode ? ((PluginNode)o1).getDownloads() : null;
                String d2 = o2 instanceof PluginNode ? ((PluginNode)o2).getDownloads() : null;
                Long count1 = d1 == null ? 0L : Long.valueOf(d1);
                Long count2 = d2 == null ? 0L : Long.valueOf(d2);
                int result2 = count2.compareTo(count1);
                if (result2 != 0) {
                    return result2;
                }
            }
            return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
        };
    }

    public static String getFormattedSize(String size) {
        if (size.equals("-1")) {
            return IdeBundle.message((String)"plugin.info.unknown", (Object[])new Object[0]);
        }
        return StringUtil.formatFileSize((long)Long.parseLong(size));
    }

    public Class getColumnClass() {
        return this.columnIdx == 1 ? Integer.class : String.class;
    }

    public TableCellRenderer getRenderer(IdeaPluginDescriptor o) {
        return this.columnIdx == 2 ? new PluginRateTableCellRenderer() : new PluginTableCellRenderer((PluginNode)o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ide/plugins/PluginManagerColumnInfo", "isDownloaded"));
    }

    private static class PluginTableCellRenderer
    extends DefaultTableCellRenderer {
        private final JLabel myLabel = new JLabel();
        private final PluginNode myPluginNode;

        private PluginTableCellRenderer(PluginNode pluginNode) {
            this.myLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
            this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.myPluginNode = pluginNode;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component orig = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color bg = orig.getBackground();
            Object grayedFg = isSelected ? orig.getForeground() : JBColor.GRAY;
            this.myLabel.setForeground((Color)grayedFg);
            this.myLabel.setBackground(bg);
            this.myLabel.setOpaque(true);
            if (column == 3) {
                long date = this.myPluginNode.getDate();
                this.myLabel.setText(date != 0L && date != Long.MAX_VALUE ? DateFormatUtil.formatDate((long)date) : "n/a");
                this.myLabel.setHorizontalAlignment(4);
            } else if (column == 1) {
                String downloads = this.myPluginNode.getDownloads();
                this.myLabel.setText(!StringUtil.isEmpty((String)downloads) ? downloads : "n/a");
                this.myLabel.setHorizontalAlignment(4);
            } else if (column == 4) {
                String category = this.myPluginNode.getCategory();
                if (StringUtil.isEmpty((String)category)) {
                    category = this.myPluginNode.getRepositoryName();
                }
                this.myLabel.setText(!StringUtil.isEmpty((String)category) ? category : "n/a");
            }
            if (this.myPluginNode.getStatus() == PluginNode.Status.INSTALLED) {
                PluginId pluginId = this.myPluginNode.getPluginId();
                boolean hasNewerVersion = ourState.hasNewerVersion(pluginId);
                if (hasNewerVersion && !isSelected) {
                    this.myLabel.setBackground(LightColors.BLUE);
                }
            }
            return this.myLabel;
        }
    }

    private static class PluginRateTableCellRenderer
    extends DefaultTableCellRenderer {
        private final RatesPanel myPanel = new RatesPanel();

        private PluginRateTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component orig = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.myPanel.setBackground(orig.getBackground());
            if (value != null) {
                this.myPanel.setRate((String)value);
            }
            return this.myPanel;
        }
    }
}

