/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.create;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateResourceBundleDialogComponent {
    private static final Logger LOG = Logger.getInstance(CreateResourceBundleDialogComponent.class);
    private static final Comparator<Locale> LOCALE_COMPARATOR = (l1, l2) -> {
        if (l1 == PropertiesUtil.DEFAULT_LOCALE) {
            return -1;
        }
        if (l2 == PropertiesUtil.DEFAULT_LOCALE) {
            return 1;
        }
        return l1.toString().compareTo(l2.toString());
    };
    private final Project myProject;
    private final PsiDirectory myDirectory;
    private final ResourceBundle myResourceBundle;
    private JPanel myPanel;
    private JTextField myResourceBundleBaseNameTextField;
    private JButton myAddLocaleFromExistButton;
    private JPanel myNewBundleLocalesPanel;
    private JPanel myProjectExistLocalesPanel;
    private JButton myAddAllButton;
    private JPanel myResourceBundleNamePanel;
    private JCheckBox myUseXMLBasedPropertiesCheckBox;
    private CollectionListModel<Locale> myLocalesModel;
    private final Map<Locale, String> myLocaleSuffixes;

    public CreateResourceBundleDialogComponent(@NotNull Project project, PsiDirectory directory, ResourceBundle resourceBundle) {
        if (project == null) {
            CreateResourceBundleDialogComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDirectory = directory;
        this.myResourceBundle = resourceBundle;
        this.$$$setupUI$$$();
        this.myLocaleSuffixes = new THashMap();
        if (resourceBundle != null) {
            this.myResourceBundleNamePanel.setVisible(false);
            this.myUseXMLBasedPropertiesCheckBox.setVisible(false);
        } else {
            final String checkBoxSelectedStateKey = this.getClass() + ".useXmlPropertiesFiles";
            this.myUseXMLBasedPropertiesCheckBox.setSelected(PropertiesComponent.getInstance().getBoolean(checkBoxSelectedStateKey));
            this.myUseXMLBasedPropertiesCheckBox.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    PropertiesComponent.getInstance().setValue(checkBoxSelectedStateKey, CreateResourceBundleDialogComponent.this.myUseXMLBasedPropertiesCheckBox.isSelected());
                }
            });
        }
    }

    private List<PsiFile> createPropertiesFiles() {
        Set<String> fileNames = this.getFileNamesToCreate();
        List createdFiles = (List)WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> (List)ReadAction.compute(() -> ContainerUtil.map((Collection)fileNames, n -> {
            boolean isXml;
            boolean bl = isXml = this.myResourceBundle == null ? this.myUseXMLBasedPropertiesCheckBox.isSelected() : this.myResourceBundle.getDefaultPropertiesFile() instanceof XmlPropertiesFile;
            if (isXml) {
                FileTemplate template = FileTemplateManager.getInstance((Project)this.myProject).getInternalTemplate("XML Properties File.xml");
                LOG.assertTrue(template != null);
                try {
                    return (PsiFile)FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)n, null, (PsiDirectory)this.myDirectory);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.myDirectory.createFile(n);
        })));
        this.combineToResourceBundleIfNeeded(createdFiles);
        return createdFiles;
    }

    @NotNull
    private Set<String> getFileNamesToCreate() {
        String name = this.getBaseName();
        String suffix = this.getPropertiesFileSuffix();
        Set set = ContainerUtil.map2Set((Collection)this.myLocalesModel.getItems(), locale -> name + (locale == PropertiesUtil.DEFAULT_LOCALE ? "" : "_" + this.myLocaleSuffixes.getOrDefault(locale, locale.toString())) + suffix);
        if (set == null) {
            CreateResourceBundleDialogComponent.$$$reportNull$$$0(1);
        }
        return set;
    }

    private void combineToResourceBundleIfNeeded(Collection<PsiFile> files) {
        List createdFiles = ContainerUtil.map(files, (Function)((NotNullFunction)dom -> {
            PropertiesFile file = PropertiesImplUtil.getPropertiesFile(dom);
            LOG.assertTrue(file != null, (Object)dom.getName());
            return file;
        }));
        ResourceBundle mainBundle = this.myResourceBundle;
        HashSet<ResourceBundle> allBundles = new HashSet<ResourceBundle>();
        if (mainBundle != null) {
            allBundles.add(mainBundle);
        }
        boolean needCombining = false;
        for (PropertiesFile file : createdFiles) {
            ResourceBundle rb = file.getResourceBundle();
            if (mainBundle == null) {
                mainBundle = rb;
            } else if (!mainBundle.equals(rb)) {
                needCombining = true;
            }
            allBundles.add(rb);
        }
        if (needCombining) {
            ArrayList<PropertiesFile> toCombine = new ArrayList<PropertiesFile>(createdFiles);
            String baseName = this.getBaseName();
            if (this.myResourceBundle != null) {
                toCombine.addAll(this.myResourceBundle.getPropertiesFiles());
            }
            ResourceBundleManager manager = ResourceBundleManager.getInstance(mainBundle.getProject());
            for (ResourceBundle bundle : allBundles) {
                manager.dissociateResourceBundle(bundle);
            }
            manager.combineToResourceBundle(toCombine, baseName);
        }
    }

    private String getBaseName() {
        return this.myResourceBundle == null ? this.myResourceBundleBaseNameTextField.getText() : this.myResourceBundle.getBaseName();
    }

    private String canCreateAllFilesForAllLocales() {
        String name = this.getBaseName();
        if (name.isEmpty()) {
            return "Base name is empty";
        }
        Set<String> files = this.getFileNamesToCreate();
        if (files.isEmpty()) {
            return "No locales added";
        }
        for (PsiElement element : this.myDirectory.getChildren()) {
            PropertiesFile propertiesFile;
            String propertiesFileName;
            if (!(element instanceof PsiFile) || !(element instanceof PropertiesFile) || !files.contains(propertiesFileName = (propertiesFile = (PropertiesFile)element).getName())) continue;
            return "Some of files already exist";
        }
        return null;
    }

    private String getPropertiesFileSuffix() {
        if (this.myResourceBundle == null) {
            return this.myUseXMLBasedPropertiesCheckBox.isSelected() ? ".xml" : ".properties";
        }
        return "." + this.myResourceBundle.getDefaultPropertiesFile().getContainingFile().getFileType().getDefaultExtension();
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    @Nullable
    private static Map<Locale, String> extractLocalesFromString(String rawLocales) {
        if (rawLocales.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] splitRawLocales = rawLocales.split(",");
        THashMap locales = new THashMap(splitRawLocales.length);
        for (String rawLocale : splitRawLocales) {
            Pair<Locale, String> localeAndSuffix = PropertiesUtil.getLocaleAndTrimmedSuffix("_" + rawLocale + ".properties");
            if (localeAndSuffix.getFirst() == PropertiesUtil.DEFAULT_LOCALE) {
                return null;
            }
            locales.putIfAbsent(localeAndSuffix.getFirst(), localeAndSuffix.getSecond());
        }
        return locales;
    }

    private void createUIComponents() {
        List restrictedLocales;
        List<Object> locales;
        final JBList projectExistLocalesList = new JBList();
        final MyExistLocalesListModel existLocalesListModel = new MyExistLocalesListModel();
        projectExistLocalesList.setModel((ListModel)existLocalesListModel);
        projectExistLocalesList.setCellRenderer(this.getLocaleRenderer());
        this.myProjectExistLocalesPanel = ToolbarDecorator.createDecorator((JList)projectExistLocalesList).disableRemoveAction().disableUpDownActions().createPanel();
        this.myProjectExistLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Project locales", (boolean)false));
        final JBList localesToAddList = new JBList();
        if (this.myResourceBundle == null) {
            locales = Collections.singletonList(PropertiesUtil.DEFAULT_LOCALE);
            restrictedLocales = Collections.emptyList();
        } else {
            locales = Collections.emptyList();
            restrictedLocales = ContainerUtil.map(this.myResourceBundle.getPropertiesFiles(), PropertiesFile::getLocale);
        }
        this.myLocalesModel = new CollectionListModel<Locale>(locales){

            public void add(@NotNull List<? extends Locale> elements) {
                if (elements == null) {
                    2.$$$reportNull$$$0(0);
                }
                List currentItems = this.getItems();
                elements = ContainerUtil.filter(elements, locale -> !restrictedLocales.contains(locale) && !currentItems.contains(locale));
                super.add(elements);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$2", "add"));
            }
        };
        localesToAddList.setModel(this.myLocalesModel);
        localesToAddList.setCellRenderer(this.getLocaleRenderer());
        localesToAddList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                projectExistLocalesList.clearSelection();
            }
        });
        projectExistLocalesList.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                localesToAddList.clearSelection();
            }
        });
        this.myNewBundleLocalesPanel = ToolbarDecorator.createDecorator((JList)localesToAddList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                String rawAddedLocales = Messages.showInputDialog((Project)CreateResourceBundleDialogComponent.this.myProject, (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.message", new Object[0]), (String)PropertiesBundle.message("create.resource.bundle.dialog.add.locales.validator.title", new Object[0]), null, null, (InputValidator)new InputValidatorEx(){

                    @Nullable
                    public String getErrorText(String inputString) {
                        return this.checkInput(inputString) ? null : "Invalid locales";
                    }

                    public boolean checkInput(String inputString) {
                        return CreateResourceBundleDialogComponent.extractLocalesFromString(inputString) != null;
                    }

                    public boolean canClose(String inputString) {
                        return this.checkInput(inputString);
                    }
                });
                if (rawAddedLocales != null) {
                    Map locales = CreateResourceBundleDialogComponent.extractLocalesFromString(rawAddedLocales);
                    LOG.assertTrue(locales != null);
                    CreateResourceBundleDialogComponent.this.myLocaleSuffixes.putAll(locales);
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(new ArrayList(locales.keySet()));
                }
            }
        }).setAddActionName("Add locales by suffix").disableUpDownActions().createPanel();
        this.myNewBundleLocalesPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Locales to add", (boolean)false));
        this.myAddLocaleFromExistButton = new JButton(AllIcons.Actions.Forward);
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(ContainerUtil.map((Object[])projectExistLocalesList.getSelectedValues(), o -> (Locale)o));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$6", "onClick"));
            }
        }.installOn((Component)this.myAddLocaleFromExistButton);
        projectExistLocalesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                List currentItems = CreateResourceBundleDialogComponent.this.myLocalesModel.getItems();
                for (Object o : projectExistLocalesList.getSelectedValues()) {
                    Locale l = (Locale)o;
                    if (restrictedLocales.contains(l) || currentItems.contains(l)) continue;
                    CreateResourceBundleDialogComponent.this.myAddLocaleFromExistButton.setEnabled(true);
                    return;
                }
                CreateResourceBundleDialogComponent.this.myAddLocaleFromExistButton.setEnabled(false);
            }
        });
        this.myAddLocaleFromExistButton.setEnabled(false);
        this.myAddAllButton = new JButton("Add All");
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    8.$$$reportNull$$$0(0);
                }
                if (clickCount == 1) {
                    CreateResourceBundleDialogComponent.this.myLocalesModel.add(existLocalesListModel.getLocales());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$8", "onClick"));
            }
        }.installOn((Component)this.myAddAllButton);
    }

    @NotNull
    private ColoredListCellRenderer<Locale> getLocaleRenderer() {
        ColoredListCellRenderer<Locale> coloredListCellRenderer = new ColoredListCellRenderer<Locale>(){

            protected void customizeCellRenderer(@NotNull JList list, Locale locale, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    9.$$$reportNull$$$0(0);
                }
                if (PropertiesUtil.DEFAULT_LOCALE == locale) {
                    this.append("Default locale");
                } else {
                    this.append(CreateResourceBundleDialogComponent.this.myLocaleSuffixes.getOrDefault(locale, locale.toString()));
                    this.append(PropertiesUtil.getPresentableLocale(locale), SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$9", "customizeCellRenderer"));
            }
        };
        if (coloredListCellRenderer == null) {
            CreateResourceBundleDialogComponent.$$$reportNull$$$0(2);
        }
        return coloredListCellRenderer;
    }

    @Nullable
    static PsiDirectory getResourceBundlePlacementDirectory(ResourceBundle resourceBundle) {
        PsiDirectory containingDirectory = null;
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (containingDirectory == null) {
                containingDirectory = propertiesFile.getContainingFile().getContainingDirectory();
                continue;
            }
            if (containingDirectory.isEquivalentTo((PsiElement)propertiesFile.getContainingFile().getContainingDirectory())) continue;
            return null;
        }
        LOG.assertTrue(containingDirectory != null);
        return containingDirectory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNamesToCreate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myResourceBundleNamePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "North");
        this.myResourceBundleBaseNameTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Resource bundle base name:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUseXMLBasedPropertiesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use XML-based properties files");
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, "Center");
        JButton jButton = this.myAddLocaleFromExistButton;
        jButton.setFocusable(false);
        jButton.setText("");
        jPanel3.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = this.myNewBundleLocalesPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 2, 2, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = this.myProjectExistLocalesPanel;
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 0, 2, 1, 0, 3, 3, 3, null, null, null));
        JButton jButton2 = this.myAddAllButton;
        jButton2.setFocusable(false);
        jButton2.setText("Add All");
        jPanel3.add((Component)jButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyExistLocalesListModel
    extends AbstractListModel {
        private final List<Locale> myLocales = new ArrayList<Locale>();

        private MyExistLocalesListModel() {
            this.myLocales.add(PropertiesUtil.DEFAULT_LOCALE);
            PropertiesReferenceManager.getInstance(CreateResourceBundleDialogComponent.this.myProject).processPropertiesFiles(GlobalSearchScope.projectScope((Project)CreateResourceBundleDialogComponent.this.myProject), (baseName, propertiesFile) -> {
                Locale locale = propertiesFile.getLocale();
                if (locale != PropertiesUtil.DEFAULT_LOCALE && !this.myLocales.contains(locale)) {
                    this.myLocales.add(locale);
                }
                return true;
            }, BundleNameEvaluator.DEFAULT);
            Collections.sort(this.myLocales, LOCALE_COMPARATOR);
        }

        @Override
        public int getSize() {
            return this.myLocales.size();
        }

        @Override
        public Locale getElementAt(int index) {
            return this.myLocales.get(index);
        }

        public List<Locale> getLocales() {
            return this.myLocales;
        }
    }

    public static class Dialog
    extends DialogWrapper {
        @NotNull
        private final Project myProject;
        @NotNull
        private final PsiDirectory myDirectory;
        private final CreateResourceBundleDialogComponent myComponent;
        private PsiElement[] myCreatedFiles;

        protected Dialog(@NotNull Project project, @Nullable PsiDirectory directory, @Nullable ResourceBundle resourceBundle) {
            if (project == null) {
                Dialog.$$$reportNull$$$0(0);
            }
            super(project);
            if (directory == null) {
                LOG.assertTrue(resourceBundle != null && CreateResourceBundleDialogComponent.getResourceBundlePlacementDirectory(resourceBundle) != null);
            }
            this.myProject = project;
            this.myDirectory = directory == null ? resourceBundle.getDefaultPropertiesFile().getContainingFile().getContainingDirectory() : directory;
            this.myComponent = new CreateResourceBundleDialogComponent(this.myProject, this.myDirectory, resourceBundle);
            this.init();
            this.initValidation();
            this.setTitle(resourceBundle == null ? "Create Resource Bundle" : "Add Locales to Resource Bundle " + resourceBundle.getBaseName());
        }

        protected void doOKAction() {
            String errorString = this.myComponent.canCreateAllFilesForAllLocales();
            if (errorString != null) {
                Messages.showErrorDialog((Component)this.getContentPanel(), (String)errorString);
            } else {
                List createFiles = this.myComponent.createPropertiesFiles();
                this.myCreatedFiles = createFiles.toArray(PsiElement.EMPTY_ARRAY);
                super.doOKAction();
            }
        }

        @Nullable
        protected ValidationInfo doValidate() {
            for (String fileName : this.myComponent.getFileNamesToCreate()) {
                if (!PathUtil.isValidFileName((String)fileName)) {
                    return new ValidationInfo(String.format("File name for properties file '%s' is invalid", fileName));
                }
                if (this.myDirectory.findFile(fileName) == null) continue;
                return new ValidationInfo(String.format("File with name '%s' already exist", fileName));
            }
            return null;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myComponent.getPanel();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myComponent.myResourceBundleBaseNameTextField;
        }

        public PsiElement[] getCreatedFiles() {
            return this.myCreatedFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/properties/create/CreateResourceBundleDialogComponent$Dialog", "<init>"));
        }
    }
}

