/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.remote;

import com.intellij.json.JsonFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRemoteContentProvider
extends DefaultRemoteContentProvider {
    private static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    private static final long UPDATE_DELAY = Duration.ofHours(4L).toMillis();
    static final String STORE_URL_PREFIX_HTTP = "http://json.schemastore.org";
    static final String STORE_URL_PREFIX_HTTPS = "https://schemastore.azurewebsites.net";
    private static final String SCHEMA_URL_PREFIX = "http://json-schema.org/";
    private static final String ETAG_HEADER = "ETag";
    private static final String LAST_MODIFIED_HEADER = "Last-Modified";
    private long myLastUpdateTime = 0L;

    public boolean canProvideContent(@NotNull Url url) {
        String externalForm;
        if (url == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(0);
        }
        return (externalForm = url.toExternalForm()).startsWith(STORE_URL_PREFIX_HTTP) || externalForm.startsWith(STORE_URL_PREFIX_HTTPS) || externalForm.startsWith(SCHEMA_URL_PREFIX) || externalForm.endsWith(".json");
    }

    protected void saveAdditionalData(@NotNull HttpRequests.Request request, @NotNull File file) throws IOException {
        URLConnection connection;
        if (request == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(2);
        }
        if (JsonSchemaRemoteContentProvider.saveTag(file, connection = request.getConnection(), ETAG_HEADER)) {
            return;
        }
        JsonSchemaRemoteContentProvider.saveTag(file, connection, LAST_MODIFIED_HEADER);
    }

    @Nullable
    protected FileType adjustFileType(@Nullable FileType type, @NotNull Url url) {
        if (url == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(3);
        }
        if (type == null && url.toExternalForm().startsWith(SCHEMA_URL_PREFIX)) {
            return JsonFileType.INSTANCE;
        }
        return super.adjustFileType(type, url);
    }

    private static boolean saveTag(@NotNull File file, @NotNull URLConnection connection, @NotNull String header) throws IOException {
        String tag;
        if (file == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(4);
        }
        if (connection == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(5);
        }
        if (header == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(6);
        }
        if ((tag = connection.getHeaderField(header)) != null) {
            String path = file.getAbsolutePath();
            if (!path.endsWith(".json")) {
                path = path + ".json";
            }
            File tagFile = new File(path + "." + header);
            JsonSchemaRemoteContentProvider.saveToFile(tagFile, tag);
            return true;
        }
        return false;
    }

    private static void saveToFile(@NotNull File tagFile, @NotNull String headerValue) throws IOException {
        if (tagFile == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(7);
        }
        if (headerValue == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(8);
        }
        if (!tagFile.exists() && !tagFile.createNewFile()) {
            return;
        }
        Files.write(tagFile.toPath(), (Iterable<? extends CharSequence>)ContainerUtil.createMaybeSingletonList((Object)headerValue), new OpenOption[0]);
    }

    public boolean isUpToDate(@NotNull Url url, @NotNull VirtualFile local) {
        long now;
        if (url == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(9);
        }
        if (local == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(10);
        }
        if ((now = System.currentTimeMillis()) - this.myLastUpdateTime < UPDATE_DELAY) {
            return true;
        }
        this.myLastUpdateTime = now;
        String path = local.getPath();
        if (now - new File(path).lastModified() < UPDATE_DELAY) {
            return true;
        }
        if (this.checkUpToDate(url, path, ETAG_HEADER)) {
            return true;
        }
        return this.checkUpToDate(url, path, LAST_MODIFIED_HEADER);
    }

    private boolean checkUpToDate(@NotNull Url url, @NotNull String path, @NotNull String header) {
        if (url == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(11);
        }
        if (path == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(12);
        }
        if (header == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(13);
        }
        File file = new File(path + "." + header);
        try {
            return this.isUpToDate(url, file, header);
        }
        catch (IOException e) {
            new File(path).setLastModified(System.currentTimeMillis());
            return true;
        }
    }

    protected int getDefaultConnectionTimeout() {
        return 10000;
    }

    private boolean isUpToDate(@NotNull Url url, @NotNull File file, @NotNull String header) throws IOException {
        String currentTag;
        if (url == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(15);
        }
        if (header == null) {
            JsonSchemaRemoteContentProvider.$$$reportNull$$$0(16);
        }
        List<String> strings = file.exists() ? Files.readAllLines(file.toPath()) : ContainerUtil.emptyList();
        String string = currentTag = strings.size() > 0 ? strings.get(0) : null;
        if (currentTag == null) {
            return false;
        }
        String remoteTag = (String)this.connect(url, HttpRequests.head((String)url.toExternalForm()), r -> r.getConnection().getHeaderField(header));
        return currentTag.equals(remoteTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: 
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 6: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/remote/JsonSchemaRemoteContentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canProvideContent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "saveAdditionalData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustFileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "saveTag";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "saveToFile";
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpToDate";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkUpToDate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

