/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectRootManager myProjectManager;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final List<VcsRootChecker> myCheckers;
    @Nullable
    private Collection<VcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK;

    public VcsRootDetectorImpl(@NotNull Project project, @NotNull ProjectRootManager projectRootManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(0);
        }
        if (projectRootManager == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(1);
        }
        if (projectLevelVcsManager == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(2);
        }
        this.LOCK = new Object();
        this.myProject = project;
        this.myProjectManager = projectRootManager;
        this.myVcsManager = projectLevelVcsManager;
        this.myCheckers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> detect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        Collection<VcsRoot> collection = this.myDetectedRoots = this.detect(this.myProject.getBaseDir());
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(3);
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        Collection<VcsRoot> collection = this.doDetect(startDir);
        if (collection == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private Collection<VcsRoot> doDetect(@Nullable VirtualFile startDir) {
        VcsRoot rootAbove;
        if (startDir == null || this.myCheckers.size() == 0) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        Set<VcsRoot> roots = this.scanForRootsInsideDir(startDir);
        if (VcsRootDetectorImpl.shouldScanAbove(startDir, roots) && (rootAbove = this.scanForSingleRootAboveDir(startDir)) != null) {
            roots.add(rootAbove);
        }
        roots.addAll(this.scanForRootsInContentRoots());
        Set<VcsRoot> set = Collections.unmodifiableSet(roots);
        if (set == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myDetectedRoots == null) {
            this.detect();
        }
        Collection<VcsRoot> collection = this.myDetectedRoots;
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(7);
        return collection;
    }

    @NotNull
    private Set<VcsRoot> scanForRootsInContentRoots() {
        HashSet<VcsRoot> vcsRoots = new HashSet<VcsRoot>();
        if (this.myProject.isDisposed()) {
            HashSet<VcsRoot> hashSet = vcsRoots;
            if (hashSet == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(8);
            }
            return hashSet;
        }
        for (VirtualFile contentRoot : this.myProjectManager.getContentRoots()) {
            VcsRoot rootAbove;
            if (this.myProject.getBaseDir() != null && VfsUtilCore.isAncestor((VirtualFile)this.myProject.getBaseDir(), (VirtualFile)contentRoot, (boolean)false)) continue;
            Set<VcsRoot> vcsRootsInContentRoot = this.scanForRootsInsideDir(contentRoot);
            if (VcsRootDetectorImpl.shouldScanAbove(contentRoot, vcsRootsInContentRoot) && (rootAbove = this.scanForSingleRootAboveDir(contentRoot)) != null) {
                vcsRootsInContentRoot.add(rootAbove);
            }
            vcsRoots.addAll(vcsRootsInContentRoot);
        }
        HashSet<VcsRoot> hashSet = vcsRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile root) {
        if (root == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(10);
        }
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, this.myProjectManager, root, dir -> {
            if (Registry.is((String)"vcs.root.detector.skip.vendor") && dir.getName().equalsIgnoreCase("vendor")) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            AbstractVcs vcs = this.getVcsFor((VirtualFile)dir);
            if (vcs != null) {
                LOG.debug("Found VCS " + vcs + " in " + dir);
                roots.add(new VcsRoot(vcs, dir));
            }
            return VirtualFileVisitor.CONTINUE;
        });
        return roots;
    }

    private static boolean shouldScanAbove(@NotNull VirtualFile startDir, @NotNull Set<? extends VcsRoot> rootsInsideDir) {
        if (startDir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(11);
        }
        if (rootsInsideDir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(12);
        }
        return rootsInsideDir.stream().noneMatch(it -> startDir.equals(it.getPath()));
    }

    @Nullable
    private VcsRoot scanForSingleRootAboveDir(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(13);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ProgressManager.checkCanceled();
        for (VirtualFile par = dir.getParent(); par != null && !par.equals(VfsUtil.getUserHomeDir()); par = par.getParent()) {
            AbstractVcs vcs = this.getVcsFor(par, dir);
            if (vcs == null) continue;
            return new VcsRoot(vcs, par);
        }
        return null;
    }

    @Nullable
    private AbstractVcs getVcsFor(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(14);
        }
        return this.getVcsFor(dir, null);
    }

    @Nullable
    private AbstractVcs getVcsFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        if (maybeRoot == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(15);
        }
        String path = maybeRoot.getPath();
        for (VcsRootChecker checker : this.myCheckers) {
            if (!checker.isRoot(path) || dirToCheckForIgnore != null && checker.isIgnored(maybeRoot, dirToCheckForIgnore)) continue;
            return this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsInsideDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doDetect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetect";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInContentRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsInsideDir";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldScanAbove";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanForSingleRootAboveDir";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

