/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.EnumComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CleanUnshelvedFilterDialog
extends DialogWrapper {
    private final JRadioButton myUnshelvedWithFilterButton;
    private final JRadioButton myAllUnshelvedButton;
    private final ComboBox myTimePeriodComboBox;

    public CleanUnshelvedFilterDialog(@Nullable Project project) {
        super(project);
        this.setTitle("Clean Unshelved Changelists");
        this.myUnshelvedWithFilterButton = new JRadioButton("older than one", true);
        this.myAllUnshelvedButton = new JRadioButton("all", false);
        this.myTimePeriodComboBox = new ComboBox((ComboBoxModel)new EnumComboBoxModel(TimePeriod.class));
        this.myTimePeriodComboBox.setEnabled(this.myUnshelvedWithFilterButton.isSelected());
        this.myUnshelvedWithFilterButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CleanUnshelvedFilterDialog.this.myTimePeriodComboBox.setEnabled(CleanUnshelvedFilterDialog.this.myUnshelvedWithFilterButton.isSelected());
            }
        });
        this.setOKButtonText("Delete");
        this.init();
        this.setResizable(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        JLabel questLabel = new JLabel("Delete already unshelved changelists: \n");
        String panelConstraints = "flowx, ins 0";
        MigLayout migLayout = new MigLayout(panelConstraints);
        JPanel buttonsPanel = new JPanel((LayoutManager)migLayout);
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myUnshelvedWithFilterButton);
        gr.add(this.myAllUnshelvedButton);
        this.myUnshelvedWithFilterButton.setBorder(BorderFactory.createEmptyBorder());
        this.myAllUnshelvedButton.setBorder(BorderFactory.createEmptyBorder());
        JPanel filterPanel = new JPanel((LayoutManager)new MigLayout(panelConstraints));
        filterPanel.add(this.myUnshelvedWithFilterButton);
        filterPanel.add((Component)this.myTimePeriodComboBox);
        buttonsPanel.add((Component)filterPanel, "wrap");
        buttonsPanel.add(this.myAllUnshelvedButton);
        panel2.add((Component)questLabel, "North");
        panel2.add((Component)buttonsPanel, "Center");
        return panel2;
    }

    public boolean isAllUnshelvedSelected() {
        return this.myAllUnshelvedButton.isSelected();
    }

    public boolean isUnshelvedWithFilterSelected() {
        return this.myUnshelvedWithFilterButton.isSelected();
    }

    public long getTimeLimitInMillis() {
        return ((TimePeriod)((Object)this.myTimePeriodComboBox.getSelectedItem())).getTimeLimitInMillis();
    }

    private static enum TimePeriod {
        Week{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    1.$$$reportNull$$$0(0);
                }
                cal.add(5, -7);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$1", "updateCalendar"));
            }
        }
        ,
        Month{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    2.$$$reportNull$$$0(0);
                }
                cal.add(2, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$2", "updateCalendar"));
            }
        }
        ,
        Year{

            @Override
            protected void updateCalendar(@NotNull Calendar cal) {
                if (cal == null) {
                    3.$$$reportNull$$$0(0);
                }
                cal.add(1, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cal", "com/intellij/openapi/vcs/changes/shelf/CleanUnshelvedFilterDialog$TimePeriod$3", "updateCalendar"));
            }
        };


        public long getTimeLimitInMillis() {
            Calendar cal = Calendar.getInstance();
            this.updateCalendar(cal);
            return cal.getTimeInMillis();
        }

        protected abstract void updateCalendar(@NotNull Calendar var1);
    }
}

