/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.vcs.commit.CommitWorkflowHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/BaseCommitExecutorAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "executorId", "", "getExecutorId", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getCommitExecutor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "handler", "Lcom/intellij/vcs/commit/CommitWorkflowHandler;", "getWorkflowHandler", "update", "intellij.platform.vcs.impl"})
public abstract class BaseCommitExecutorAction
extends DumbAwareAction {
    @NotNull
    private final String executorId = "";

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        CommitWorkflowHandler workflowHandler = this.getWorkflowHandler(e);
        CommitExecutor executor = this.getCommitExecutor(workflowHandler);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(workflowHandler != null && executor != null);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(workflowHandler != null && executor != null && workflowHandler.isExecutorEnabled(executor));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        CommitWorkflowHandler commitWorkflowHandler = this.getWorkflowHandler(e);
        if (commitWorkflowHandler == null) {
            Intrinsics.throwNpe();
        }
        CommitWorkflowHandler workflowHandler = commitWorkflowHandler;
        CommitExecutor commitExecutor = this.getCommitExecutor(workflowHandler);
        if (commitExecutor == null) {
            Intrinsics.throwNpe();
        }
        CommitExecutor executor = commitExecutor;
        workflowHandler.execute(executor);
    }

    @NotNull
    protected String getExecutorId() {
        return this.executorId;
    }

    @Nullable
    protected CommitExecutor getCommitExecutor(@Nullable CommitWorkflowHandler handler) {
        CommitWorkflowHandler commitWorkflowHandler = handler;
        return commitWorkflowHandler != null ? commitWorkflowHandler.getExecutor(this.getExecutorId()) : null;
    }

    private final CommitWorkflowHandler getWorkflowHandler(AnActionEvent e) {
        return (CommitWorkflowHandler)VcsDataKeys.COMMIT_WORKFLOW_HANDLER.getData(e.getDataContext());
    }

    public BaseCommitExecutorAction() {
        this.setEnabledInModalContext(true);
        this.executorId = "";
    }
}

