/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.menu;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;

public abstract class AbstractByRendererMenu
extends ProtegeOWLAction {
    private static final long serialVersionUID = -143138190636320921L;
    private JCheckBoxMenuItem menuItem;
    private OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
    private OWLModelManagerListener listener;

    protected abstract boolean isMyRendererPlugin(RendererPlugin var1);

    protected abstract boolean isConfigured(RendererPlugin var1);

    protected abstract void configure(RendererPlugin var1);

    public void setMenuItem(JMenuItem menuItem) {
        this.menuItem = (JCheckBoxMenuItem)menuItem;
        this.updateCheckedStatus();
    }

    public void initialise() throws Exception {
        this.listener = event -> {
            if (event.isType(EventType.ENTITY_RENDERER_CHANGED)) {
                this.updateCheckedStatus();
            }
        };
        this.getOWLModelManager().addListener(this.listener);
    }

    private void updateCheckedStatus() {
        if (this.menuItem != null) {
            RendererPlugin plugin = this.preferences.getRendererPlugin();
            this.menuItem.setSelected(this.isMyRendererPlugin(plugin) && this.isConfigured(plugin));
        }
    }

    public void dispose() throws Exception {
        this.getOWLModelManager().removeListener(this.listener);
    }

    public void actionPerformed(ActionEvent e) {
        OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
        for (RendererPlugin plugin : preferences.getRendererPlugins()) {
            if (!this.isMyRendererPlugin(plugin)) continue;
            preferences.setRendererPlugin(plugin);
            this.configure(plugin);
            this.getOWLModelManager().refreshRenderer();
            this.menuItem.setSelected(true);
            break;
        }
    }
}

