/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.entity.EntityImpl;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public final class EntityFactory {
    private final Map<String, ILeaf> leafsByCode = new LinkedHashMap<String, ILeaf>();
    private final Map<String, IGroup> groupsByCode = new LinkedHashMap<String, IGroup>();
    private final Map<Ident, ILeaf> leafs2 = new LinkedHashMap<Ident, ILeaf>();
    private final Map<Ident, IGroup> groups2 = new LinkedHashMap<Ident, IGroup>();
    private final List<Link> links = new ArrayList<Link>();
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final List<HideOrShow2> hides2;
    private final List<HideOrShow2> removed;

    public EntityFactory(List<HideOrShow2> hides2, List<HideOrShow2> removed) {
        this.hides2 = hides2;
        this.removed = removed;
    }

    public boolean isHidden(ILeaf leaf) {
        boolean hidden = false;
        for (HideOrShow2 hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    public boolean isRemoved(ILeaf leaf) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public void thisIsGoingToBeALeaf(Ident ident) {
    }

    public void thisIsNotArealGroup(Ident ident) {
    }

    public ILeaf createLeaf(Ident ident, Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (entityType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(entityType, hides);
        EntityImpl result = new EntityImpl(ident, code, this, bodier, parentContainer, entityType, namespaceSeparator, this.rawLayout);
        bodier.setLeaf(result);
        result.setDisplay(display);
        return result;
    }

    public IGroup createGroup(Ident ident, Code code, Display display, Code namespace, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        if (groupType == null) {
            throw new IllegalArgumentException();
        }
        Bodier bodier = new Bodier(null, hides);
        EntityImpl result = new EntityImpl(ident, code, this, bodier, parentContainer, groupType, namespace, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public void addLeaf(ILeaf entity) {
        this.leafsByCode.put(entity.getCodeGetName(), entity);
        this.leafs2.put(entity.getIdent(), entity);
    }

    public void addGroup(IGroup group) {
        this.groupsByCode.put(group.getCodeGetName(), group);
        this.groups2.put(group.getIdent(), group);
    }

    void removeGroup(String name) {
        IEntity removed = this.groupsByCode.remove(name);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
        IEntity removed2 = this.groups2.remove(removed.getIdent());
        if (removed != removed2) {
            EntityFactory.bigError();
        }
    }

    public static void bigError() {
        Thread.dumpStack();
    }

    void removeLeaf(String name) {
        IEntity removed = this.leafsByCode.remove(name);
        if (removed == null) {
            throw new IllegalArgumentException();
        }
        IEntity removed2 = this.leafs2.remove(removed.getIdent());
        if (removed != removed2) {
            EntityFactory.bigError();
        }
    }

    public IGroup muteToGroup(String name, Code namespace, GroupType type, IGroup parent) {
        ILeaf leaf = this.leafsByCode.get(name);
        ((EntityImpl)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(name);
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final ILeaf getLeaf(Ident ident) {
        return this.leafs2.get(ident);
    }

    public final ILeaf getLeaf(Code code) {
        ILeaf result = this.leafsByCode.get(code.getName());
        if (result != null && result != this.leafs2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final IGroup getGroup(Code code) {
        IGroup result = this.groupsByCode.get(code.getName());
        if (result != null && result != this.groups2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final IGroup getGroup(Ident ident) {
        IGroup result = this.groups2.get(ident);
        return result;
    }

    public final Collection<ILeaf> leafs() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafsByCode.values());
        if (!new ArrayList<ILeaf>(result).equals(new ArrayList<ILeaf>(this.leafs2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groupsByCode.values());
        if (!new ArrayList<IGroup>(result).equals(new ArrayList<IGroup>(this.groups2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups2() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groups2.values());
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<ILeaf> leafs2() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafs2.values());
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup getParentContainer(Ident ident, IGroup parentContainer) {
        if (parentContainer == null) {
            throw new IllegalArgumentException();
        }
        return parentContainer;
    }
}

