/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_ProfileGray;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Optional;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.sejda.core.support.io.IOUtils;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.FileSource;
import org.sejda.model.input.Source;
import org.sejda.model.input.SourceDispatcher;
import org.sejda.model.input.StreamSource;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.sejda.sambox.pdmodel.graphics.image.UnsupportedTiffImageException;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.sejda.sambox.util.Matrix;
import org.sejda.sambox.util.filetypedetector.FileType;
import org.sejda.sambox.util.filetypedetector.FileTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageImageWriter {
    private static final Logger LOG = LoggerFactory.getLogger(PageImageWriter.class);
    private PDDocument document;

    public PageImageWriter(PDDocument document) {
        this.document = document;
    }

    public void append(PDPage page, PDImageXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.APPEND, gs, true, rotation);
    }

    public void append(PDPage page, PDFormXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.APPEND, gs, true, rotation);
    }

    public void prepend(PDPage page, PDImageXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.PREPEND, gs, false, rotation);
    }

    public void prepend(PDPage page, PDFormXObject image, Point2D position, float width, float height, PDExtendedGraphicsState gs, int rotation) throws TaskIOException {
        this.write(page, (PDXObject)image, position, width, height, PDPageContentStream.AppendMode.PREPEND, gs, false, rotation);
    }

    private void write(PDPage page, PDXObject image, Point2D position, float width, float height, PDPageContentStream.AppendMode mode, PDExtendedGraphicsState gs, boolean resetContext, int rotation) throws TaskIOException {
        try (PDPageContentStream contentStream = new PDPageContentStream(this.document, page, mode, true, resetContext);){
            AffineTransform at = new AffineTransform(width, 0.0f, 0.0f, height, (float)position.getX(), (float)position.getY());
            if (rotation != 0) {
                at.rotate(Math.toRadians(rotation));
            }
            if (image instanceof PDFormXObject) {
                contentStream.drawImage((PDFormXObject)image, new Matrix(at), gs);
            } else {
                contentStream.drawImage((PDImageXObject)image, new Matrix(at), gs);
            }
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred writing image to the page.", (Throwable)e);
        }
    }

    public static PDImageXObject toPDXImageObject(final Source<?> imageSource) throws TaskIOException {
        return (PDImageXObject)imageSource.dispatch((SourceDispatcher)new SourceDispatcher<PDImageXObject>(){

            public PDImageXObject dispatch(FileSource source) throws TaskIOException {
                try {
                    return PageImageWriter.createFromFile(source.getSource().getPath());
                }
                catch (Exception e) {
                    throw new TaskIOException("An error occurred creating PDImageXObject from file source: " + imageSource.getName(), (Throwable)e);
                }
            }

            public PDImageXObject dispatch(StreamSource source) throws TaskIOException {
                try {
                    String extension = FilenameUtils.getExtension((String)source.getName());
                    File tmp = IOUtils.createTemporaryBuffer((String)("." + extension));
                    try (FileOutputStream fos = new FileOutputStream(tmp);){
                        org.apache.commons.io.IOUtils.copyLarge((InputStream)source.getSource(), (OutputStream)fos);
                    }
                    return PageImageWriter.createFromFile(tmp.getPath());
                }
                catch (Exception e) {
                    throw new TaskIOException("An error occurred creating PDImageXObject from file source: " + imageSource.getName(), (Throwable)e);
                }
            }
        });
    }

    public static PDImageXObject createFromFile(String originalFilePath) throws TaskIOException, IOException {
        File file = new File(originalFilePath);
        Optional<File> maybeConvertedFile = PageImageWriter.convertCMYKJpegIf(file);
        if (maybeConvertedFile.isPresent()) {
            file = maybeConvertedFile.get();
        }
        if ((maybeConvertedFile = PageImageWriter.convertICCGrayPngIf(file)).isPresent()) {
            file = maybeConvertedFile.get();
        }
        String filePath = file.getAbsolutePath();
        try {
            return PDImageXObject.createFromFile((String)filePath);
        }
        catch (UnsupportedTiffImageException e) {
            LOG.warn("Found unsupported TIFF compression, converting TIFF to JPEG: " + e.getMessage());
            try {
                return PDImageXObject.createFromFile((String)PageImageWriter.convertTiffToJpg(filePath));
            }
            catch (UnsupportedOperationException ex) {
                if (ex.getMessage().contains("alpha channel")) {
                    LOG.warn("Found alpha channel image, JPEG compression failed, converting TIFF to PNG");
                    return PDImageXObject.createFromFile((String)PageImageWriter.convertTiffToPng(filePath));
                }
                throw ex;
            }
        }
    }

    public static String convertTiffToJpg(String filePath) throws IOException, TaskIOException {
        return PageImageWriter.convertImageTo(filePath, "jpeg");
    }

    public static String convertTiffToPng(String filePath) throws IOException, TaskIOException {
        return PageImageWriter.convertImageTo(filePath, "png");
    }

    private static FileType getFileType(File file) {
        try {
            return FileTypeDetector.detectFileType((File)file);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertImageTo(String filePath, String format) throws IOException, TaskIOException {
        BufferedImage image = ImageIO.read(new File(filePath));
        File tmpFile = IOUtils.createTemporaryBuffer((String)("." + format));
        FileImageOutputStream outputStream = new FileImageOutputStream(tmpFile);
        try {
            ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
            writer.setOutput(outputStream);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (format.equals("jpeg")) {
                param.setCompressionMode(2);
                param.setCompressionQuality(1.0f);
            }
            writer.write(null, new IIOImage(image, null, null), param);
        }
        finally {
            org.apache.commons.io.IOUtils.closeQuietly((Closeable)outputStream);
        }
        return tmpFile.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<File> convertCMYKJpegIf(File file) throws IOException, TaskIOException {
        try {
            if (!FileType.JPEG.equals((Object)PageImageWriter.getFileType(file))) return Optional.empty();
            try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
                ImageReader reader = ImageIO.getImageReadersByFormatName("jpg").next();
                boolean isCmyk = false;
                try {
                    ImageIO.setUseCache(false);
                    reader.setInput(iis);
                    Iterator<ImageTypeSpecifier> it = reader.getImageTypes(0);
                    while (it.hasNext()) {
                        ImageTypeSpecifier typeSpecifier = it.next();
                        if (typeSpecifier.getColorModel().getColorSpace().getType() != 9) continue;
                        isCmyk = true;
                    }
                    if (!isCmyk) return Optional.empty();
                    LOG.debug("Detected a CMYK JPEG image, will convert to RGB and save to a new file");
                    BufferedImage image = reader.read(0);
                    File tmpFile = IOUtils.createTemporaryBufferWithName((String)file.getName());
                    ImageIO.write((RenderedImage)image, "jpg", tmpFile);
                    Optional<File> optional = Optional.of(tmpFile);
                    return optional;
                }
                finally {
                    reader.dispose();
                }
            }
        }
        catch (IIOException e) {
            if (!e.getMessage().startsWith("Not a JPEG stream")) throw e;
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<File> convertICCGrayPngIf(File file) throws IOException, TaskIOException {
        try {
            if (!FileType.PNG.equals((Object)PageImageWriter.getFileType(file))) return Optional.empty();
            try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
                ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
                boolean isICCGray = false;
                try {
                    ImageIO.setUseCache(false);
                    reader.setInput(iis);
                    Iterator<ImageTypeSpecifier> it = reader.getImageTypes(0);
                    while (it.hasNext()) {
                        ImageTypeSpecifier typeSpecifier = it.next();
                        ColorSpace colorSpace = typeSpecifier.getColorModel().getColorSpace();
                        if (!(colorSpace instanceof ICC_ColorSpace) || !(((ICC_ColorSpace)colorSpace).getProfile() instanceof ICC_ProfileGray)) continue;
                        isICCGray = true;
                    }
                    if (!isICCGray) return Optional.empty();
                    LOG.debug("Detected a Gray PNG image, will convert to RGB and save to a new file");
                    BufferedImage original = reader.read(0);
                    BufferedImage rgb = PageImageWriter.toARGB(original);
                    File tmpFile = IOUtils.createTemporaryBufferWithName((String)file.getName());
                    ImageIO.write((RenderedImage)rgb, "png", tmpFile);
                    Optional<File> optional = Optional.of(tmpFile);
                    return optional;
                }
                finally {
                    reader.dispose();
                }
            }
        }
        catch (IIOException e) {
            if (!e.getMessage().equals("I/O error reading PNG header!")) throw e;
            return Optional.empty();
        }
    }

    private static BufferedImage toARGB(BufferedImage i) {
        BufferedImage rgb = new BufferedImage(i.getWidth(null), i.getHeight(null), 2);
        rgb.createGraphics().drawImage((Image)i, 0, 0, null);
        return rgb;
    }
}

