# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.unstructured_grid_ghost_cells_generator import UnstructuredGridGhostCellsGenerator


class PUnstructuredGridGhostCellsGenerator(UnstructuredGridGhostCellsGenerator):
    """
    PUnstructuredGridGhostCellsGenerator - Builds ghost cells for a
     distributed unstructured grid dataset.
    
    Superclass: UnstructuredGridGhostCellsGenerator
    
    This filter generate ghost cells for distributed a unstructured grid
    in parallel - using MPI asynchronous communications. The filter can
    take benefit of the input grid point global ids to perform.
    
    @warning
     
       A step of 'all reduce' (each process send/receive grid bounds
    to/from
            all other processes).
       The code currently assumes one grid per rank. 
       point_data and cell_data must match across partitions/processes. 
     
    
    @sa
    DistributedDataFilter
    
    @par Thanks: This filter has been developed by Joachim Pouderoux,
    Kitware SAS 2015.
    
    @par Thanks: This filter was expanded to compute multiple ghost
    layers by Boonthanome Nouanesengsy and John Patchett, Los Alamos
    National Laboratory 2016. These changes are based on the paper: M.
    Patchett, John & Nouanesengesy, Boonthanome & Pouderoux, Joachim &
    Ahrens, James & Hagen, Hans. (2017). "Parallel Multi-Level Ghost Cell Generation for Distributed Unstructured
    Grids" which was presented at LDAV 2017 (The 7th IEEE Symposium on
    Large Data Analysis and Visualization), At Phoenix, AZ, USA.
    
    @par Thanks:
    ************************************************
    
    @par Thanks: This filter uses different algorithms when obtaining the
    first layer of ghost cells and getting subsequent layers.
    
    @par Thanks: First ghost cell layer algorithm:
    - each proc obtains surface points using the surface filter
    - share bounds to determine potential neighbor processes
    - share surface points with each potential neighbors
    - for each neighbor proc, look at their points, and see if any points
      match any of your local points
    - for each matching point, find all local cells which use those
      points, and send those cells to that proc. mark the cells that were
    sent (used for later ghost layers)
    - receive all cells sent to you, and merge everything together
    
    @par Thanks: Subsequent ghost layers
    - for each cell that was sent last round, find all other local cells
      which border these cells. 'local cells' also includes all ghost
      cells which i have. send these cells to the same proc, and mark
      them as sent last round
    - receive all cells sent to you, and merge everything together
    - if another layer is needed, repeat
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPUnstructuredGridGhostCellsGenerator, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/Get the MPI multi process controller object.
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)
        V.get_input() -> DataObject
        C++: DataObject *GetInput()"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('build_if_required', 'GetBuildIfRequired'), ('has_global_cell_ids',
    'GetHasGlobalCellIds'), ('use_global_point_ids',
    'GetUseGlobalPointIds'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('global_cell_ids_array_name', 'GetGlobalCellIdsArrayName'),
    ('global_point_ids_array_name', 'GetGlobalPointIdsArrayName'),
    ('minimum_number_of_ghost_levels', 'GetMinimumNumberOfGhostLevels'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'build_if_required', 'debug',
    'global_warning_display', 'has_global_cell_ids', 'release_data_flag',
    'use_global_point_ids', 'global_cell_ids_array_name',
    'global_point_ids_array_name', 'minimum_number_of_ghost_levels',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PUnstructuredGridGhostCellsGenerator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['build_if_required', 'has_global_cell_ids',
            'use_global_point_ids'], [], ['global_cell_ids_array_name',
            'global_point_ids_array_name', 'minimum_number_of_ghost_levels']),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PUnstructuredGridGhostCellsGenerator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

