/*
 * Decompiled with CFR 0.152.
 */
package kotlin.script.experimental.jvm.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.jvm.impl.PathUtilKt;
import kotlin.script.experimental.jvm.util.ClassLoaderResourceRootFIlePathCalculator;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a2\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016H\u0000\u001a\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0001H\u0000\u001a\f\u0010#\u001a\u00020\u0001*\u00020$H\u0002\u001a,\u0010%\u001a\u00020\u0011*\u00020&2\u0006\u0010\u0014\u001a\u00020\u00012\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00110\u0016\u001a\f\u0010'\u001a\u00020\u0001*\u00020\u0001H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0014\u0010\n\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\"\u0014\u0010\u000e\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006("}, d2={"pathElementPattern", "", "getPathElementPattern", "()Ljava/lang/String;", "pathSeparatorChars", "", "getPathSeparatorChars", "()[C", "pathSeparatorPattern", "getPathSeparatorPattern", "patternCharsToEscape", "getPatternCharsToEscape", "specialPatternChars", "getSpecialPatternChars", "wildcardChars", "getWildcardChars", "forAllMatchingFilesInDirectory", "", "baseDir", "Ljava/io/File;", "namePattern", "body", "Lkotlin/Function2;", "Ljava/io/InputStream;", "forAllMatchingFilesInJar", "jarFile", "nameRegex", "Lkotlin/text/Regex;", "forAllMatchingFilesInJarFile", "Ljava/util/jar/JarFile;", "forAllMatchingFilesInJarStream", "jarInputStream", "Ljava/util/jar/JarInputStream;", "namePatternToRegex", "pattern", "escape", "", "forAllMatchingFiles", "Ljava/lang/ClassLoader;", "toUniversalSeparator", "kotlin-scripting-jvm"})
public final class JvmClassLoaderUtilKt {
    @NotNull
    private static final char[] wildcardChars;
    @NotNull
    private static final char[] patternCharsToEscape;
    @NotNull
    private static final char[] pathSeparatorChars;
    @NotNull
    private static final String pathElementPattern;
    @NotNull
    private static final String pathSeparatorPattern;
    @NotNull
    private static final char[] specialPatternChars;

    public static final void forAllMatchingFiles(@NotNull ClassLoader $this$forAllMatchingFiles, @NotNull String namePattern, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)$this$forAllMatchingFiles, (String)"$this$forAllMatchingFiles");
        Intrinsics.checkParameterIsNotNull((Object)namePattern, (String)"namePattern");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        HashSet processedDirs = new HashSet();
        HashSet processedJars = new HashSet();
        Regex nameRegex = JvmClassLoaderUtilKt.namePatternToRegex(namePattern);
        Function1<String[], Unit> $fun$iterateResources$1 = new Function1<String[], Unit>($this$forAllMatchingFiles, processedJars, nameRegex, body, processedDirs, namePattern){
            final /* synthetic */ ClassLoader $this_forAllMatchingFiles;
            final /* synthetic */ HashSet $processedJars;
            final /* synthetic */ Regex $nameRegex;
            final /* synthetic */ Function2 $body;
            final /* synthetic */ HashSet $processedDirs;
            final /* synthetic */ String $namePattern;

            public final void invoke(String ... keyResourcePaths) {
                Intrinsics.checkParameterIsNotNull((Object)keyResourcePaths, (String)"keyResourcePaths");
                for (String keyResourcePath : keyResourcePaths) {
                    ClassLoaderResourceRootFIlePathCalculator resourceRootCalc = new ClassLoaderResourceRootFIlePathCalculator(keyResourcePath);
                    Enumeration<URL> enumeration = this.$this_forAllMatchingFiles.getResources(keyResourcePath);
                    Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"getResources(keyResourcePath)");
                    Iterator iterator = CollectionsKt.iterator(enumeration);
                    while (iterator.hasNext()) {
                        File rootDir;
                        File file;
                        URL url;
                        URL uRL = url = (URL)iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"url");
                        if (Intrinsics.areEqual((Object)uRL.getProtocol(), (Object)"jar")) {
                            JarFile jarFile;
                            JarURLConnection jarConnection;
                            URLConnection uRLConnection = url.openConnection();
                            if (!(uRLConnection instanceof JarURLConnection)) {
                                uRLConnection = null;
                            }
                            JarURLConnection jarURLConnection = jarConnection = (JarURLConnection)uRLConnection;
                            URL jarUrl = jarURLConnection != null ? jarURLConnection.getJarFileURL() : null;
                            if (jarUrl == null || this.$processedJars.contains(jarUrl)) continue;
                            this.$processedJars.add(jarUrl);
                            try {
                                jarFile = jarConnection.getJarFile();
                            }
                            catch (IOException _) {
                                jarFile = null;
                            }
                            JarFile jarFile2 = jarFile;
                            if (jarFile2 == null) continue;
                            jarFile = jarFile2;
                            boolean bl = false;
                            boolean bl2 = false;
                            JarFile it = jarFile;
                            boolean bl3 = false;
                            JvmClassLoaderUtilKt.forAllMatchingFilesInJarFile(it, this.$nameRegex, (Function2<? super String, ? super InputStream, Unit>)this.$body);
                            continue;
                        }
                        if (PathUtilKt.toFileOrNull(url) != null) {
                            File file2;
                            boolean bl = false;
                            boolean bl4 = false;
                            File it = file2;
                            boolean bl5 = false;
                            file = resourceRootCalc.invoke(it);
                        } else {
                            file = null;
                        }
                        if ((rootDir = file) == null || !rootDir.isDirectory() || this.$processedDirs.contains(rootDir)) continue;
                        this.$processedDirs.add(rootDir);
                        JvmClassLoaderUtilKt.forAllMatchingFilesInDirectory(rootDir, this.$namePattern, (Function2<? super String, ? super InputStream, Unit>)this.$body);
                    }
                }
            }
            {
                this.$this_forAllMatchingFiles = classLoader;
                this.$processedJars = hashSet;
                this.$nameRegex = regex;
                this.$body = function2;
                this.$processedDirs = hashSet2;
                this.$namePattern = string;
                super(1);
            }
        };
        $fun$iterateResources$1.invoke(new String[]{"", "META-INF/MANIFEST.MF"});
    }

    @NotNull
    public static final char[] getWildcardChars() {
        return wildcardChars;
    }

    @NotNull
    public static final char[] getPatternCharsToEscape() {
        return patternCharsToEscape;
    }

    private static final String escape(char $this$escape) {
        return ($this$escape == '\\' || ArraysKt.contains((char[])patternCharsToEscape, (char)$this$escape) ? "\\" : "") + $this$escape;
    }

    @NotNull
    public static final char[] getPathSeparatorChars() {
        return pathSeparatorChars;
    }

    @NotNull
    public static final String getPathElementPattern() {
        return pathElementPattern;
    }

    @NotNull
    public static final String getPathSeparatorPattern() {
        return pathSeparatorPattern;
    }

    @NotNull
    public static final char[] getSpecialPatternChars() {
        return specialPatternChars;
    }

    private static final String toUniversalSeparator(@NotNull String $this$toUniversalSeparator) {
        return File.separatorChar == '/' ? $this$toUniversalSeparator : StringsKt.replace$default((String)$this$toUniversalSeparator, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    public static final void forAllMatchingFilesInDirectory(@NotNull File baseDir, @NotNull String namePattern, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
        Intrinsics.checkParameterIsNotNull((Object)namePattern, (String)"namePattern");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        int patternStart = StringsKt.indexOfAny$default((CharSequence)namePattern, (char[])wildcardChars, (int)0, (boolean)false, (int)6, null);
        if (patternStart < 0) {
            File file = FilesKt.resolve((File)baseDir, (String)namePattern);
            boolean bl = false;
            boolean bl2 = false;
            File it = file;
            boolean bl3 = false;
            File file2 = it.exists() && it.isFile() ? file : null;
            if (file2 != null) {
                file = file2;
                bl = false;
                bl2 = false;
                File file3 = file;
                boolean bl4 = false;
                String string = FilesKt.relativeToOrSelf((File)file3, (File)baseDir).getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.relativeToOrSelf(baseDir).path");
                File file4 = file3;
                String string2 = JvmClassLoaderUtilKt.toUniversalSeparator(string);
                Function2<? super String, ? super InputStream, Unit> function2 = body;
                boolean bl5 = false;
                FileInputStream fileInputStream = new FileInputStream(file4);
                function2.invoke((Object)string2, (Object)fileInputStream);
            }
        } else {
            File root;
            int bl4;
            File file;
            int patternDirStart = StringsKt.lastIndexOfAny$default((CharSequence)namePattern, (char[])pathSeparatorChars, (int)patternStart, (boolean)false, (int)4, null);
            if (patternDirStart <= 0) {
                file = baseDir;
            } else {
                String string = namePattern;
                int file3 = 0;
                File file5 = baseDir;
                bl4 = 0;
                String string3 = string.substring(file3, patternDirStart);
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string4 = string3;
                file = root = FilesKt.resolve((File)file5, (String)string4);
            }
            if (root.exists() && root.isDirectory()) {
                String file3 = namePattern;
                bl4 = patternDirStart + 1;
                boolean bl = false;
                String string = file3.substring(bl4);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                Regex re = JvmClassLoaderUtilKt.namePatternToRegex(string);
                Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)root)), (Function1)((Function1)new Function1<File, Boolean>(re, root){
                    final /* synthetic */ Regex $re;
                    final /* synthetic */ File $root;

                    public final boolean invoke(@NotNull File it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        String string = FilesKt.relativeToOrSelf((File)it, (File)this.$root).getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativeToOrSelf(root).path");
                        return this.$re.matches((CharSequence)string);
                    }
                    {
                        this.$re = regex;
                        this.$root = file;
                        super(1);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File file6 = (File)element$iv;
                    boolean bl6 = false;
                    String string5 = FilesKt.relativeToOrSelf((File)file6, (File)baseDir).getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"file.relativeToOrSelf(baseDir).path");
                    File file7 = file6;
                    String string6 = JvmClassLoaderUtilKt.toUniversalSeparator(string5);
                    Function2<? super String, ? super InputStream, Unit> function2 = body;
                    boolean bl7 = false;
                    FileInputStream fileInputStream = new FileInputStream(file7);
                    function2.invoke((Object)string6, (Object)fileInputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarStream(@NotNull JarInputStream jarInputStream, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        JarEntry entry;
        Intrinsics.checkParameterIsNotNull((Object)jarInputStream, (String)"jarInputStream");
        Intrinsics.checkParameterIsNotNull((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        do {
            if ((entry = jarInputStream.getNextJarEntry()) == null) continue;
            try {
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                if (!nameRegex.matches((CharSequence)string)) continue;
                String string2 = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                body.invoke((Object)string2, (Object)jarInputStream);
            }
            finally {
                jarInputStream.closeEntry();
            }
        } while (entry != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJar(@NotNull File jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        Closeable closeable = new JarInputStream(new FileInputStream(jarFile));
        boolean bl = false;
        Throwable throwable = null;
        try {
            JarInputStream it = (JarInputStream)closeable;
            boolean bl2 = false;
            JvmClassLoaderUtilKt.forAllMatchingFilesInJarStream(it, nameRegex, body);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void forAllMatchingFilesInJarFile(@NotNull JarFile jarFile, @NotNull Regex nameRegex, @NotNull Function2<? super String, ? super InputStream, Unit> body) {
        Intrinsics.checkParameterIsNotNull((Object)jarFile, (String)"jarFile");
        Intrinsics.checkParameterIsNotNull((Object)nameRegex, (String)"nameRegex");
        Intrinsics.checkParameterIsNotNull(body, (String)"body");
        Enumeration<JarEntry> enumeration = jarFile.entries();
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"jarFile.entries()");
        Enumeration<JarEntry> enumeration2 = enumeration;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration2));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarEntry entry = (JarEntry)element$iv;
            boolean bl2 = false;
            JarEntry jarEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)jarEntry, (String)"entry");
            if (jarEntry.isDirectory()) continue;
            String string = entry.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
            if (!nameRegex.matches((CharSequence)string)) continue;
            Closeable closeable = jarFile.getInputStream(entry);
            boolean bl3 = false;
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl4 = false;
                String string2 = entry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entry.name");
                InputStream inputStream = stream;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"stream");
                body.invoke((Object)string2, (Object)inputStream);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final Regex namePatternToRegex(@NotNull String pattern) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl4 = false;
        int current = 0;
        while (current < pattern.length()) {
            String string2;
            int nextIndex = StringsKt.indexOfAny$default((CharSequence)pattern, (char[])specialPatternChars, (int)current, (boolean)false, (int)4, null);
            int next = nextIndex < 0 ? pattern.length() : nextIndex;
            String string3 = pattern;
            StringBuilder stringBuilder2 = $this$buildString;
            boolean bl5 = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(current, next), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            stringBuilder2.append(string2);
            current = next + 1;
            if (next >= pattern.length()) break;
            if (ArraysKt.contains((char[])pathSeparatorChars, (char)pattern.charAt(next))) {
                $this$buildString.append(pathSeparatorPattern);
                continue;
            }
            if (pattern.charAt(next) == '?') {
                $this$buildString.append('.');
                continue;
            }
            if (pattern.charAt(next) == '*' && next + 1 < pattern.length() && pattern.charAt(next + 1) == '*') {
                $this$buildString.append(".*");
                ++current;
                continue;
            }
            if (pattern.charAt(next) == '*') {
                $this$buildString.append(pathElementPattern);
                continue;
            }
            $this$buildString.append('\\');
            $this$buildString.append(pattern.charAt(next));
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        String string5 = string = string4;
        return new Regex(string5);
    }

    static {
        boolean bl;
        int n;
        Object it;
        boolean bl2;
        boolean bl3;
        Object object;
        block3: {
            object = "*?";
            bl3 = false;
            char[] cArray = ((String)object).toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            wildcardChars = cArray;
            object = ".*?+()[]^${}|";
            bl3 = false;
            char[] cArray2 = ((String)object).toCharArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)cArray2, (String)"(this as java.lang.String).toCharArray()");
            object = cArray2;
            bl3 = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            char[] $this$all$iv = wildcardChars;
            boolean $i$f$all = false;
            char[] cArray3 = $this$all$iv;
            n = cArray3.length;
            for (int i = 0; i < n; ++i) {
                char element$iv;
                char wc = element$iv = cArray3[i];
                boolean bl5 = false;
                if (ArraysKt.contains((char[])it, (char)wc)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        boolean bl6 = bl;
        boolean bl7 = false;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl6) {
            n = 0;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        patternCharsToEscape = (char[])object;
        object = "/";
        bl3 = false;
        bl2 = false;
        it = object;
        boolean bl9 = false;
        object = File.separatorChar == '/' ? it : (String)it + File.separator;
        bl3 = false;
        Object object2 = object;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        char[] cArray = ((String)object2).toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        pathSeparatorChars = cArray;
        pathElementPattern = File.separatorChar == '/' ? "[^/]*" : "[^/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + "]*";
        pathSeparatorPattern = File.separatorChar == '/' ? "/" : "[/" + JvmClassLoaderUtilKt.escape(File.separatorChar) + "].";
        specialPatternChars = ArraysKt.plus((char[])patternCharsToEscape, (char[])pathSeparatorChars);
    }
}

