/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.widgets.Composite;

public final class DriverUIContributorRegistry {
    private static DriverUIContributorRegistry instance = new DriverUIContributorRegistry();
    private Hashtable driverUIContributorTable = null;
    private BlankDriverUIContributor blankDriverUIContributor = new BlankDriverUIContributor();

    private DriverUIContributorRegistry() {
        this.initializeDriverCollection();
    }

    public static DriverUIContributorRegistry getInstance() {
        return instance;
    }

    public IDriverUIContributor getDriverUIContributor(String driverInstanceID) {
        IDriverUIContributor foundDriverUIContributor;
        String driverTemplateID;
        IDriverUIContributor driverUIContributor = this.blankDriverUIContributor;
        if (driverInstanceID != null && (driverTemplateID = DriverManager.getInstance().getDriverInstanceByID(driverInstanceID).getTemplate().getId()) != null && (foundDriverUIContributor = (IDriverUIContributor)this.driverUIContributorTable.get(driverTemplateID)) != null) {
            driverUIContributor = foundDriverUIContributor;
        }
        return driverUIContributor;
    }

    private void initializeDriverCollection() {
        this.driverUIContributorTable = new Hashtable();
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.datatools.connectivity.ui", "driverUIContributor");
        IExtension[] extensions = extensionPoint.getExtensions();
        int extensionIndex = 0;
        while (extensionIndex < extensions.length) {
            IConfigurationElement[] configElements = extensions[extensionIndex].getConfigurationElements();
            int elementIndex = 0;
            while (elementIndex < configElements.length) {
                if (configElements[elementIndex].getName().equals("driverUIContributor")) {
                    IConfigurationElement configElement = configElements[elementIndex];
                    String driverTemplateID = configElement.getAttribute("driverTemplateID");
                    IDriverUIContributor driverUIContributor = null;
                    try {
                        driverUIContributor = (IDriverUIContributor)configElement.createExecutableExtension("class");
                    }
                    catch (Exception exception) {}
                    if (driverUIContributor != null) {
                        this.driverUIContributorTable.put(driverTemplateID, driverUIContributor);
                    }
                }
                ++elementIndex;
            }
            ++extensionIndex;
        }
    }

    private class BlankDriverUIContributor
    implements IDriverUIContributor {
        Composite baseComposite = null;

        @Override
        public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
            if (this.baseComposite == null || this.baseComposite.isDisposed()) {
                this.baseComposite = new Composite(parent, 0);
            }
            return this.baseComposite;
        }

        @Override
        public boolean determineContributorCompletion() {
            return false;
        }

        @Override
        public void setDialogPage(DialogPage parentPage) {
        }

        @Override
        public void setDriverUIContributorInformation(IDriverUIContributorInformation information) {
        }

        @Override
        public void loadProperties() {
        }

        @Override
        public List getSummaryData() {
            return new ArrayList();
        }
    }
}

