/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.feature.FeaturePlugin;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureData;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.ide.IDE;

public class OpenReferenceAction
extends SelectionProviderAction {
    public OpenReferenceAction(ISelectionProvider provider) {
        super(provider, PDEUIMessages.Actions_open_label);
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FeaturePlugin) {
            IPluginBase base = ((FeaturePlugin)obj).getPluginBase();
            if (base != null) {
                ManifestEditor.openPluginEditor((IPluginModelBase)base.getModel());
            }
        } else if (obj instanceof IFeatureData) {
            IProject project;
            IFile file;
            IFeatureData data = (IFeatureData)obj;
            String id = data.getId();
            IResource resource = data.getModel().getUnderlyingResource();
            if (resource != null && (file = (project = resource.getProject()).getFile(id)) != null && file.exists()) {
                IWorkbenchPage page = PDEPlugin.getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        } else if (obj instanceof IFeatureChild) {
            IFeatureChild included = (IFeatureChild)obj;
            IFeature feature = ((FeatureChild)included).getReferencedFeature();
            FeatureEditor.openFeatureEditor(feature);
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!selection.isEmpty());
    }
}

