/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public class ProjectTools {
    public static final Predicate<IProject> IS_JAVA_PROJECT = new HasNature("org.eclipse.jdt.core.javanature");
    public static final Transformer<IProject, String> NAME_TRANSFORMER = new NameTransformer();

    public static IPath getJarRuntimeRootPath(IProject project) {
        String path = "/";
        if (ProjectTools.hasWebFacet(project)) {
            path = String.valueOf(path) + "WEB-INF";
        }
        return new Path(path);
    }

    public static boolean hasWebFacet(IProject project) {
        return ProjectTools.hasFacet(project, "jst.web");
    }

    public static boolean hasFacet(IProject project, IProjectFacet facet) {
        return ProjectTools.hasFacet(project, facet.getId());
    }

    public static boolean hasFacet(IProject project, String facetID) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetID);
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    public static boolean isJavaProject(IProject project) {
        return ProjectTools.hasNature(project, "org.eclipse.jdt.core.javanature");
    }

    public static boolean hasNature(IProject project, String natureID) {
        try {
            return project.exists() && project.isOpen() && project.hasNature(natureID);
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    private ProjectTools() {
        throw new UnsupportedOperationException();
    }

    public static class HasFacet
    extends CriterionPredicate<IProject, String> {
        public HasFacet(String facetID) {
            super((Object)facetID);
        }

        public boolean evaluate(IProject project) {
            return ProjectTools.hasFacet(project, (String)this.criterion);
        }
    }

    public static class HasNature
    extends CriterionPredicate<IProject, String> {
        public HasNature(String natureID) {
            super((Object)natureID);
        }

        public boolean evaluate(IProject project) {
            return ProjectTools.hasNature(project, (String)this.criterion);
        }
    }

    public static class NameTransformer
    extends TransformerAdapter<IProject, String> {
        public String transform(IProject project) {
            return project.getName();
        }
    }
}

