/*
 * Decompiled with CFR 0.152.
 */
package bt747.model;

import bt747.model.AppSettings;
import bt747.model.EventPoster;
import bt747.model.ModelEvent;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import gps.BT747Constants;
import gps.GPSListener;
import gps.GpsEvent;
import gps.connection.GPSrxtx;
import gps.log.GPSFilter;
import gps.log.GPSFilterAdvanced;
import gps.mvc.DeviceDirector;
import gps.mvc.GpsController;
import gps.mvc.GpsModel;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;
import net.sf.bt747.loc.HttpLocationSender;
import net.sf.bt747.loc.LocationSender;

public class Model
extends AppSettings
implements EventPoster,
GPSListener {
    private final PrivateData data = new PrivateData(0);
    private GPSrxtx gpsRxTx;
    public static final int NO_LOG_LOGTYPE = 0;
    public static final int CSV_LOGTYPE = 1;
    public static final int GMAP_LOGTYPE = 2;
    public static final int GPX_LOGTYPE = 3;
    public static final int KML_LOGTYPE = 4;
    public static final int NMEA_LOGTYPE = 5;
    public static final int PLT_LOGTYPE = 6;
    public static final int TRK_LOGTYPE = 7;
    public static final int BIN_LOGTYPE = 8;
    public static final int TRL_LOGTYPE = 9;
    public static final int SR_LOGTYPE = 10;
    public static final int KMZ_LOGTYPE = 11;
    public static final int ARRAY_LOGTYPE = 12;
    public static final int MULTI_LOGTYPE = 13;
    public static final int OSM_LOGTYPE = 14;
    public static final int OSM_UPLOAD_LOGTYPE = 15;
    public static final int EXTERNAL_LOGTYPE = 16;
    public static final int GOOGLE_MAP_STATIC_URL_LOGTYPE = 17;
    public static final int SQL_LOGTYPE = 18;
    public static final int POSTGIS_LOGTYPE = 19;
    public static final int SONYTRACKERRESULT_LOGTYPE = 20;
    public static final int WPT_LOGTYPE = 21;
    public static final int EXTERNAL_GPS2KML_LOGTYPE = 22;
    private static final int SECONDS_PER_DAY = 86400;
    private int filterStartTime;
    private int filterEndTime;
    private int lastConversionOngoing = 0;
    private boolean conversionOngoing = false;
    private static final int C_NBR_FILTERS = 2;
    private GPSFilter[] logFilters = new GPSFilter[2];
    private GPSFilterAdvanced[] logFiltersAdv = new GPSFilterAdvanced[2];
    private boolean expectedConnectionState = false;
    private static final int XDOP_FLOAT_TO_INT_100 = 100;
    private int downloadMethod = 1;
    public static final int DOWNLOAD_FILLED = 0;
    public static final int DOWNLOAD_SMART = 1;
    public static final int DOWNLOAD_FULL = 2;

    public Model() {
        int n;
        for (n = 0; n < this.logFilters.length; ++n) {
            this.logFilters[n] = new GPSFilter();
            this.logFiltersAdv[n] = new GPSFilterAdvanced();
        }
        this.filterStartTime = JavaLibBridge.getDateInstance(1, 1, 1983).dateToUTCepoch1970();
        this.filterEndTime = JavaLibBridge.getDateInstance().dateToUTCepoch1970() + 86399;
        this.gpsRxTx = new GPSrxtx();
        this.data.device = new DeviceDirector();
        n = this.getIntOpt(51);
        this.setProtocol(n);
    }

    protected final void setProtocol(int n) {
        if (((PrivateData)this.data).device.model != null) {
            ((PrivateData)this.data).device.model.removeListener(this);
        }
        int n2 = n;
        GPSrxtx gPSrxtx = this.gpsRxTx;
        DeviceDirector deviceDirector = this.data.device;
        this.data.device.gpsRxTx = gPSrxtx;
        int n3 = n2;
        if (deviceDirector.model == null) {
            deviceDirector.model = new GpsModel(deviceDirector.gpsRxTx, n3);
        } else {
            deviceDirector.model.setProtocol(n3);
        }
        deviceDirector.mtkModel = deviceDirector.model.getMtkModel();
        if (deviceDirector.devController == null) {
            deviceDirector.devController = GpsController.getInstance(deviceDirector.model, n3);
        } else {
            deviceDirector.devController.setProtocol(n3);
        }
        deviceDirector.mtkControl = deviceDirector.devController.getMtkController();
        ((PrivateData)this.data).device.model.addListener(this);
    }

    protected final GpsModel gpsM() {
        return this.data.gpsM();
    }

    protected final GpsController gpsC() {
        return this.data.gpsC();
    }

    protected final MtkController gpsMtkC() {
        return ((PrivateData)this.data).device.mtkControl;
    }

    protected final GPSrxtx gpsRxTx() {
        return this.gpsRxTx;
    }

    public final boolean isConnected() {
        boolean bl = this.gpsRxTx.isConnected();
        if (bl != this.expectedConnectionState) {
            this.expectedConnectionState = bl;
            if (bl) {
                this.postEvent(266);
            } else {
                this.postEvent(267);
            }
        }
        return bl;
    }

    public final int getOutstandingCommandsCount() {
        return this.gpsM().getOutStandingCmdsCount();
    }

    public final int getLastConversionOngoing() {
        return this.lastConversionOngoing;
    }

    protected final void setLastConversionOngoing(int n) {
        this.lastConversionOngoing = n;
    }

    public final boolean isConversionOngoing() {
        return this.conversionOngoing;
    }

    public final int getValidMask(int n) {
        switch (n) {
            case 1: {
                return this.getIntOpt(86);
            }
            case 0: {
                return this.getIntOpt(88);
            }
        }
        return 0;
    }

    public final int getRcrMask(int n) {
        switch (n) {
            case 1: {
                return this.getIntOpt(89);
            }
            case 0: {
                return this.getIntOpt(87);
            }
        }
        return 0;
    }

    protected final GPSFilterAdvanced[] getLogFiltersAdv() {
        this.setupAdvancedFilters();
        return this.logFiltersAdv;
    }

    private void setupBasicSettingsFilter(GPSFilter[] gPSFilterArray) {
        gPSFilterArray[0].setRcrMask(this.getIntOpt(87));
        gPSFilterArray[0].setValidMask(this.getIntOpt(88));
        gPSFilterArray[1].setRcrMask(this.getIntOpt(89));
        gPSFilterArray[1].setValidMask(this.getIntOpt(86));
    }

    public final GPSFilter[] getLogFilters() {
        this.setupBasicSettingsFilter(this.logFilters);
        return this.logFilters;
    }

    private void setupAdvancedFilters() {
        GPSFilter[] gPSFilterArray = this.logFiltersAdv;
        this.setupBasicSettingsFilter(gPSFilterArray);
        for (int i = this.logFiltersAdv.length - 1; i >= 0; --i) {
            GPSFilter gPSFilter = gPSFilterArray[i];
            ((GPSFilterAdvanced)gPSFilter).setMinRecCount(this.getIntOpt(77));
            ((GPSFilterAdvanced)gPSFilter).setMaxRecCount(this.getIntOpt(78));
            ((GPSFilterAdvanced)gPSFilter).setMinSpeed(this.getFloatOpt(74));
            ((GPSFilterAdvanced)gPSFilter).setMaxSpeed(this.getFloatOpt(75));
            ((GPSFilterAdvanced)gPSFilter).setMinDist(this.getFloatOpt(79));
            ((GPSFilterAdvanced)gPSFilter).setMaxDist(this.getFloatOpt(83));
            ((GPSFilterAdvanced)gPSFilter).setMaxPDOP((int)(this.getFloatOpt(81) * 100.0f));
            ((GPSFilterAdvanced)gPSFilter).setMaxHDOP((int)(this.getFloatOpt(82) * 100.0f));
            ((GPSFilterAdvanced)gPSFilter).setMaxVDOP((int)(this.getFloatOpt(80) * 100.0f));
            ((GPSFilterAdvanced)gPSFilter).setMinNSAT(this.getIntOpt(76));
        }
    }

    public final int getFilterStartTime() {
        return this.filterStartTime;
    }

    protected final void setFilterStartTime(int n) {
        this.filterStartTime = n;
    }

    public final int getFilterEndTime() {
        return this.filterEndTime;
    }

    protected final void setFilterEndTime(int n) {
        this.filterEndTime = n;
    }

    protected final void logConversionStarted(int n) {
        this.lastConversionOngoing = n;
        this.conversionOngoing = true;
        this.postEvent(256);
    }

    protected final void logConversionEnded(int n) {
        this.conversionOngoing = false;
        this.postEvent(257);
    }

    public final int getStartAddr() {
        return this.gpsM().getStartAddr();
    }

    public final int getEndAddr() {
        return this.gpsM().getEndAddr();
    }

    public final boolean isDownloadOnGoing() {
        return this.gpsM().isLogDownloadOnGoing();
    }

    public final int getNextReadAddr() {
        return this.gpsM().getNextReadAddr();
    }

    public final boolean isIncremental() {
        return this.downloadMethod == 1;
    }

    protected final void setIncremental(boolean bl) {
        this.downloadMethod = bl ? 1 : 0;
        this.postEvent(261);
    }

    public final int getDownloadMethod() {
        return this.downloadMethod;
    }

    public final void setDownloadMethod(int n) {
        this.downloadMethod = n;
        this.postEvent(270);
    }

    public final MtkModel mtkModel() {
        return ((PrivateData)this.data).device.mtkModel;
    }

    public final boolean isLoggingActive() {
        return this.mtkModel().isLoggingActive();
    }

    public final boolean isLoggerNeedsFormat() {
        return this.mtkModel().isLoggerNeedsFormat();
    }

    public final int logMemSize() {
        return this.mtkModel().getLogMemSize();
    }

    public final int logMemUsed() {
        return this.mtkModel().getLogMemUsed();
    }

    public final int logMemUsedPercent() {
        return this.mtkModel().logMemUsedPercent;
    }

    public final int logNbrLogPts() {
        return this.mtkModel().logNbrLogPts;
    }

    public final String getMtkLogVersion() {
        return this.mtkModel().getMtkLogVersion();
    }

    public final String getMainVersion() {
        return this.mtkModel().getMainVersion();
    }

    public final String getFirmwareVersion() {
        return this.mtkModel().getFirmwareVersion();
    }

    public final String getModelStr() {
        return this.mtkModel().getModel();
    }

    public final int getFlashManuProdID() {
        return this.mtkModel().getFlashManuProdID();
    }

    public final String getFlashDesc() {
        return this.mtkModel().getFlashDesc();
    }

    public final int getLogFormat() {
        return this.mtkModel().getLogFormat();
    }

    public final boolean isHolux() {
        return this.mtkModel().isHolux();
    }

    public final int logMemUsefullSize() {
        this.gpsC().setDataNeeded(0);
        return this.mtkModel().logMemUsefullSize();
    }

    public final int logFreeMemUsefullSize() {
        this.gpsC().setDataNeeded(0);
        this.gpsC().setDataNeeded(2);
        MtkModel mtkModel = this.mtkModel();
        return mtkModel.getLogMemSize() - mtkModel.getLogMemUsed() - (mtkModel.getLogMemSize() - mtkModel.getLogMemUsed() >> 16 << 9);
    }

    public final int getDtUpdateRate() {
        return this.mtkModel().getDtUpdateRate();
    }

    public final int getDtGLL_Period() {
        return this.mtkModel().getDtGLL_Period();
    }

    public final int getDtRMC_Period() {
        return this.mtkModel().getDtRMC_Period();
    }

    public final int getDtVTG_Period() {
        return this.mtkModel().getDtVTG_Period();
    }

    public final int getDtGSA_Period() {
        return this.mtkModel().getDtGSA_Period();
    }

    public final int getDtGSV_Period() {
        return this.mtkModel().getDtGSV_Period();
    }

    public final int getDtGGA_Period() {
        return this.mtkModel().getDtGGA_Period();
    }

    public final int getDtZDA_Period() {
        return this.mtkModel().getDtZDA_Period();
    }

    public final int getDtMCHN_Period() {
        return this.mtkModel().getDtMCHN_Period();
    }

    public final int getDtBaudRate() {
        return this.mtkModel().getDtBaudRate();
    }

    public final int getDtUserOptionTimesLeft() {
        return this.mtkModel().getDtUserOptionTimesLeft();
    }

    public final String getHoluxName() {
        return this.mtkModel().getHoluxName();
    }

    public final String getBTAddr() {
        return this.mtkModel().getBtMacAddr();
    }

    public final int getNMEAPeriod(int n) {
        return this.mtkModel().getNMEAPeriod(n);
    }

    public final int getLogTimeInterval() {
        return this.mtkModel().getLogTimeInterval();
    }

    public final int getLogSpeedInterval() {
        return this.mtkModel().getLogSpeedInterval();
    }

    public final int getLogDistanceInterval() {
        return this.mtkModel().getLogDistanceInterval();
    }

    public final int getLogFixPeriod() {
        return this.mtkModel().getLogFixPeriod();
    }

    public final int getDgpsMode() {
        return this.mtkModel().getDgpsMode();
    }

    public final boolean isLogFullOverwrite() {
        return this.mtkModel().isLogFullOverwrite();
    }

    public final boolean isInitialLogOverwrite() {
        return this.mtkModel().isInitialLogOverwrite();
    }

    public final boolean isSBASEnabled() {
        return this.mtkModel().isSBASEnabled();
    }

    public final boolean isSBASTestEnabled() {
        return this.mtkModel().isSBASTestEnabled();
    }

    public final boolean isPowerSaveEnabled() {
        return this.mtkModel().isPowerSaveEnabled();
    }

    public final int getDatum() {
        return this.mtkModel().getDatum();
    }

    public final int getEstimatedNbrRecords(int n) {
        int n2 = 0;
        try {
            n = BT747Constants.logRecordAndChecksumSize(n, this.getCurrentGpsType(), 12);
            if (n != 0) {
                n2 = this.logMemUsefullSize() / n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    private final int getCurrentGpsType() {
        if (this.isHolux() && this.gpsRxTx.isConnected()) {
            return 5;
        }
        return this.getIntOpt(23);
    }

    public final int getEstimatedNbrRecordsFree(int n) {
        int n2 = 0;
        try {
            n = BT747Constants.logRecordAndChecksumSize(n, this.getCurrentGpsType(), 12);
            if (n != 0) {
                n2 = this.logFreeMemUsefullSize() / n;
            }
        }
        catch (Exception exception) {
            Generic.debug("EstRecords", exception);
        }
        return n2;
    }

    public static final boolean isDebug() {
        return Generic.isDebug();
    }

    public final boolean isAvailable(int n) {
        return this.mtkModel().isDataAvailable(n);
    }

    public final boolean isDebugConn() {
        return this.gpsRxTx.isDebugConn();
    }

    @Override
    public final void gpsEvent(GpsEvent gpsEvent) {
        this.postEvent(new ModelEvent(gpsEvent));
    }

    LocationSender createAndConfigureLocationSender() {
        HttpLocationSender httpLocationSender = new HttpLocationSender(this);
        httpLocationSender.setUpdatePeriod(1000 * this.getIntOpt(67));
        httpLocationSender.setTargetFile(this.getStringOpt(63));
        httpLocationSender.setTargetHostname(this.getStringOpt(61));
        httpLocationSender.setTargetPort(this.getIntOpt(62));
        httpLocationSender.setUser(this.getStringOpt(65));
        httpLocationSender.setPassword(this.getStringOpt(66));
        if (this.isConnected()) {
            httpLocationSender.setBluetoothAdress(this.getBTAddr());
        }
        return httpLocationSender;
    }

    static final class PrivateData {
        private DeviceDirector device;

        private PrivateData() {
        }

        protected final GpsModel gpsM() {
            return this.device.model;
        }

        protected final GpsController gpsC() {
            return this.device.devController;
        }

        /* synthetic */ PrivateData(byte by) {
            this();
        }
    }
}

