/*
 * Copyright © 2012 - 2014 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef __OCL_RELATIONAL_H__
#define __OCL_RELATIONAL_H__

#include "ocl_types.h"
#include "ocl_as.h"

OVERLOADABLE int isequal(float x, float y);
OVERLOADABLE int isnotequal(float x, float y);
OVERLOADABLE int isgreater(float x, float y);
OVERLOADABLE int isgreaterequal(float x, float y);
OVERLOADABLE int isless(float x, float y);
OVERLOADABLE int islessequal(float x, float y);
OVERLOADABLE int islessgreater(float x, float y);

OVERLOADABLE int isfinite(float x);
OVERLOADABLE int isinf(float x);
OVERLOADABLE int isnan(float x);
OVERLOADABLE int isnormal(float x);

OVERLOADABLE int isordered(float x, float y);
OVERLOADABLE int isunordered(float x, float y);
OVERLOADABLE int signbit(float x);

// Half half version.
OVERLOADABLE int isequal(half x, half y);
OVERLOADABLE int isnotequal(half x, half y);
OVERLOADABLE int isgreater(half x, half y);
OVERLOADABLE int isgreaterequal(half x, half y);
OVERLOADABLE int isless(half x, half y);
OVERLOADABLE int islessequal(half x, half y);
OVERLOADABLE int islessgreater(half x, half y);

OVERLOADABLE int isfinite(half x);
OVERLOADABLE int isinf(half x);
OVERLOADABLE int isnan(half x);
OVERLOADABLE int isnormal(half x);

OVERLOADABLE int isordered(half x, half y);
OVERLOADABLE int isunordered(half x, half y);
OVERLOADABLE int signbit(half x);

OVERLOADABLE int isequal(double x, double y);
OVERLOADABLE int isnotequal(double x, double y);
OVERLOADABLE int isgreater(double x, double y);
OVERLOADABLE int isgreaterequal(double x, double y);
OVERLOADABLE int isless(double x, double y);
OVERLOADABLE int islessequal(double x, double y);
OVERLOADABLE int islessgreater(double x, double y);

OVERLOADABLE int isfinite(double x);
OVERLOADABLE int isinf(double x);
OVERLOADABLE int isnan(double x);
OVERLOADABLE int isnormal(double x);

OVERLOADABLE int isordered(double x, double y);
OVERLOADABLE int isunordered(double x, double y);
OVERLOADABLE int signbit(double x);

// any
#define DEC1(type) OVERLOADABLE int any(type a);
#define DEC2(type) OVERLOADABLE int any(type a);
#define DEC3(type) OVERLOADABLE int any(type a);
#define DEC4(type) OVERLOADABLE int any(type a);
#define DEC8(type) OVERLOADABLE int any(type a);
#define DEC16(type) OVERLOADABLE int any(type a);
DEC1(char);
DEC1(short);
DEC1(int);
DEC1(long);
#define DEC(n) DEC##n(char##n); DEC##n(short##n); DEC##n(int##n); DEC##n(long##n);
DEC(2);
DEC(3);
DEC(4);
DEC(8);
DEC(16);
#undef DEC
#undef DEC1
#undef DEC2
#undef DEC3
#undef DEC4
#undef DEC8
#undef DEC16

// all
#define DEC1(type) OVERLOADABLE int all(type a);
#define DEC2(type) OVERLOADABLE int all(type a);
#define DEC3(type) OVERLOADABLE int all(type a);
#define DEC4(type) OVERLOADABLE int all(type a);
#define DEC8(type) OVERLOADABLE int all(type a);
#define DEC16(type) OVERLOADABLE int all(type a);
DEC1(char)
DEC1(short)
DEC1(int)
DEC1(long)
#define DEC(n) DEC##n(char##n) DEC##n(short##n) DEC##n(int##n) DEC##n(long##n)
DEC(2)
DEC(3)
DEC(4)
DEC(8)
DEC(16)
#undef DEC
#undef DEC1
#undef DEC2
#undef DEC3
#undef DEC4
#undef DEC8
#undef DEC16

#define DEF(type) OVERLOADABLE type bitselect(type a, type b, type c);
DEF(char) DEF(uchar) DEF(short) DEF(ushort) DEF(int) DEF(uint)
DEF(long) DEF(ulong)
#undef DEF
OVERLOADABLE float bitselect(float a, float b, float c);
OVERLOADABLE half bitselect(half a, half b, half c);
OVERLOADABLE double bitselect(double a, double b, double c);


#define DEF(TYPE1, TYPE2) \
OVERLOADABLE TYPE1 select(TYPE1 src0, TYPE1 src1, TYPE2 cond);
DEF(char, char)
DEF(char, uchar)
DEF(uchar, char)
DEF(uchar, uchar)
DEF(short, short)
DEF(short, ushort)
DEF(ushort, short)
DEF(ushort, ushort)
DEF(int, int)
DEF(int, uint)
DEF(uint, int)
DEF(uint, uint)
DEF(long, long)
DEF(long, ulong)
DEF(ulong, long)
DEF(ulong, ulong)
DEF(float, int)
DEF(float, uint)
DEF(half, short)
DEF(half, ushort)
#undef DEF
//Begin from this part is autogenerated.
//Don't modify it manually.
//relational builtin functions
//intn isequal (floatn x, floatn y)

OVERLOADABLE int2 isequal (float2 param0, float2 param1);
OVERLOADABLE int3 isequal (float3 param0, float3 param1);
OVERLOADABLE int4 isequal (float4 param0, float4 param1);
OVERLOADABLE int8 isequal (float8 param0, float8 param1);
OVERLOADABLE int16 isequal (float16 param0, float16 param1);

//shortn isequal (halfn x, halfn y)

OVERLOADABLE short2 isequal (half2 param0, half2 param1);
OVERLOADABLE short3 isequal (half3 param0, half3 param1);
OVERLOADABLE short4 isequal (half4 param0, half4 param1);
OVERLOADABLE short8 isequal (half8 param0, half8 param1);
OVERLOADABLE short16 isequal (half16 param0, half16 param1);

//longn isequal (doublen x, doublen y)

OVERLOADABLE long2 isequal (double2 param0, double2 param1);
OVERLOADABLE long3 isequal (double3 param0, double3 param1);
OVERLOADABLE long4 isequal (double4 param0, double4 param1);
OVERLOADABLE long8 isequal (double8 param0, double8 param1);
OVERLOADABLE long16 isequal (double16 param0, double16 param1);

//intn isnotequal (floatn x, floatn y)

OVERLOADABLE int2 isnotequal (float2 param0, float2 param1);
OVERLOADABLE int3 isnotequal (float3 param0, float3 param1);
OVERLOADABLE int4 isnotequal (float4 param0, float4 param1);
OVERLOADABLE int8 isnotequal (float8 param0, float8 param1);
OVERLOADABLE int16 isnotequal (float16 param0, float16 param1);

//shortn isnotequal (halfn x, halfn y)

OVERLOADABLE short2 isnotequal (half2 param0, half2 param1);
OVERLOADABLE short3 isnotequal (half3 param0, half3 param1);
OVERLOADABLE short4 isnotequal (half4 param0, half4 param1);
OVERLOADABLE short8 isnotequal (half8 param0, half8 param1);
OVERLOADABLE short16 isnotequal (half16 param0, half16 param1);

//longn isnotequal (doublen x, doublen y)

OVERLOADABLE long2 isnotequal (double2 param0, double2 param1);
OVERLOADABLE long3 isnotequal (double3 param0, double3 param1);
OVERLOADABLE long4 isnotequal (double4 param0, double4 param1);
OVERLOADABLE long8 isnotequal (double8 param0, double8 param1);
OVERLOADABLE long16 isnotequal (double16 param0, double16 param1);

//intn isgreater (floatn x, floatn y)

OVERLOADABLE int2 isgreater (float2 param0, float2 param1);
OVERLOADABLE int3 isgreater (float3 param0, float3 param1);
OVERLOADABLE int4 isgreater (float4 param0, float4 param1);
OVERLOADABLE int8 isgreater (float8 param0, float8 param1);
OVERLOADABLE int16 isgreater (float16 param0, float16 param1);

//shortn isgreater (halfn x, halfn y)

OVERLOADABLE short2 isgreater (half2 param0, half2 param1);
OVERLOADABLE short3 isgreater (half3 param0, half3 param1);
OVERLOADABLE short4 isgreater (half4 param0, half4 param1);
OVERLOADABLE short8 isgreater (half8 param0, half8 param1);
OVERLOADABLE short16 isgreater (half16 param0, half16 param1);

//longn isgreater (doublen x, doublen y)

OVERLOADABLE long2 isgreater (double2 param0, double2 param1);
OVERLOADABLE long3 isgreater (double3 param0, double3 param1);
OVERLOADABLE long4 isgreater (double4 param0, double4 param1);
OVERLOADABLE long8 isgreater (double8 param0, double8 param1);
OVERLOADABLE long16 isgreater (double16 param0, double16 param1);

//intn isgreaterequal (floatn x, floatn y)

OVERLOADABLE int2 isgreaterequal (float2 param0, float2 param1);
OVERLOADABLE int3 isgreaterequal (float3 param0, float3 param1);
OVERLOADABLE int4 isgreaterequal (float4 param0, float4 param1);
OVERLOADABLE int8 isgreaterequal (float8 param0, float8 param1);
OVERLOADABLE int16 isgreaterequal (float16 param0, float16 param1);

//shortn isgreaterequal (halfn x, halfn y)

OVERLOADABLE short2 isgreaterequal (half2 param0, half2 param1);
OVERLOADABLE short3 isgreaterequal (half3 param0, half3 param1);
OVERLOADABLE short4 isgreaterequal (half4 param0, half4 param1);
OVERLOADABLE short8 isgreaterequal (half8 param0, half8 param1);
OVERLOADABLE short16 isgreaterequal (half16 param0, half16 param1);

//longn isgreaterequal (doublen x, doublen y)

OVERLOADABLE long2 isgreaterequal (double2 param0, double2 param1);
OVERLOADABLE long3 isgreaterequal (double3 param0, double3 param1);
OVERLOADABLE long4 isgreaterequal (double4 param0, double4 param1);
OVERLOADABLE long8 isgreaterequal (double8 param0, double8 param1);
OVERLOADABLE long16 isgreaterequal (double16 param0, double16 param1);

//intn isless (floatn x, floatn y)

OVERLOADABLE int2 isless (float2 param0, float2 param1);
OVERLOADABLE int3 isless (float3 param0, float3 param1);
OVERLOADABLE int4 isless (float4 param0, float4 param1);
OVERLOADABLE int8 isless (float8 param0, float8 param1);
OVERLOADABLE int16 isless (float16 param0, float16 param1);

//shortn isless (halfn x, halfn y)

OVERLOADABLE short2 isless (half2 param0, half2 param1);
OVERLOADABLE short3 isless (half3 param0, half3 param1);
OVERLOADABLE short4 isless (half4 param0, half4 param1);
OVERLOADABLE short8 isless (half8 param0, half8 param1);
OVERLOADABLE short16 isless (half16 param0, half16 param1);

//longn isless (doublen x, doublen y)

OVERLOADABLE long2 isless (double2 param0, double2 param1);
OVERLOADABLE long3 isless (double3 param0, double3 param1);
OVERLOADABLE long4 isless (double4 param0, double4 param1);
OVERLOADABLE long8 isless (double8 param0, double8 param1);
OVERLOADABLE long16 isless (double16 param0, double16 param1);

//intn islessequal (floatn x, floatn y)

OVERLOADABLE int2 islessequal (float2 param0, float2 param1);
OVERLOADABLE int3 islessequal (float3 param0, float3 param1);
OVERLOADABLE int4 islessequal (float4 param0, float4 param1);
OVERLOADABLE int8 islessequal (float8 param0, float8 param1);
OVERLOADABLE int16 islessequal (float16 param0, float16 param1);

//shortn islessequal (halfn x, halfn y)

OVERLOADABLE short2 islessequal (half2 param0, half2 param1);
OVERLOADABLE short3 islessequal (half3 param0, half3 param1);
OVERLOADABLE short4 islessequal (half4 param0, half4 param1);
OVERLOADABLE short8 islessequal (half8 param0, half8 param1);
OVERLOADABLE short16 islessequal (half16 param0, half16 param1);

//longn islessequal (doublen x, doublen y)

OVERLOADABLE long2 islessequal (double2 param0, double2 param1);
OVERLOADABLE long3 islessequal (double3 param0, double3 param1);
OVERLOADABLE long4 islessequal (double4 param0, double4 param1);
OVERLOADABLE long8 islessequal (double8 param0, double8 param1);
OVERLOADABLE long16 islessequal (double16 param0, double16 param1);

//intn islessgreater (floatn x, floatn y)

OVERLOADABLE int2 islessgreater (float2 param0, float2 param1);
OVERLOADABLE int3 islessgreater (float3 param0, float3 param1);
OVERLOADABLE int4 islessgreater (float4 param0, float4 param1);
OVERLOADABLE int8 islessgreater (float8 param0, float8 param1);
OVERLOADABLE int16 islessgreater (float16 param0, float16 param1);

//shortn islessgreater (halfn x, halfn y)

OVERLOADABLE short2 islessgreater (half2 param0, half2 param1);
OVERLOADABLE short3 islessgreater (half3 param0, half3 param1);
OVERLOADABLE short4 islessgreater (half4 param0, half4 param1);
OVERLOADABLE short8 islessgreater (half8 param0, half8 param1);
OVERLOADABLE short16 islessgreater (half16 param0, half16 param1);

//longn islessgreater (doublen x, doublen y)

OVERLOADABLE long2 islessgreater (double2 param0, double2 param1);
OVERLOADABLE long3 islessgreater (double3 param0, double3 param1);
OVERLOADABLE long4 islessgreater (double4 param0, double4 param1);
OVERLOADABLE long8 islessgreater (double8 param0, double8 param1);
OVERLOADABLE long16 islessgreater (double16 param0, double16 param1);

//intn isfinite (floatn)

OVERLOADABLE int2 isfinite (float2 param0);
OVERLOADABLE int3 isfinite (float3 param0);
OVERLOADABLE int4 isfinite (float4 param0);
OVERLOADABLE int8 isfinite (float8 param0);
OVERLOADABLE int16 isfinite (float16 param0);

//shortn isfinite (halfn)

OVERLOADABLE short2 isfinite (half2 param0);
OVERLOADABLE short3 isfinite (half3 param0);
OVERLOADABLE short4 isfinite (half4 param0);
OVERLOADABLE short8 isfinite (half8 param0);
OVERLOADABLE short16 isfinite (half16 param0);

//longn isfinite (doublen)

OVERLOADABLE long2 isfinite (double2 param0);
OVERLOADABLE long3 isfinite (double3 param0);
OVERLOADABLE long4 isfinite (double4 param0);
OVERLOADABLE long8 isfinite (double8 param0);
OVERLOADABLE long16 isfinite (double16 param0);

//intn isinf (floatn)

OVERLOADABLE int2 isinf (float2 param0);
OVERLOADABLE int3 isinf (float3 param0);
OVERLOADABLE int4 isinf (float4 param0);
OVERLOADABLE int8 isinf (float8 param0);
OVERLOADABLE int16 isinf (float16 param0);

//shortn isinf (halfn)

OVERLOADABLE short2 isinf (half2 param0);
OVERLOADABLE short3 isinf (half3 param0);
OVERLOADABLE short4 isinf (half4 param0);
OVERLOADABLE short8 isinf (half8 param0);
OVERLOADABLE short16 isinf (half16 param0);

//longn isinf (doublen)

OVERLOADABLE long2 isinf (double2 param0);
OVERLOADABLE long3 isinf (double3 param0);
OVERLOADABLE long4 isinf (double4 param0);
OVERLOADABLE long8 isinf (double8 param0);
OVERLOADABLE long16 isinf (double16 param0);

//intn isnan (floatn)

OVERLOADABLE int2 isnan (float2 param0);
OVERLOADABLE int3 isnan (float3 param0);
OVERLOADABLE int4 isnan (float4 param0);
OVERLOADABLE int8 isnan (float8 param0);
OVERLOADABLE int16 isnan (float16 param0);

//shortn isnan (halfn)

OVERLOADABLE short2 isnan (half2 param0);
OVERLOADABLE short3 isnan (half3 param0);
OVERLOADABLE short4 isnan (half4 param0);
OVERLOADABLE short8 isnan (half8 param0);
OVERLOADABLE short16 isnan (half16 param0);

//longn isnan (doublen)

OVERLOADABLE long2 isnan (double2 param0);
OVERLOADABLE long3 isnan (double3 param0);
OVERLOADABLE long4 isnan (double4 param0);
OVERLOADABLE long8 isnan (double8 param0);
OVERLOADABLE long16 isnan (double16 param0);

//intn isnormal (floatn)

OVERLOADABLE int2 isnormal (float2 param0);
OVERLOADABLE int3 isnormal (float3 param0);
OVERLOADABLE int4 isnormal (float4 param0);
OVERLOADABLE int8 isnormal (float8 param0);
OVERLOADABLE int16 isnormal (float16 param0);

//shortn isnormal (halfn)

OVERLOADABLE short2 isnormal (half2 param0);
OVERLOADABLE short3 isnormal (half3 param0);
OVERLOADABLE short4 isnormal (half4 param0);
OVERLOADABLE short8 isnormal (half8 param0);
OVERLOADABLE short16 isnormal (half16 param0);

//longn isnormal (doublen)

OVERLOADABLE long2 isnormal (double2 param0);
OVERLOADABLE long3 isnormal (double3 param0);
OVERLOADABLE long4 isnormal (double4 param0);
OVERLOADABLE long8 isnormal (double8 param0);
OVERLOADABLE long16 isnormal (double16 param0);

//intn isordered (floatn x, floatn y)

OVERLOADABLE int2 isordered (float2 param0, float2 param1);
OVERLOADABLE int3 isordered (float3 param0, float3 param1);
OVERLOADABLE int4 isordered (float4 param0, float4 param1);
OVERLOADABLE int8 isordered (float8 param0, float8 param1);
OVERLOADABLE int16 isordered (float16 param0, float16 param1);

//shortn isordered (halfn x, halfn y)

OVERLOADABLE short2 isordered (half2 param0, half2 param1);
OVERLOADABLE short3 isordered (half3 param0, half3 param1);
OVERLOADABLE short4 isordered (half4 param0, half4 param1);
OVERLOADABLE short8 isordered (half8 param0, half8 param1);
OVERLOADABLE short16 isordered (half16 param0, half16 param1);

//longn isordered (doublen x, doublen y)

OVERLOADABLE long2 isordered (double2 param0, double2 param1);
OVERLOADABLE long3 isordered (double3 param0, double3 param1);
OVERLOADABLE long4 isordered (double4 param0, double4 param1);
OVERLOADABLE long8 isordered (double8 param0, double8 param1);
OVERLOADABLE long16 isordered (double16 param0, double16 param1);

//intn isunordered (floatn x, floatn y)

OVERLOADABLE int2 isunordered (float2 param0, float2 param1);
OVERLOADABLE int3 isunordered (float3 param0, float3 param1);
OVERLOADABLE int4 isunordered (float4 param0, float4 param1);
OVERLOADABLE int8 isunordered (float8 param0, float8 param1);
OVERLOADABLE int16 isunordered (float16 param0, float16 param1);

//shortn isunordered (halfn x, halfn y)

OVERLOADABLE short2 isunordered (half2 param0, half2 param1);
OVERLOADABLE short3 isunordered (half3 param0, half3 param1);
OVERLOADABLE short4 isunordered (half4 param0, half4 param1);
OVERLOADABLE short8 isunordered (half8 param0, half8 param1);
OVERLOADABLE short16 isunordered (half16 param0, half16 param1);

//longn isunordered (doublen x, doublen y)

OVERLOADABLE long2 isunordered (double2 param0, double2 param1);
OVERLOADABLE long3 isunordered (double3 param0, double3 param1);
OVERLOADABLE long4 isunordered (double4 param0, double4 param1);
OVERLOADABLE long8 isunordered (double8 param0, double8 param1);
OVERLOADABLE long16 isunordered (double16 param0, double16 param1);

//intn signbit (floatn)

OVERLOADABLE int2 signbit (float2 param0);
OVERLOADABLE int3 signbit (float3 param0);
OVERLOADABLE int4 signbit (float4 param0);
OVERLOADABLE int8 signbit (float8 param0);
OVERLOADABLE int16 signbit (float16 param0);

//shortn signbit (halfn)

OVERLOADABLE short2 signbit (half2 param0);
OVERLOADABLE short3 signbit (half3 param0);
OVERLOADABLE short4 signbit (half4 param0);
OVERLOADABLE short8 signbit (half8 param0);
OVERLOADABLE short16 signbit (half16 param0);

//longn signbit (doublen)

OVERLOADABLE long2 signbit (double2 param0);
OVERLOADABLE long3 signbit (double3 param0);
OVERLOADABLE long4 signbit (double4 param0);
OVERLOADABLE long8 signbit (double8 param0);
OVERLOADABLE long16 signbit (double16 param0);

//int any (igentype x)


//int all (igentype x)


//gentype bitselect (gentype a, gentype b, gentype c)

OVERLOADABLE char2 bitselect (char2 param0, char2 param1, char2 param2);
OVERLOADABLE char3 bitselect (char3 param0, char3 param1, char3 param2);
OVERLOADABLE char4 bitselect (char4 param0, char4 param1, char4 param2);
OVERLOADABLE char8 bitselect (char8 param0, char8 param1, char8 param2);
OVERLOADABLE char16 bitselect (char16 param0, char16 param1, char16 param2);
OVERLOADABLE short2 bitselect (short2 param0, short2 param1, short2 param2);
OVERLOADABLE short3 bitselect (short3 param0, short3 param1, short3 param2);
OVERLOADABLE short4 bitselect (short4 param0, short4 param1, short4 param2);
OVERLOADABLE short8 bitselect (short8 param0, short8 param1, short8 param2);
OVERLOADABLE short16 bitselect (short16 param0, short16 param1, short16 param2);
OVERLOADABLE int2 bitselect (int2 param0, int2 param1, int2 param2);
OVERLOADABLE int3 bitselect (int3 param0, int3 param1, int3 param2);
OVERLOADABLE int4 bitselect (int4 param0, int4 param1, int4 param2);
OVERLOADABLE int8 bitselect (int8 param0, int8 param1, int8 param2);
OVERLOADABLE int16 bitselect (int16 param0, int16 param1, int16 param2);
OVERLOADABLE long2 bitselect (long2 param0, long2 param1, long2 param2);
OVERLOADABLE long3 bitselect (long3 param0, long3 param1, long3 param2);
OVERLOADABLE long4 bitselect (long4 param0, long4 param1, long4 param2);
OVERLOADABLE long8 bitselect (long8 param0, long8 param1, long8 param2);
OVERLOADABLE long16 bitselect (long16 param0, long16 param1, long16 param2);
OVERLOADABLE uchar2 bitselect (uchar2 param0, uchar2 param1, uchar2 param2);
OVERLOADABLE uchar3 bitselect (uchar3 param0, uchar3 param1, uchar3 param2);
OVERLOADABLE uchar4 bitselect (uchar4 param0, uchar4 param1, uchar4 param2);
OVERLOADABLE uchar8 bitselect (uchar8 param0, uchar8 param1, uchar8 param2);
OVERLOADABLE uchar16 bitselect (uchar16 param0, uchar16 param1, uchar16 param2);
OVERLOADABLE ushort2 bitselect (ushort2 param0, ushort2 param1, ushort2 param2);
OVERLOADABLE ushort3 bitselect (ushort3 param0, ushort3 param1, ushort3 param2);
OVERLOADABLE ushort4 bitselect (ushort4 param0, ushort4 param1, ushort4 param2);
OVERLOADABLE ushort8 bitselect (ushort8 param0, ushort8 param1, ushort8 param2);
OVERLOADABLE ushort16 bitselect (ushort16 param0, ushort16 param1, ushort16 param2);
OVERLOADABLE uint2 bitselect (uint2 param0, uint2 param1, uint2 param2);
OVERLOADABLE uint3 bitselect (uint3 param0, uint3 param1, uint3 param2);
OVERLOADABLE uint4 bitselect (uint4 param0, uint4 param1, uint4 param2);
OVERLOADABLE uint8 bitselect (uint8 param0, uint8 param1, uint8 param2);
OVERLOADABLE uint16 bitselect (uint16 param0, uint16 param1, uint16 param2);
OVERLOADABLE ulong2 bitselect (ulong2 param0, ulong2 param1, ulong2 param2);
OVERLOADABLE ulong3 bitselect (ulong3 param0, ulong3 param1, ulong3 param2);
OVERLOADABLE ulong4 bitselect (ulong4 param0, ulong4 param1, ulong4 param2);
OVERLOADABLE ulong8 bitselect (ulong8 param0, ulong8 param1, ulong8 param2);
OVERLOADABLE ulong16 bitselect (ulong16 param0, ulong16 param1, ulong16 param2);
OVERLOADABLE float2 bitselect (float2 param0, float2 param1, float2 param2);
OVERLOADABLE float3 bitselect (float3 param0, float3 param1, float3 param2);
OVERLOADABLE float4 bitselect (float4 param0, float4 param1, float4 param2);
OVERLOADABLE float8 bitselect (float8 param0, float8 param1, float8 param2);
OVERLOADABLE float16 bitselect (float16 param0, float16 param1, float16 param2);
OVERLOADABLE double2 bitselect (double2 param0, double2 param1, double2 param2);
OVERLOADABLE double3 bitselect (double3 param0, double3 param1, double3 param2);
OVERLOADABLE double4 bitselect (double4 param0, double4 param1, double4 param2);
OVERLOADABLE double8 bitselect (double8 param0, double8 param1, double8 param2);
OVERLOADABLE double16 bitselect (double16 param0, double16 param1, double16 param2);
OVERLOADABLE half2 bitselect (half2 param0, half2 param1, half2 param2);
OVERLOADABLE half3 bitselect (half3 param0, half3 param1, half3 param2);
OVERLOADABLE half4 bitselect (half4 param0, half4 param1, half4 param2);
OVERLOADABLE half8 bitselect (half8 param0, half8 param1, half8 param2);
OVERLOADABLE half16 bitselect (half16 param0, half16 param1, half16 param2);

//gentype select (gentype a, gentype b, igentype c)

OVERLOADABLE char2 select (char2 param0, char2 param1, char2 param2);
OVERLOADABLE char3 select (char3 param0, char3 param1, char3 param2);
OVERLOADABLE char4 select (char4 param0, char4 param1, char4 param2);
OVERLOADABLE char8 select (char8 param0, char8 param1, char8 param2);
OVERLOADABLE char16 select (char16 param0, char16 param1, char16 param2);
OVERLOADABLE short2 select (short2 param0, short2 param1, short2 param2);
OVERLOADABLE short3 select (short3 param0, short3 param1, short3 param2);
OVERLOADABLE short4 select (short4 param0, short4 param1, short4 param2);
OVERLOADABLE short8 select (short8 param0, short8 param1, short8 param2);
OVERLOADABLE short16 select (short16 param0, short16 param1, short16 param2);
OVERLOADABLE int2 select (int2 param0, int2 param1, int2 param2);
OVERLOADABLE int3 select (int3 param0, int3 param1, int3 param2);
OVERLOADABLE int4 select (int4 param0, int4 param1, int4 param2);
OVERLOADABLE int8 select (int8 param0, int8 param1, int8 param2);
OVERLOADABLE int16 select (int16 param0, int16 param1, int16 param2);
OVERLOADABLE long2 select (long2 param0, long2 param1, long2 param2);
OVERLOADABLE long3 select (long3 param0, long3 param1, long3 param2);
OVERLOADABLE long4 select (long4 param0, long4 param1, long4 param2);
OVERLOADABLE long8 select (long8 param0, long8 param1, long8 param2);
OVERLOADABLE long16 select (long16 param0, long16 param1, long16 param2);
OVERLOADABLE uchar2 select (uchar2 param0, uchar2 param1, char2 param2);
OVERLOADABLE uchar3 select (uchar3 param0, uchar3 param1, char3 param2);
OVERLOADABLE uchar4 select (uchar4 param0, uchar4 param1, char4 param2);
OVERLOADABLE uchar8 select (uchar8 param0, uchar8 param1, char8 param2);
OVERLOADABLE uchar16 select (uchar16 param0, uchar16 param1, char16 param2);
OVERLOADABLE ushort2 select (ushort2 param0, ushort2 param1, short2 param2);
OVERLOADABLE ushort3 select (ushort3 param0, ushort3 param1, short3 param2);
OVERLOADABLE ushort4 select (ushort4 param0, ushort4 param1, short4 param2);
OVERLOADABLE ushort8 select (ushort8 param0, ushort8 param1, short8 param2);
OVERLOADABLE ushort16 select (ushort16 param0, ushort16 param1, short16 param2);
OVERLOADABLE uint2 select (uint2 param0, uint2 param1, int2 param2);
OVERLOADABLE uint3 select (uint3 param0, uint3 param1, int3 param2);
OVERLOADABLE uint4 select (uint4 param0, uint4 param1, int4 param2);
OVERLOADABLE uint8 select (uint8 param0, uint8 param1, int8 param2);
OVERLOADABLE uint16 select (uint16 param0, uint16 param1, int16 param2);
OVERLOADABLE ulong2 select (ulong2 param0, ulong2 param1, long2 param2);
OVERLOADABLE ulong3 select (ulong3 param0, ulong3 param1, long3 param2);
OVERLOADABLE ulong4 select (ulong4 param0, ulong4 param1, long4 param2);
OVERLOADABLE ulong8 select (ulong8 param0, ulong8 param1, long8 param2);
OVERLOADABLE ulong16 select (ulong16 param0, ulong16 param1, long16 param2);
OVERLOADABLE float2 select (float2 param0, float2 param1, int2 param2);
OVERLOADABLE float3 select (float3 param0, float3 param1, int3 param2);
OVERLOADABLE float4 select (float4 param0, float4 param1, int4 param2);
OVERLOADABLE float8 select (float8 param0, float8 param1, int8 param2);
OVERLOADABLE float16 select (float16 param0, float16 param1, int16 param2);
OVERLOADABLE double2 select (double2 param0, double2 param1, long2 param2);
OVERLOADABLE double3 select (double3 param0, double3 param1, long3 param2);
OVERLOADABLE double4 select (double4 param0, double4 param1, long4 param2);
OVERLOADABLE double8 select (double8 param0, double8 param1, long8 param2);
OVERLOADABLE double16 select (double16 param0, double16 param1, long16 param2);
OVERLOADABLE half2 select (half2 param0, half2 param1, short2 param2);
OVERLOADABLE half3 select (half3 param0, half3 param1, short3 param2);
OVERLOADABLE half4 select (half4 param0, half4 param1, short4 param2);
OVERLOADABLE half8 select (half8 param0, half8 param1, short8 param2);
OVERLOADABLE half16 select (half16 param0, half16 param1, short16 param2);

//gentype select (gentype a, gentype b, ugentype c)

OVERLOADABLE char2 select (char2 param0, char2 param1, uchar2 param2);
OVERLOADABLE char3 select (char3 param0, char3 param1, uchar3 param2);
OVERLOADABLE char4 select (char4 param0, char4 param1, uchar4 param2);
OVERLOADABLE char8 select (char8 param0, char8 param1, uchar8 param2);
OVERLOADABLE char16 select (char16 param0, char16 param1, uchar16 param2);
OVERLOADABLE short2 select (short2 param0, short2 param1, ushort2 param2);
OVERLOADABLE short3 select (short3 param0, short3 param1, ushort3 param2);
OVERLOADABLE short4 select (short4 param0, short4 param1, ushort4 param2);
OVERLOADABLE short8 select (short8 param0, short8 param1, ushort8 param2);
OVERLOADABLE short16 select (short16 param0, short16 param1, ushort16 param2);
OVERLOADABLE int2 select (int2 param0, int2 param1, uint2 param2);
OVERLOADABLE int3 select (int3 param0, int3 param1, uint3 param2);
OVERLOADABLE int4 select (int4 param0, int4 param1, uint4 param2);
OVERLOADABLE int8 select (int8 param0, int8 param1, uint8 param2);
OVERLOADABLE int16 select (int16 param0, int16 param1, uint16 param2);
OVERLOADABLE long2 select (long2 param0, long2 param1, ulong2 param2);
OVERLOADABLE long3 select (long3 param0, long3 param1, ulong3 param2);
OVERLOADABLE long4 select (long4 param0, long4 param1, ulong4 param2);
OVERLOADABLE long8 select (long8 param0, long8 param1, ulong8 param2);
OVERLOADABLE long16 select (long16 param0, long16 param1, ulong16 param2);
OVERLOADABLE uchar2 select (uchar2 param0, uchar2 param1, uchar2 param2);
OVERLOADABLE uchar3 select (uchar3 param0, uchar3 param1, uchar3 param2);
OVERLOADABLE uchar4 select (uchar4 param0, uchar4 param1, uchar4 param2);
OVERLOADABLE uchar8 select (uchar8 param0, uchar8 param1, uchar8 param2);
OVERLOADABLE uchar16 select (uchar16 param0, uchar16 param1, uchar16 param2);
OVERLOADABLE ushort2 select (ushort2 param0, ushort2 param1, ushort2 param2);
OVERLOADABLE ushort3 select (ushort3 param0, ushort3 param1, ushort3 param2);
OVERLOADABLE ushort4 select (ushort4 param0, ushort4 param1, ushort4 param2);
OVERLOADABLE ushort8 select (ushort8 param0, ushort8 param1, ushort8 param2);
OVERLOADABLE ushort16 select (ushort16 param0, ushort16 param1, ushort16 param2);
OVERLOADABLE uint2 select (uint2 param0, uint2 param1, uint2 param2);
OVERLOADABLE uint3 select (uint3 param0, uint3 param1, uint3 param2);
OVERLOADABLE uint4 select (uint4 param0, uint4 param1, uint4 param2);
OVERLOADABLE uint8 select (uint8 param0, uint8 param1, uint8 param2);
OVERLOADABLE uint16 select (uint16 param0, uint16 param1, uint16 param2);
OVERLOADABLE ulong2 select (ulong2 param0, ulong2 param1, ulong2 param2);
OVERLOADABLE ulong3 select (ulong3 param0, ulong3 param1, ulong3 param2);
OVERLOADABLE ulong4 select (ulong4 param0, ulong4 param1, ulong4 param2);
OVERLOADABLE ulong8 select (ulong8 param0, ulong8 param1, ulong8 param2);
OVERLOADABLE ulong16 select (ulong16 param0, ulong16 param1, ulong16 param2);
OVERLOADABLE float2 select (float2 param0, float2 param1, uint2 param2);
OVERLOADABLE float3 select (float3 param0, float3 param1, uint3 param2);
OVERLOADABLE float4 select (float4 param0, float4 param1, uint4 param2);
OVERLOADABLE float8 select (float8 param0, float8 param1, uint8 param2);
OVERLOADABLE float16 select (float16 param0, float16 param1, uint16 param2);
OVERLOADABLE double2 select (double2 param0, double2 param1, ulong2 param2);
OVERLOADABLE double3 select (double3 param0, double3 param1, ulong3 param2);
OVERLOADABLE double4 select (double4 param0, double4 param1, ulong4 param2);
OVERLOADABLE double8 select (double8 param0, double8 param1, ulong8 param2);
OVERLOADABLE double16 select (double16 param0, double16 param1, ulong16 param2);
OVERLOADABLE half2 select (half2 param0, half2 param1, ushort2 param2);
OVERLOADABLE half3 select (half3 param0, half3 param1, ushort3 param2);
OVERLOADABLE half4 select (half4 param0, half4 param1, ushort4 param2);
OVERLOADABLE half8 select (half8 param0, half8 param1, ushort8 param2);
OVERLOADABLE half16 select (half16 param0, half16 param1, ushort16 param2);

#endif
