/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.ActiveChar;
import com.dickimawbooks.texparserlib.AssignedActiveChar;
import com.dickimawbooks.texparserlib.AssignedControlSequence;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class Let
extends Primitive {
    public Let() {
        this("let");
    }

    public Let(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new Let(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject == null) {
            this.process(teXParser);
            return;
        }
        TeXObject teXObject2 = teXObjectList.popToken();
        if (teXObject2 == null) {
            teXObject2 = teXParser.popToken();
        }
        this.doAssignment(teXParser, teXObject, teXObject2);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject = teXParser.popToken();
        TeXObject teXObject2 = teXParser.popToken();
        this.doAssignment(teXParser, teXObject, teXObject2);
    }

    protected void doAssignment(TeXParser teXParser, TeXObject teXObject, TeXObject teXObject2) {
        if (teXObject2 instanceof TeXCsRef) {
            teXObject2 = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject2).getName());
        }
        TeXObject teXObject3 = (TeXObject)teXObject2.clone();
        if (teXObject instanceof ControlSequence) {
            ControlSequence controlSequence = (ControlSequence)teXObject;
            AssignedControlSequence assignedControlSequence = new AssignedControlSequence(controlSequence.getName(), teXObject3);
            teXParser.putControlSequence(this.getPrefix() != 2, assignedControlSequence);
        } else if (teXObject instanceof ActiveChar) {
            ActiveChar activeChar = (ActiveChar)teXObject;
            AssignedActiveChar assignedActiveChar = new AssignedActiveChar(activeChar.getCharCode(), teXObject3);
            teXParser.putActiveChar(this.getPrefix() != 2, assignedActiveChar);
        } else if (teXObject instanceof CharObject) {
            CharObject charObject = (CharObject)teXObject;
            AssignedActiveChar assignedActiveChar = new AssignedActiveChar(charObject.getCharCode(), teXObject3);
            teXParser.putActiveChar(this.getPrefix() != 2, assignedActiveChar);
        } else {
            String string = teXObject.toString(teXParser);
            AssignedActiveChar assignedActiveChar = new AssignedActiveChar(string.codePointAt(0), teXObject3);
            teXParser.putActiveChar(this.getPrefix() != 2, assignedActiveChar);
        }
        this.clearPrefix();
    }
}

