/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_km extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AL = "\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8";
        final String metaValue_AM = "\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8";
        final String metaValue_AZ = "\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb";
        final String metaValue_BY = "\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f";
        final String metaValue_CN = "\u1785\u17b7\u1793";
        final String metaValue_DE = "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb";
        final String metaValue_DK = "\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780";
        final String metaValue_EE = "\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8";
        final String metaValue_ES = "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789";
        final String metaValue_ET = "\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8";
        final String metaValue_FI = "\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb";
        final String metaValue_FR = "\u1794\u17b6\u179a\u17b6\u17c6\u1784";
        final String metaValue_GR = "\u1780\u17d2\u179a\u17b7\u1785";
        final String metaValue_HR = "\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u178f";
        final String metaValue_HT = "\u17a0\u17c3\u1791\u17b8";
        final String metaValue_HU = "\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8";
        final String metaValue_ID = "\u17a5\u178e\u17d2\u178c\u17bc\u178e\u17c1\u179f\u17ca\u17b8";
        final String metaValue_IE = "\u17a2\u17c0\u179a\u17a1\u1784\u17cb";
        final String metaValue_IL = "\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b";
        final String metaValue_IS = "\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u1784\u17cb";
        final String metaValue_IT = "\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8";
        final String metaValue_JP = "\u1787\u1794\u17c9\u17bb\u1793";
        final String metaValue_KG = "\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb";
        final String metaValue_KZ = "\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u1784\u17cb\u17cb";
        final String metaValue_LA = "\u17a1\u17b6\u179c";
        final String metaValue_LK = "\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6";
        final String metaValue_LT = "\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8";
        final String metaValue_LU = "\u179b\u17bb\u1785\u17a0\u17d2\u179f\u17c6\u1794\u17bd\u179a";
        final String metaValue_MA = "\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780";
        final String metaValue_MN = "\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8";
        final String metaValue_MT = "\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6";
        final String metaValue_MY = "\u1798\u17c9\u17b6\u17a1\u17c1\u179f\u17ca\u17b8";
        final String metaValue_NL = "\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb";
        final String metaValue_NP = "\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb";
        final String metaValue_PH = "\u17a0\u17d2\u179c\u17b8\u179b\u17b8\u1796\u17b8\u1793";
        final String metaValue_PL = "\u1794\u17c9\u17bc\u17a1\u17bc\u1789";
        final String metaValue_PT = "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb";
        final String metaValue_RO = "\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8";
        final String metaValue_RS = "\u179f\u17ca\u17c2\u1794";
        final String metaValue_RU = "\u179a\u17bb\u179f\u17d2\u179f\u17ca\u17b8";
        final String metaValue_SD = "\u179f\u17ca\u17bc\u178a\u1784\u17cb";
        final String metaValue_SE = "\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a";
        final String metaValue_SK = "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8";
        final String metaValue_SO = "\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8";
        final String metaValue_TH = "\u1790\u17c3";
        final String metaValue_TM = "\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb";
        final String metaValue_TR = "\u1791\u17bd\u179a\u1782\u17b8";
        final String metaValue_UA = "\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793";
        final String metaValue_UZ = "\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb";
        final String metaValue_VN = "\u179c\u17c0\u178f\u178e\u17b6\u1798";
        final String metaValue_ar = "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb";
        final String metaValue_bn = "\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f";
        final String metaValue_bo = "\u1791\u17b8\u1794\u17c1";
        final String metaValue_km = "\u1781\u17d2\u1798\u17c2\u179a";
        final String metaValue_kn = "\u1780\u1793\u17d2\u1793\u178a";
        final String metaValue_ko = "\u1780\u17bc\u179a\u17c9\u17c1";
        final String metaValue_ml = "\u1798\u179b\u1799\u17b6\u179b\u17d0\u1798";
        final String metaValue_my = "\u1797\u17bc\u1798\u17b6";
        final String metaValue_or = "\u17a2\u17bc\u179a\u17b8\u1799\u17c9\u17b6";
        final String metaValue_ta = "\u178f\u17b6\u1798\u17b8\u179b";
        final String metaValue_te = "\u178f\u17c1\u179b\u17bb\u1782\u17bb";
        final String metaValue_type_nu_taml = "\u179b\u17c1\u1781\u200b\u178f\u17b6\u1798\u17b8\u179b";
        final Object[][] data = new Object[][] {
            { "sbp", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17bc" },
            { "nyn", "\u178e\u17b6\u1793\u1780\u17bc\u179b\u17c1" },
            { "luo", "\u179b\u17bc\u17a2\u17bc" },
            { "Zsym", "\u1793\u17b7\u1798\u17b7\u178f\u17d2\u178f\u179f\u1789\u17d2\u1789\u17b6" },
            { "fil", metaValue_PH },
            { "luy", "\u179b\u17bc\u1799\u17c9\u17b6" },
            { "es_ES", "\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789 (\u17a2\u17ca\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "teo", "\u178f\u17c1\u179f\u17bc" },
            { "aa", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a" },
            { "ab", "\u17a2\u17b6\u1794\u17cb\u1781\u17b6\u17a0\u17ca\u17d2\u179f\u17b6\u1793" },
            { "AC", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u179f\u17c1\u1793\u179f\u17b7\u1793" },
            { "AD", "\u17a2\u1784\u17cb\u178a\u17bc\u179a\u17c9\u17b6" },
            { "AE", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179a\u17bd\u1798" },
            { "ae", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179c\u17c2\u179f\u17d2\u178f\u1784\u17cb" },
            { "nl_BE", "\u1795\u17d2\u179b\u17b6\u1798\u17b8\u179f" },
            { "AF", "\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "af", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u17b6\u1793" },
            { "AG", "\u17a2\u1784\u17cb\u1791\u17b8\u1782\u17d0\u179a \u1793\u17b7\u1784\u200b\u1794\u17b6\u1794\u17bb\u1799\u178a\u17b6" },
            { "type.ca.ethiopic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "AI", "\u17a2\u1784\u17cb\u1780\u17bc\u17a1\u17b6" },
            { "ak", "\u17a2\u17b6\u1780\u17b6\u1793" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "am", "\u17a2\u17b6\u1798\u17a0\u17b6\u179a\u17b8\u1785" },
            { "Arab", metaValue_ar },
            { "an", "\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793" },
            { "AO", "\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6" },
            { "Jpan", metaValue_JP },
            { "AQ", "\u17a2\u1784\u17cb\u178f\u17b6\u1780\u17cb\u1791\u17b7\u1780" },
            { "ar", metaValue_ar },
            { "AR", "\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793" },
            { "AS", "\u179f\u17b6\u1798\u17c9\u17bc\u17a2\u17b6\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "as", "\u17a2\u17b6\u179f\u17b6\u1798\u17b8\u179f" },
            { "AT", "\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f" },
            { "AU", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8" },
            { "AW", "\u17a2\u17b6\u179a\u17bc\u1794\u17b6" },
            { "sdh", "\u17a2\u1798\u17d2\u1794\u17bc\u179a\u1783\u17ba\u178a\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "AX", "\u1780\u17c4\u17c7\u200b\u17a2\u17b6\u17a1\u17b6\u17c6\u1784" },
            { "ay", "\u1797\u17b6\u179f\u17b6\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6" },
            { "az", metaValue_AZ },
            { "AZ", metaValue_AZ },
            { "BA", "\u1794\u17bc\u179f\u17d2\u1793\u17b8 \u1793\u17b7\u1784\u17a0\u17ba\u17a0\u17d2\u179f\u17b8\u17a0\u17d2\u1782\u17bc\u179c\u17b8\u178e\u17b6" },
            { "ba", "\u1794\u17c2\u179f\u17d2\u1780\u17ba" },
            { "BB", "\u1794\u17b6\u179a\u1794\u17b6\u178a\u17bc\u179f" },
            { "BD", "\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c1\u179f\u17d2\u17a0" },
            { "be", metaValue_BY },
            { "BE", "\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17c9\u17b7\u1780" },
            { "BF", "\u1794\u17ca\u17bc\u179a\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc" },
            { "BG", "\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8" },
            { "bg", "\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1780\u17b6\u179a\u17b8" },
            { "BH", "\u1794\u17b6\u179a\u17c9\u17c2\u1793" },
            { "BI", "\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8" },
            { "BJ", "\u1794\u17c1\u178e\u17b6\u17c6\u1784" },
            { "BL", "\u179f\u1784\u17cb \u1794\u17b6\u178f\u17c1\u17a1\u17c1\u1798\u17c9\u17b8" },
            { "BM", "\u1794\u17ca\u17ba\u1798\u17bb\u1799\u178a\u17b6" },
            { "bm", "\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6" },
            { "bn", metaValue_bn },
            { "BN", "\u1794\u17d2\u179a\u17ca\u17bb\u1799\u178e\u17c1" },
            { "bo", metaValue_bo },
            { "BO", "\u1794\u17bc\u179b\u17b8\u179c\u17b8" },
            { "BQ", "\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb \u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "BR", "\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b" },
            { "br", "\u1794\u17d2\u179a\u17b8\u179f\u17d2\u178f\u17bb\u1793" },
            { "BS", "\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6" },
            { "bs", "\u1794\u17bc\u179f\u17d2\u1793\u17b8" },
            { "xog", "\u179f\u17bc\u17a0\u17d2\u1782\u17b6" },
            { "BT", "\u1794\u17ca\u17bc\u178f\u17b6\u1793" },
            { "BV", "\u1780\u17c4\u17c7\u200b\u1794\u17ca\u17bc\u179c\u17c9\u17c1\u178f" },
            { "Mymr", metaValue_my },
            { "BW", "\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6" },
            { "type.nu.laoo", "\u179b\u17c1\u1781\u200b\u17a1\u17b6\u179c" },
            { "BY", metaValue_BY },
            { "seh", "\u179f\u17ca\u17b8\u178e\u17b6" },
            { "BZ", "\u1794\u17c1\u179b\u17b8\u17a0\u17d2\u179f" },
            { "type.ca.persian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1796\u17c2\u1780\u17d2\u179f" },
            { "type.nu.hebr", "\u179b\u17c1\u1781\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "CA", "\u1780\u17b6\u178e\u17b6\u178a\u17b6" },
            { "ca", "\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793" },
            { "CC", "\u1780\u17c4\u17c7\u200b\u1780\u17bc\u1780\u17bc\u179f" },
            { "mzn", "\u1798\u17c9\u17b6\u17a0\u17d2\u179f\u17b6\u1793\u178a\u17ba\u179a\u17c1\u1793\u17b8" },
            { "ses", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1794\u17bc\u179a\u17c9\u17bb\u179f\u17ca\u17b8\u1793\u17b8" },
            { "CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4- \u1782\u17b8\u1793\u179f\u17d2\u17a0\u17b6\u179f\u17b6" },
            { "ce", "\u1788\u17b8\u1786\u17c1\u1793" },
            { "CF", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "CG", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4 - \u1794\u17d2\u179a\u17b6\u17a0\u17d2\u179f\u17b6\u179c\u17b8\u179b" },
            { "CH", "\u179f\u17d2\u179c\u17b8\u179f" },
            { "CI", "\u1780\u17bc\u178a\u178c\u17b8\u179c\u17d0\u179a" },
            { "CK", "\u1780\u17c4\u17c7\u200b\u1781\u17bc\u1780" },
            { "CL", "\u179f\u17ca\u17b8\u179b\u17b8" },
            { "CM", "\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793" },
            { "CN", metaValue_CN },
            { "CO", "\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8" },
            { "co", "\u1780\u17bc\u179f\u17ca\u17b8\u1781\u17b6\u1793" },
            { "CP", "\u1780\u17c4\u17c7\u200b\u1783\u17d2\u179b\u17b8\u1797\u17ba\u178f\u17bb\u1793" },
            { "Orya", metaValue_or },
            { "CR", "\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6" },
            { "cs", "\u1786\u17c1\u1780" },
            { "CU", "\u1782\u17bb\u1799\u1794\u17b6" },
            { "CV", "\u1780\u17b6\u1794\u179c\u17c2\u179a" },
            { "cv", "\u1788\u17bc\u179c\u17c9\u17b6\u179f" },
            { "CW", "\u1780\u17bc\u179a\u17c9\u17b6\u1780\u17c5" },
            { "CX", "\u1780\u17c4\u17c7\u200b\u1782\u17d2\u179a\u17b8\u179f\u17d2\u1798\u17b6\u179f" },
            { "CY", "\u179f\u17ca\u17b8\u1796\u179a\u17cd" },
            { "cy", "\u179c\u17c1\u179b" },
            { "CZ", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1786\u17c1\u1780" },
            { "type.nu.ethi", "\u179b\u17c1\u1781\u200b\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8" },
            { "da", metaValue_DK },
            { "pt_PT", "\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u179b\u17cb (\u17a2\u17ba\u179a\u17c9\u17bb\u1794)" },
            { "de", metaValue_DE },
            { "DE", metaValue_DE },
            { "cgg", "\u1788\u17b8\u17a0\u17d2\u1782\u17b6" },
            { "DG", "\u178c\u17c0\u17a0\u17d2\u1782\u17c4\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "type.nu.deva", "\u179b\u17c1\u1781\u200b\u178c\u17b8\u179c\u17c9\u17b6\u178e\u17b6\u1780\u17b6\u179a\u17b8" },
            { "DJ", "\u17a0\u17d2\u179f\u17ca\u17b8\u1794\u17bc\u1791\u17b8" },
            { "DK", metaValue_DK },
            { "Brai", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u179f\u1798\u17d2\u179a\u17b6\u1794\u17cb\u1798\u1793\u17bb\u179f\u17d2\u179f\u200b\u1796\u17b7\u1780\u17b6\u179a\u200b\u1797\u17d2\u1793\u17c2\u1780" },
            { "DM", "\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17b6" },
            { "type.nu.armnlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "DO", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17c2\u1793" },
            { "bem", "\u1794\u17c1\u1798\u1794\u17b6" },
            { "DZ", "\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8" },
            { "dz", "\u178a\u17bb\u1784\u1781\u17b6" },
            { "bez", "\u1794\u17c1\u178e\u17b6" },
            { "type.ca.chinese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1785\u17b7\u1793" },
            { "EA", "\u1787\u17ba\u178f\u17b6 \u1793\u17b7\u1784\u200b\u1798\u17c9\u17c1\u179b\u17b8\u17a1\u17b6" },
            { "EC", "\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u178c\u17d0\u179a" },
            { "dje", "\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6" },
            { "type.nu.grek", "\u179b\u17c1\u1781\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "EE", metaValue_EE },
            { "ee", "\u17a2\u17ca\u17b8\u179c" },
            { "type.lb.normal", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1792\u1798\u17d2\u1798\u178f\u17b6" },
            { "EG", "\u17a2\u17c1\u17a0\u17d2\u179f\u17ca\u17b8\u1794" },
            { "EH", "\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ro_MD", "\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8" },
            { "el", metaValue_GR },
            { "en", "\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "eo", "\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17cb\u178f\u17bc" },
            { "chr", "\u1786\u17c1\u179a\u17bc\u1782\u17b8" },
            { "ER", "\u17a2\u17c1\u179a\u17b8\u1791\u17d2\u179a\u17b6" },
            { "es", metaValue_ES },
            { "ES", metaValue_ES },
            { "et", metaValue_EE },
            { "ET", metaValue_ET },
            { "EU", "\u179f\u17a0\u1797\u17b6\u1796\u200b\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "eu", "\u1794\u17b6\u179f\u17d2\u1780\u17c1" },
            { "Hang", "\u17a0\u17b6\u17c6\u1784\u1780\u17bb\u179b" },
            { "type.ca.gregorian", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "shi", "\u178f\u17b6\u1788\u17b8\u179b\u17a0\u17ca\u17b8\u178f" },
            { "type.nu.gujr", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "hsb", "\u179f\u17bc\u1794\u17ca\u17b8\u179b\u17be" },
            { "Hani", "\u17a0\u17b6\u1793" },
            { "fa", "\u1797\u17ba\u179f\u17c0\u1793" },
            { "Hans", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.latn", "\u179b\u17c1\u1781\u200b\u1794\u1785\u17d2\u1785\u17b9\u1798\u200b\u1794\u17d2\u179a\u1791\u17c1\u179f" },
            { "Hant", "\u17a2\u1780\u17d2\u179f\u179a\u200b\u1785\u17b7\u1793\u200b\u1796\u17c1\u1789" },
            { "fi", metaValue_FI },
            { "FI", metaValue_FI },
            { "FJ", "\u17a0\u17d2\u179c\u17b8\u1787\u17b8" },
            { "fj", "\u17a0\u17ca\u17d2\u179c\u17b8\u1787\u17b8" },
            { "FK", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u1780\u17cb\u17a1\u17c2\u1793" },
            { "FM", "\u1798\u17b8\u1780\u17d2\u179a\u17bc\u1793\u17c1\u179f\u17ca\u17b8" },
            { "bgn", "\u1794\u17b6\u17a1\u17bc\u1787\u17b8\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "FO", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179c\u17b6\u179a\u17c9\u17bc" },
            { "fo", "\u17a0\u17d2\u179c\u17b6\u179a\u17bc\u179f" },
            { "Taml", metaValue_ta },
            { "fr", metaValue_FR },
            { "FR", metaValue_FR },
            { "fy", "\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u179f\u17ca\u17b6\u1793\u1781\u17b6\u1784\u179b\u17b7\u1785" },
            { "ga", metaValue_IE },
            { "GA", "\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784" },
            { "GB", "\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "GD", "\u17a0\u17d2\u1782\u17d2\u179a\u17b8\u178e\u17b6\u178a\u17b6" },
            { "gd", "\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782 (gd)" },
            { "GE", "\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8" },
            { "GF", "\u17a0\u17d2\u1782\u17c0\u178e\u17b6\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "GG", "\u17a0\u17d2\u1782\u17c1\u1793\u179f\u17ca\u17b8" },
            { "GH", "\u17a0\u17d2\u1782\u17b6\u178e\u17b6" },
            { "GI", "\u17a0\u17d2\u1782\u17b8\u1794\u17d2\u179a\u17b6\u179b\u178f\u17b6" },
            { "GL", "\u17a0\u17d2\u1782\u17d2\u179a\u17c4\u17a2\u1784\u17cb\u17a1\u1784\u17cb" },
            { "gl", "\u17a0\u17d2\u1782\u17b6\u179b\u17b8\u179f\u17d2\u1799\u17b6\u1793" },
            { "GM", "\u17a0\u17d2\u1782\u17b6\u17c6\u1794\u17ca\u17b8" },
            { "GN", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "gn", "\u17a0\u17d2\u1782\u17bc\u179a\u17c9\u17b6\u1793\u17b8" },
            { "GP", "\u17a0\u17d2\u1782\u17c4\u178a\u17ba\u17a1\u17bb\u1794" },
            { "GQ", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a" },
            { "und", "\u1797\u17b6\u179f\u17b6\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "GR", metaValue_GR },
            { "GS", "\u1780\u17c4\u17c7\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784 \u1793\u17b7\u1784\u200b\u179f\u17b6\u1793\u17cb\u179c\u17b7\u1785\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "GT", "\u17a0\u17d2\u1782\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6" },
            { "GU", "\u17a0\u17d2\u1782\u17b6\u17c6" },
            { "gu", "\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8" },
            { "gv", "\u1798\u17c1\u1793" },
            { "GW", "\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17bc" },
            { "GY", "\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u178e\u17b6" },
            { "ha", "\u17a0\u17bc\u179f\u17b6" },
            { "ckb", "\u1781\u17ba\u178a\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "zxx", "\u1782\u17d2\u1798\u17b6\u1793\u200b\u1791\u17b7\u1793\u17d2\u1793\u1793\u17d0\u1799\u200b\u1797\u17b6\u179f\u17b6" },
            { "he", metaValue_IL },
            { "hi", "\u17a0\u17b7\u178e\u17d2\u178c\u17b8" },
            { "HK", "\u17a0\u17bb\u1784\u1780\u17bb\u1784" },
            { "HM", "\u1780\u17c4\u17c7\u200b\u17a0\u17ba\u178a \u1793\u17b7\u1784\u200b\u1798\u17c9\u17b6\u1780\u17cb\u178a\u17bc\u178e\u17b6\u179b\u17cb" },
            { "HN", "\u17a0\u17bb\u1784\u178c\u17bd\u179a\u17c9\u17b6\u179f\u17cb" },
            { "hr", metaValue_HR },
            { "HR", metaValue_HR },
            { "agq", "\u17a2\u17b6\u17a0\u17d2\u1782\u17b8\u1798" },
            { "gsw", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784 (\u179f\u17d2\u179c\u17b8\u179f)" },
            { "ht", metaValue_HT },
            { "HT", metaValue_HT },
            { "hu", metaValue_HU },
            { "HU", metaValue_HU },
            { "hy", metaValue_AM },
            { "IC", "\u1780\u17c4\u17c7\u200b\u1780\u17b6\u178e\u17b6\u179a\u17b8" },
            { "id", metaValue_ID },
            { "ID", metaValue_ID },
            { "type.nu.tibt", "\u179b\u17c1\u1781\u1791\u17b8\u1794\u17c1" },
            { "IE", metaValue_IE },
            { "ig", "\u17a2\u17ca\u17b8\u1780\u1794\u17bc" },
            { "naq", "\u178e\u17b6\u1798\u17c9\u17b6" },
            { "ii", "\u179f\u17ca\u17b8\u1788\u17b6\u1793\u17cb\u1799\u17b8" },
            { "IL", metaValue_IL },
            { "IM", "\u17a2\u17c2\u179b\u17a2\u17bb\u17a0\u17d2\u179c\u1798\u17c2\u1793" },
            { "IN", "\u17a5\u178e\u17d2\u178c\u17b6" },
            { "IO", "\u178a\u17c2\u1793\u200b\u1798\u17a0\u17b6\u200b\u179f\u1798\u17bb\u1791\u17d2\u179a\u200b\u17a5\u178e\u17d2\u178c\u17b6 \u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "IQ", "\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb" },
            { "IR", "\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb" },
            { "is", metaValue_IS },
            { "IS", metaValue_IS },
            { "it", metaValue_IT },
            { "IT", metaValue_IT },
            { "iu", "\u17a2\u17ca\u17b8\u1793\u17bb\u1780\u1791\u17b8\u1791\u17bb\u178f" },
            { "type.nu.thai", "\u179b\u17c1\u1781\u200b\u1790\u17c3" },
            { "type.nu.beng", "\u179b\u17c1\u1781\u200b\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c2\u179f" },
            { "ja", metaValue_JP },
            { "Mlym", metaValue_ml },
            { "JE", "\u1787\u17ba\u179f\u17ca\u17b8" },
            { "type.ca.islamic", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a2\u17ca\u17b8\u179f\u17d2\u179b\u17b6\u1798" },
            { "Beng", metaValue_bn },
            { "JM", "\u1785\u17b6\u1798\u17c9\u17c3\u1780\u17b6" },
            { "JO", "\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8" },
            { "JP", metaValue_JP },
            { "sma", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "jv", "\u1787\u17d2\u179c\u17b6" },
            { "guz", "\u17a0\u17d2\u1782\u17bc\u179f\u17ca\u17b8" },
            { "type.nu.knda", "\u179b\u17c1\u1781\u1780\u1793\u17d2\u1793\u178a" },
            { "smj", "\u179b\u17bc\u179b\u17b8\u179f\u17b6\u1798\u17b8" },
            { "smn", "\u17a2\u17ca\u17b8\u178e\u17b6\u179a\u17b8\u179f\u17b6\u1798\u17c9\u17b8" },
            { "ka", "\u17a0\u17d2\u179f\u1780\u200b\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "type.ca.buddhist", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1780\u1796\u17bb\u1791\u17d2\u1792\u179f\u17b6\u179f\u1793\u17b6" },
            { "sms", "\u179f\u17d2\u1780\u17bb\u179b\u179f\u17b6\u1798\u17b8" },
            { "KE", "\u1780\u17c1\u1793\u1799\u17c9\u17b6" },
            { "KG", metaValue_KG },
            { "419", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u17a1\u17b6\u1791\u17b8\u1793" },
            { "KH", "\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6" },
            { "KI", "\u1782\u17b7\u179a\u17b7\u1794\u17b6\u1791\u17b8" },
            { "ki", "\u1782\u17b8\u1782\u17bc\u1799\u17bc" },
            { "mas", "\u1798\u17c9\u17b6\u179f\u17c3" },
            { "kk", metaValue_KZ },
            { "kl", "\u1780\u17b6\u17a1\u17b6\u179b\u179b\u17b8\u179f\u17ca\u17bb\u178f" },
            { "km", metaValue_km },
            { "KM", "\u1780\u17bb\u17c6\u1798\u17c9\u17bc\u179a\u17c9\u17bc\u179f" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u179f\u1784\u17cb\u1783\u17b8\u178f \u1793\u17b7\u1784\u200b\u178e\u17c1\u179c\u17b8\u179f" },
            { "ko", metaValue_ko },
            { "KP", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "KR", "\u1780\u17bc\u179a\u17c9\u17c1\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "ks", "\u1780\u17b6\u179f\u17d2\u1798\u17c0\u179a" },
            { "ku", "\u1783\u17ba\u178a" },
            { "KW", "\u1782\u17bb\u1799\u179c\u17c9\u17c2\u178f" },
            { "kw", "\u1780\u17bc\u1793\u17b8\u179f" },
            { "ky", metaValue_KG },
            { "KY", "\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1798\u17c9\u1784\u17cb" },
            { "KZ", metaValue_KZ },
            { "Cyrl", "\u179f\u17ca\u17b8\u179a\u17b8\u179b\u17b8\u1780" },
            { "LA", metaValue_LA },
            { "la", "\u17a1\u17b6\u178f\u17c6\u17b6\u1784" },
            { "lb", metaValue_LU },
            { "LB", "\u179b\u17b8\u1794\u1784\u17cb" },
            { "LC", "\u179f\u1784\u17cb\u200b\u179b\u17bc\u179f\u17c0" },
            { "type.nu.mlym", "\u179b\u17c1\u1781\u200b\u1798\u179b\u1799\u17b6\u179b\u17d0\u1798" },
            { "lg", "\u17a0\u17d2\u1782\u17b6\u1793\u17cb\u178a\u17b6" },
            { "nds", "\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb\u1780\u17d2\u179a\u17c4\u1798" },
            { "LI", "\u179b\u17b7\u1785\u1791\u17c1\u1793\u179f\u17d2\u178f\u17c2\u1793" },
            { "LK", metaValue_LK },
            { "Tibt", metaValue_bo },
            { "ln", "\u179b\u17b8\u1793\u1780\u17b6\u17a1\u17b6" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1785\u1780\u17d2\u179a\u1796\u17d0\u1791\u17d2\u1792" },
            { "LR", "\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "LS", "\u179b\u17be\u179f\u17bc\u178f\u17bc" },
            { "lt", metaValue_LT },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "lu", "\u179b\u17bc\u1794\u17b6\u1780\u17b6\u178f\u17b6\u1793\u17a0\u17d2\u1782\u17b6" },
            { "LV", "\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6" },
            { "lv", "\u17a1\u17b6\u178f\u179c\u17b8" },
            { "Kana", "\u1780\u17b6\u178f\u17b6\u1780\u17b6\u178e\u17b6" },
            { "LY", "\u179b\u17b8\u1794\u17ca\u17b8" },
            { "vun", "\u179c\u17bb\u1793\u1785\u17bc" },
            { "lag", "\u17a1\u17b6\u1793\u17a0\u17d2\u1782\u17b8" },
            { "Thaa", "\u1790\u17b6\u178e\u17b6" },
            { "MA", metaValue_MA },
            { "MC", "\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc" },
            { "MD", "\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8" },
            { "ME", "\u1798\u17c9\u17bb\u1784\u178f\u17c1\u178e\u17c1\u17a0\u17d2\u1782\u17d2\u179a\u17c4" },
            { "MF", "\u179f\u1784\u17cb\u200b\u1798\u17c9\u17b6\u1791\u17b8\u1793" },
            { "MG", "\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u17d2\u1780\u17b6\u179a" },
            { "mg", "\u1798\u17c9\u17b6\u17a1\u17b6\u17a0\u17d2\u1782\u17b6\u179f\u17ca\u17b8" },
            { "Thai", metaValue_TH },
            { "MH", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179f\u17cb\u179f\u179b" },
            { "type.co.ducet", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u1799\u17bc\u1793\u17b8\u1780\u17bc\u178a\u200b\u179b\u17c6\u1793\u17b6\u17c6\u178a\u17be\u1798" },
            { "mi", "\u1798\u17c9\u17c4\u179a\u17b8" },
            { "MK", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b6" },
            { "mk", "\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8" },
            { "ml", metaValue_ml },
            { "ML", "\u1798\u17c9\u17b6\u179b\u17b8" },
            { "MM", "\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6 (\u1797\u17bc\u1798\u17b6)" },
            { "mn", metaValue_MN },
            { "MN", metaValue_MN },
            { "MO", "\u1798\u17c9\u17b6\u1780\u17b6\u179c" },
            { "MP", "\u1780\u17c4\u17c7\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17b6\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "MQ", "\u1798\u17c9\u17b6\u1791\u17b8\u1793\u17b8\u1780" },
            { "MR", "\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8" },
            { "mr", "\u1798\u17c9\u17b6\u179a\u17c9\u17b6\u1792\u17b8" },
            { "ms", metaValue_MY },
            { "MS", "\u1798\u17c9\u17bb\u1784\u200b\u179f\u17c1\u179a\u17c9\u1784\u17cb" },
            { "mt", metaValue_MT },
            { "MT", metaValue_MT },
            { "MU", "\u1798\u17c9\u17bc\u179a\u17b8\u1791\u17bb\u179f" },
            { "MV", "\u1798\u17c9\u17b6\u179b\u17cb\u178c\u17b8\u179c" },
            { "MW", "\u1798\u17c9\u17b6\u17a1\u17b6\u179c\u17b8" },
            { "MX", "\u1798\u17c9\u17b7\u1785\u179f\u17b7\u1780" },
            { "type.ca.japanese", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "MY", metaValue_MY },
            { "my", metaValue_my },
            { "MZ", "\u1798\u17c9\u17bc\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b7\u1780" },
            { "Armn", "\u17a2\u17b6\u1798\u17c9\u17b6\u1793\u17b8" },
            { "dsb", "\u179f\u17bc\u1794\u17ca\u17b8\u1780\u17d2\u179a\u17c4\u1798" },
            { "NA", "\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8" },
            { "type.co.search", "\u179f\u17d2\u179c\u17c2\u1784\u179a\u1780\u200b\u1791\u17bc\u1791\u17c5" },
            { "nb", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1794\u17bb\u1780\u1798\u17c9\u17b6\u179b\u17cb" },
            { "type.ca.hebrew", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u17a0\u17c1\u1794\u17d2\u179a\u17ba" },
            { "NC", "\u1789\u17bc\u1780\u17b6\u17a1\u17c1\u178a\u17bc\u1793\u17c0" },
            { "nd", "\u1793\u17c1\u1794\u17c1\u179b\u17c1\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "ne", metaValue_NP },
            { "NE", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a" },
            { "NF", "\u1780\u17c4\u17c7\u200b\u178e\u17d0\u179a\u17a0\u17d2\u179c\u1780\u17cb" },
            { "NG", "\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6" },
            { "NI", "\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17d0\u179a" },
            { "nl", metaValue_NL },
            { "NL", metaValue_NL },
            { "nn", "\u1793\u17d0\u179a\u179c\u17c2\u179f \u1793\u17b8\u1793\u17bc\u179f" },
            { "NO", "\u1793\u17d0\u179a\u179c\u17c2\u179f" },
            { "no", "\u1797\u17b6\u179f\u17b6\u1793\u17d0\u179a\u179c\u17c2\u179f" },
            { "NP", metaValue_NP },
            { "NR", "\u178e\u17bc\u179a\u17bc" },
            { "NU", "\u178e\u17c0" },
            { "rof", "\u179a\u17bb\u1798\u1794\u17bc" },
            { "NZ", "\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u179f\u17c1\u17a1\u1784\u17cb" },
            { "kab", "\u1780\u17b6\u1794\u17ca\u17b8\u17a1\u17c1" },
            { "kam", "\u1780\u17b6\u17c6\u1794\u17b6" },
            { "mer", "\u1798\u17c1\u179a\u17bc" },
            { "type.nu.armn", "\u179b\u17c1\u1781\u200b\u17a2\u17b6\u1798\u17c1\u1793\u17b8" },
            { "OM", "\u17a2\u17bc\u1798\u17c9\u1784\u17cb" },
            { "om", "\u17a2\u17bc\u179a\u17c9\u17bc\u1798\u17c9\u17bc" },
            { "or", metaValue_or },
            { "mfe", "\u1798\u17c9\u17bc\u179a\u17b8\u179f\u17ca\u17b8\u1793" },
            { "PA", "\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6" },
            { "pa", "\u1794\u17b9\u1793\u1787\u17b6\u1796\u17b7" },
            { "dua", "\u178c\u17bc\u17a2\u17b6\u17a1\u17b6" },
            { "PE", "\u1794\u17c9\u17c1\u179a\u17bc" },
            { "PF", "\u1794\u17c9\u17bc\u179b\u17b8\u200b\u178e\u17c1\u179f\u17ca\u17b8\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784" },
            { "PG", "\u1794\u17c9\u17b6\u1796\u17bd\u1789\u17c9\u17bc\u17a0\u17d2\u1782\u17b8\u178e\u17c1" },
            { "PH", metaValue_PH },
            { "PK", "\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793" },
            { "pl", metaValue_PL },
            { "PL", metaValue_PL },
            { "PM", "\u179f\u1784\u17cb\u1796\u17d2\u1799\u17c2\u179a \u1793\u17b7\u1784\u200b\u1798\u17b8\u1782\u17b8\u17a1\u17bb\u1784" },
            { "PN", "\u1780\u17c4\u17c7\u200b\u1797\u17b8\u178f\u1781\u17b6\u179a\u17b7\u1793" },
            { "type.ca.dangi", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1780\u17bc\u179a\u17c9\u17c1" },
            { "PR", "\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc" },
            { "PS", "\u178a\u17c2\u1793\u200b\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793" },
            { "ps", "\u1794\u17b6\u179f\u17d2\u178f\u17bc" },
            { "pt", metaValue_PT },
            { "PT", metaValue_PT },
            { "key.co", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794" },
            { "PW", "\u1795\u17c5\u17a1\u17bc" },
            { "type.nu.greklow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u1780\u17d2\u179a\u17b7\u1780" },
            { "PY", "\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "Hebr", metaValue_IL },
            { "mgh", "\u1798\u17c9\u17b6\u1780\u1782\u17bc\u179c\u17c9\u17b6\u1798\u17b8\u178f\u17bc" },
            { "QA", "\u1780\u17b6\u178f\u17b6" },
            { "key.ca", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793" },
            { "Laoo", metaValue_LA },
            { "mgo", "\u1798\u17c1\u178f\u17b6" },
            { "type.hc.h23", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (0\u201323)" },
            { "type.hc.h24", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 24 \u1798\u17c9\u17c4\u1784 (1\u201324)" },
            { "type.nu.mymr", "\u179b\u17c1\u1781\u200b\u1797\u17bc\u1798\u17b6" },
            { "QO", "\u178f\u17c6\u1794\u1793\u17cb\u1787\u17b6\u1799\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "qu", "\u1780\u17c1\u1791\u1787\u17bd\u17a2\u17b6" },
            { "brx", "\u1794\u17bc\u178a\u17bc" },
            { "kde", "\u1798\u17c9\u17b6\u1780\u17bc\u1793\u178a\u17c1" },
            { "Ethi", metaValue_ET },
            { "001", "\u1796\u17b7\u1797\u1796\u179b\u17c4\u1780" },
            { "002", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780" },
            { "003", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "RE", "\u179a\u17c9\u17c1\u17a2\u17ca\u17bb\u1799\u17c9\u17bb\u1784" },
            { "type.hc.h12", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (1\u201312)" },
            { "005", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "type.hc.h11", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792 12 \u1798\u17c9\u17c4\u1784 (0\u201311)" },
            { "009", "\u17a2\u17bc\u179f\u17c1\u17a2\u17b6\u1793\u17b8" },
            { "rm", "\u179a\u17c9\u17bc\u1798\u17c9\u1784\u17cb" },
            { "rn", "\u179a\u17bc\u1793\u17d2\u178c\u17b8" },
            { "key.cu", "\u179a\u17bc\u1794\u17b7\u1799\u1794\u17d0\u178e\u17d2\u178e" },
            { "ro", metaValue_RO },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "type.nu.orya", "\u179b\u17c1\u1781\u200b\u17a2\u17bc\u179a\u17b8\u1799\u17c9\u17b6" },
            { "type.nu.hanidec", "\u179b\u17c1\u1781\u200b\u1791\u179f\u1797\u17b6\u1782\u200b\u1785\u17b7\u1793" },
            { "ru", metaValue_RU },
            { "RU", metaValue_RU },
            { "RW", "\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "rw", "\u1782\u17b7\u1793\u1799\u17c9\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6" },
            { "kea", "\u1780\u17b6\u1794\u17ca\u17bc\u179c\u17ba\u178c\u17c0\u1793\u17bc" },
            { "SA", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17ca\u17bc\u178c\u17b8\u178f" },
            { "sa", "\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f" },
            { "SB", "\u1780\u17c4\u17c7\u200b\u179f\u17ca\u17bc\u17a1\u17bc\u1798\u17c9\u17bb\u1784" },
            { "twq", "\u178f\u17b6\u179f\u17b6\u179c\u17c9\u17b6\u1780\u17cb" },
            { "011", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "SC", "\u179f\u17b8\u179f\u17c2\u179b" },
            { "SD", metaValue_SD },
            { "sd", "\u179f\u17ca\u17b8\u1793\u178c\u17b8" },
            { "SE", metaValue_SE },
            { "013", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "se", "\u179f\u17b6\u1798\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "014", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u1780\u17be\u178f" },
            { "015", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "SG", "\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8" },
            { "sg", "\u179f\u17b6\u1793\u17a0\u17d2\u1782\u17c4" },
            { "SH", "\u179f\u1784\u17cb\u200b\u17a0\u17c1\u17a1\u17c1\u178e\u17b6" },
            { "type.lb.strict", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u178f\u17b9\u1784\u179a\u17b9\u1784" },
            { "si", metaValue_LK },
            { "017", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u200b\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "SI", "\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8" },
            { "018", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1797\u17b6\u1782\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "SJ", "\u179f\u17d2\u179c\u17b6\u1794\u17ca\u17ba\u178f \u1793\u17b7\u1784\u200b\u17a0\u17d2\u1799\u1784\u17cb\u1798\u17c9\u17b6\u1799\u17c1\u1793" },
            { "sk", metaValue_SK },
            { "SK", metaValue_SK },
            { "019", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "SL", "\u179f\u17c1\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793" },
            { "sl", "\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8" },
            { "SM", "\u179f\u17b6\u1793\u200b\u1798\u17c9\u17b6\u179a\u17b8\u178e\u17bc" },
            { "sm", "\u1797\u17b6\u179f\u17b6\u179f\u17b6\u1798\u17bc\u17a2\u17b6" },
            { "SN", "\u179f\u17c1\u1793\u17c1\u17a0\u17d2\u1780\u17b6\u179b\u17cb" },
            { "sn", "\u179f\u17bc\u178e\u17b6" },
            { "so", metaValue_SO },
            { "SO", metaValue_SO },
            { "arn", "\u1798\u17c9\u17b6\u1796\u17bc\u1788\u17b8" },
            { "type.nu.arab", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb" },
            { "sq", metaValue_AL },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "sr", metaValue_RS },
            { "SR", "\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798" },
            { "ListKeyTypePattern", "{0}\u17d6 {1}" },
            { "SS", "\u179f\u17ca\u17bc\u178a\u1784\u17cb\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "ST", "\u179f\u17c5\u200b\u178f\u17bc\u1798\u17c1 \u1793\u17b7\u1784\u200b\u1796\u17d2\u179a\u17b8\u1793\u179f\u17ca\u17b8\u1794\u17c9\u17c1" },
            { "su", metaValue_SD },
            { "sv", metaValue_SE },
            { "SV", "\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a" },
            { "sw", "\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "SX", "\u179f\u17b8\u1784\u200b\u1798\u17c9\u17b6\u1792\u17b8\u1793" },
            { "SY", "\u179f\u17ca\u17b8\u179a\u17b8" },
            { "type.nu.hantfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "SZ", "\u179f\u17d2\u179c\u17b6\u17a0\u17d2\u179f\u17ca\u17b8\u17a1\u1784\u17cb" },
            { "ta", metaValue_ta },
            { "TA", "\u1791\u17d2\u179a\u17b8\u179f\u17d2\u178f\u1784\u17cb\u200b\u178a\u17b6\u200b\u1785\u17bc\u1793\u17a0\u17b6" },
            { "asa", "\u17a2\u17b6\u179f\u17ca\u17bc" },
            { "type.ms.ussystem", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "021", "\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780\u200b\u1797\u17b6\u1782\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "142", "\u17a2\u17b6\u179f\u17ca\u17b8" },
            { "TC", "\u1780\u17c4\u17c7\u200b\u1780\u17c3\u1780\u17bc\u179f \u1793\u17b7\u1784\u1791\u17bc\u1780" },
            { "143", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1780\u178e\u17d2\u178a\u17b6\u179b" },
            { "TD", "\u1786\u17b6\u178a" },
            { "te", metaValue_te },
            { "145", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "TF", "\u178a\u17c2\u1793\u200b\u1794\u17b6\u179a\u17b6\u17c6\u1784\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "TG", "\u178f\u17bc\u17a0\u17d2\u1782\u17c4" },
            { "tg", "\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "th", metaValue_TH },
            { "TH", metaValue_TH },
            { "ti", "\u1791\u17b8\u179a\u17b7\u1793\u1799\u17b6" },
            { "TJ", "\u178f\u17b6\u1787\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb" },
            { "tk", metaValue_TM },
            { "029", "\u1780\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u1793" },
            { "TK", "\u178f\u17bc\u1781\u17c1\u17a1\u17c5" },
            { "TL", "\u1791\u17b8\u1798\u17d0\u179a" },
            { "TM", metaValue_TM },
            { "TN", "\u1791\u17bb\u1799\u1793\u17c1\u179f\u17ca\u17b8" },
            { "TO", "\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6" },
            { "to", "\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4" },
            { "dyo", "\u1785\u17bc\u17a1\u17b6\u17a0\u17ca\u17d2\u179c\u17bb\u1793\u1799\u17b8" },
            { "type.nu.jpan", "\u179b\u17c1\u1781\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "tr", metaValue_TR },
            { "TR", metaValue_TR },
            { "TT", "\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178f \u1793\u17b7\u1784\u200b\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4" },
            { "tt", "\u178f\u17b6\u178f\u17b6" },
            { "TV", "\u1791\u17bc\u179c\u17c9\u17b6\u179b\u17bc" },
            { "TW", "\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb" },
            { "TZ", "\u178f\u1784\u17cb\u17a0\u17d2\u179f\u17b6\u1793\u17b8" },
            { "nmg", "\u1780\u17d2\u179c\u17b6\u179f\u17d2\u1799\u17bc" },
            { "Zzzz", "\u17a2\u1780\u17d2\u179f\u179a\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "UA", metaValue_UA },
            { "150", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794" },
            { "030", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "151", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1780\u17be\u178f" },
            { "154", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u1787\u17be\u1784" },
            { "sw_CD", "\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179f\u17d2\u179c\u17b6\u17a0\u17ca\u17b8\u179b\u17b8" },
            { "034", "\u17a2\u17b6\u179f\u17ca\u17b8\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "155", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u179b\u17b7\u1785" },
            { "035", "\u17a2\u17b6\u179f\u17ca\u17b8\u17a2\u17b6\u1782\u17d2\u1793\u17c1\u1799\u17cd" },
            { "UG", "\u17a2\u17ca\u17bc\u17a0\u17d2\u1780\u1784\u17cb\u178a\u17b6" },
            { "ug", "\u17a2\u17ca\u17bb\u1799\u17a0\u17d2\u1782\u17ba\u179a" },
            { "Kore", metaValue_ko },
            { "Zyyy", "\u1791\u17bc\u1791\u17c5" },
            { "uk", metaValue_UA },
            { "039", "\u17a2\u17ba\u179a\u17c9\u17bb\u1794\u200b\u1781\u17b6\u1784\u200b\u178f\u17d2\u1794\u17bc\u1784" },
            { "Sinh", "\u179f\u17ca\u17b8\u1793\u17a0\u17b6\u17a1\u17b6" },
            { "UM", "\u1780\u17c4\u17c7\u200b\u17a2\u17c5\u17a1\u17b6\u1799\u17b8\u1784\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "ur", "\u17a2\u17ca\u17bc\u179a\u178c\u17bc" },
            { "US", "\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "haw", "\u17a0\u17b6\u179c\u17c3" },
            { "UY", "\u17a2\u17ca\u17bb\u1799\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799" },
            { "uz", metaValue_UZ },
            { "UZ", metaValue_UZ },
            { "tzm", "\u178f\u17b6\u1798\u17c9\u17b6\u179f\u17b6\u1799\u17a2\u17b6\u178f\u17d2\u179b\u17b6\u179f\u1780\u178e\u17d2\u178f\u17b6\u179b" },
            { "VA", "\u1791\u17b8\u1780\u17d2\u179a\u17bb\u1784\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb" },
            { "nds_NL", "\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u1799\u17bb\u1784\u1780\u17d2\u179a\u17c4\u1798" },
            { "VC", "\u179f\u17b6\u17c6\u1784\u200b\u179c\u17b8\u1793\u179f\u17c1\u1793 \u1793\u17b7\u1784\u200b\u178c\u17b9\u200b\u17a0\u17d2\u1782\u17d2\u179a\u17b8\u178e\u17b6\u178c\u17b8\u1793\u17b8\u179f" },
            { "VE", "\u179c\u17c1\u1793\u17c1\u17a0\u17d2\u179f\u17ca\u17bb\u1799\u17a1\u17b6" },
            { "type.ca.roc", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793\u1798\u17b8\u1784\u1782\u17d0\u179a" },
            { "VG", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b7\u1793\u200b\u1785\u1780\u17d2\u179a\u1797\u1796\u200b\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f" },
            { "vi", metaValue_VN },
            { "VI", "\u1780\u17c4\u17c7\u200b\u179c\u17ba\u1787\u17b8\u1793\u200b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780" },
            { "khq", "\u1782\u17bb\u1799\u179a\u17c9\u17b6\u1788\u17b8\u1793\u17b8" },
            { "key.hc", "\u179c\u178a\u17d2\u178f\u1798\u17c9\u17c4\u1784 (12 vs 24)" },
            { "VN", metaValue_VN },
            { "quc", "\u1782\u17b8\u1785\u1788\u17b8" },
            { "VU", "\u179c\u17c9\u17b6\u1793\u17bc\u17a2\u17b6\u1791\u17bc" },
            { "rwk", "\u179a\u17c9\u17d2\u179c\u17b6" },
            { "gag", "\u1780\u17b6\u1782\u17bc\u179f" },
            { "053", "\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u17a1\u17b6\u179f\u17ca\u17b8" },
            { "054", "\u1798\u17c1\u17a1\u17b6\u178e\u17c1\u179f\u17ca\u17b8" },
            { "WF", "\u179c\u17c9\u17b6\u179b\u17b8\u179f \u1793\u17b7\u1784\u200b\u17a0\u17d2\u179c\u17bc\u1791\u17bc\u178e\u17b6" },
            { "Grek", metaValue_GR },
            { "057", "\u178f\u17c6\u1794\u1793\u17cb\u200b\u1798\u17b8\u1780\u17d2\u179a\u17bc\u178e\u17c1\u179f\u17ca\u17b8" },
            { "jgo", "\u1784\u17bb\u17c6\u1794\u17b6" },
            { "lkt", "\u17a1\u17b6\u1780\u17bc\u178f\u17b6" },
            { "wo", "\u179c\u17bc\u17a1\u17bb\u17a0\u17d2\u179c" },
            { "zgh", metaValue_MA },
            { "ar_001", "\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u1795\u17d2\u179b\u17bc\u179c\u1780\u17b6\u179a" },
            { "WS", "\u179f\u17b6\u200b\u1798\u17c9\u17bc\u17a2\u17b6" },
            { "Mong", metaValue_MN },
            { "061", "\u1794\u17c9\u17bc\u179b\u17b8\u178e\u17c1\u179f\u17ca\u17b8" },
            { "Latn", "\u17a1\u17b6\u178f\u17b6\u17c6\u1784" },
            { "type.nu.hans", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "type.nu.hant", "\u179b\u17c1\u1781\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "xh", "\u1783\u179f\u17b6" },
            { "XK", "\u1780\u17bc\u179f\u17bc\u179c\u17c9\u17bc" },
            { "type.nu.romanlow", "\u179b\u17c1\u1781\u200b\u178f\u17bc\u1785\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "Gujr", "\u1782\u17bc\u1785\u17b6\u179a\u17c9\u17b6\u1791\u17b8" },
            { "Zxxx", "\u1782\u17d2\u1798\u17b6\u1793\u1780\u17b6\u179a\u179f\u179a\u179f\u17c1\u179a" },
            { "wbp", "\u179c\u17c9\u17b6\u179a\u17b8\u1794\u17c9\u17b6\u179a\u17b8" },
            { "moh", "\u1798\u17ca\u17bc\u17a0\u17b6\u1782" },
            { "YE", "\u1799\u17c1\u1798\u17c2\u1793" },
            { "nqo", "\u1793\u1782\u17c4" },
            { "type.co.standard", "\u179b\u17c6\u178a\u17b6\u1794\u17cb\u200b\u178f\u1798\u17d2\u179a\u17c0\u1794\u200b\u179f\u17d2\u178f\u1784\u17cb\u178a\u17b6\u179a" },
            { "yi", "\u1797\u17b6\u179f\u17b6\u1799\u17b8\u178c\u17b8\u17a0\u17d2\u179f" },
            { "yo", "\u1799\u179a\u17bc\u1794\u17b6" },
            { "YT", "\u1798\u17c9\u17b6\u1799\u17bb\u178f" },
            { "vai", "\u179c\u17c3" },
            { "ZA", "\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784" },
            { "za", "\u1797\u17b6\u179f\u17b6\u1785\u17bd\u1784" },
            { "type.lb.loose", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb\u1781\u17d2\u179b\u17b8" },
            { "kln", "\u1780\u17b6\u179b\u17c2\u1793\u1787\u17b8\u1793" },
            { "Deva", "\u178a\u17b6\u179c\u17c9\u17b6\u1793\u17cb\u178e\u17b6\u1780\u17b6\u179a\u17b7" },
            { "zh", metaValue_CN },
            { "type.nu.geor", "\u179b\u17c1\u1781\u200b\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17b8" },
            { "Hira", "\u17a0\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17b6\u178e\u17b6" },
            { "ZM", "\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b8" },
            { "Bopo", "\u1794\u17bc\u1795\u17bc\u1798\u17c9\u17bc\u17a0\u17d2\u179c\u17bc" },
            { "key.lb", "\u179a\u1794\u17c0\u1794\u1785\u17bb\u17c7\u1794\u1793\u17d2\u1791\u17b6\u178f\u17cb" },
            { "zu", "\u179f\u17bc\u179b\u17bc" },
            { "ZW", "\u17a0\u17d2\u179f\u17ca\u17b8\u1798\u1794\u17b6\u179c\u17c9\u17c1" },
            { "ZZ", "\u178f\u17c6\u1794\u1793\u17cb\u1798\u17b7\u1793\u179f\u17d2\u1782\u17b6\u179b\u17cb" },
            { "Geor", "\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17ca\u17b8" },
            { "type.ms.metric", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784\u1798\u17c9\u17b6\u1791\u17d2\u179a\u17b7\u1780" },
            { "type.ca.iso8601", "\u1794\u17d2\u179a\u178f\u17b7\u1791\u17b7\u1793 ISO-8601" },
            { "type.nu.telu", "\u179b\u17c1\u1781\u200b\u178f\u17c1\u179b\u17bb\u1782\u17bb" },
            { "type.nu.jpanfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1787\u1794\u17c9\u17bb\u1793" },
            { "ebu", "\u17a2\u17c1\u1798\u1794\u17ca\u17bc" },
            { "jmc", "\u1798\u17c9\u17b6\u1786\u17b6\u17c6" },
            { "zh_Hans", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "koi", "\u1782\u17bc\u1798\u17b8\u1797\u17b9\u1798\u1799\u17c9\u17b6\u1782" },
            { "type.nu.hansfin", "\u179b\u17c1\u1781\u200b\u17a0\u17b7\u179a\u1789\u17d2\u1789\u179c\u178f\u17d2\u1790\u17bb\u200b\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1780\u17b6\u178f\u17cb" },
            { "kok", "\u1782\u17bb\u1793\u1780\u17b6\u1793\u17b8" },
            { "type.nu.arabext", "\u179b\u17c1\u1781\u200b\u17a5\u178e\u17d2\u178c\u17b6-\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u200b\u1796\u1784\u17d2\u179a\u17b8\u1780" },
            { "nus", "\u1793\u17bc\u17a2\u17d0\u179a" },
            { "type.nu.fullwide", "\u179b\u17c1\u1781\u200b\u1791\u1791\u17b9\u1784\u200b\u1796\u17c1\u1789" },
            { "dav", "\u178f\u17c3\u178f\u17b6" },
            { "lrc", "\u179b\u17bc\u179a\u17b8\u1781\u17b6\u1784\u1787\u17be\u1784" },
            { "zh_Hant", "\u1785\u17b7\u1793\u200b\u17a2\u1780\u17d2\u179f\u179a\u200b\u1796\u17c1\u1789" },
            { "type.nu.khmr", "\u179b\u17c1\u1781\u200b\u1781\u17d2\u1798\u17c2\u179a" },
            { "mua", "\u1798\u17bb\u1793\u178a\u17b6\u1784" },
            { "type.nu.guru", "\u179b\u17c1\u1781\u200b\u1780\u17bb\u1798\u17bb\u1783\u17b8" },
            { "Khmr", metaValue_km },
            { "key.ms", "\u1794\u17d2\u179a\u1796\u17d0\u1793\u17d2\u1792\u179c\u17b6\u179f\u17cb\u179c\u17c2\u1784" },
            { "type.nu.roman", "\u179b\u17c1\u1781\u200b\u179a\u17c9\u17bc\u1798\u17b6\u17c6\u1784" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "saq", "\u179f\u17b6\u1798\u1794\u17bc\u179a\u17bc" },
            { "key.nu", "\u179b\u17c1\u1781" },
            { "Guru", "\u1780\u17bb\u1798\u17bb\u1799\u1783\u17b8" },
            { "ksb", "\u179f\u17b6\u1798\u1794\u17b6\u17a1\u17b6" },
            { "Telu", metaValue_te },
            { "ksf", "\u1794\u17b6\u17a0\u17d2\u179c\u17c0" },
        };
        return data;
    }
}
