/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CorbaResourceUtil {
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public static String getString(String key) {
        if (!resourcesInitialized) {
            CorbaResourceUtil.initResources();
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getText(String key) {
        String message = CorbaResourceUtil.getString(key);
        if (message == null) {
            message = "no text found: \"" + key + "\"";
        }
        return message;
    }

    public static String getText(String key, int num) {
        return CorbaResourceUtil.getText(key, Integer.toString(num), null, null);
    }

    public static String getText(String key, String arg0) {
        return CorbaResourceUtil.getText(key, arg0, null, null);
    }

    public static String getText(String key, String arg0, String arg1) {
        return CorbaResourceUtil.getText(key, arg0, arg1, null);
    }

    public static String getText(String key, String arg0, String arg1, String arg2) {
        String format = CorbaResourceUtil.getString(key);
        if (format == null) {
            format = "no text found: key = \"" + key + "\", " + "arguments = \"{0}\", \"{1}\", \"{2}\"";
        }
        String[] args = new String[]{arg0 != null ? arg0.toString() : "null", arg1 != null ? arg1.toString() : "null", arg2 != null ? arg2.toString() : "null"};
        return MessageFormat.format(format, args);
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("com.sun.corba.se.impl.orbutil.resources.sunorb");
            resourcesInitialized = true;
        }
        catch (MissingResourceException e) {
            throw new Error("fatal: missing resource bundle: " + e.getClassName());
        }
    }
}

