/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Elevatable;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Label;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.ObserverCamera;
import com.eteks.sweethome3d.model.Polyline;
import com.eteks.sweethome3d.model.Room;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.model.Wall;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.Home3DAttributesController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.undo.UndoableEditSupport;

public class HomeController3D
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View home3DView;
    private final CameraControllerState topCameraState;
    private final CameraControllerState observerCameraState;
    private CameraControllerState cameraState;

    public HomeController3D(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.topCameraState = new TopCameraState(userPreferences);
        this.observerCameraState = new ObserverCameraState();
        this.setCameraState(home.getCamera() == home.getTopCamera() ? this.topCameraState : this.observerCameraState);
        this.addModelListeners(home);
    }

    private void addModelListeners(final Home home) {
        home.addPropertyChangeListener(Home.Property.CAMERA, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeController3D.this.setCameraState(home.getCamera() == home.getTopCamera() ? HomeController3D.this.topCameraState : HomeController3D.this.observerCameraState);
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) && home.getEnvironment().isObserverCameraElevationAdjusted()) {
                    home.getObserverCamera().setZ(Math.max(HomeController3D.this.getObserverCameraMinimumElevation(home), home.getObserverCamera().getZ() + ((Float)propertyChangeEvent.getNewValue()).floatValue() - ((Float)propertyChangeEvent.getOldValue()).floatValue()));
                }
            }
        };
        Level level = home.getSelectedLevel();
        if (level != null) {
            level.addPropertyChangeListener(propertyChangeListener);
        }
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Level level = (Level)propertyChangeEvent.getOldValue();
                Level level2 = home.getSelectedLevel();
                if (home.getEnvironment().isObserverCameraElevationAdjusted()) {
                    home.getObserverCamera().setZ(Math.max(HomeController3D.this.getObserverCameraMinimumElevation(home), home.getObserverCamera().getZ() + (level2 == null ? 0.0f : level2.getElevation()) - (level == null ? 0.0f : level.getElevation())));
                }
                if (level != null) {
                    level.removePropertyChangeListener(propertyChangeListener);
                }
                if (level2 != null) {
                    level2.addPropertyChangeListener(propertyChangeListener);
                }
            }
        });
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                List<Level> list = home.getLevels();
                Level level = home.getSelectedLevel();
                boolean bl = true;
                for (int i = 0; i < list.size(); ++i) {
                    list.get(i).setVisible(bl);
                    if (list.get(i) != level || home.getEnvironment().isAllLevelsVisible()) continue;
                    bl = false;
                }
            }
        };
        home.addPropertyChangeListener(Home.Property.SELECTED_LEVEL, propertyChangeListener2);
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.ALL_LEVELS_VISIBLE, propertyChangeListener2);
    }

    private float getObserverCameraMinimumElevation(Home home) {
        List<Level> list = home.getLevels();
        float f = list.size() == 0 ? 10.0f : 10.0f + list.get(0).getElevation();
        return f;
    }

    @Override
    public View getView() {
        if (this.home3DView == null) {
            this.home3DView = this.viewFactory.createView3D(this.home, this.preferences, this);
        }
        return this.home3DView;
    }

    public void viewFromTop() {
        this.home.setCamera(this.home.getTopCamera());
    }

    public void viewFromObserver() {
        this.home.setCamera(this.home.getObserverCamera());
    }

    public void storeCamera(String string) {
        Camera camera = this.home.getCamera().clone();
        camera.setName(string);
        List<Camera> list = this.home.getStoredCameras();
        ArrayList<Camera> arrayList = new ArrayList<Camera>(list.size() + 1);
        arrayList.addAll(list);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Camera camera2 = (Camera)arrayList.get(i);
            if (!string.equals(camera2.getName()) && (camera.getX() != camera2.getX() || camera.getY() != camera2.getY() || camera.getZ() != camera2.getZ() || camera.getPitch() != camera2.getPitch() || camera.getYaw() != camera2.getYaw() || camera.getFieldOfView() != camera2.getFieldOfView() || camera.getTime() != camera2.getTime() || camera.getLens() != camera2.getLens())) continue;
            arrayList.remove(i);
        }
        arrayList.add(0, camera);
        while (arrayList.size() > this.preferences.getStoredCamerasMaxCount()) {
            arrayList.remove(arrayList.size() - 1);
        }
        this.home.setStoredCameras(arrayList);
    }

    public void goToCamera(Camera camera) {
        if (camera instanceof ObserverCamera) {
            this.viewFromObserver();
        } else {
            this.viewFromTop();
        }
        this.cameraState.goToCamera(camera);
        ArrayList<Camera> arrayList = new ArrayList<Camera>(this.home.getStoredCameras());
        arrayList.remove(camera);
        arrayList.add(0, camera);
        this.home.setStoredCameras(arrayList);
    }

    public void deleteCameras(List<Camera> list) {
        List<Camera> list2 = this.home.getStoredCameras();
        ArrayList<Camera> arrayList = new ArrayList<Camera>(list2.size() - list.size());
        for (Camera camera : list2) {
            if (list.contains(camera)) continue;
            arrayList.add(camera);
        }
        this.home.setStoredCameras(arrayList);
    }

    public void displayAllLevels() {
        this.home.getEnvironment().setAllLevelsVisible(true);
    }

    public void displaySelectedLevel() {
        this.home.getEnvironment().setAllLevelsVisible(false);
    }

    public void modifyAttributes() {
        new Home3DAttributesController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    protected void setCameraState(CameraControllerState cameraControllerState) {
        if (this.cameraState != null) {
            this.cameraState.exit();
        }
        this.cameraState = cameraControllerState;
        this.cameraState.enter();
    }

    public void moveCamera(float f) {
        this.cameraState.moveCamera(f);
    }

    public void moveCameraSideways(float f) {
        this.cameraState.moveCameraSideways(f);
    }

    public void elevateCamera(float f) {
        this.cameraState.elevateCamera(f);
    }

    public void rotateCameraYaw(float f) {
        this.cameraState.rotateCameraYaw(f);
    }

    public void rotateCameraPitch(float f) {
        this.cameraState.rotateCameraPitch(f);
    }

    public void modifyFieldOfView(float f) {
        this.cameraState.modifyFieldOfView(f);
    }

    protected CameraControllerState getObserverCameraState() {
        return this.observerCameraState;
    }

    protected CameraControllerState getTopCameraState() {
        return this.topCameraState;
    }

    private class ObserverCameraState
    extends CameraControllerState {
        private ObserverCamera observerCamera;
        private PropertyChangeListener levelElevationChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Level.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName())) {
                    ObserverCameraState.this.updateCameraMinimumElevation();
                }
            }
        };
        private CollectionListener<Level> levelsListener = new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(ObserverCameraState.this.levelElevationChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(ObserverCameraState.this.levelElevationChangeListener);
                }
                ObserverCameraState.this.updateCameraMinimumElevation();
            }
        };

        private ObserverCameraState() {
        }

        @Override
        public void enter() {
            this.observerCamera = (ObserverCamera)HomeController3D.this.home.getCamera();
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.addPropertyChangeListener(this.levelElevationChangeListener);
            }
            HomeController3D.this.home.addLevelsListener(this.levelsListener);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void moveCamera(float f) {
            this.observerCamera.setX(this.observerCamera.getX() - (float)Math.sin(this.observerCamera.getYaw()) * f);
            this.observerCamera.setY(this.observerCamera.getY() + (float)Math.cos(this.observerCamera.getYaw()) * f);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void moveCameraSideways(float f) {
            this.observerCamera.setX(this.observerCamera.getX() - (float)Math.cos(this.observerCamera.getYaw()) * f);
            this.observerCamera.setY(this.observerCamera.getY() - (float)Math.sin(this.observerCamera.getYaw()) * f);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void elevateCamera(float f) {
            float f2 = this.observerCamera.getZ() + f;
            f2 = Math.min(Math.max(f2, this.getMinimumElevation()), HomeController3D.this.preferences.getLengthUnit().getMaximumElevation());
            this.observerCamera.setZ(f2);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        private void updateCameraMinimumElevation() {
            this.observerCamera.setZ(Math.max(this.observerCamera.getZ(), this.getMinimumElevation()));
        }

        public float getMinimumElevation() {
            List<Level> list = HomeController3D.this.home.getLevels();
            if (list.size() > 0) {
                return 10.0f + list.get(0).getElevation();
            }
            return 10.0f;
        }

        @Override
        public void rotateCameraYaw(float f) {
            this.observerCamera.setYaw(this.observerCamera.getYaw() + f);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void rotateCameraPitch(float f) {
            float f2 = this.observerCamera.getPitch() + f;
            f2 = Math.min(Math.max(-1.5707964f, f2), 1.5707964f);
            this.observerCamera.setPitch(f2);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void modifyFieldOfView(float f) {
            float f2 = this.observerCamera.getFieldOfView() + f;
            f2 = (float)Math.min(Math.max(Math.toRadians(2.0), (double)f2), Math.toRadians(120.0));
            this.observerCamera.setFieldOfView(f2);
            if (HomeController3D.this.preferences.isObserverCameraSelectedAtChange()) {
                HomeController3D.this.home.setSelectedItems(Arrays.asList(this.observerCamera));
            }
        }

        @Override
        public void goToCamera(Camera camera) {
            this.observerCamera.setCamera(camera);
            this.observerCamera.setTime(camera.getTime());
            this.observerCamera.setLens(camera.getLens());
        }

        @Override
        public void exit() {
            List<Selectable> list = HomeController3D.this.home.getSelectedItems();
            if (list.contains(this.observerCamera)) {
                list = new ArrayList<Selectable>(list);
                list.remove(this.observerCamera);
                HomeController3D.this.home.setSelectedItems(list);
            }
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.removePropertyChangeListener(this.levelElevationChangeListener);
            }
            HomeController3D.this.home.removeLevelsListener(this.levelsListener);
            this.observerCamera = null;
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<TopCameraState> topCameraState;

        public UserPreferencesChangeListener(TopCameraState topCameraState) {
            this.topCameraState = new WeakReference<TopCameraState>(topCameraState);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            TopCameraState topCameraState = (TopCameraState)this.topCameraState.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (topCameraState == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                topCameraState.setAerialViewCenteredOnSelectionEnabled(userPreferences.isAerialViewCenteredOnSelectionEnabled());
            }
        }
    }

    private class TopCameraState
    extends CameraControllerState {
        private final float MIN_WIDTH = 100.0f;
        private final float MIN_DEPTH = 100.0f;
        private final float MIN_HEIGHT = 20.0f;
        private Camera topCamera;
        private float[] aerialViewBoundsLowerPoint;
        private float[] aerialViewBoundsUpperPoint;
        private float minDistanceToAerialViewCenter;
        private float maxDistanceToAerialViewCenter;
        private boolean aerialViewCenteredOnSelectionEnabled;
        private boolean previousSelectionEmpty;
        private float distanceToCenterWithSelection = -1.0f;
        private PropertyChangeListener objectChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private CollectionListener<Level> levelsListener = new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private CollectionListener<Wall> wallsListener = new CollectionListener<Wall>(){

            @Override
            public void collectionChanged(CollectionEvent<Wall> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private CollectionListener<HomePieceOfFurniture> furnitureListener = new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    TopCameraState.this.addPropertyChangeListener(collectionEvent.getItem(), TopCameraState.this.objectChangeListener);
                    TopCameraState.this.updateCameraFromHomeBounds(HomeController3D.this.home.getFurniture().size() == 1 && HomeController3D.this.home.getWalls().isEmpty() && HomeController3D.this.home.getRooms().isEmpty(), false);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    TopCameraState.this.removePropertyChangeListener(collectionEvent.getItem(), TopCameraState.this.objectChangeListener);
                    TopCameraState.this.updateCameraFromHomeBounds(false, false);
                }
            }
        };
        private CollectionListener<Room> roomsListener = new CollectionListener<Room>(){

            @Override
            public void collectionChanged(CollectionEvent<Room> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private CollectionListener<Polyline> polylinesListener = new CollectionListener<Polyline>(){

            @Override
            public void collectionChanged(CollectionEvent<Polyline> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private CollectionListener<Label> labelsListener = new CollectionListener<Label>(){

            @Override
            public void collectionChanged(CollectionEvent<Label> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(TopCameraState.this.objectChangeListener);
                } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                    collectionEvent.getItem().removePropertyChangeListener(TopCameraState.this.objectChangeListener);
                }
                TopCameraState.this.updateCameraFromHomeBounds(false, false);
            }
        };
        private SelectionListener selectionListener = new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                boolean bl = selectionEvent.getSelectedItems().isEmpty();
                TopCameraState.this.updateCameraFromHomeBounds(false, TopCameraState.this.previousSelectionEmpty && !bl);
                TopCameraState.this.previousSelectionEmpty = bl;
            }
        };
        private UserPreferencesChangeListener userPreferencesChangeListener;

        public TopCameraState(UserPreferences userPreferences) {
            this.aerialViewCenteredOnSelectionEnabled = userPreferences.isAerialViewCenteredOnSelectionEnabled();
            this.userPreferencesChangeListener = new UserPreferencesChangeListener(this);
        }

        private void addPropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    this.addPropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
                }
            } else {
                homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
            }
        }

        private void removePropertyChangeListener(HomePieceOfFurniture homePieceOfFurniture, PropertyChangeListener propertyChangeListener) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()) {
                    this.removePropertyChangeListener(homePieceOfFurniture2, propertyChangeListener);
                }
            } else {
                homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void enter() {
            this.topCamera = HomeController3D.this.home.getCamera();
            this.previousSelectionEmpty = HomeController3D.this.home.getSelectedItems().isEmpty();
            this.updateCameraFromHomeBounds(false, false);
            for (Level homeObject : HomeController3D.this.home.getLevels()) {
                homeObject.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addLevelsListener(this.levelsListener);
            for (Wall wall : HomeController3D.this.home.getWalls()) {
                wall.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addWallsListener(this.wallsListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                this.addPropertyChangeListener(homePieceOfFurniture, this.objectChangeListener);
            }
            HomeController3D.this.home.addFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addRoomsListener(this.roomsListener);
            for (Polyline polyline : HomeController3D.this.home.getPolylines()) {
                polyline.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addPolylinesListener(this.polylinesListener);
            for (Label label : HomeController3D.this.home.getLabels()) {
                label.addPropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.addLabelsListener(this.labelsListener);
            HomeController3D.this.home.addSelectionListener(this.selectionListener);
            HomeController3D.this.preferences.addPropertyChangeListener(UserPreferences.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, this.userPreferencesChangeListener);
        }

        public void setAerialViewCenteredOnSelectionEnabled(boolean bl) {
            this.aerialViewCenteredOnSelectionEnabled = bl;
            this.updateCameraFromHomeBounds(false, false);
        }

        private void updateCameraFromHomeBounds(boolean bl, boolean bl2) {
            if (this.aerialViewBoundsLowerPoint == null) {
                this.updateAerialViewBoundsFromHomeBounds(this.aerialViewCenteredOnSelectionEnabled);
            }
            float f = bl2 && HomeController3D.this.preferences.isAerialViewCenteredOnSelectionEnabled() && this.distanceToCenterWithSelection != -1.0f ? this.distanceToCenterWithSelection : this.getCameraToAerialViewCenterDistance();
            if (!HomeController3D.this.home.getSelectedItems().isEmpty()) {
                this.distanceToCenterWithSelection = f;
            }
            this.updateAerialViewBoundsFromHomeBounds(this.aerialViewCenteredOnSelectionEnabled);
            this.updateCameraIntervalToAerialViewCenter();
            this.placeCameraAt(f, bl);
        }

        private float getCameraToAerialViewCenterDistance() {
            return (float)Math.sqrt(Math.pow((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f - this.topCamera.getX(), 2.0) + Math.pow((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - this.topCamera.getY(), 2.0) + Math.pow((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f - this.topCamera.getZ(), 2.0));
        }

        private void updateAerialViewBoundsFromHomeBounds(boolean bl) {
            Object object;
            float f;
            float f2;
            this.aerialViewBoundsUpperPoint = null;
            this.aerialViewBoundsLowerPoint = null;
            List list = Collections.emptyList();
            if (bl) {
                list = new ArrayList();
                for (Selectable selectable : HomeController3D.this.home.getSelectedItems()) {
                    if (!(selectable instanceof Elevatable) || !this.isItemAtVisibleLevel((Elevatable)((Object)selectable)) || selectable instanceof HomePieceOfFurniture && !((HomePieceOfFurniture)selectable).isVisible() || selectable instanceof Label && ((Label)selectable).getPitch() == null) continue;
                    list.add(selectable);
                }
            }
            boolean bl2 = list.size() == 0 || !bl;
            boolean bl3 = false;
            for (Wall homeObject : bl2 ? HomeController3D.this.home.getWalls() : Home.getWallsSubList(list)) {
                if (!this.isItemAtVisibleLevel(homeObject)) continue;
                bl3 = true;
                f2 = homeObject.getLevel() != null ? homeObject.getLevel().getElevation() : 0.0f;
                f = bl2 ? 0.0f : f2;
                object = homeObject.getHeight();
                float f3 = object != null ? f2 + ((Float)object).floatValue() : f2 + HomeController3D.this.home.getWallHeight();
                Float f4 = homeObject.getHeightAtEnd();
                if (f4 != null) {
                    f3 = Math.max(f3, f2 + f4.floatValue());
                }
                for (float[] fArray : homeObject.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f, f3);
                }
            }
            for (HomePieceOfFurniture homePieceOfFurniture : bl2 ? HomeController3D.this.home.getFurniture() : Home.getFurnitureSubList(list)) {
                if (!homePieceOfFurniture.isVisible() || !this.isItemAtVisibleLevel(homePieceOfFurniture)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, homePieceOfFurniture.getGroundElevation());
                    f = Math.max(0.0f, homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeightInPlan());
                } else {
                    f2 = homePieceOfFurniture.getGroundElevation();
                    f = homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeightInPlan();
                }
                for (Object object2 : (Object)homePieceOfFurniture.getPoints()) {
                    this.updateAerialViewBounds((float)object2[0], (float)object2[1], f2, f);
                }
            }
            for (Room room : bl2 ? HomeController3D.this.home.getRooms() : Home.getRoomsSubList(list)) {
                if (!this.isItemAtVisibleLevel(room)) continue;
                f2 = 0.0f;
                f = 20.0f;
                object = room.getLevel();
                if (object != null) {
                    f2 = ((Level)object).getElevation() - ((Level)object).getFloorThickness();
                    f = ((Level)object).getElevation();
                    if (bl2) {
                        f2 = Math.max(0.0f, f2);
                        f = Math.max(20.0f, ((Level)object).getElevation());
                    }
                }
                for (float[] fArray : room.getPoints()) {
                    this.updateAerialViewBounds(fArray[0], fArray[1], f2, f);
                }
            }
            for (Polyline polyline : bl2 ? HomeController3D.this.home.getPolylines() : Home.getPolylinesSubList(list)) {
                if (!polyline.isVisibleIn3D() || !this.isItemAtVisibleLevel(polyline)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, polyline.getGroundElevation());
                    f = Math.max(20.0f, polyline.getGroundElevation());
                } else {
                    f2 = f = polyline.getGroundElevation();
                }
                for (Object object3 : (Object)polyline.getPoints()) {
                    this.updateAerialViewBounds((float)object3[0], (float)object3[1], f2, f);
                }
            }
            for (Label label : bl2 ? HomeController3D.this.home.getLabels() : Home.getLabelsSubList(list)) {
                if (label.getPitch() == null || !this.isItemAtVisibleLevel(label)) continue;
                if (bl2) {
                    f2 = Math.max(0.0f, label.getGroundElevation());
                    f = Math.max(20.0f, label.getGroundElevation());
                } else {
                    f2 = f = label.getGroundElevation();
                }
                for (Object object4 : (Object)label.getPoints()) {
                    this.updateAerialViewBounds((float)object4[0], (float)object4[1], f2, f);
                }
            }
            if (this.aerialViewBoundsLowerPoint == null) {
                this.aerialViewBoundsLowerPoint = new float[]{0.0f, 0.0f, 0.0f};
                this.aerialViewBoundsUpperPoint = new float[]{100.0f, 100.0f, 20.0f};
            } else if (bl3 && bl2) {
                if (100.0f > this.aerialViewBoundsUpperPoint[0] - this.aerialViewBoundsLowerPoint[0]) {
                    this.aerialViewBoundsLowerPoint[0] = (this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f - 50.0f;
                    this.aerialViewBoundsUpperPoint[0] = this.aerialViewBoundsLowerPoint[0] + 100.0f;
                }
                if (100.0f > this.aerialViewBoundsUpperPoint[1] - this.aerialViewBoundsLowerPoint[1]) {
                    this.aerialViewBoundsLowerPoint[1] = (this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - 50.0f;
                    this.aerialViewBoundsUpperPoint[1] = this.aerialViewBoundsLowerPoint[1] + 100.0f;
                }
                if (20.0f > this.aerialViewBoundsUpperPoint[2] - this.aerialViewBoundsLowerPoint[2]) {
                    this.aerialViewBoundsLowerPoint[2] = (this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f - 10.0f;
                    this.aerialViewBoundsUpperPoint[2] = this.aerialViewBoundsLowerPoint[2] + 20.0f;
                }
            }
        }

        private void updateAerialViewBounds(float f, float f2, float f3, float f4) {
            if (this.aerialViewBoundsLowerPoint == null) {
                this.aerialViewBoundsLowerPoint = new float[]{f, f2, f3};
                this.aerialViewBoundsUpperPoint = new float[]{f, f2, f4};
            } else {
                this.aerialViewBoundsLowerPoint[0] = Math.min(this.aerialViewBoundsLowerPoint[0], f);
                this.aerialViewBoundsUpperPoint[0] = Math.max(this.aerialViewBoundsUpperPoint[0], f);
                this.aerialViewBoundsLowerPoint[1] = Math.min(this.aerialViewBoundsLowerPoint[1], f2);
                this.aerialViewBoundsUpperPoint[1] = Math.max(this.aerialViewBoundsUpperPoint[1], f2);
                this.aerialViewBoundsLowerPoint[2] = Math.min(this.aerialViewBoundsLowerPoint[2], f3);
                this.aerialViewBoundsUpperPoint[2] = Math.max(this.aerialViewBoundsUpperPoint[2], f4);
            }
        }

        private boolean isItemAtVisibleLevel(Elevatable elevatable) {
            return elevatable.getLevel() == null || elevatable.getLevel().isViewableAndVisible();
        }

        private void updateCameraIntervalToAerialViewCenter() {
            float f = this.aerialViewBoundsUpperPoint[0] - this.aerialViewBoundsLowerPoint[0];
            float f2 = this.aerialViewBoundsUpperPoint[1] - this.aerialViewBoundsLowerPoint[1];
            float f3 = this.aerialViewBoundsUpperPoint[2] - this.aerialViewBoundsLowerPoint[2];
            float f4 = (float)Math.sqrt(f * f + f2 * f2 + f3 * f3) / 2.0f;
            this.minDistanceToAerialViewCenter = f4 * 1.05f;
            this.maxDistanceToAerialViewCenter = Math.max(5.0f * this.minDistanceToAerialViewCenter, 2500.0f);
        }

        @Override
        public void moveCamera(float f) {
            float f2 = this.getCameraToAerialViewCenterDistance() - (f *= 5.0f);
            this.placeCameraAt(f2, false);
        }

        public void placeCameraAt(float f, boolean bl) {
            f = Math.max(f, this.minDistanceToAerialViewCenter);
            f = Math.min(f, this.maxDistanceToAerialViewCenter);
            if (bl) {
                f = Math.min(f, 3.0f * this.minDistanceToAerialViewCenter);
            }
            double d = (double)f * Math.cos(this.topCamera.getPitch());
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(this.topCamera.getYaw()) * d));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(this.topCamera.getYaw()) * d));
            this.topCamera.setZ((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f + (float)Math.sin(this.topCamera.getPitch()) * f);
        }

        @Override
        public void rotateCameraYaw(float f) {
            float f2 = this.topCamera.getYaw() + f;
            double d = (double)this.getCameraToAerialViewCenterDistance() * Math.cos(this.topCamera.getPitch());
            this.topCamera.setYaw(f2);
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(f2) * d));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(f2) * d));
        }

        @Override
        public void rotateCameraPitch(float f) {
            float f2 = this.topCamera.getPitch() + f;
            f2 = Math.max(f2, 0.0f);
            f2 = Math.min(f2, 1.5707964f);
            double d = this.getCameraToAerialViewCenterDistance();
            double d2 = d * Math.cos(f2);
            this.topCamera.setPitch(f2);
            this.topCamera.setX((this.aerialViewBoundsLowerPoint[0] + this.aerialViewBoundsUpperPoint[0]) / 2.0f + (float)(Math.sin(this.topCamera.getYaw()) * d2));
            this.topCamera.setY((this.aerialViewBoundsLowerPoint[1] + this.aerialViewBoundsUpperPoint[1]) / 2.0f - (float)(Math.cos(this.topCamera.getYaw()) * d2));
            this.topCamera.setZ((this.aerialViewBoundsLowerPoint[2] + this.aerialViewBoundsUpperPoint[2]) / 2.0f + (float)(d * Math.sin(f2)));
        }

        @Override
        public void goToCamera(Camera camera) {
            this.topCamera.setCamera(camera);
            this.topCamera.setTime(camera.getTime());
            this.topCamera.setLens(camera.getLens());
            this.updateCameraFromHomeBounds(false, false);
        }

        @Override
        public void exit() {
            this.topCamera = null;
            for (Wall homeObject : HomeController3D.this.home.getWalls()) {
                homeObject.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeWallsListener(this.wallsListener);
            for (HomePieceOfFurniture homePieceOfFurniture : HomeController3D.this.home.getFurniture()) {
                this.removePropertyChangeListener(homePieceOfFurniture, this.objectChangeListener);
            }
            HomeController3D.this.home.removeFurnitureListener(this.furnitureListener);
            for (Room room : HomeController3D.this.home.getRooms()) {
                room.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeRoomsListener(this.roomsListener);
            for (Polyline polyline : HomeController3D.this.home.getPolylines()) {
                polyline.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removePolylinesListener(this.polylinesListener);
            for (Label label : HomeController3D.this.home.getLabels()) {
                label.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeLabelsListener(this.labelsListener);
            for (Level level : HomeController3D.this.home.getLevels()) {
                level.removePropertyChangeListener(this.objectChangeListener);
            }
            HomeController3D.this.home.removeLevelsListener(this.levelsListener);
            HomeController3D.this.home.removeSelectionListener(this.selectionListener);
            HomeController3D.this.preferences.removePropertyChangeListener(UserPreferences.Property.AERIAL_VIEW_CENTERED_ON_SELECTION_ENABLED, this.userPreferencesChangeListener);
        }
    }

    protected static abstract class CameraControllerState {
        protected CameraControllerState() {
        }

        public void enter() {
        }

        public void exit() {
        }

        public void moveCamera(float f) {
        }

        public void moveCameraSideways(float f) {
        }

        public void elevateCamera(float f) {
        }

        public void rotateCameraYaw(float f) {
        }

        public void rotateCameraPitch(float f) {
        }

        public void modifyFieldOfView(float f) {
        }

        public void goToCamera(Camera camera) {
        }
    }
}

