/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FurnitureCatalogController
implements Controller {
    private final FurnitureCatalog catalog;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final List<SelectionListener> selectionListeners;
    private List<CatalogPieceOfFurniture> selectedFurniture;
    private View catalogView;

    public FurnitureCatalogController(FurnitureCatalog furnitureCatalog, ViewFactory viewFactory) {
        this(furnitureCatalog, null, viewFactory, null);
    }

    public FurnitureCatalogController(FurnitureCatalog furnitureCatalog, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this.catalog = furnitureCatalog;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.selectionListeners = new ArrayList<SelectionListener>();
        this.selectedFurniture = Collections.emptyList();
        this.catalog.addFurnitureListener(new FurnitureCatalogChangeListener(this));
        if (userPreferences != null) {
            userPreferences.addPropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, new FurnitureCatalogViewChangeListener(this));
        }
    }

    @Override
    public View getView() {
        if (this.catalogView == null) {
            this.catalogView = this.viewFactory.createFurnitureCatalogView(this.catalog, this.preferences, this);
        }
        return this.catalogView;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public List<CatalogPieceOfFurniture> getSelectedFurniture() {
        return Collections.unmodifiableList(this.selectedFurniture);
    }

    public void setSelectedFurniture(List<CatalogPieceOfFurniture> list) {
        this.selectedFurniture = new ArrayList<CatalogPieceOfFurniture>(list);
        if (!this.selectionListeners.isEmpty()) {
            SelectionListener[] selectionListenerArray;
            SelectionEvent selectionEvent = new SelectionEvent(this, this.getSelectedFurniture());
            for (SelectionListener selectionListener : selectionListenerArray = this.selectionListeners.toArray(new SelectionListener[this.selectionListeners.size()])) {
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }

    private void deselectPieceOfFurniture(CatalogPieceOfFurniture catalogPieceOfFurniture) {
        int n = this.selectedFurniture.indexOf(catalogPieceOfFurniture);
        if (n != -1) {
            ArrayList<CatalogPieceOfFurniture> arrayList = new ArrayList<CatalogPieceOfFurniture>(this.getSelectedFurniture());
            arrayList.remove(n);
            this.setSelectedFurniture(arrayList);
        }
    }

    public void modifySelectedFurniture() {
        CatalogPieceOfFurniture catalogPieceOfFurniture;
        if (this.preferences != null && this.selectedFurniture.size() > 0 && (catalogPieceOfFurniture = this.selectedFurniture.get(0)).isModifiable()) {
            AddedFurnitureSelector addedFurnitureSelector = new AddedFurnitureSelector();
            this.preferences.getFurnitureCatalog().addFurnitureListener(addedFurnitureSelector);
            new ImportedFurnitureWizardController(catalogPieceOfFurniture, this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
            addedFurnitureSelector.selectAddedFurniture();
            this.preferences.getFurnitureCatalog().removeFurnitureListener(addedFurnitureSelector);
        }
    }

    public void importFurniture() {
        if (this.preferences != null) {
            AddedFurnitureSelector addedFurnitureSelector = new AddedFurnitureSelector();
            this.preferences.getFurnitureCatalog().addFurnitureListener(addedFurnitureSelector);
            new ImportedFurnitureWizardController(this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
            addedFurnitureSelector.selectAddedFurniture();
            this.preferences.getFurnitureCatalog().removeFurnitureListener(addedFurnitureSelector);
        }
    }

    private void importFurniture(String string) {
        if (this.preferences != null) {
            new ImportedFurnitureWizardController(string, this.preferences, this.viewFactory, this.contentManager).displayView(this.getView());
        }
    }

    public void deleteSelection() {
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.selectedFurniture) {
            if (!catalogPieceOfFurniture.isModifiable()) continue;
            this.catalog.delete(catalogPieceOfFurniture);
        }
    }

    public void dropFiles(List<String> list) {
        AddedFurnitureSelector addedFurnitureSelector = new AddedFurnitureSelector();
        this.preferences.getFurnitureCatalog().addFurnitureListener(addedFurnitureSelector);
        for (String string : list) {
            this.importFurniture(string);
        }
        addedFurnitureSelector.selectAddedFurniture();
        this.preferences.getFurnitureCatalog().removeFurnitureListener(addedFurnitureSelector);
    }

    private class AddedFurnitureSelector
    implements CollectionListener<CatalogPieceOfFurniture> {
        private List<CatalogPieceOfFurniture> addedFurniture = new ArrayList<CatalogPieceOfFurniture>();

        private AddedFurnitureSelector() {
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                this.addedFurniture.add(collectionEvent.getItem());
            }
        }

        public void selectAddedFurniture() {
            if (this.addedFurniture.size() > 0) {
                FurnitureCatalogController.this.setSelectedFurniture(this.addedFurniture);
            }
        }
    }

    private static class FurnitureCatalogViewChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureCatalogController> controller;

        public FurnitureCatalogViewChangeListener(FurnitureCatalogController furnitureCatalogController) {
            this.controller = new WeakReference<FurnitureCatalogController>(furnitureCatalogController);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureCatalogController furnitureCatalogController = (FurnitureCatalogController)this.controller.get();
            if (furnitureCatalogController == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.FURNITURE_CATALOG_VIEWED_IN_TREE, this);
            } else {
                furnitureCatalogController.catalogView = null;
            }
        }
    }

    private static class FurnitureCatalogChangeListener
    implements CollectionListener<CatalogPieceOfFurniture> {
        private WeakReference<FurnitureCatalogController> furnitureCatalogController;

        public FurnitureCatalogChangeListener(FurnitureCatalogController furnitureCatalogController) {
            this.furnitureCatalogController = new WeakReference<FurnitureCatalogController>(furnitureCatalogController);
        }

        @Override
        public void collectionChanged(CollectionEvent<CatalogPieceOfFurniture> collectionEvent) {
            FurnitureCatalogController furnitureCatalogController = (FurnitureCatalogController)this.furnitureCatalogController.get();
            if (furnitureCatalogController == null) {
                ((FurnitureCatalog)collectionEvent.getSource()).removeFurnitureListener(this);
            } else if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                furnitureCatalogController.deselectPieceOfFurniture(collectionEvent.getItem());
            }
        }
    }
}

