/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core.shader;

import org.sunflow.SunflowAPI;
import org.sunflow.core.ParameterList;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;

public class AmbientOcclusionShader
implements Shader {
    private Color bright = Color.WHITE;
    private Color dark = Color.BLACK;
    private int samples = 32;
    private float maxDist = Float.POSITIVE_INFINITY;

    public AmbientOcclusionShader() {
    }

    public AmbientOcclusionShader(Color color, float f) {
        this();
        this.bright = color;
        this.maxDist = f;
    }

    public boolean update(ParameterList parameterList, SunflowAPI sunflowAPI) {
        this.bright = parameterList.getColor("bright", this.bright);
        this.dark = parameterList.getColor("dark", this.dark);
        this.samples = parameterList.getInt("samples", this.samples);
        this.maxDist = parameterList.getFloat("maxdist", this.maxDist);
        if (this.maxDist <= 0.0f) {
            this.maxDist = Float.POSITIVE_INFINITY;
        }
        return true;
    }

    public Color getBrightColor(ShadingState shadingState) {
        return this.bright;
    }

    public Color getRadiance(ShadingState shadingState) {
        return shadingState.occlusion(this.samples, this.maxDist, this.getBrightColor(shadingState), this.dark);
    }

    public void scatterPhoton(ShadingState shadingState, Color color) {
    }

    public boolean isOpaque() {
        return true;
    }

    public Color getOpacity(ShadingState shadingState) {
        return null;
    }
}

