/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi;

import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class JsonStringLiteralManipulator
extends AbstractElementManipulator<JsonStringLiteral> {
    public JsonStringLiteral handleContentChange(@NotNull JsonStringLiteral element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(0);
        }
        if (range == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(1);
        }
        assert (new TextRange(0, element.getTextLength()).contains(range));
        String originalContent = element.getText();
        TextRange withoutQuotes = this.getRangeInElement(element);
        JsonElementGenerator generator = new JsonElementGenerator(element.getProject());
        String replacement = originalContent.substring(withoutQuotes.getStartOffset(), range.getStartOffset()) + newContent + originalContent.substring(range.getEndOffset(), withoutQuotes.getEndOffset());
        return (JsonStringLiteral)element.replace(generator.createStringLiteral(replacement));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull JsonStringLiteral element) {
        String content;
        if (element == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(2);
        }
        int startOffset = (content = element.getText()).startsWith("'") || content.startsWith("\"") ? 1 : 0;
        int endOffset = content.length() > 1 && (content.endsWith("'") || content.endsWith("\"")) ? -1 : 0;
        TextRange textRange = new TextRange(startOffset, content.length() + endOffset);
        if (textRange == null) {
            JsonStringLiteralManipulator.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/psi/JsonStringLiteralManipulator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/psi/JsonStringLiteralManipulator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

