/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.personalization.impl;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.stats.personalization.UserFactor;
import com.intellij.stats.personalization.UserFactorDescriptions;
import com.intellij.stats.personalization.UserFactorStorage;
import com.intellij.stats.personalization.impl.CompletionTypeReader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/stats/personalization/impl/CompletionTypeRatio;", "Lcom/intellij/stats/personalization/UserFactor;", "type", "Lcom/intellij/codeInsight/completion/CompletionType;", "(Lcom/intellij/codeInsight/completion/CompletionType;)V", "id", "", "getId", "()Ljava/lang/String;", "compute", "storage", "Lcom/intellij/stats/personalization/UserFactorStorage;", "intellij.statsCollector"})
public final class CompletionTypeRatio
implements UserFactor {
    @NotNull
    private final String id;
    private final CompletionType type;

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String compute(@NotNull UserFactorStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        CompletionTypeReader reader = storage.getFactorReader(UserFactorDescriptions.INSTANCE.getCOMPLETION_TYPE());
        double total = reader.getTotalCompletionCount();
        return total == 0.0 ? "0.0" : String.valueOf(reader.getCompletionCountByType(this.type) / total);
    }

    public CompletionTypeRatio(@NotNull CompletionType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        this.type = type;
        this.id = "CompletionTypeRatioOf" + this.type;
    }
}

